/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salorder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillTypeApHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmc.pmts.formplugin.workbench.rpt.salorder.MultiOrganHelper;
import kd.pmc.pmts.formplugin.workbench.rpt.salorder.OrgHelper;

public class ProjSalOrderBillReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String HEAD_ORG = "head_org";
    private static final String HAS_PERMISSION_SAL_ORG = "hasPermissionPurOrg";
    protected static final String ORGF7 = "ischange";

    public void registerListener(EventObject e) {
        BasedataEdit selectBill;
        BasedataEdit bizDept;
        BasedataEdit bizOperateOrgGroup;
        BasedataEdit bizOperator;
        BasedataEdit material;
        BasedataEdit supplier;
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(HEAD_ORG);
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("customerfield")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizOperator = (BasedataEdit)this.getView().getControl("bizoperatorfield")) != null) {
            bizOperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizOperateOrgGroup = (BasedataEdit)this.getView().getControl("bizoperatorgroupfield")) != null) {
            bizOperateOrgGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizDept = (BasedataEdit)this.getView().getControl("bizdeptfield")) != null) {
            bizDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((selectBill = (BasedataEdit)this.getView().getControl("selectbill")) != null) {
            selectBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue(HEAD_ORG);
        if (org == null || org.isEmpty()) {
            List orgList;
            String pkSet = this.getPageCache().get(HAS_PERMISSION_SAL_ORG);
            if (pkSet == null || pkSet.length() < 1) {
                orgList = OrgHelper.getHasPermissionOrg(formId, OrgHelper.getFisSaleViewType());
                this.getPageCache().put(HAS_PERMISSION_SAL_ORG, SerializationUtils.toJsonString((Object)orgList));
            } else {
                orgList = (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
            }
            if (orgList != null && orgList.size() > 0) {
                Long orgId = RequestContext.get().getOrgId();
                if (orgList.contains(orgId)) {
                    model.setValue(HEAD_ORG, (Object)new Object[]{orgId});
                } else {
                    model.setValue(HEAD_ORG, (Object)new Object[]{orgList.get(0)});
                }
            }
        }
        this.controlBillStatusEnable(model);
        DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
        if (operateGroup == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long billType = BillTypeApHelper.getDefaultBillTypeId((String)"sm_salorder");
        this.getModel().setValue("billtypefield", (Object)billType);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(HEAD_ORG);
        List<Long> listOrgId = null;
        switch (fieldKey) {
            case "head_org": {
                String pkSet = this.getPageCache().get(HAS_PERMISSION_SAL_ORG);
                if (pkSet == null || pkSet.length() < 1) {
                    List<Long> orgList = OrgHelper.getHasPermissionOrg(showParameter.getFormId(), OrgHelper.getFisSaleViewType());
                    this.getPageCache().put(HAS_PERMISSION_SAL_ORG, SerializationUtils.toJsonString(orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                } else {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ORGF7);
                showParameter.setCloseCallBack(closeCallBack);
                break;
            }
            case "bizoperatorfield": {
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("bizoperatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalOrderBillReportPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = this.getBaseDataPkIds(operateGroup);
                if (groups.size() <= 0) break;
                QFilter filter1 = new QFilter("operatorgrpid", "in", groups);
                showParameter.getListFilterParameter().setFilter(filter1);
                break;
            }
            case "bizoperatorgroupfield": {
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                listOrgId = MultiOrganHelper.getAllOrg(org, false);
                QFilter f = MultiOrganHelper.getOrgGrpQfilter(listOrgId);
                showParameter.getListFilterParameter().setFilter(f);
                QFilter bd_operatorgroup = MultiOrganHelper.getBaseDataFilter("bd_operatorgroup", listOrgId);
                if (bd_operatorgroup == null) break;
                showParameter.getListFilterParameter().setFilter(bd_operatorgroup);
                showParameter.setShowApproved(false);
                break;
            }
            case "materialfield": {
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrganHelper.getAllOrg(org, false);
                QFilter bd_material = MultiOrganHelper.getBaseDataFilter("bd_material", listOrgId);
                if (bd_material == null) break;
                showParameter.getListFilterParameter().setFilter(bd_material);
                showParameter.setShowApproved(false);
                break;
            }
            case "selectbill": {
                DynamicObject billtype;
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter orderFilter = new QFilter("1", "=", (Object)1);
                QFilter filterF7 = new QFilter("1", "=", (Object)1);
                Date startdate = (Date)this.getModel().getValue("startdate");
                Date enddate = (Date)this.getModel().getValue("enddate");
                if (startdate != null && enddate != null && org != null) {
                    List OrgList = MultiOrganHelper.getBaseDataIds(org);
                    QFilter qFilterOrgId = new QFilter("org.id", "in", OrgList);
                    QFilter qFilterStartDate = new QFilter("bizdate", ">=", (Object)this.getStartOrEndDate(startdate, false));
                    QFilter qFilterEndDate = new QFilter("bizdate", "<=", (Object)this.getStartOrEndDate(enddate, true));
                    orderFilter.and(qFilterOrgId).and(qFilterStartDate).and(qFilterEndDate);
                    filterF7.and(qFilterOrgId).and(qFilterStartDate).and(qFilterEndDate);
                }
                if ((billtype = (DynamicObject)this.getModel().getValue("billtypefield")) != null) {
                    QFilter qFilterbilltype = new QFilter("billtype.id", "=", billtype.getPkValue());
                    orderFilter.and(qFilterbilltype);
                    filterF7.and(qFilterbilltype);
                }
                DynamicObjectCollection customer = (DynamicObjectCollection)this.getModel().getValue("customerfield");
                List<Object> customerIds = new ArrayList();
                if (customer != null && customer.size() > 0) {
                    customerIds = this.getBaseDataPkIds(customer);
                }
                if (customerIds != null && customerIds.size() > 0) {
                    QFilter qFilterCustomer = new QFilter("customer.id", "in", customerIds);
                    QFilter qFilterCustomerF7 = new QFilter("customerid.id", "in", customerIds);
                    orderFilter.and(qFilterCustomer);
                    filterF7.and(qFilterCustomerF7);
                }
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)"A");
                DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"sm_salorder", (String)"id,billentry.material", (QFilter[])new QFilter[]{statusFilter, orderFilter});
                ArrayList<Long> ids = new ArrayList<Long>(16);
                for (DynamicObject d : dynamicObject) {
                    boolean hasEntry = false;
                    DynamicObjectCollection entrys = d.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entrys) {
                        if (entry.getDynamicObject("material") == null) continue;
                        hasEntry = true;
                        break;
                    }
                    if (hasEntry) continue;
                    ids.add((Long)d.getPkValue());
                }
                if (ids.size() > 0) {
                    QFilter idFilter = new QFilter("id", "not in", ids);
                    orderFilter.and(idFilter);
                    filterF7.and(idFilter);
                }
                showParameter.getListFilterParameter().setFilter(filterF7);
                showParameter.setFormId("bos_listf7_sal");
                break;
            }
            case "bizdeptfield": {
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "customerfield": {
                if (org == null || org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrganHelper.getBaseDataLongIds(this.getView(), HEAD_ORG);
                QFilter bd_customer = MultiOrganHelper.getBaseDataFilter("bd_customer", listOrgId);
                if (bd_customer != null) {
                    showParameter.getListFilterParameter().setFilter(bd_customer);
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "head_org": {
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (newValue != null && newValue.equals(oldValue) && !((DynamicObjectCollection)newValue).isEmpty() && !"1".equals(this.getPageCache().get(ORGF7))) break;
                model.setValue("materialfield", null);
                model.setValue("customerfield", null);
                model.setValue("bizoperatorfield", null);
                model.setValue("bizoperatorgroupfield", null);
                model.setValue("bizdeptfield", null);
                model.setValue("selectbill", null);
                this.getPageCache().put(ORGF7, "0");
                break;
            }
            case "billstatusfield": {
                this.controlBillStatusEnable(model);
                break;
            }
            case "bizoperatorgroupfield": {
                DynamicObjectCollection operatorGroup = (DynamicObjectCollection)newValue;
                if (operatorGroup == null || operatorGroup.size() == 0) {
                    this.getModel().setValue("bizoperatorfield", null);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"bizoperatorfield"});
                    break;
                }
                this.getModel().setValue("bizoperatorfield", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"bizoperatorfield"});
                break;
            }
            case "billtypefield": {
                if (newValue == null || newValue == oldValue) break;
                model.setValue("selectbill", null);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "ischange": {
                if (closedCallBackEvent.getReturnData() == null) break;
                ListSelectedRowCollection returnValue = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                this.getPageCache().put(ORGF7, "1");
                this.getModel().setValue(HEAD_ORG, (Object)returnValue.getPrimaryKeyValues());
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection(HEAD_ORG);
        boolean isVerify = true;
        if (org == null || org.isEmpty()) {
            isVerify = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalOrderBillReportPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null && enddate == null) {
            isVerify = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalOrderBillReportPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
        }
        return isVerify;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put(HEAD_ORG, filterInfo.getDynamicObjectCollection(HEAD_ORG));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("customerfield", filterInfo.getDynamicObjectCollection("customerfield"));
        queryParam.getCustomParam().put("materialfield", filterInfo.getDynamicObjectCollection("materialfield"));
        queryParam.getCustomParam().put("bizdeptfield", filterInfo.getDynamicObjectCollection("bizdeptfield"));
        queryParam.getCustomParam().put("bizoperatorgroupfield", filterInfo.getDynamicObjectCollection("bizoperatorgroupfield"));
        queryParam.getCustomParam().put("bizoperatorfield", filterInfo.getDynamicObjectCollection("bizoperatorfield"));
        queryParam.getCustomParam().put("selectbill", filterInfo.getDynamicObjectCollection("selectbill"));
        queryParam.getCustomParam().put("billtypefield", filterInfo.getDynamicObject("billtypefield"));
        queryParam.getCustomParam().put("billstatusfield", filterInfo.getString("billstatusfield"));
        queryParam.getCustomParam().put("closestatusfield", filterInfo.getString("closestatusfield"));
        queryParam.getCustomParam().put("rowstatusfield", filterInfo.getString("rowstatusfield"));
        queryParam.getCustomParam().put("project", filterInfo.getDynamicObjectCollection("hproject"));
        queryParam.getCustomParam().put("wbs", filterInfo.getDynamicObjectCollection("hwbs"));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        if (fieldName.equals("billno")) {
            BillShowParameter param = new BillShowParameter();
            ReportList list = (ReportList)this.getControl("reportlistap");
            String billno = (String)list.getReportModel().getValue(rowIndex, "billno");
            DynamicObjectCollection contract = QueryServiceHelper.query((String)"sm_salorder", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            if (contract == null || contract.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"SalOrderBillReportPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
            } else {
                param.setPkId((Object)((DynamicObject)contract.get(0)).getLong("id"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId("sm_salorder");
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private void controlBillStatusEnable(IDataModel model) {
        String value = (String)this.getModel().getValue("billstatusfield");
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getModel().setValue("billstatusfield", (Object)"A");
        }
        if (!"C".equals(value) && !"A".equals(value)) {
            model.setValue("closestatusfield", (Object)"A");
            model.setValue("rowstatusfield", (Object)"B");
            this.getView().setEnable(Boolean.FALSE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rowstatusfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"closestatusfield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"rowstatusfield"});
        }
    }
}

