/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salorder;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algox.DataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.pmc.pmts.formplugin.workbench.rpt.OrderByTransform;
import kd.pmc.pmts.formplugin.workbench.rpt.RowCloseStatusEnum;
import kd.pmc.pmts.formplugin.workbench.rpt.RowTerminateStatusEnum;
import kd.pmc.pmts.formplugin.workbench.rpt.salorder.JoinFinArBillTransform;
import kd.pmc.pmts.formplugin.workbench.rpt.salorder.MultiOrganHelper;

public class ProjSalSynthesisReportHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> filters = this.getFilters(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            if (!"sm_salorder".equalsIgnoreCase(srcEntity)) continue;
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            for (QFilter filter : filters) {
                dataFs.and(filter);
            }
            srcBlockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new OrderByTransform(ctx));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("billentryid");
        repoColFilter.add("entrysettleorg");
        repoColFilter.add("settlecustomer");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new JoinFinArBillTransform(ctx));
        transCollector.add(new IDataXTransform(){

            public DataSetX doTransform(DataSetX srcData) {
                return srcData.removeFields(new String[]{"billentryid", "entrysettleorg", "settlecustomer", "id"});
            }
        });
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new OrderByTransform(ctx));
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("sm_salorder".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id", "id");
            repoColFullSrcColMap.putIfAbsent("billentryid", "billentry.id");
            repoColFullSrcColMap.putIfAbsent("rowseq", "billentry.seq");
        }
    }

    private List<QFilter> getFilters(Map<String, Object> filterInfo) {
        DynamicObjectCollection wbs;
        DynamicObject billtype;
        DynamicObjectCollection salOrderBillNo;
        DynamicObjectCollection bizoperators;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection materials;
        String HEAD_ORG = "head_org";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.get(HEAD_ORG);
        if (org != null && !org.isEmpty()) {
            Object[] pkIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)pkIds));
        }
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)ProjSalSynthesisReportHandle.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)ProjSalSynthesisReportHandle.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection customers = (DynamicObjectCollection)filterInfo.get("customerfield");
        if (customers != null && customers.size() > 0) {
            List ids = MultiOrganHelper.getMasterIds(customers);
            filters.add(new QFilter("customer.masterid", "in", ids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
            filters.add(QFilter.isNotNull((String)"billentry.material"));
        }
        DynamicObjectCollection bizdepts = (DynamicObjectCollection)filterInfo.get("bizdeptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((bizoperatorgroups = (DynamicObjectCollection)filterInfo.get("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizoperators = (DynamicObjectCollection)filterInfo.get("bizoperatorfield")) != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((salOrderBillNo = (DynamicObjectCollection)filterInfo.get("selectbill")) != null && salOrderBillNo.size() > 0) {
            Object[] billNo = ProjSalSynthesisReportHandle.getBaseDataPkIds(salOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((billtype = (DynamicObject)filterInfo.get("billtypefield")) != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = ProjSalSynthesisReportHandle.getStatusFilter(filterInfo);
        filters.addAll(statusfilters);
        DynamicObjectCollection projects = (DynamicObjectCollection)filterInfo.get("project");
        if (projects != null && projects.size() > 0) {
            Object[] projectIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(projects);
            filters.add(new QFilter("billentry.project.id", "in", (Object)projectIds));
        }
        if ((wbs = (DynamicObjectCollection)filterInfo.get("wbs")) != null && wbs.size() > 0) {
            Object[] wbsIds = ProjSalSynthesisReportHandle.getBaseDataPkIds(wbs);
            filters.add(new QFilter("billentry.wbs.id", "in", (Object)wbsIds));
        }
        return filters;
    }

    private static List<QFilter> getStatusFilter(Map<String, Object> filterInfo) {
        String rowstatus;
        String closestatus;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = (String)filterInfo.get("billstatusfield");
        if (!"C".equals(billstatus) && !"A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "!=", (Object)"C"));
            return filters;
        }
        if ("C".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        if ("B".equals(closestatus = (String)filterInfo.get("closestatusfield")) || "A".equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        if ("B".equals(rowstatus = (String)filterInfo.get("rowstatusfield"))) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if ("A".equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

