/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salsynthesis;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.util.StringDateUtils;
import kd.pmc.pmts.formplugin.workbench.rpt.CommonUtils;

public class ProjSalSynthesisReportFormPlugin
extends AbstractReportFormPlugin {
    protected static final Log logger = LogFactory.getLog(ProjSalSynthesisReportFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.setCustomParam();
    }

    private void setCustomParam() {
        logger.debug("Executing afterCreateNewData method...");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        Boolean withoutSysProj = Boolean.TRUE;
        Boolean withoutSysWbs = Boolean.TRUE;
        String startDate = (String)params.get("query_startDate");
        String endDate = (String)params.get("query_endDate");
        String projectId = (String)params.get("query_projectid");
        String wbs = (String)params.get("query_wbs");
        String saleOrg = (String)params.get("query_saleorg");
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            Date before90DaysData = StringDateUtils.getAfterXDaysData((String)startDate, (int)-90);
            this.getModel().setValue("startdate", (Object)before90DaysData);
            this.getModel().setValue("enddate", (Object)endDate);
            logger.debug("Set startdate to " + before90DaysData + " and enddate to " + endDate);
        }
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            this.getModel().setValue("hproject", (Object)new Object[]{Long.parseLong(projectId)});
            withoutSysProj = !QueryServiceHelper.exists((String)"bd_project", (Object)Long.parseLong(projectId));
            logger.debug("Set hproject to " + projectId);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrg)) {
            this.getModel().setValue("horg", (Object)Long.parseLong(saleOrg));
            logger.debug("Set horg to " + saleOrg);
        }
        if (StringUtils.isNotBlank((CharSequence)wbs)) {
            List wbsIds = (List)SerializationUtils.fromJsonString((String)wbs, List.class);
            withoutSysWbs = !QueryServiceHelper.exists((String)"bd_wbs", wbsIds.get(0));
            this.getModel().setValue("hwbs", (Object)wbsIds.toArray());
            logger.debug("Set hwbs to " + wbsIds);
        }
        if (withoutSysProj.booleanValue() && withoutSysWbs.booleanValue()) {
            CommonUtils.setInterceptOperation((IFormView)this.getView());
        }
    }
}

