/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salsynthesis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SalContractRptHelper {
    private static final String PURCONTRACT_ORG = "org";
    private static final String PURCONTRACT_BIZTIME = "biztime";
    private static final String PURCONTRACT_CUSTOMER = "customer";
    private static final String PURCONTRACT_TYPE = "type";
    private static final String BILLNO = "billno";
    private static final String BILLENTRY = "billentry";

    public static DataSet getMUConv(DataSet dataSet) {
        ArrayList<Object[]> MUConvs = new ArrayList<Object[]>();
        for (Row row : dataSet) {
            Long material = row.getLong("material");
            Long unit = row.getLong("billentry.unit");
            Long baseunit = row.getLong("billentry.baseunit");
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)material, (Long)baseunit, (Long)unit);
            int numerator = muConv == null ? 1 : muConv.getInt("numerator");
            int denominator = muConv == null ? 1 : muConv.getInt("denominator");
            Long id = row.getLong("id");
            Long entryId = row.getLong("entryId");
            MUConvs.add(new Object[]{id, entryId, numerator, denominator});
        }
        Algo muConv = Algo.create((String)"MUConv");
        DataSetBuilder dataSetBuilder = muConv.createDataSetBuilder(SalContractRptHelper.getRowMeta());
        for (Object[] conv : MUConvs) {
            dataSetBuilder.append(conv);
        }
        return dataSetBuilder.build();
    }

    private static RowMeta getRowMeta() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("id", (DataType)DataType.LongType));
        fields.add(new Field("entryId", (DataType)DataType.LongType));
        fields.add(new Field("numerator", (DataType)DataType.IntegerType));
        fields.add(new Field("denominator", (DataType)DataType.IntegerType));
        return new RowMeta(fields.toArray(new Field[fields.size()]));
    }

    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(10);
        selectorSet.add("id");
        selectorSet.add(BILLNO);
        selectorSet.add("billname");
        selectorSet.add(PURCONTRACT_ORG);
        selectorSet.add(PURCONTRACT_CUSTOMER);
        selectorSet.add(PURCONTRACT_TYPE);
        selectorSet.add("billstatus");
        selectorSet.add(PURCONTRACT_BIZTIME);
        selectorSet.add("operator");
        selectorSet.add("changestatus");
        selectorSet.add("freezestatus");
        selectorSet.add("cancelstatus");
        selectorSet.add("settlecurrency");
        selectorSet.add("totalamount");
        selectorSet.add("totaltaxamount");
        selectorSet.add("totalallamount");
        selectorSet.add("validdate");
        selectorSet.add("billentry.id as entryId");
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.materialname as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as model");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.baseunit as baseunit");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.baseqty as baseqty");
        selectorSet.add("billentry.price as price");
        selectorSet.add("billentry.amountandtax as amount");
        selectorSet.add("billentry.orderbaseqty as orderbaseqty");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmjoinorder");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmjoinar");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2orderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billno as orderbillno");
        selectorSet.add("billentry.baseqty as orderbaseqty");
        selectorSet.add("billentry.amountandtax as orderamount");
        selectorSet.add("concat(tochar(billentry.srcbillid),tochar(billentry.srcbillentryid)) as conmjoinorder");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderjoinim");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2inorderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billno as out_billno");
        selectorSet.add("billentry.baseqty as outbaseqty");
        selectorSet.add("billentry.amountandtax as outamount");
        selectorSet.add("concat(tochar(billentry.mainbillid),tochar(billentry.mainbillentryid)) as imjoinorder");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as imjoinar");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2returnorderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billno as return_billno");
        selectorSet.add("billentry.baseqty as basereturnqty");
        selectorSet.add("billentry.amountandtax as returnamount");
        selectorSet.add("concat(tochar(billentry.mainbillid),tochar(billentry.mainbillentryid)) as returnjoinin");
        selectorSet.add("concat(tochar(billentry.srcbillid),tochar(billentry.srcbillentryid)) as injoinreturn");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2Ar_Busbill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("concat(tochar(entry.e_srcbillid),tochar(entry.e_srcentryid)) as arjoinim");
        selectorSet.add("concat(tochar(id),tochar(entry.id)) as arjoinfinar");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2payablebill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billno as finar_billno");
        selectorSet.add("entry.e_baseunitqty as finarbaseqty");
        selectorSet.add("entry.e_recamount as finaramount");
        selectorSet.add("concat(tochar(entry.e_srcid),tochar(entry.e_srcentryid)) as finarjoin");
        selectorSet.add("concat(tochar(entry.corebillid),tochar(entry.corebillentryid)) as finarjoinorder");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject contract;
        DynamicObject type;
        DynamicObjectCollection customers;
        Date endDate;
        Date startDate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        if (org != null) {
            filters.add(new QFilter(PURCONTRACT_ORG, "=", org.getPkValue()));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filters.add(new QFilter(PURCONTRACT_BIZTIME, ">=", (Object)SalContractRptHelper.getStartOrEndDate(startDate, false)));
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filters.add(new QFilter(PURCONTRACT_BIZTIME, "<=", (Object)SalContractRptHelper.getStartOrEndDate(endDate, true)));
        }
        if ((customers = filterInfo.getDynamicObjectCollection("customerfield")) != null) {
            Object[] ids = customers.stream().map(DataEntityBase::getPkValue).toArray();
            filters.add(new QFilter(PURCONTRACT_CUSTOMER, "in", (Object)ids));
        }
        if ((type = filterInfo.getDynamicObject("typeid")) != null) {
            filters.add(new QFilter(PURCONTRACT_TYPE, "=", type.getPkValue()));
        }
        if ((contract = filterInfo.getDynamicObject("billnoid")) != null) {
            filters.add(new QFilter("id", "=", contract.getPkValue()));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<QFilter> getUnitFilters(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.addAll(SalContractRptHelper.getFilters(filterInfo));
        filters.add(new QFilter("billentry.baseqty", "=", (Object)BigDecimal.ZERO));
        return filters;
    }
}

