/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salsynthesis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class UnitConvertFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private String material;
    private String srcUnit;
    private String trgUnit;
    private String[] qtyFields;
    private Map<String, Integer> fieldIndexMap;

    public UnitConvertFunction(RowMeta rowMeta, String material, String srcUnit, String trgUnit, String[] qtyFields) {
        this.rowMeta = rowMeta;
        this.material = material;
        this.srcUnit = srcUnit;
        this.trgUnit = trgUnit;
        this.qtyFields = qtyFields;
        Field[] fields = rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (this.fieldIndexMap == null) {
                this.fieldIndexMap = new HashMap<String, Integer>();
            }
            this.fieldIndexMap.put(field.getName(), i);
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Integer materialIndex = this.fieldIndexMap.get(this.material);
        Integer srcUnitIndex = this.fieldIndexMap.get(this.srcUnit);
        Integer trgUnitIndex = this.fieldIndexMap.get(this.trgUnit);
        for (RowX row : iterable) {
            if (materialIndex != null && srcUnitIndex != null && trgUnitIndex != null) {
                Long materialId = row.getLong(materialIndex.intValue());
                Long srcUnitId = row.getLong(srcUnitIndex.intValue());
                Long trgUnitId = row.getLong(trgUnitIndex.intValue());
                if (materialId != null && materialId.compareTo(0L) != 0 && srcUnitId != null && srcUnitId.compareTo(0L) != 0 && trgUnitId != null && trgUnitId.compareTo(0L) != 0 && srcUnitId.compareTo(trgUnitId) != 0) {
                    DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)trgUnitId);
                    int numerator = muConv == null ? 1 : muConv.getInt("numerator");
                    int denominator = muConv == null ? 1 : muConv.getInt("denominator");
                    for (String field : this.qtyFields) {
                        Integer fieldIndex = this.fieldIndexMap.get(field);
                        if (fieldIndex == null) continue;
                        BigDecimal qty = row.getBigDecimal(fieldIndex.intValue());
                        if (denominator == 0) continue;
                        qty = qty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), 10, RoundingMode.HALF_UP);
                        row.set(fieldIndex.intValue(), (Object)qty);
                    }
                }
            }
            collector.collect(row);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

