/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmrp.enums.IssueStatusEnum;
import kd.pmc.pmrp.util.CommonUtils;

public class MyQuestionUtils
extends AttachmentServiceHelper {
    private static final String PMBD_ENTERPRISE_HM_RES_PO = "pmbd_enterprise_hm_res_po";
    private static final String NUMBER = "number";
    private static final String ID = "id";

    public static Long getHmResPoForUserId(Long userId) {
        QFilter idsFilter = new QFilter(ID, "=", (Object)userId);
        DynamicObject bosUserDyObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)NUMBER, (QFilter[])new QFilter[]{idsFilter});
        if (bosUserDyObject == null) {
            return 0L;
        }
        String number = bosUserDyObject.getString(NUMBER);
        if (number == null) {
            return 0L;
        }
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)PMBD_ENTERPRISE_HM_RES_PO, (String)ID, (QFilter[])new QFilter[]{numberFilter});
        if (dynObj != null) {
            return dynObj.getLong(ID);
        }
        return 0L;
    }

    public static DynamicObject getMyQuestionForId(Long id, String selectFields) {
        QFilter idsFilter = new QFilter(ID, "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"pmrp_myquestion", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
    }

    public static String getDateStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getExpositionHtml(String context) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='w-e-text w-e-text-container'>");
        sb.append(context);
        sb.append("</div>");
        return sb.toString();
    }

    public static String getIssueStatusName(Integer number) {
        if (IssueStatusEnum.PENDING.getNumber().equals(number)) {
            return IssueStatusEnum.PENDING.getName();
        }
        if (IssueStatusEnum.PROCESSING.getNumber().equals(number)) {
            return IssueStatusEnum.PROCESSING.getName();
        }
        if (IssueStatusEnum.COMPLETE.getNumber().equals(number)) {
            return IssueStatusEnum.COMPLETE.getName();
        }
        if (IssueStatusEnum.CLOSE.getNumber().equals(number)) {
            return IssueStatusEnum.CLOSE.getName();
        }
        return null;
    }

    public static DynamicObject[] getMyQuestionProcess(String pkValue) {
        String selectFields = CommonUtils.getSelects("myquestion", "handler", "statustaggroup", "desc", "createtime", "creator", ID, "active");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"pmrp_myquestionprocess", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("myquestion", "=", (Object)Long.parseLong(pkValue))}, (String)"createtime desc, id DESC");
        return result;
    }
}

