/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.util;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class RiskParaSetUtils {
    public static Tips getTips(String title, String content) {
        Tips tips = new Tips();
        tips.setType("text");
        tips.setTitle(new LocaleString(title));
        tips.setContent(new LocaleString(content));
        return tips;
    }

    public static int[] getScaleValues(Integer scope, Integer average) {
        int size = scope / average;
        int[] scaleValues = new int[size];
        for (int i = 0; i < size; ++i) {
            scaleValues[i] = i * average + average;
        }
        return scaleValues;
    }

    public static boolean riskGradeScopeCondition(Integer riskGradeScope, int[] crossVals, int[] verticalVals) {
        for (int i : crossVals) {
            for (int j : verticalVals) {
                if (i * j != riskGradeScope) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getCrossScopeVal(String crossScope) {
        try {
            return Integer.parseInt(crossScope.substring(crossScope.indexOf("0-") + "0-".length()));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static DynamicObject getRiskParaSet(Long id, String selectFields) {
        QFilter idsFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"pmrp_riskparaset", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
        return dyn;
    }

    public static DynamicObject[] getRiskParaSets(Long org, String selectFields) {
        QFilter orgFilter = new QFilter("createorg", "=", (Object)org);
        QFilter defaultSchemeFilter = new QFilter("defaultscheme", "=", (Object)Boolean.TRUE);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"pmrp_riskparaset", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, defaultSchemeFilter});
        return result;
    }

    public static Long getDefaultRiskParaSet(Long orgId) {
        DynamicObject dyn;
        QFilter orgFilter = new QFilter("createorg", "=", (Object)orgId);
        QFilter defaultSchemeFilter = new QFilter("defaultscheme", "=", (Object)Boolean.TRUE);
        boolean isExists = QueryServiceHelper.exists((String)"pmrp_riskparaset", (QFilter[])new QFilter[]{orgFilter, defaultSchemeFilter});
        if (isExists) {
            QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            orgFilter.and(defaultSchemeFilter).and(statusFilter);
        }
        return (dyn = QueryServiceHelper.queryOne((String)"pmrp_riskparaset", (String)"id", (QFilter[])new QFilter[]{orgFilter})) == null ? null : Long.valueOf(dyn.getLong("id"));
    }

    public static DynamicObject queryRiskParaSet(long id, String selectFields) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"pmrp_riskparaset", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        return dyn;
    }

    public static void showForm(Long riskParaSetId, Long riskScopeId, IFormView view) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pmrp_riskscopedefinition1");
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("openSource", "pmrp_riskparaset");
        if (riskScopeId != null) {
            formShowParameter.setPkId((Object)riskScopeId);
            map.put("existData", Boolean.TRUE);
        } else {
            map.put("existData", Boolean.FALSE);
            map.put("pmrp_riskparaset", riskParaSetId);
        }
        formShowParameter.setCustomParams(map);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)formShowParameter);
    }
}

