/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmrp.enums.RiskAxisEnum;
import kd.pmc.pmrp.util.CommonUtils;

public class RiskRegisterUtils {
    static final int FIRST_INDEX = 0;
    static final int SEC_INDEX = 1;

    public static Set<Long> getUserForProjectTeam(Long projectId) {
        HashSet<Long> users = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects("entryentity.subentryentity.enterprisehmrespo.id");
        QFilter idFilter = new QFilter("pmpdproject.id", "=", (Object)projectId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getProjectTeam", (String)"pmpd_projectteam", (String)selectFields, (QFilter[])new QFilter[]{idFilter, statusFilter}, null);){
            for (Row row : ds) {
                if (row == null || row.getLong("entryentity.subentryentity.enterprisehmrespo.id") == 0L) continue;
                users.add(row.getLong("entryentity.subentryentity.enterprisehmrespo.id"));
            }
        }
        return users;
    }

    public static List<Map<String, Object>> getRiskRegisterToParaSetId(Long paraSetId, String xAxisDesc, List<List<String>> bglist, Map<String, List<BigDecimal>> map, QFilter itFilter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        String selectFields = CommonUtils.getSelects("id", "riskimpactdegree", "riskprobability", "riskpersonliable.name", "name", "evaluationdate");
        QFilter idFilter = new QFilter("riskparaset", "=", (Object)paraSetId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        QFilter riskStatusFilter = new QFilter("riskstatus.type", "!=", (Object)"100");
        if (itFilter != null) {
            idFilter.and(itFilter);
        }
        String xAxis = null;
        String yAxis = null;
        if (RiskAxisEnum.PROBABILITY.getName().equals(xAxisDesc)) {
            xAxis = "riskprobability";
            yAxis = "riskimpactdegree";
        } else {
            yAxis = "riskprobability";
            xAxis = "riskimpactdegree";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getRiskRegisterToParaSetId", (String)"pmrp_riskregister", (String)selectFields, (QFilter[])new QFilter[]{idFilter, statusFilter, riskStatusFilter}, null);){
            for (Row row : ds) {
                String riskpersonliable;
                HashMap<String, Object> riskMap = new HashMap<String, Object>(8);
                riskMap.put("x", row.getBigDecimal(xAxis).toString());
                riskMap.put("y", row.getBigDecimal(yAxis).toString());
                riskMap.put("id", row.getLong("id"));
                riskMap.put("title", row.getString("name"));
                riskMap.put("color", RiskRegisterUtils.getShowColor(CommonUtils.clearNoUseZeroForBigDecimal(row.getBigDecimal(xAxis)), CommonUtils.clearNoUseZeroForBigDecimal(row.getBigDecimal(yAxis)), bglist, map));
                HashMap<String, String> content = new HashMap<String, String>();
                Date date = row.getDate("evaluationdate");
                if (date != null) {
                    content.put(ResManager.loadKDString((String)"\u8bc4\u4f30\u65f6\u95f4", (String)"RiskRegisterUtils_0", (String)"mmc-pmts-common", (Object[])new Object[0]), df.format(date));
                }
                if ((riskpersonliable = row.getString("riskpersonliable.name")) != null) {
                    content.put(ResManager.loadKDString((String)"\u98ce\u9669\u8d23\u4efb\u4eba", (String)"RiskRegisterUtils_1", (String)"mmc-pmts-common", (Object[])new Object[0]), riskpersonliable);
                }
                content.put(ResManager.loadKDString((String)"\u5f71\u54cd\u7a0b\u5ea6", (String)"RiskRegisterUtils_2", (String)"mmc-pmts-common", (Object[])new Object[0]), row.getBigDecimal("riskimpactdegree").stripTrailingZeros().toPlainString());
                content.put(ResManager.loadKDString((String)"\u53d1\u751f\u6982\u7387", (String)"RiskRegisterUtils_3", (String)"mmc-pmts-common", (Object[])new Object[0]), row.getBigDecimal("riskprobability").stripTrailingZeros().toPlainString());
                riskMap.put("content", content);
                list.add(riskMap);
            }
        }
        return list;
    }

    public static Map<String, List<BigDecimal>> getAxisMap(String[] xAxisValue, String[] yAxisValue) {
        HashMap<String, List<BigDecimal>> map = new HashMap<String, List<BigDecimal>>(2);
        ArrayList<BigDecimal> xAxisSet = new ArrayList<BigDecimal>(16);
        ArrayList<BigDecimal> yAxisSet = new ArrayList<BigDecimal>(16);
        for (String x : xAxisValue) {
            xAxisSet.add(new BigDecimal(x));
        }
        for (String y : yAxisValue) {
            yAxisSet.add(new BigDecimal(y));
        }
        map.put("xAxisSet", xAxisSet);
        map.put("yAxisSet", yAxisSet);
        return map;
    }

    private static String getAxis(List<List<String>> bglist, Map<String, List<BigDecimal>> map, BigDecimal xAxis, BigDecimal yAxis) {
        List<BigDecimal> xAxisSet = map.get("xAxisSet");
        List<BigDecimal> yAxisSet = map.get("yAxisSet");
        int xSize = xAxisSet.size();
        int ySize = yAxisSet.size();
        BigDecimal x = null;
        BigDecimal y = null;
        for (int i = 0; i < xSize; ++i) {
            if (xAxis.compareTo(xAxisSet.get(i)) > 0) continue;
            x = xAxisSet.get(i);
            break;
        }
        for (int j = 0; j < ySize; ++j) {
            if (yAxis.compareTo(yAxisSet.get(j)) > 0) continue;
            y = yAxisSet.get(j);
            break;
        }
        if (x != null && y != null) {
            return RiskRegisterUtils.getColor(bglist, x, y);
        }
        return null;
    }

    private static String getColor(List<List<String>> bglist, BigDecimal xAxis, BigDecimal yAxis) {
        int size = bglist.size();
        for (int i = 0; i < size; ++i) {
            List<String> bg = bglist.get(i);
            if (bg.size() != 5 || xAxis.compareTo(new BigDecimal(bg.get(0))) != 0 || yAxis.compareTo(new BigDecimal(bg.get(1))) != 0) continue;
            return bg.get(4);
        }
        return null;
    }

    private static String getShowColor(BigDecimal xAxis, BigDecimal yAxis, List<List<String>> bglist, Map<String, List<BigDecimal>> map) {
        return RiskRegisterUtils.getAxis(bglist, map, xAxis, yAxis);
    }

    public static BigDecimal getAverage(String[] axisValue) {
        if (axisValue.length >= 2) {
            return CommonUtils.clearNoUseZeroForBigDecimal(new BigDecimal(axisValue[1]).subtract(new BigDecimal(axisValue[0])));
        }
        return null;
    }

    public static Map<String, String> getBorderStyle() {
        HashMap<String, String> borderStyle = new HashMap<String, String>(2);
        borderStyle.put("borderWidth", "1PX");
        borderStyle.put("borderColor", "#FFF");
        return borderStyle;
    }

    public static Set<Long> getRiskStatus(Set<Long> ids) {
        HashSet<Long> riskStatusIds = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects("riskstatus.id");
        QFilter idFilter = new QFilter("riskstatus.id", "in", ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getRiskRegisterConst", (String)"pmrp_riskregister", (String)selectFields, (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : ds) {
                riskStatusIds.add(row.getLong("riskstatus.id"));
            }
        }
        return riskStatusIds;
    }
}

