/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmrp.enums.RiskAxisEnum;
import kd.pmc.pmrp.util.CommonUtils;
import kd.pmc.pmrp.util.RiskRegisterUtils;

public class RiskScopeDefinitionUtils {
    public static Map<String, Object> getRiskMatrixDiagramForRiskParaSet(DynamicObject riskParaSetDynObj) {
        List<String[]> bglist;
        HashMap<String, Object> scopeMap = new HashMap<String, Object>(2);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        HashMap<String, Object> xAxis = new HashMap<String, Object>(2);
        HashMap<String, Object> yAxis = new HashMap<String, Object>(2);
        DynamicObjectCollection probabilityDynColl = riskParaSetDynObj.getDynamicObjectCollection("entryentity");
        String[] probabilityVals = new String[probabilityDynColl.size()];
        int i = 0;
        for (DynamicObject dyn : probabilityDynColl) {
            probabilityVals[i] = dyn.getString("probabilityval");
            ++i;
        }
        DynamicObjectCollection degreeDynColl = riskParaSetDynObj.getDynamicObjectCollection("entryentity1");
        String[] degreeVals = new String[degreeDynColl.size()];
        i = 0;
        for (DynamicObject dyn : degreeDynColl) {
            degreeVals[i] = dyn.getString("degreeval");
            ++i;
        }
        if (RiskAxisEnum.PROBABILITY.getValue().equals(riskParaSetDynObj.getString("crosspara"))) {
            xAxis.put("value", probabilityVals);
            xAxis.put("desc", RiskAxisEnum.PROBABILITY.getName());
            yAxis.put("value", degreeVals);
            yAxis.put("desc", RiskAxisEnum.DEGREE.getName());
            bglist = RiskScopeDefinitionUtils.setBg(probabilityVals, degreeVals, "#FAFAFA");
        } else {
            xAxis.put("value", degreeVals);
            xAxis.put("desc", RiskAxisEnum.DEGREE.getName());
            yAxis.put("value", probabilityVals);
            yAxis.put("desc", RiskAxisEnum.PROBABILITY.getName());
            bglist = RiskScopeDefinitionUtils.setBg(degreeVals, probabilityVals, "#FAFAFA");
        }
        dataMap.put("xAxis", xAxis);
        dataMap.put("yAxis", yAxis);
        dataMap.put("bg", bglist.toArray());
        DynamicObjectCollection riskColl = riskParaSetDynObj.getDynamicObjectCollection("entryentity2");
        ArrayList rislColorVals = new ArrayList(riskColl.size());
        i = 0;
        for (DynamicObject risk : riskColl) {
            HashMap<String, String> prevBgMap = new HashMap<String, String>(2);
            prevBgMap.put("value", risk.getString("riskgradecolorval"));
            prevBgMap.put("desc", risk.getString("risklevel.name"));
            prevBgMap.put("name", risk.getString("risklevel.name"));
            prevBgMap.put("riskshowcolor", risk.getString("riskshowcolorval"));
            rislColorVals.add(prevBgMap);
            ++i;
        }
        dataMap.put("prevBg", rislColorVals.toArray());
        Map<String, String> borderStyle = RiskRegisterUtils.getBorderStyle();
        dataMap.put("borderStyle", borderStyle);
        scopeMap.put("data", dataMap);
        scopeMap.put("action", "init");
        scopeMap.put("editable", true);
        return scopeMap;
    }

    private static List<String[]> setBg(String[] probabilityVals, String[] degreeVals, String color) {
        ArrayList<String[]> list = new ArrayList<String[]>(probabilityVals.length * degreeVals.length);
        for (String probabilityVal : probabilityVals) {
            for (String degreeVal : degreeVals) {
                String[] arr = new String[]{probabilityVal, degreeVal, color};
                list.add(arr);
            }
        }
        return list;
    }

    public static Set<Long> getRiskScopeToRiskParaSet() {
        HashSet<Long> riskParaSet = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects("riskparaset");
        QFilter filter = new QFilter("riskparaset", "is not null", null);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getRiskScopeDefinitio", (String)"pmrp_riskscopedefinition1", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : ds) {
                if (row == null || row.getLong("riskparaset") == 0L) continue;
                riskParaSet.add(row.getLong("riskparaset"));
            }
        }
        return riskParaSet;
    }

    public static String getRiskScopeToRiskParaSet(Long riskScopeId) {
        String selectFields = CommonUtils.getSelects("id", "riskmatrixdiagramdata_tag");
        QFilter filter = new QFilter("riskparaset", "=", (Object)riskScopeId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"pmrp_riskscopedefinition1", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (dy != null) {
            return dy.getString("riskmatrixdiagramdata_tag");
        }
        return null;
    }

    public static boolean existsRiskScopeToParaSet(Long riskParaSetId) {
        QFilter filter = new QFilter("riskparaset", "=", (Object)riskParaSetId);
        return QueryServiceHelper.exists((String)"pmrp_riskscopedefinition1", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, Object> htmlAddBg(Map<String, Object> htmlData, String riskMatrixDiagramData) {
        if (htmlData != null && !htmlData.isEmpty()) {
            if (riskMatrixDiagramData != null && !riskMatrixDiagramData.isEmpty()) {
                Map riskMatrixDiagramDataMap = (Map)SerializationUtils.fromJsonString((String)riskMatrixDiagramData, Map.class);
                Map dataMap = (Map)htmlData.get("data");
                dataMap.put("bg", riskMatrixDiagramDataMap.get("bg"));
            }
            htmlData.put("editable", false);
        }
        return htmlData;
    }

    public static Map<String, Object> setEditable(Map<String, Object> htmlData, boolean status) {
        if (htmlData != null && !htmlData.isEmpty()) {
            if (status) {
                htmlData.put("editable", true);
            } else {
                htmlData.put("editable", false);
            }
        }
        return htmlData;
    }

    public static Set<Long> getRiskScopeDefinitioForRiskParaSetToOrg(Long org) {
        HashSet<Long> riskParaSet = new HashSet<Long>(16);
        String selectFields = CommonUtils.getSelects("riskparaset");
        QFilter filter = new QFilter("riskparaset", "is not null", null);
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter paraSetStatusFilter = new QFilter("riskparaset.status", "=", (Object)Character.valueOf('C'));
        QFilter orgFilter = new QFilter("riskparaset.createorg", "=", (Object)org);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getRiskScopeDefinitio", (String)"pmrp_riskscopedefinition1", (String)selectFields, (QFilter[])new QFilter[]{filter, statusFilter, paraSetStatusFilter, orgFilter}, null);){
            for (Row row : ds) {
                if (row == null || row.getLong("riskparaset") == 0L) continue;
                riskParaSet.add(row.getLong("riskparaset"));
            }
        }
        return riskParaSet;
    }

    public static Long getRiskScopeToRiskParaSetId(Long id) {
        String selectFields = CommonUtils.getSelects("id");
        QFilter filter = new QFilter("riskparaset", "=", (Object)id);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getRiskScopeDefinitio", (String)"pmrp_riskscopedefinition1", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            for (Row row : ds) {
                if (row == null || row.getLong("id") == 0L) continue;
                Long l = row.getLong("id");
                return l;
            }
        }
        return null;
    }
}

