/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.model.workbench;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.ganttmodel.DecimalPropModel;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.common.consts.workbench.SingleProjectWorkBenchConst;
import kd.pmc.pmts.common.model.workbench.ProjectTreeBuildContext;
import kd.pmc.pmts.common.model.workbench.ProjectTreeCellModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeMenuModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeRowModel;
import kd.pmc.pmts.common.util.workbench.ProjectTreeUtil;

public class ProjectTreeRowCompent
implements Serializable {
    private static final long serialVersionUID = -4816219238243291045L;
    private ProjectTreeBuildContext context;
    private DynamicObject dynobj;
    private String entityName = "";
    private Integer level = 0;
    private Boolean isLeaf = Boolean.TRUE;
    private ProjectTreeRowCompent parentComponent;
    private List<ProjectTreeRowCompent> childComps = new LinkedList<ProjectTreeRowCompent>();
    private ProjectTreeRowModel rowDataModel;

    public ProjectTreeRowCompent(ProjectTreeBuildContext context, DynamicObject dynobj) {
        this.context = context;
        this.dynobj = dynobj;
    }

    public ProjectTreeRowCompent() {
    }

    public ProjectTreeBuildContext getContext() {
        return this.context;
    }

    public void setContext(ProjectTreeBuildContext context) {
        this.context = context;
    }

    public DynamicObject getDynobj() {
        return this.dynobj;
    }

    public void setDynobj(DynamicObject dynobj) {
        this.dynobj = dynobj;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Boolean getLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(Boolean leaf) {
        this.isLeaf = leaf;
    }

    public ProjectTreeRowCompent getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(ProjectTreeRowCompent parentComponent) {
        this.parentComponent = parentComponent;
    }

    public List<ProjectTreeRowCompent> getChildComps() {
        return this.childComps;
    }

    public void setChildComps(List<ProjectTreeRowCompent> childComps) {
        this.childComps = childComps;
    }

    public ProjectTreeRowModel getRowDataModel() {
        return this.rowDataModel;
    }

    public void setRowDataModel(ProjectTreeRowModel rowDataModel) {
        this.rowDataModel = rowDataModel;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void createRowModel() {
        String requestId = this.getContext().getRequestId();
        String id = String.valueOf(this.getDynobj().getLong("id"));
        String fieldStr = this.getContext().getEntityTreeNameMap().get(this.entityName);
        if (StringUtils.isBlank((CharSequence)fieldStr)) {
            MainEntityType entityType = this.context.getEntityMainEntityTypeMap().get(this.entityName);
            if (entityType instanceof BasedataEntityType) {
                fieldStr = "name";
            } else if (entityType instanceof BillEntityType) {
                fieldStr = "billno";
            }
        }
        String name = "";
        if (StringUtils.isNotBlank((CharSequence)fieldStr)) {
            name = this.getFieldValue(fieldStr);
        }
        ProjectTreeRowModel rowModel = new ProjectTreeRowModel(requestId.concat(id), id, null, this.getLeaf(), Boolean.TRUE, this.getLevel(), name, this.entityName);
        int pixelOfStr = ProjectTreeUtil.getPixelOfStr(name);
        rowModel.setTextWidth(10 + 20 * this.getLevel() + 20 + 20 + pixelOfStr + 10);
        List<ProjectTreeCellModel> cellModelList = this.createCellModel();
        rowModel.setCellList(cellModelList);
        rowModel.setIconKey(this.entityName);
        Integer iconIndex = -1;
        if (StringUtils.equals((CharSequence)"pmpd_project", (CharSequence)this.entityName)) {
            iconIndex = 0;
        } else if (StringUtils.equals((CharSequence)"pmts_wbs", (CharSequence)this.entityName)) {
            iconIndex = 1;
        } else if (StringUtils.equals((CharSequence)"pmts_task", (CharSequence)this.entityName)) {
            String scheduleType;
            Boolean isSpecial;
            iconIndex = 7;
            Boolean importantTask = this.getDynobj().getBoolean("importanttask");
            if (importantTask.booleanValue()) {
                iconIndex = 3;
            }
            if ((isSpecial = Boolean.valueOf(this.getDynobj().getBoolean("isspecial"))).booleanValue()) {
                iconIndex = 4;
            }
            if (StringUtils.equals((CharSequence)"3", (CharSequence)(scheduleType = this.getDynobj().getString("scheduletype")))) {
                iconIndex = 2;
            }
        } else if (StringUtils.equals((CharSequence)"pmts_materialreqlist", (CharSequence)this.entityName)) {
            iconIndex = 6;
        }
        rowModel.setIconIndex(iconIndex);
        Map<String, List<ProjectTreeMenuModel>> entityMenuMap = this.getContext().getEntityMenuMap();
        List<ProjectTreeMenuModel> menuModelList = ((List)entityMenuMap.getOrDefault(this.entityName, new ArrayList())).stream().filter(x -> x.getIsCondition() == false || x.getApplyIdSet().contains(id)).collect(Collectors.toList());
        rowModel.setMenus(menuModelList);
        this.rowDataModel = rowModel;
    }

    private String getFieldValue(String fieldStr) {
        Map decimalPropMap;
        DecimalPropModel decimalPropModel;
        Object value = this.getDynobj().get(fieldStr);
        if (Objects.isNull(value)) {
            return "";
        }
        if (StringUtils.equals((CharSequence)"number", (CharSequence)fieldStr) && this.context.getIsPublish().booleanValue() && SingleProjectWorkBenchConst.VERSION_ENTITY_LIST.contains(this.getEntityName())) {
            return value.toString().split("&")[0];
        }
        Map comboItemsMap = this.getContext().getEntityComboItemsMap().getOrDefault(this.entityName, new HashMap(16));
        List valueMapItems = (List)comboItemsMap.get(fieldStr);
        if (CollectionUtils.isNotEmpty((Collection)valueMapItems)) {
            for (ValueMapItem valueMapItem : valueMapItems) {
                if (!valueMapItem.getValue().equals(value.toString())) continue;
                return valueMapItem.getName().toString();
            }
        }
        if ((decimalPropModel = (DecimalPropModel)(decimalPropMap = (Map)this.getContext().getEntityDecimalPropMap().getOrDefault(this.entityName, new HashMap(16))).get(fieldStr)) != null) {
            BigDecimal bigDecimal = new BigDecimal(value.toString()).setScale(decimalPropModel.getScale(), 4);
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            if (decimalPropModel.getNoDisplayScaleZero()) {
                bigDecimal = bigDecimal.stripTrailingZeros();
            }
            return bigDecimal.toPlainString();
        }
        Map dateFormatMap = this.getContext().getEntityDateFormatMap().getOrDefault(this.entityName, new HashMap(16));
        String dateFormat = (String)dateFormatMap.get(fieldStr);
        if (StringUtils.isNotBlank((CharSequence)dateFormat)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            return simpleDateFormat.format((Date)value);
        }
        return value.toString();
    }

    private List<ProjectTreeCellModel> createCellModel() {
        ArrayList<ProjectTreeCellModel> cellModelList = new ArrayList<ProjectTreeCellModel>(this.getContext().getColDynList().size());
        Map<String, Map<String, String>> entityColMap = this.getContext().getEntityColMap();
        Map fieldSetMap = entityColMap.getOrDefault(this.entityName, new HashMap(1));
        for (int i = 0; i < this.getContext().getColDynList().size(); ++i) {
            ProjectTreeCellModel cellModel = new ProjectTreeCellModel();
            cellModel.setColIndex(i);
            DynamicObject dynamicObject = this.getContext().getColDynList().get(i);
            String fieldKey = dynamicObject.getString("fieldindentif");
            String fieldStr = (String)fieldSetMap.get(fieldKey);
            if (StringUtils.isNotBlank((CharSequence)fieldStr)) {
                cellModel.setFieldFlag(fieldStr);
                cellModel.setVal(this.getFieldValue(fieldStr));
            }
            cellModelList.add(cellModel);
        }
        return cellModelList;
    }

    public void setPidList() {
        ArrayList<String> pidList = new ArrayList<String>();
        this.getPIdList(this, pidList);
        this.rowDataModel.setPids(pidList);
    }

    private void getPIdList(ProjectTreeRowCompent compent, List<String> pidList) {
        ProjectTreeRowCompent parentComponent = compent.getParentComponent();
        if (parentComponent != null) {
            pidList.add(parentComponent.getRowDataModel().getId());
            this.getPIdList(parentComponent, pidList);
        }
    }
}

