/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util.workbench;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.common.consts.workbench.SingleProjectWorkBenchConst;
import kd.pmc.pmts.common.model.workbench.GanttDataSourceModel;
import kd.pmc.pmts.common.util.workbench.SingleProjectBenchUtil;

public class ProjectTreeUtil {
    private static Log logger = LogFactory.getLog(ProjectTreeUtil.class);
    private static String font = "Microsoft YaHei";
    private static int fontSize = 12;

    public static int getPixelOfStr(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            return 0;
        }
        Font f = new Font(font, 0, fontSize);
        JLabel j = new JLabel();
        FontMetrics fm = j.getFontMetrics(f);
        int descLength = fm.stringWidth(desc);
        return descLength;
    }

    public static List<String> getPatchRelation(DynamicObject configDyn, GanttDataSourceModel sourceModel) {
        DynamicObjectCollection entryColl = configDyn.getDynamicObjectCollection("configentry");
        Map<String, List<String>> upEntityMap = sourceModel.getUpEntityMap();
        HashSet<String> allEntitySet = new HashSet<String>(10);
        for (Object dynamicObject : entryColl) {
            String string = dynamicObject.getString("pnodestr");
            DynamicObject entityDyn = dynamicObject.getDynamicObject("confentity");
            String number = entityDyn.getString("number");
            allEntitySet.add(number);
            if (upEntityMap.containsKey(number) || !StringUtils.isNotBlank((CharSequence)string)) continue;
            Map pNodeMap = (Map)SerializationUtils.fromJsonString((String)string, Map.class);
            for (String upEntity : pNodeMap.keySet()) {
                List stringList = upEntityMap.computeIfAbsent(number, k -> new ArrayList());
                stringList.add(upEntity);
            }
        }
        HashSet<String> allUpEntityList = new HashSet<String>(entryColl.size());
        for (List list : upEntityMap.values()) {
            for (String s : list) {
                allUpEntityList.add(s);
            }
        }
        String lastEntity = "";
        for (String entity : allEntitySet) {
            if (allUpEntityList.contains(entity)) continue;
            lastEntity = entity;
        }
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> patchList = new ArrayList<String>();
        ProjectTreeUtil.getUp(upEntityMap, lastEntity, patchList, arrayList);
        if (CollectionUtils.isEmpty(arrayList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u3002", (String)"ProjectTreeUtil_0", (String)"mmc-pmts-common", (Object[])new Object[0]));
        }
        arrayList.sort((x1, x2) -> x2.size() - x1.size());
        return (List)arrayList.get(0);
    }

    private static void getUp(Map<String, List<String>> upEntityMap, String entity, List<String> patchList, List<List<String>> allList) {
        if (patchList.contains(entity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u7684\u5de5\u4f5c\u53f0\u914d\u7f6e\u65b9\u6848\u5b9e\u4f53\u5173\u7cfb\u5b58\u5728\u95ed\u73af\uff0c\u8bf7\u68c0\u67e5", (String)"ProjectTreeUtil_1", (String)"mmc-pmts-common", (Object[])new Object[0]));
        }
        patchList.add(entity);
        List<String> upList = upEntityMap.get(entity);
        if (CollectionUtils.isNotEmpty(upList)) {
            for (int i = 0; i < upList.size(); ++i) {
                if (i == upList.size() - 1) {
                    ProjectTreeUtil.getUp(upEntityMap, upList.get(i), patchList, allList);
                    continue;
                }
                ArrayList<String> copyList = new ArrayList<String>(patchList.size());
                for (String s : patchList) {
                    copyList.add(s);
                }
                ProjectTreeUtil.getUp(upEntityMap, upList.get(i), copyList, allList);
            }
        } else {
            allList.add(patchList);
        }
    }

    public static void showBillFormInContainer(IFormView view, String entityKey, Object pkId, String flex) {
        if (pkId != null && !StringUtils.equals((CharSequence)"0", (CharSequence)pkId.toString())) {
            QFilter qFilter;
            DynamicObject dynamicObject;
            SingleProjectBenchUtil.closeViewByPageId(view, flex);
            Map entityOpenPageMap = (Map)GanttBigObjectCache.get((String)view.getPageId(), (String)"openPage");
            String openPage = entityOpenPageMap.getOrDefault(entityKey, entityKey);
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId(openPage);
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(flex);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setPkId(pkId);
            String pageId = flex.concat("_").concat(pkId.toString()).concat("_").concat(view.getPageId()).concat(Long.toString(System.currentTimeMillis()));
            formShowParameter.setPageId(pageId);
            view.getPageCache().put(flex, pageId);
            if (StringUtils.equals((CharSequence)"pmts_task", (CharSequence)entityKey) && "3".equals((dynamicObject = QueryServiceHelper.queryOne((String)"pmts_task", (String)"scheduletype", (QFilter[])(qFilter = new QFilter("id", "=", pkId)).toArray())).getString("scheduletype"))) {
                formShowParameter.setFormId("pmts_milestone");
            }
            if (SingleProjectBenchUtil.isPulishPage(view.getPageCache()).booleanValue() && SingleProjectWorkBenchConst.VERSION_ENTITY_LIST.contains(entityKey)) {
                formShowParameter.setCustomParam("isPulishPage", (Object)"true");
                formShowParameter.addCustPlugin("kd.pmc.pmts.formplugin.base.projecttree.FmmHiddenPagePanelPlugin");
                view.showForm((FormShowParameter)formShowParameter);
            } else {
                if (StringUtils.equals((CharSequence)entityKey, (CharSequence)"pmts_materialreqlist")) {
                    formShowParameter.addCustPlugin("kd.pmc.pmts.formplugin.workbench.PmtsHiddenPagePanelPlugin");
                } else if (Arrays.asList("pmpd_project", "pmts_wbs", "pmts_task").contains(entityKey)) {
                    formShowParameter.addCustPlugin("kd.pmc.pmts.formplugin.base.projecttree.FmmHiddenPagePanelPlugin");
                }
                formShowParameter.addCustPlugin("kd.pmc.pmts.formplugin.base.projecttree.ChangeUpdateViewPlugin");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)SingleProjectBenchUtil.getBusiOpEdit(view), "updateTree"));
                formShowParameter.setCustomParam("benchPageId", (Object)view.getPageId());
                formShowParameter.setCustomParam("tabkey", (Object)flex);
                boolean hasModify = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (String)view.getFormShowParameter().getAppId(), (String)entityKey, (String)"4715a0df000000ac");
                if (hasModify) {
                    String ignoreLock = view.getPageCache().get("ignorelock");
                    if (StringUtils.isNotBlank((CharSequence)ignoreLock)) {
                        view.getPageCache().remove("ignorelock");
                        MutexHelper.release((String)entityKey, (String)"modify", (String)String.valueOf(pkId));
                    }
                    StringBuilder failInfo = new StringBuilder();
                    MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), "", (String)null, entityKey, "modify", true, "default");
                    boolean isMutexLocked = MutexHelper.require((IFormView)view, (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
                    if (isMutexLocked) {
                        MutexHelper.release((String)entityKey, (String)"modify", (String)String.valueOf(pkId));
                        formShowParameter.setStatus(OperationStatus.EDIT);
                        view.showForm((FormShowParameter)formShowParameter);
                    } else {
                        view.showForm((FormShowParameter)formShowParameter);
                        boolean hasView = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (String)view.getFormShowParameter().getAppId(), (String)entityKey, (String)"4715a0df000000ac");
                        if (hasView) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u8be5\u6570\u636e\uff0c\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00", (String)"ProjectTreeUtil_2", (String)"mmc-pmts-common", (Object[])new Object[0]));
                        }
                    }
                } else {
                    view.showForm((FormShowParameter)formShowParameter);
                    boolean hasView = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (String)view.getFormShowParameter().getAppId(), (String)entityKey, (String)"4715a0df000000ac");
                    if (hasView) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u4fee\u6539\u6743\u9650\uff0c\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00", (String)"ProjectTreeUtil_3", (String)"mmc-pmts-common", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public static void removeCache(IFormView view) {
        view.getPageCache().remove("openDataId");
        view.getPageCache().remove("selectEntity");
        view.getPageCache().remove("selectDataId");
    }

    public static void queryWbsChild(List<Object> id, List<Object> idList) {
        QFilter qFilter1 = new QFilter("parent", "in", id);
        List objectList = QueryServiceHelper.queryPrimaryKeys((String)"pmts_wbs", (QFilter[])new QFilter[]{qFilter1}, null, (int)-1);
        if (CollectionUtils.isNotEmpty((Collection)objectList)) {
            idList.addAll(objectList);
            ProjectTreeUtil.queryWbsChild(objectList, idList);
        }
    }

    public static DynamicObject getProjectBenchConfig(Object projectId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection configColl = QueryServiceHelper.query((String)"pmts_wkbenchconfigplan", (String)"id, headfilter_tag", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime desc");
        if (CollectionUtils.isNotEmpty((Collection)configColl)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pmpd_project");
            for (DynamicObject dynamicObject : configColl) {
                String filterStr = dynamicObject.getString("headfilter_tag");
                long id = dynamicObject.getLong("id");
                if (StringUtils.isBlank((CharSequence)filterStr)) {
                    return ProjectTreeUtil.loadProjectBenchConfig(id);
                }
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
                fb.buildFilter(false);
                List qFilters = fb.getQFilters();
                qFilters.add(new QFilter("id", "=", projectId));
                boolean exists = QueryServiceHelper.exists((String)"pmpd_project", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
                if (!exists) continue;
                return ProjectTreeUtil.loadProjectBenchConfig(id);
            }
        }
        return null;
    }

    private static DynamicObject loadProjectBenchConfig(long configId) {
        return BusinessDataServiceHelper.loadSingle((Object)configId, (String)"pmts_wkbenchconfigplan");
    }
}

