/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.common.util.workbench;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.common.model.workbench.ProjectTreeBuildContext;
import kd.pmc.pmts.common.util.ShowFormUtils;
import kd.pmc.pmts.common.util.workbench.ProjectTreeUtil;

public class SingleProjectBenchUtil {
    protected static final Log logger = LogFactory.getLog(SingleProjectBenchUtil.class);
    private static final String ENTITY_TASK = "pmts_task";
    public static final String CACHE_PROJECT = "cache_project";
    public static final String CACHE_PRE_PROJECT = "cache_pre_project";
    private static Map<String, String> pageMap = new HashMap<String, String>();

    public static ProjectTreeBuildContext getContextByCache(String pageId) {
        ProjectTreeBuildContext context = (ProjectTreeBuildContext)GanttBigObjectCache.get((String)pageId, (String)"context");
        return context;
    }

    public static String getProjectIdStr(IPageCache pageCache) {
        String projectIdStr = pageCache.get(CACHE_PROJECT);
        return StringUtils.equals((CharSequence)projectIdStr, (CharSequence)"0") ? null : projectIdStr;
    }

    public static String getPreProjectIdStr(IPageCache pageCache) {
        String preProjectIdStr = pageCache.get(CACHE_PRE_PROJECT);
        return StringUtils.equals((CharSequence)preProjectIdStr, (CharSequence)"0") ? null : preProjectIdStr;
    }

    public static void cacheProjectIdStr(IPageCache pageCache, String projectId) {
        String preProjectIdStr = SingleProjectBenchUtil.getProjectIdStr(pageCache);
        pageCache.put(CACHE_PROJECT, projectId);
        if (StringUtils.isNotBlank((CharSequence)preProjectIdStr)) {
            pageCache.put(CACHE_PRE_PROJECT, preProjectIdStr);
        }
    }

    public static String getPublishVersion(IPageCache pageCache) {
        return pageCache.get("publishVersionId");
    }

    public static Boolean isPulishPage(IPageCache pageCache) {
        return StringUtils.isNotBlank((CharSequence)pageCache.get("publishVersionId"));
    }

    public static void showChangeTabInfo(IFormView view) {
        boolean dataChange;
        String openDataId = view.getPageCache().get("openDataId");
        String selectEntity = view.getPageCache().get("selectEntity");
        String selectDataId = view.getPageCache().get("selectDataId");
        boolean bl = dataChange = StringUtils.isNotBlank((CharSequence)openDataId) && StringUtils.equals((CharSequence)openDataId, (CharSequence)selectDataId);
        if (dataChange) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)selectDataId)) {
            view.getPageCache().put("openDataId", selectDataId);
            ProjectTreeUtil.showBillFormInContainer(view, selectEntity, Long.parseLong(selectDataId), "flex_change");
        }
    }

    public static FormShowParameter getBillShowParam(IFormView view, AbstractFormPlugin plugin, String operateKey) {
        String pageStr = pageMap.get(operateKey);
        if (StringUtils.isBlank((CharSequence)pageStr)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        String orgIdStr = Long.toString(orgId);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)pageStr, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        MainEntityType srcbillMainType = EntityMetadataCache.getDataEntityTypeById((String)formMeta.getEntityId());
        boolean permission = ShowFormUtils.isPermission((String)srcbillMainType.getName(), (Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)orgIdStr, (IFormView)view);
        if (!permission) {
            return null;
        }
        HashMap<String, String> para = new HashMap<String, String>(8);
        para.put("createorg", orgIdStr);
        para.put("useorgId", orgIdStr);
        para.put("formId", pageStr);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, operateKey));
        return showParameter;
    }

    public static AbstractFormPlugin getBusiOpEdit(IFormView view) {
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        AbstractFormPlugin busiOpEdit = (AbstractFormPlugin)service.getPlugIns().stream().filter(p -> p.getPluginName().contains("SingleProjectBenchBusiOpEdit")).findFirst().get();
        return busiOpEdit;
    }

    public static void closeViewByPageId(IFormView view, String flex) {
        IFormView historyView;
        String pageId = view.getPageCache().get(flex);
        if (StringUtils.isNotBlank((CharSequence)pageId) && (historyView = SessionManager.getCurrent().getView(pageId)) != null) {
            try {
                historyView.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            }
            catch (Exception exception) {
                logger.info("closeViewByPageId#setDataChanged#false_fail info:" + exception.getMessage());
            }
            historyView.close();
            view.sendFormAction(historyView);
        }
    }

    public static DynamicObject queryPublishVersion(Object projectId) {
        QFilter qFilter = new QFilter("versiontype", "=", (Object)1565962687752550400L);
        qFilter.and(new QFilter("projectnum", "=", projectId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_gantt_version_task", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        return CollectionUtils.isNotEmpty((Collection)query) ? (DynamicObject)query.get(0) : null;
    }

    public static void changeTabName(IFormView view, String entityKey) {
        String tabName = ResManager.loadKDString((String)"\u4efb\u52a1", (String)"SingleProjectBenchUtil_0", (String)"mmc-pmts-common", (Object[])new Object[0]);
        if (!StringUtils.equals((CharSequence)entityKey, (CharSequence)ENTITY_TASK)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            tabName = dataEntityType.getDisplayName().getLocaleValue();
        }
        HashMap<String, String> nameMap = new HashMap<String, String>(2);
        nameMap.put(Lang.get().getLocale().toString(), tabName);
        HashMap<String, HashMap<String, String>> changeMap = new HashMap<String, HashMap<String, String>>(2);
        changeMap.put("text", nameMap);
        view.updateControlMetadata("tab_change", changeMap);
    }

    public static void changeViewTab(IFormView view, String tabFlexName, String tabKey) {
        Tab tab = (Tab)view.getControl(tabFlexName);
        tab.activeTab(tabKey);
    }

    public static void changeTabVisible(IFormView view, String entityKey) {
        HashSet<String> needDispEntities = new HashSet<String>(){
            {
                this.add("pmpd_project");
                this.add("pmts_wbs");
            }
        };
        Map<String, Boolean> permTabsMap = SingleProjectBenchUtil.getPermTabsMap();
        Map partitionedMap = permTabsMap.entrySet().stream().collect(Collectors.partitioningBy(e -> e.getValue() != null && (Boolean)e.getValue() != false, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        Object[] hasPermTabs = partitionedMap.getOrDefault(true, Collections.emptySet()).toArray(new String[0]);
        view.setVisible(Boolean.valueOf(needDispEntities.contains(entityKey)), (String[])hasPermTabs);
        logger.info("SingleProjectBenchUtil#changeTabVisible entityKey:" + entityKey);
        logger.info("SingleProjectBenchUtil#changeTabVisible hasPermTabs:" + Arrays.toString(hasPermTabs));
    }

    private static Map<String, Boolean> getPermTabsMap() {
        Map<String, Tuple<String, String>> tabToEntityInfo = SingleProjectBenchUtil.getTabToEntityInfo();
        long currUserId = RequestContext.get().getCurrUserId();
        HashMap<String, Boolean> permResultMap = new HashMap<String, Boolean>(tabToEntityInfo.size());
        tabToEntityInfo.forEach((key, tuple) -> {
            boolean hasPerm = PermissionServiceHelper.hasViewPermission((long)currUserId, (String)((String)tuple.item1), (String)((String)tuple.item2));
            permResultMap.computeIfAbsent((String)key, k -> false);
            permResultMap.put((String)key, hasPerm);
        });
        SingleProjectBenchUtil.updateAdditionalPermissions(permResultMap);
        logger.info("SingleProjectBenchUtil#getPermTabsMap#permResultMap\uff1a" + ((Object)permResultMap).toString());
        return permResultMap;
    }

    private static void updateAdditionalPermissions(Map<String, Boolean> permResultMap) {
        if (permResultMap.getOrDefault("tab_projcontractsum", false).booleanValue() && permResultMap.getOrDefault("tab_projfuldetail", false).booleanValue() && permResultMap.getOrDefault("tab_projorderexec", false).booleanValue()) {
            permResultMap.put("tab_projsumcontract", true);
        } else {
            permResultMap.put("tab_projsumcontract", false);
        }
        if (permResultMap.getOrDefault("tab_projsalesum", false).booleanValue() && permResultMap.getOrDefault("tab_projfulacct", false).booleanValue() && permResultMap.getOrDefault("tab_projorserexec", false).booleanValue()) {
            permResultMap.put("tab_projsale", true);
        } else {
            permResultMap.put("tab_projsale", false);
        }
    }

    private static Map<String, Tuple<String, String>> getTabToEntityInfo() {
        return new HashMap<String, Tuple<String, String>>(){
            {
                this.put("tab_projcontractsum", new Tuple((Object)"conm", (Object)"conm_pursynthesisrpt"));
                this.put("tab_projfuldetail", new Tuple((Object)"conm", (Object)"conm_purexecutedetailed"));
                this.put("tab_projorderexec", new Tuple((Object)"pm", (Object)"pm_purorderbillrpt_new"));
                this.put("tab_projsalesum", new Tuple((Object)"conm", (Object)"conm_salsynthesisrpt"));
                this.put("tab_projfulacct", new Tuple((Object)"conm", (Object)"conm_salexecutedetailed"));
                this.put("tab_projorserexec", new Tuple((Object)"pm", (Object)"pm_purorderbillrpt_new"));
                this.put("tab_projproduct", new Tuple((Object)"mpdm", (Object)"mpdm_orderdetail_tpl"));
                this.put("tab_projoutproduct", new Tuple((Object)"mpdm", (Object)"mpdm_orderdetail_tpl"));
            }
        };
    }

    public static void asynOpenProjectPage(IFormView view, Long projectId) {
        ProjectTreeUtil.showBillFormInContainer(view, "pmpd_project", projectId, "flex_change");
        SingleProjectBenchUtil.changeTabName(view, "pmpd_project");
        SingleProjectBenchUtil.changeViewTab(view);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDataChangedByPageId(IFormView view, String flex) {
        IFormView historyView = SingleProjectBenchUtil.getFlexViewByPageId(view, flex);
        String result = "";
        if (historyView != null) {
            try {
                IDataModel historyViewModel = historyView.getModel();
                if (historyViewModel.getDataChanged()) {
                    result = historyViewModel.getChangeDesc();
                }
            }
            catch (Exception e) {
                logger.info("closeViewByPageId#setDataChanged#false_fail info:" + e.getMessage());
            }
        }
        return result;
    }

    public static void setNotChangedByPageId(IFormView view, String flex) {
        IFormView historyView = SingleProjectBenchUtil.getFlexViewByPageId(view, flex);
        if (historyView != null) {
            IDataModel historyViewModel = historyView.getModel();
            historyViewModel.setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    public static IFormView getFlexViewByPageId(IFormView view, String flex) {
        IFormView historyView;
        String pageId = view.getPageCache().get(flex);
        if (StringUtils.isNotBlank((CharSequence)pageId) && (historyView = SessionManager.getCurrent().getView(pageId)) != null) {
            return historyView;
        }
        return null;
    }

    public static String getFirstOpenTabCacheKey(String tab) {
        return "firstOpenCache_" + tab;
    }

    public static void changeViewTab(IFormView view) {
        SingleProjectBenchUtil.changeViewTab(view, "tabap", "tab_change");
        SingleProjectBenchUtil.changeViewTab(view, "tabap1", "tab_projcontractsum");
        SingleProjectBenchUtil.changeViewTab(view, "tabap2", "tab_projsalesum");
        SingleProjectBenchUtil.markRptAsFirstOpen(view);
    }

    private static void markRptAsFirstOpen(IFormView view) {
        view.getPageCache().put(SingleProjectBenchUtil.getFirstOpenTabCacheKey("tab_projsumcontract"), "TRUE");
        view.getPageCache().put(SingleProjectBenchUtil.getFirstOpenTabCacheKey("tab_projsale"), "TRUE");
    }

    static {
        pageMap.put("addproject", "pmpd_project_fastinsert");
        pageMap.put("addwbs", "pmts_wbs_insert");
        pageMap.put("addtask", "pmts_task_insert");
    }
}

