/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.report.inprocess;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.utils.AuxPropertyHelperUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class MftOrderProdWIPRptListPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MftOrderProdWIPRptListPlugin.class);
    private final String thisClass = ((Object)((Object)this)).getClass().getName() + " : ";
    private static final String[] TOTAL_COLUMN = new String[]{"moduleno", "modulename", "moduleconfig", "auxproperty", "operationdesc", "workstation", "modulemodel", "modulenuit"};
    private static final String[] GROUP_FIELDS = new String[]{"orgname", "billno", "billrow", "transactionname", "biztype", "materialno", "materialname", "configuredcode", "planbegintime", "bdprojectno", "bdprojectname", "tracknumber", "moduleno", "modulename", "moduleconfig", "auxproperty", "operationdesc", "workstation", "workcenter", "materialmodel", "modulemodel", "hidenuit", "modulenuit", "org", "material", "module", "billrowint", "hideauxproperty"};
    private static final String[] MFT_INFO_FIELDS = new String[]{"materialno", "materialname", "materialmodel"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String sort;
        FilterInfo filter = reportQueryParam.getFilter();
        String selectedProperty = this.getSelectFields();
        List<QFilter> qFilterList = this.createHeadFilters(filter);
        qFilterList.add(new QFilter("orderentryid.producttype", "=", (Object)"C"));
        QFilter[] mftStockSel = qFilterList.toArray(new QFilter[0]);
        DataSet results = QueryServiceHelper.queryDataSet((String)(this.thisClass + "query"), (String)"pom_mftstock", (String)selectedProperty, (QFilter[])mftStockSel, null);
        results = results.addField("Cast(billrowint as String) as billrow", "billrow");
        results = this.joinProduct(results);
        results = this.joinAuxProperty(results);
        results = results.where("wipqty != 0");
        results = results.groupBy(GROUP_FIELDS).sum("demandqty").sum("actissueqty").sum("rejectedqty").sum("feedingqty").sum("useqty").sum("wipqty").sum("allotqty").finish();
        results = results.addField("actissueqty + feedingqty - rejectedqty", "sendingqty");
        results = results.select(results.getRowMeta().getFieldNames()).where("wipqty > 0");
        results = this.funnelFilter(results, filter);
        HashSet checkSet = new HashSet();
        results.copy().forEach(row -> checkSet.add(row.get("org")));
        String amountStr = filter.getString("amount");
        if (!checkSet.isEmpty() && StringUtils.isNotEmpty((String)amountStr)) {
            results = this.getAddUp(results, amountStr);
        }
        if (StringUtils.isNotEmpty((String)(sort = reportQueryParam.getSortInfo()))) {
            String[] sortArr = sort.split(" ");
            if (StringUtils.isNotEmpty((String)amountStr)) {
                if ("moduleno".equals(sortArr[0]) || "modulename".equals(sortArr[0])) {
                    results = results.orderBy(new String[]{sort});
                }
            } else {
                results = results.orderBy(new String[]{sort});
            }
        }
        if (((Boolean)filter.getValue("showsumrow")).booleanValue()) {
            DataSet sumDataSet = this.getSumUp(results);
            results = this.union(results, sumDataSet);
        }
        return results;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        HashSet<String> dimList = new HashSet<String>();
        dimList.add("org");
        dimList.add("billrowint");
        dimList.add("material");
        dimList.add("module");
        dimList.add("hidenuit");
        dimList.add("hideauxproperty");
        FilterInfo filter = this.getQueryParam().getFilter();
        if (StringUtils.isEmpty((String)filter.getString("amount")) && !((Boolean)filter.getValue("showsumrow")).booleanValue()) {
            dimList.add("sumtext");
        }
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            String fieldKey = reportColumn.getFieldKey();
            reportColumn.setHide(dimList.contains(fieldKey));
        }
        return super.getColumns(columns);
    }

    protected String getSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("org,");
        sb.append("org.name AS orgname,");
        sb.append("orderentryid.headbillno AS billno,");
        sb.append("orderentryid.entryseq AS billrowint,");
        sb.append("transactiontypeid.name AS transactionname,");
        sb.append("bdproject.number AS bdprojectno,");
        sb.append("bdproject.name AS bdprojectname,");
        sb.append("orderentryid.tracknumber.number AS tracknumber,");
        sb.append("orderentryid.planbegintime AS planbegintime,");
        sb.append("orderentryid.material AS material,");
        sb.append("orderentryid.configuredcode.number AS configuredcode,");
        sb.append("transactiontypeid.transactiontype.name AS biztype,");
        sb.append("stockentry.oprworkcenter.name AS workcenter,");
        sb.append("stockentry.materielmasterid AS module,");
        sb.append("stockentry.materielmasterid.number AS moduleno,");
        sb.append("stockentry.materielmasterid.name AS modulename,");
        sb.append("stockentry.entryconfiguredcode.number AS moduleconfig,");
        sb.append("stockentry.childauxpropertyid AS hideauxproperty,");
        sb.append("stockentry.operationdesc AS operationdesc,");
        sb.append("stockentry.workstation.name AS workstation,");
        sb.append("stockentry.materielmasterid.modelnum AS modulemodel,");
        sb.append("stockentry.materialunitid AS hidenuit,");
        sb.append("stockentry.materialunitid.name AS modulenuit,");
        sb.append("stockentry.demandqty AS demandqty,");
        sb.append("stockentry.actissueqty AS actissueqty,");
        sb.append("stockentry.rejectedqty AS rejectedqty,");
        sb.append("stockentry.feedingqty AS feedingqty,");
        sb.append("stockentry.useqty AS useqty,");
        sb.append("stockentry.wipqty AS wipqty,");
        sb.append("stockentry.allotqty AS allotqty");
        return sb.toString();
    }

    protected List<QFilter> createHeadFilters(FilterInfo filter) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(16);
        this.createOrgFilter(filter, qfList);
        this.createBizTypeFilter(filter, qfList);
        this.createTransactionFilter(filter, qfList);
        this.createBillNoFilter(filter, qfList);
        this.createProdNoFilter(filter, qfList);
        this.createStockFilter(filter, qfList);
        this.createBDProjFilter(filter, qfList);
        this.createFollowNoFilter(filter, qfList);
        this.createCrTimeFilter(filter, qfList);
        this.createStartTimeFilter(filter, qfList);
        this.createFinishTimeFilter(filter, qfList);
        this.createBizStatusFilter(filter, qfList);
        this.createPlanStatusFilter(filter, qfList);
        this.createTaskStatusFilter(filter, qfList);
        this.createPickStatusFilter(filter, qfList);
        return qfList;
    }

    private DataSet joinProduct(DataSet resultDataSet) {
        HashSet<Long> materialMftIds = new HashSet<Long>();
        for (Row row : resultDataSet.copy()) {
            Long materialId = row.getLong("material");
            if (materialId == null || materialId == 0L) continue;
            materialMftIds.add(materialId);
        }
        String mftInfoSel = "id infoid, masterid";
        QFilter[] mftInfoQF = new QFilter[]{new QFilter("id", "in", materialMftIds)};
        DataSet mftInfoDataSet = QueryServiceHelper.queryDataSet((String)(this.thisClass + "joinProduct"), (String)"bd_materialmftinfo", (String)mftInfoSel, (QFilter[])mftInfoQF, null);
        HashSet<Long> materialIds = new HashSet<Long>();
        for (Row row : mftInfoDataSet.copy()) {
            materialIds.add(row.getLong("masterid"));
        }
        String materialSel = "id, number AS materialno, name AS materialname, modelnum AS materialmodel";
        QFilter[] materialQf = new QFilter[]{new QFilter("id", "in", materialIds)};
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)(this.thisClass + "joinProduct"), (String)"bd_material", (String)materialSel, (QFilter[])materialQf, null);
        mftInfoDataSet = mftInfoDataSet.join(materialDataSet).select(new String[]{"infoid", "materialno", "materialname", "materialmodel"}).on("masterid", "id").finish();
        String[] stockFieldNames = resultDataSet.getRowMeta().getFieldNames();
        resultDataSet = resultDataSet.leftJoin(mftInfoDataSet).select(stockFieldNames, MFT_INFO_FIELDS).on("material", "infoid").finish();
        return resultDataSet;
    }

    private DataSet joinAuxProperty(DataSet resultDataSet) {
        HashSet<Long> auxPropIds = new HashSet<Long>();
        for (Row row : resultDataSet.copy()) {
            Long auxId = row.getLong("hideauxproperty");
            if (auxId == null || auxId == 0L) continue;
            auxPropIds.add(auxId);
        }
        Map hgResultsMap = AuxPropertyHelperUtils.getAuxPropertyStringByIds(auxPropIds);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(new RowMeta(new Field[]{new Field("hideauxid", (DataType)DataType.LongType), new Field("auxproperty", (DataType)DataType.StringType)}));
        for (Map.Entry map : hgResultsMap.entrySet()) {
            dataSetBuilder.append(new Object[]{map.getKey(), map.getValue()});
        }
        DataSet axuDataSet = dataSetBuilder.build();
        String[] resultFieldNames = resultDataSet.getRowMeta().getFieldNames();
        String[] axuFieldNames = new String[]{"hideauxid", "auxproperty"};
        resultDataSet = resultDataSet.leftJoin(axuDataSet).select(resultFieldNames, axuFieldNames).on("hideauxproperty", "hideauxid").finish();
        return resultDataSet;
    }

    protected DataSet funnelFilter(DataSet results, FilterInfo filter) {
        List headFilters = filter.getHeadFilters();
        if (headFilters.isEmpty()) {
            return results;
        }
        StringJoiner whereSJ = new StringJoiner(" AND ");
        for (QFilter headFilter : headFilters) {
            String varStr;
            String property = headFilter.getProperty();
            String cp = headFilter.getCP();
            Object value = headFilter.getValue();
            DynamicProperty dynamicProperty = MetadataServiceHelper.getDataEntityType((String)"pom_prodwipsearch").getProperty(property);
            if (dynamicProperty instanceof QtyProp) {
                whereSJ.add(property + ' ' + cp + ' ' + value);
                continue;
            }
            if (dynamicProperty instanceof TextProp) {
                if ("is null".equals(cp)) {
                    whereSJ.add(property + " is null ");
                    continue;
                }
                if ("is not null".equals(cp)) {
                    whereSJ.add(property + " is not null ");
                    continue;
                }
                whereSJ.add(headFilter.toString());
                continue;
            }
            if (!(dynamicProperty instanceof DateTimeProp)) continue;
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            String[] dayFilters = new String[2];
            if ("=".equals(cp)) {
                dayFilters[0] = property + " >= " + value + " 00:00:00'";
                dayFilters[1] = property + " <= " + value + " 23:59:59'";
            } else {
                dayFilters = headFilter.toString().split(" AND ");
            }
            if ((varStr = this.dateArrayFilterTransfer(dayFilters, filterMap)).isEmpty()) continue;
            results = results.where(varStr, filterMap);
        }
        if (whereSJ.length() > 0) {
            results = results.where(whereSJ.toString());
        }
        return results;
    }

    private String dateArrayFilterTransfer(String[] dayFilters, Map<String, Object> filterMap) {
        StringJoiner varSJ = new StringJoiner(" AND ");
        for (int i = 0; i < dayFilters.length; ++i) {
            String[] splitTime = dayFilters[i].split("'");
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = sdf.parse(splitTime[1]);
                filterMap.put("var" + i, date);
                varSJ.add(splitTime[0] + "var" + i);
                continue;
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        }
        return varSJ.toString();
    }

    protected DataSet getAddUp(DataSet dataSet, String amountStr) {
        if (!"addup01".equals(amountStr)) {
            return dataSet;
        }
        DataSet[] dataSets = dataSet.splitByGroup(TOTAL_COLUMN);
        ArrayList<DataSet> dataList = new ArrayList<DataSet>(dataSets.length);
        for (DataSet addSet : dataSets) {
            HashMap<String, Object> addData = new HashMap<String, Object>();
            for (Row row : addSet.copy()) {
                for (String showColumn : TOTAL_COLUMN) {
                    addData.put(showColumn, row.get(showColumn) != null ? row.get(showColumn) : "");
                }
                addData.put("hidenuit", row.get("hidenuit"));
            }
            DataSet sumDataSet = this.addUpGroupData(addSet, addData);
            DataSet addDataSet = this.union(addSet, sumDataSet);
            dataList.add(addDataSet);
        }
        if (dataList.size() == 1) {
            return (DataSet)dataList.get(0);
        }
        DataSet auSet = (DataSet)dataList.get(0);
        for (int i = 1; i < dataList.size(); ++i) {
            auSet = auSet.union((DataSet)dataList.get(i));
        }
        return auSet;
    }

    protected DataSet addUpGroupData(DataSet dataSet, Map<String, Object> addData) {
        DataSet sumDataSet = dataSet.select(dataSet.getRowMeta().getFieldNames()).groupBy(null).sum("demandqty").sum("actissueqty").sum("rejectedqty").sum("feedingqty").sum("sendingqty").sum("useqty").sum("wipqty").sum("allotqty").finish();
        sumDataSet = sumDataSet.addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"MftOrderProdWIPRptListPlugin_2", (String)"mmc-pom-report", (Object[])new Object[0]), "sumtext");
        for (String showColumn : TOTAL_COLUMN) {
            sumDataSet = sumDataSet.addField(String.format("'%1$s'", addData.get(showColumn)), showColumn);
        }
        sumDataSet = sumDataSet.addField(String.format("%1$d", (Long)addData.get("hidenuit")), "hidenuit");
        HashSet surplus = new HashSet();
        Collections.addAll(surplus, dataSet.getRowMeta().getFieldNames());
        Arrays.stream(sumDataSet.getRowMeta().getFieldNames()).forEach(surplus::remove);
        String[] fields = surplus.toArray(new String[0]);
        sumDataSet = sumDataSet.addNullField(fields);
        return sumDataSet;
    }

    private DataSet union(DataSet resultDataSet, DataSet sumDataSet) {
        HashSet<String> resSet = new HashSet<String>();
        Collections.addAll(resSet, resultDataSet.getRowMeta().getFieldNames());
        if (resSet.add("sumtext")) {
            resultDataSet = resultDataSet.addNullField("sumtext");
        }
        String[] resArray = resSet.toArray(new String[0]);
        resultDataSet = resultDataSet.select(resArray).union(sumDataSet.select(resArray));
        return resultDataSet;
    }

    protected DataSet getSumUp(DataSet resultDataSet) {
        DataSet sumDataSet = resultDataSet.select(resultDataSet.getRowMeta().getFieldNames()).groupBy(null).sum("demandqty").sum("actissueqty").sum("rejectedqty").sum("feedingqty").sum("sendingqty").sum("useqty").sum("wipqty").sum("allotqty").finish();
        sumDataSet = sumDataSet.addField(ResManager.loadKDString((String)"'\u603b\u8ba1'", (String)"MftOrderProdWIPRptListPlugin_1", (String)"mmc-pom-report", (Object[])new Object[0]), "sumtext");
        HashSet surplus = new HashSet();
        Collections.addAll(surplus, resultDataSet.getRowMeta().getFieldNames());
        Arrays.stream(sumDataSet.getRowMeta().getFieldNames()).forEach(surplus::remove);
        String[] fields = surplus.toArray(new String[0]);
        sumDataSet = sumDataSet.addNullField(fields);
        return sumDataSet;
    }

    private void createOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection prodOrg = filter.getDynamicObjectCollection("orgmul");
        if (prodOrg != null) {
            HashSet<Object> idSet = new HashSet<Object>(prodOrg.size());
            for (DynamicObject obj : prodOrg) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("org", "in", idSet));
        }
    }

    private void createBizTypeFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection bizType = filter.getDynamicObjectCollection("biztypemul");
        if (bizType != null) {
            HashSet<Object> idSet = new HashSet<Object>(bizType.size());
            for (DynamicObject obj : bizType) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("transactiontypeid.transactiontype", "in", idSet));
        }
    }

    private void createTransactionFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection transactionTypeId = filter.getDynamicObjectCollection("transactmul");
        if (transactionTypeId != null) {
            HashSet<Object> idSet = new HashSet<Object>(transactionTypeId.size());
            for (DynamicObject obj : transactionTypeId) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("transactiontypeid", "in", idSet));
        }
    }

    private void createBillNoFilter(FilterInfo filter, List<QFilter> qfList) {
        String billNo = filter.getString("prodnomul");
        String[] splitBillNo = billNo.split(";");
        if (splitBillNo.length != 0 && !"".equals(splitBillNo[0])) {
            HashSet<String> idSet = new HashSet<String>(splitBillNo.length);
            idSet.addAll(Arrays.asList(splitBillNo));
            qfList.add(new QFilter("orderentryid.headbillno", "in", idSet));
        }
    }

    private void createProdNoFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection prodNo = filter.getDynamicObjectCollection("productnomul");
        if (prodNo != null) {
            HashSet<Object> idSet = new HashSet<Object>(prodNo.size());
            for (DynamicObject obj : prodNo) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("orderentryid.material", "in", idSet));
        }
    }

    private void createStockFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection moduleNo = filter.getDynamicObjectCollection("modulenomul");
        if (moduleNo != null) {
            HashSet<Object> idSet = new HashSet<Object>(moduleNo.size());
            for (DynamicObject obj : moduleNo) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("stockentry.materialid", "in", idSet));
        }
    }

    private void createBDProjFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection bdProj = filter.getDynamicObjectCollection("projectnomul");
        if (bdProj != null) {
            HashSet<Object> idSet = new HashSet<Object>(bdProj.size());
            for (DynamicObject obj : bdProj) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("bdproject", "in", idSet));
        }
    }

    private void createFollowNoFilter(FilterInfo filter, List<QFilter> qfList) {
        DynamicObjectCollection followNo = filter.getDynamicObjectCollection("follownomul");
        if (followNo != null) {
            HashSet<Object> idSet = new HashSet<Object>(followNo.size());
            for (DynamicObject obj : followNo) {
                idSet.add(obj.getPkValue());
            }
            qfList.add(new QFilter("orderentryid.tracknumber", "in", idSet));
        }
    }

    private void createCrTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("bctbegin");
        Date endDate = filter.getDate("bctend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("createtime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("createtime", "<", (Object)cal.getTime()));
        }
    }

    private void createStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("petbegin");
        Date endDate = filter.getDate("petend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planbegintime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planbegintime", "<", (Object)cal.getTime()));
        }
    }

    private void createFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        Date beginDate = filter.getDate("petbegin");
        Date endDate = filter.getDate("petend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planendtime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void createBizStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String bizStatus = filter.getString("bizstatus");
        String[] status = bizStatus.substring(1, bizStatus.length() - 1).split(",");
        qfList.add(new QFilter("orderentryid.bizstatus", "in", (Object)status));
    }

    private void createPlanStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String planStatus = filter.getString("planstatus");
        String[] status = planStatus.substring(1, planStatus.length() - 1).split(",");
        qfList.add(new QFilter("orderentryid.planstatus", "in", (Object)status));
    }

    private void createTaskStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String taskStatus = filter.getString("taskstatus");
        String[] status = taskStatus.substring(1, taskStatus.length() - 1).split(",");
        qfList.add(new QFilter("orderentryid.taskstatus", "in", (Object)status));
    }

    private void createPickStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        String pickStatus = filter.getString("pickstatus");
        String[] status = pickStatus.substring(1, pickStatus.length() - 1).split(",");
        qfList.add(new QFilter("orderentryid.pickstatus", "in", (Object)status));
    }
}

