/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.mftorder.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalendarUtils {
    public static final String KEY_MFTDEFAULT = "fmm_defaultorg";
    public static final String KEY_CREATEORG = "createorg";
    public static final String KEY_ENABLE = "enable";
    public static final String KEY_STATUS = "status";
    private static final String KEY_CALENDARID = "calendar";
    public static final String KEY_CALENDAR = "mpdm_calendar";
    public static final String KEY_DEFAULTORG = "fmm_defaultorg";

    private CalendarUtils() {
    }

    public static boolean isExistsCalendar(DynamicObject dept) {
        if (dept == null) {
            return false;
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", dept.getPkValue()), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        return QueryServiceHelper.exists((String)"fmm_defaultorg", (QFilter[])qfilters);
    }

    public static Date getRecentleWorkDate(String id, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        DynamicObject calendarInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id), (String)KEY_CALENDAR);
        if (calendarInfo == null) {
            return null;
        }
        DynamicObjectCollection dateEntryInfo = calendarInfo.getDynamicObjectCollection("dateentry");
        HashMap<String, String> map = new HashMap<String, String>(dateEntryInfo.size());
        for (int i = 0; i < dateEntryInfo.size(); ++i) {
            Date dater = (Date)((DynamicObject)dateEntryInfo.get(i)).get("workdate");
            map.put(sdf.format(dater), ((DynamicObject)dateEntryInfo.get(i)).get("datetype").toString());
        }
        return CalendarUtils.getRecentleWorkDate(map, date);
    }

    public static Date getRecentleWorkDate(Map map, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (map.get(sdf.format(date)) == null) {
            return null;
        }
        if ("1".equals(map.get(sdf.format(date)))) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        return CalendarUtils.getRecentleWorkDate(map, c.getTime());
    }

    public static Date getRecentleWorkDate(DynamicObject org, Date date) {
        String calendarId = CalendarUtils.getCalendarId(org);
        if (calendarId.isEmpty() || "0".equals(calendarId)) {
            return date;
        }
        return CalendarUtils.getRecentleWorkDate(calendarId, date);
    }

    public static Date getRecentleWorkDate(Object orgId, Date date) {
        String calendarId = CalendarUtils.getCalendarId(orgId);
        if (calendarId.isEmpty()) {
            return date;
        }
        return CalendarUtils.getRecentleWorkDate(calendarId, date);
    }

    public static String getCalendarId(DynamicObject dept) {
        if (dept == null) {
            return "";
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", dept.getPkValue()), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObject colByOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        if (colByOrg != null) {
            DynamicObject dynamicObject = colByOrg.getDynamicObject(KEY_CALENDARID);
            if (dynamicObject == null) {
                return "";
            }
            return colByOrg.getDynamicObject(KEY_CALENDARID).getString("id");
        }
        return "";
    }

    public static String getCalendarId(Object orgId) {
        if (orgId == null) {
            return "";
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", orgId), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObject colByOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        if (colByOrg != null) {
            DynamicObject dynamicObject = colByOrg.getDynamicObject(KEY_CALENDARID);
            if (dynamicObject == null) {
                return "";
            }
            return colByOrg.getDynamicObject(KEY_CALENDARID).getString("id");
        }
        return "";
    }
}

