/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.mftorder.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MftGenStocksUtils {
    public static final String KEY_ENTRY_REPLACEPLAN = "replaceplan";
    public static final String KEY_ENTRY_PRIORITY = "priority";
    public static final String KEY_ENTRY_ISMAINREPLAC = "ismainreplace";

    public static DynamicObject getOrderStock(Object orderid, Object orderEntryid, String entityType) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)MftGenStocksUtils.selectStockProperties(), (QFilter[])new QFilter[]{filter1, filter2});
    }

    private static String selectStockProperties() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,billno,productid,billstatus,orderno,orderid,qty,baseqty,billauxqty,orderentryid,baseunitid,unitid,billauxunit,org,bomid,replaceno,modifytime,modifier,auxproperty,transactiontypeid,processroute,stockentry,stockentry.materialid,stockentry.qtytype,");
        selector.append("stockentry.productqty,stockentry.useratio,stockentry.qtynumerator,stockentry.oprno,stockentry.processseq,stockentry.wipqty,");
        selector.append("stockentry.qtydenominator,stockentry.fixscrap,stockentry.scraprate,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.feedingqty,");
        selector.append("stockentry.rejectedqty,stockentry.scrapqty,stockentry.cansendqty,stockentry.unissueqty,stockentry.outsqty,stockentry.iscannegative,");
        selector.append("stockentry.wastagerateformula,stockentry.isbackflush,stockentry.useqty,stockentry.iskeypart,stockentry.issuemode,stockentry.isbomextend,stockentry.childauxpropertyid,");
        selector.append("stockentry.materialid,stockentry.materialid.scraprateexpr,stockentry.overissuecontrl,stockentry.issinhighlimit,stockentry.extraratioqty,stockentry.batchno,");
        selector.append("stockentry.issinlowlimit,stockentry.lackraitioqty,stockentry.oprworkcenter,stockentry.warehouseid,stockentry.location,").append("stockentry.bomentryid,");
        selector.append("stockentry.leadtimeunit,stockentry.leadtime,stockentry.demanddate,stockentry.materialunitid,stockentry.materialunitid.precision,");
        selector.append("transactiontypeid,transactiontypeid.isconsiderloss");
        return selector.toString();
    }

    public static Object aculActissueQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
            if (stockEntry.getBoolean("iscannegative")) {
                actissueQty = stockEntry.getBigDecimal("demandqty");
            }
            return actissueQty;
        }
        return null;
    }

    public static DynamicObject getManuEntryByEntryID(DynamicObject manuorder, String entryid) {
        DynamicObjectCollection orderentrys = manuorder.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderentry : orderentrys) {
            if (!StringUtils.equals((CharSequence)orderentry.getPkValue().toString(), (CharSequence)entryid)) continue;
            return orderentry;
        }
        return null;
    }

    public static StringBuilder manufactureSelectProperties() {
        StringBuilder selectPro = new StringBuilder();
        selectPro.append("id,billno,org,org.fisinventory,transactiontype,biztype,billdate,billstatus,treeentryentity,treeentryentity.seq,treeentryentity.material,");
        selectPro.append("treeentryentity.baseunit,treeentryentity.producedept,treeentryentity.unit,treeentryentity.qty,treeentryentity.planbegintime,");
        selectPro.append("treeentryentity.planendtime,treeentryentity.bomid,treeentryentity.bomid.version,treeentryentity.replaceno,treeentryentity.processroute,");
        selectPro.append("treeentryentity.producttype,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pickstatus,treeentryentity.auxproperty,treeentryentity.expendbomtime,");
        selectPro.append("treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routeversion");
        return selectPro;
    }
}

