/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.mftorder.utils;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.utils.CommonUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;

public class OrderGenChildOrderUtils {
    private static Log logger = LogFactory.getLog(OrderGenChildOrderUtils.class);
    public static final String INTERFACE_MODEL = "model_pdm";
    public static final String SUPERBOMEXPANDTYPE = "superbom";
    public static final String BOMTYPE_CHAR = "_bomtype";

    public static FormShowParameter createShowParameter(String caption, IFormPlugin plugin, String action, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        showParameter.setCloseCallBack(new CloseCallBack(plugin, action));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public static DynamicObject getDefalutBizType(String formId, Long billTypeId, String paramFormId) {
        if (!(CommonUtils.isNull((Object)formId) || CommonUtils.isNull((Object)billTypeId) || CommonUtils.isNull((Object)paramFormId))) {
            DynamicObject defaultBizType = null;
            Object bizTypeObjs = OrderGenChildOrderUtils.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
            if (!CommonUtils.isNull((Object)bizTypeObjs) && bizTypeObjs instanceof DynamicObjectCollection) {
                DynamicObjectCollection bizTypes = (DynamicObjectCollection)bizTypeObjs;
                List defaultBizTypes = bizTypes.stream().filter(dym -> dym.getBoolean("isdefault")).collect(Collectors.toList());
                if (!CommonUtils.isNull(defaultBizTypes)) {
                    defaultBizType = (DynamicObject)defaultBizTypes.get(0);
                }
                defaultBizType = defaultBizType != null ? defaultBizType.getDynamicObject("biztypenumber") : ((DynamicObject)bizTypes.get(0)).getDynamicObject("biztypenumber");
            }
            return defaultBizType;
        }
        return null;
    }

    public static Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (!(CommonUtils.isNull((Object)formId) || CommonUtils.isNull((Object)billTypeId) || CommonUtils.isNull((Object)paramFormId) || CommonUtils.isNull((Object)propertyName))) {
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
            return !CommonUtils.isNull((Object)billTypeParam) ? billTypeParam.get(propertyName) : null;
        }
        return null;
    }

    public static DynamicObject getDefaultTranscationType(Object bizTypeid, String pomorom, Long orgid) {
        DynamicObject defaultTranscationType = null;
        QFilter qFilter = new QFilter("transactiontype", "=", bizTypeid);
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)orgid));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("pomorom", "=", (Object)pomorom));
        Map transactiontypes = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactproduct", (String)OrderGenChildOrderUtils.getSelectProperties(), (QFilter[])new QFilter[]{qFilter});
        if (transactiontypes != null && transactiontypes.size() > 0) {
            List defaultTrans = transactiontypes.values().stream().filter(obj -> obj.getBoolean("isfault")).collect(Collectors.toList());
            if (defaultTrans != null && defaultTrans.size() > 0) {
                defaultTranscationType = (DynamicObject)defaultTrans.get(0);
            }
            if (defaultTranscationType == null) {
                List collect = transactiontypes.values().stream().collect(Collectors.toList());
                defaultTranscationType = (DynamicObject)collect.get(0);
            }
        }
        return defaultTranscationType;
    }

    public static List<DynamicObject> getTranscationTypes(Object bizTypeid, String pomorom, Long orgid) {
        QFilter qFilter = new QFilter("transactiontype", "=", bizTypeid);
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)orgid));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("pomorom", "=", (Object)pomorom));
        Map transactiontypes = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactproduct", (String)OrderGenChildOrderUtils.getSelectProperties(), (QFilter[])new QFilter[]{qFilter});
        if (transactiontypes != null && transactiontypes.size() > 0) {
            return transactiontypes.values().stream().collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>(1);
    }

    public static String getSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("number,");
        sf.append("name,");
        sf.append("isconsiderloss,");
        sf.append("bomexpandconfig,");
        sf.append("isfault");
        return sf.toString();
    }

    public static BigDecimal calEstscrapqty(DynamicObject mftOrderEntry, DynamicObject planinfo) {
        BigDecimal estscrapqty = BigDecimal.ZERO;
        if (null != mftOrderEntry) {
            BigDecimal yield = mftOrderEntry.getBigDecimal("yieldrate");
            BigDecimal qty = mftOrderEntry.getBigDecimal("qty");
            DynamicObject bom = mftOrderEntry.getDynamicObject("bomid");
            if (BigDecimal.ZERO.compareTo(yield) < 0) {
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yield));
            } else if (null == bom) {
                if (planinfo != null) {
                    BigDecimal yieldrate = planinfo.getBigDecimal("yield");
                    estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(new BigDecimal(yieldrate.toString())));
                }
            } else {
                BigDecimal yieldrate = bom.getBigDecimal("yieldrate");
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yieldrate));
            }
        }
        return estscrapqty;
    }

    public static Date getPlanBeginDate(DynamicObject materialPlan, DynamicObject entry) {
        Calendar calendar = Calendar.getInstance();
        if (entry == null) {
            return calendar.getTime();
        }
        Date planendtime = entry.get("planendtime") == null ? new Date() : entry.getDate("planendtime");
        Date begindate = null;
        calendar.setTime(planendtime);
        if (materialPlan != null) {
            String leadtimetype = materialPlan.getString("leadtimetype");
            int fixedleadtime = materialPlan.getInt("fixedleadtime");
            int changeleadtime = materialPlan.getInt("changeleadtime");
            int preprocessingtime = materialPlan.getInt("preprocessingtime");
            int postprocessingtime = materialPlan.getInt("postprocessingtime");
            int changebatch = materialPlan.getInt("changebatch");
            if ("A".equals(leadtimetype)) {
                calendar.add(5, 0 - fixedleadtime);
            } else if ("B".equals(leadtimetype)) {
                BigDecimal qty = entry.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("baseqty");
                BigDecimal decChangebatch = new BigDecimal(changebatch);
                BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
                if (changebatch != 0) {
                    BigDecimal result = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                    calendar.add(5, 0 - result.intValue());
                }
            }
            calendar.add(5, 0 - preprocessingtime);
            calendar.add(5, 0 - postprocessingtime);
            begindate = calendar.getTime();
        } else {
            begindate = calendar.getTime();
        }
        return begindate;
    }

    public static void deleteChildOrder(String orderEntity, Object orderid, Object billno, Object orderEntryid, String orderEntryseq) throws KDBizException {
        if (orderEntryid == null || orderEntryid.equals(0L) || StringUtils.isEmpty((CharSequence)orderEntity) || StringUtils.isBlank((Object)billno) || StringUtils.isBlank((CharSequence)orderEntryseq)) {
            return;
        }
        QFilter qFilter = new QFilter("parentorderid", "=", orderEntryid);
        OrderGenChildOrderUtils.doDelete(orderEntity, qFilter);
    }

    private static void doDelete(String orderEntity, QFilter qFilter) {
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)(OrderGenChildOrderUtils.class.getName() + ".deleteChildOrder"), (String)orderEntity, (String)"id,billno", (QFilter[])qFilter.toArray(), null);){
            if (rows.hasNext()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignorewarn", String.valueOf(true));
                option.setVariableValue("ignoreinteraction", String.valueOf(true));
                option.setVariableValue("strictvalidation", String.valueOf(true));
                HashSet<Long> deleteOrderpk = new HashSet<Long>(10);
                for (Row row : rows) {
                    deleteOrderpk.add(row.getLong("id"));
                }
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)orderEntity, (Object[])deleteOrderpk.toArray(), (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    String operationResultErrorInfos = OrderMergeHelper.getOperationResultErrorInfos((OperationResult)operationResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u7ea7\u5de5\u5355\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"OrderGenChildOrderUtils_0", (String)"mmc-pom-common", (Object[])new Object[0]), operationResultErrorInfos));
                }
            }
        }
    }

    public static void batchDeleteChildOrder(String orderEntity, Set<Object> orderids, Set<Object> orderEntryids) throws KDBizException {
        if (StringUtils.isEmpty((CharSequence)orderEntity)) {
            return;
        }
        QFilter qFilter = new QFilter("parentorderid", "in", orderEntryids);
        OrderGenChildOrderUtils.doDelete(orderEntity, qFilter);
    }

    public static List<String> queryExistsChildOrder(String orderEntity, Object orderid, Object billno, List<Object> orderEntryids) throws KDBizException {
        if (CollectionUtils.isEmpty(orderEntryids) || StringUtils.isEmpty((CharSequence)orderEntity) || StringUtils.isBlank((Object)billno)) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> existsSeq = new ArrayList<String>(orderEntryids.size());
        QFilter qFilter = new QFilter("parentorderid", "in", orderEntryids);
        qFilter.and(new QFilter("treeentryentity.srcorderentryid", "in", orderEntryids));
        try (AlgoContext algo = Algo.newContext();){
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(OrderGenChildOrderUtils.class.getName() + "queryExistsChildOrder"), (String)"pom_mftorder", (String)"id,billno,parentorderid,treeentryentity.sourceentryseq orderseq", (QFilter[])qFilter.toArray(), null);
            DataSet dataSetOrderby = dataSet.orderBy(new String[]{"orderseq"});
            for (Row row : dataSetOrderby) {
                if (StringUtils.isBlank((Object)row.get("orderseq"))) continue;
                existsSeq.add(row.getString("orderseq"));
            }
        }
        return existsSeq;
    }

    public static List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (OrderGenChildOrderUtils.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Long fromOrg = map == null || map.isEmpty() ? Long.valueOf(0L) : map.get("id");
                Long longFromOrg = fromOrg;
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private static boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    public static JSONObject getExpandConfigBom(DistributeSessionlessCache cache, Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal qty, Long routedId, Map<String, String> bomResultCacheMap, String modelStr, Long masterid, Long orgId) {
        long startdate = System.currentTimeMillis();
        String resStr = OrderGenChildOrderUtils.getConfigBomFilterStr(searchTime, configCodeId, qty, isNeedProRoute, routedId, modelStr, masterid, orgId);
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        bomResultCacheMap.put(resStr + BOMTYPE_CHAR, SUPERBOMEXPANDTYPE);
        String cacheValue = bomResultCacheMap.get(resStr);
        if (!kd.bos.util.StringUtils.isEmpty((String)cacheValue)) {
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from bomResultCacheMap");
            return JSONObject.parseObject((String)cacheValue);
        }
        cacheValue = (String)cache.get(resStr);
        if (!kd.bos.util.StringUtils.isEmpty((String)cacheValue)) {
            bomResultCacheMap.put(resStr, cacheValue);
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from DistributeSessionlessCache");
            return JSONObject.parseObject((String)cacheValue);
        }
        JSONObject returnObject = OrderGenChildOrderUtils.expandConfigBom(searchTime, isNeedProRoute, configCodeId, qty, routedId, modelStr, masterid, orgId);
        if (!"success".equalsIgnoreCase(returnObject.getString("status"))) {
            String errorInfo = returnObject.getString("msg");
            logger.info("-------------configBomExpad error:" + errorInfo + ",configCodeId=" + configCodeId);
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from mservice");
        JSONObject data = returnObject.getJSONObject("data").getJSONObject(String.valueOf(configCodeId));
        if ("failed".equalsIgnoreCase(data.getString("status"))) {
            String errorInfo = data.getString("errorMsg");
            logger.info("-------------configBomExpad errorInfo:" + errorInfo + ",configCodeId=" + configCodeId);
            logger.info("-------------configBomExpad stackTrace:" + data.getString("StackTrace"));
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        bomResultCacheMap.put(resStr, data.toJSONString());
        cache.put(resStr, (Object)data.toJSONString(), 600);
        return data;
    }

    public static String getConfigBomFilterStr(Date expandtime, Long configedCodeId, BigDecimal qty, boolean isNeedProRoute, Long routId, String modelStr, Long masterid, Long orgId) {
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return configedCodeId + "-" + qty + "-" + sdf.format(expandtime) + "-" + isNeedProRoute + "-" + routId + "-" + modelStr + "-" + masterid + "-" + orgId;
        }
        return configedCodeId + "-" + qty + "-" + expandtime.getTime() + "-" + isNeedProRoute + "-" + routId + "-" + modelStr + "-" + masterid + "-" + orgId;
    }

    public static JSONObject expandConfigBom(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long routId, String modelStr, Long masterid, Long orgId) {
        JSONObject paramObject = OrderGenChildOrderUtils.getJsonObjectParam(searchTime, isNeedProRoute, configCodeId, num, routId, modelStr, masterid, orgId);
        JSONObject returnJsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getConfigBomForWorkOrder", (Object[])new Object[]{paramObject.toString()});
        return returnJsonObject;
    }

    public static JSONObject getJsonObjectParam(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long routId, String modelStr, Long masterid, Long orgId) {
        JSONObject configedCodeObject = new JSONObject();
        configedCodeObject.put(String.valueOf(configCodeId), (Object)String.valueOf(routId));
        JSONObject paramObject = new JSONObject();
        paramObject.put("org", (Object)orgId);
        paramObject.put("searchTime", (Object)searchTime);
        paramObject.put("isNeedProRoute", (Object)isNeedProRoute);
        paramObject.put("configCodeList", (Object)configedCodeObject);
        paramObject.put("model", (Object)modelStr);
        paramObject.put("matId", (Object)masterid);
        paramObject.put("bomVer", null);
        paramObject.put("num", (Object)num);
        paramObject.put("purchaseExpand", (Object)true);
        return paramObject;
    }
}

