/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.resready.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.pom.common.resready.consts.ResReadyEquipSumReportField;
import kd.mmc.pom.common.resready.consts.ResReadyReportField;
import kd.mmc.pom.common.resready.consts.ResReadySumReportField;

public class DataSetListTransUtil {
    public static List<Map<String, Object>> parseToList(DataSet dateSet) {
        List<Map<String, Object>> list = Collections.synchronizedList(new ArrayList());
        if (dateSet == null) {
            return list;
        }
        String[] fieldNames = dateSet.getRowMeta().getFieldNames();
        while (dateSet.hasNext()) {
            Row row = dateSet.next();
            Map<String, Object> map = Collections.synchronizedMap(new HashMap());
            for (int i = 0; i < fieldNames.length; ++i) {
                String key = fieldNames[i];
                Object value = row.get(key);
                map.put(key, value);
            }
            if (map.isEmpty()) continue;
            list.add(map);
        }
        return list;
    }

    public static DataSet parseToDataSet(Object plugin, List<Map<String, Object>> list, RowMeta rowMeta) {
        Algo algo = Algo.create((String)plugin.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] names = rowMeta.getFieldNames();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            Object[] objArray = new Object[names.length];
            for (int k = 0; k < names.length; ++k) {
                Object value;
                String fiedName = names[k];
                objArray[k] = value = map.get(fiedName);
            }
            builder.append(objArray);
        }
        AbstractDataSet dateSet = (AbstractDataSet)builder.build();
        return dateSet;
    }

    public static DataSet parseToReportDataSet(Object plugin, List<Map<String, Object>> list) {
        return DataSetListTransUtil.parseToReportDataSet(plugin, list, false);
    }

    public static DataSet parseToReportDataSet(Object plugin, List<Map<String, Object>> list, boolean isSum) {
        ArrayList<Field> fields = isSum ? ResReadySumReportField.getFields() : ResReadyReportField.getFields();
        return DataSetListTransUtil.parseToReportDataSet(plugin, list, fields);
    }

    public static DataSet parseToEquipSumReportDataSet(Object plugin, List<Map<String, Object>> list) {
        ArrayList<Field> fields = ResReadyEquipSumReportField.getFields();
        return DataSetListTransUtil.parseToReportDataSet(plugin, list, fields);
    }

    public static DataSet parseToReportDataSet(Object plugin, List<Map<String, Object>> list, ArrayList<Field> fields) {
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)plugin.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        if (list != null) {
            for (Map<String, Object> dataMap : list) {
                Object[] values = new Object[fields.size()];
                block9: for (int i = 0; i < fields.size(); ++i) {
                    String name = fields.get(i).getName();
                    Object data = null;
                    if (dataMap.containsKey("entryentity." + name)) {
                        data = dataMap.get("entryentity." + name);
                    } else if (dataMap.containsKey(name)) {
                        data = dataMap.get(name);
                    }
                    DataType dataType = fields.get(i).getDataType();
                    String dataTypeName = dataType.getName();
                    if (data == null) continue;
                    if (data.getClass().getName().contains(dataTypeName)) {
                        values[i] = data;
                        continue;
                    }
                    if (data instanceof String) {
                        if (StringUtils.isEmpty((CharSequence)data.toString())) continue;
                        String regex = "^[0-9]{1,9}$";
                        String regexLong = "^[0-9].*$";
                        switch (dataTypeName) {
                            case "Integer": {
                                if (!Pattern.matches(regex, data.toString())) continue block9;
                                values[i] = Integer.parseInt(data.toString());
                                break;
                            }
                            case "Long": {
                                if (!Pattern.matches(regexLong, data.toString())) continue block9;
                                values[i] = Long.parseLong(data.toString());
                                break;
                            }
                            default: {
                                values[i] = data;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)dataTypeName, (CharSequence)"String")) continue;
                    values[i] = data.toString();
                }
                builder.append(values);
            }
        }
        DataSet build = builder.build();
        return build;
    }
}

