/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class POMBomQueryConfigEdit
extends AbstractFormPlugin {
    public static String[] strName = new String[]{"entrymaterial", "entrymaterialid", "baseunit", "entryqtynumerator", "entryqtydenominator", "entryqtytype", "entryfixscrap", "entryscraprate", "entryprocessseq", "entryoperationnumber", "entryownertype", "entryowner", "entrysupplyorg", "entryconfiguredcode", "entryauxproperty"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnquery".equals(control.getKey())) {
            this.fillEntry();
        }
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selects = entryGrid.getSelectRows();
            HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>();
            if (selects.length > 0) {
                for (int i = 0; i < selects.length; ++i) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", entryGrid.getSelectRows()[i]);
                    if (null == entry) continue;
                    hashMap.put(entry.getString("seq"), entry);
                }
            }
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
    }

    private void fillEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("mftmaterial");
        DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
        DynamicObject bomDym = (DynamicObject)this.getModel().getValue("bom");
        DynamicObject bomexpandconfig = (DynamicObject)this.getModel().getValue("bomexpandconfig");
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
        Date expendbomtime = (Date)this.getModel().getValue("expendbomtime");
        JSONObject paramObject = new JSONObject(10);
        if (bomDym != null) {
            paramObject.put("bomId", (Object)((Long)bomDym.getPkValue()));
        }
        paramObject.put("materialid", mftmaterial.getDynamicObject("masterid").getPkValue());
        paramObject.put("expandConfig", bomexpandconfig.getPkValue());
        paramObject.put("searchDate", (Object)expendbomtime);
        paramObject.put("configcode", configuredcode == null ? Long.valueOf(0L) : configuredcode.getPkValue());
        paramObject.put("org", this.getUserOrg().getPkValue());
        paramObject.put("num", (Object)qty);
        paramObject.put("showtype", (Object)"E");
        paramObject.put("purexpand", (Object)true);
        paramObject.put("model", (Object)"model_im");
        JSONArray filterArrayNew = new JSONArray();
        filterArrayNew.add((Object)paramObject);
        JSONArray result = JSON.parseArray((String)CreateStockByBomUtils.getQueryDataResMulType((String)filterArrayNew.toString()));
        if (result.toString().indexOf("true") >= 0) {
            JSONObject object = (JSONObject)result.get(0);
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
            String res = (String)cache.get(object.getString("dataKey"));
            JSONArray resArray = JSONArray.parseArray((String)res);
            if (resArray != null) {
                model.beginInit();
                model.deleteEntryData("entryentity");
                TableValueSetter vs = new TableValueSetter(new String[0]);
                for (String str : strName) {
                    vs.addField(str, new Object[0]);
                }
                HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
                if (resArray != null) {
                    for (int i = 0; i < resArray.size(); ++i) {
                        JSONObject resJson = (JSONObject)resArray.get(i);
                        bomEntryIdSet.add(resJson.getLong("entry_Id"));
                    }
                }
                Map bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
                for (int i = 0; i < resArray.size(); ++i) {
                    JSONObject resJson = (JSONObject)resArray.get(i);
                    DynamicObject bomEntry = (DynamicObject)bomEntryMap.get(resJson.getLong("entry_Id"));
                    Object entryprocessseq = bomEntry.get("entryprocessseq");
                    Object entryoperationnumber = bomEntry.get("entryoperationnumber");
                    Object entryownertype = bomEntry.get("entryownertype");
                    DynamicObject entryowner = bomEntry.getDynamicObject("entryowner");
                    DynamicObject entrysupplyorg = bomEntry.getDynamicObject("entrysupplyorg");
                    DynamicObject entryauxproperty = bomEntry.getDynamicObject("entryauxproperty");
                    DynamicObject entryconfiguredcode = bomEntry.getDynamicObject("entryconfiguredcode");
                    vs.addRow(new Object[]{resJson.get((Object)"entrymaterialInfo"), resJson.get((Object)"entrymaterialId"), resJson.get((Object)"entryunit"), resJson.get((Object)"entryqtynumerator"), resJson.get((Object)"entryqtydenominator"), resJson.get((Object)"entryqtytype"), resJson.get((Object)"entryfixscrap"), resJson.get((Object)"entryscraprate"), entryprocessseq, entryoperationnumber, entryownertype, entryowner == null ? Long.valueOf(0L) : entryowner.getPkValue(), entrysupplyorg == null ? Long.valueOf(0L) : entrysupplyorg.getPkValue(), entryconfiguredcode == null ? Long.valueOf(0L) : entryconfiguredcode.getPkValue(), entryauxproperty == null ? Long.valueOf(0L) : entryauxproperty.getPkValue()});
                }
                model.batchCreateNewEntryRow("entryentity", vs);
                model.endInit();
                this.getView().updateView("entryentity");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u67e5\u8be2\u6761\u4ef6\u3002", (String)"POMBomQueryConfigEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        String parentEntity = parentView.getEntityId();
        if (StringUtils.equals((CharSequence)"pom_restructurbill", (CharSequence)parentEntity)) {
            String bomIdStr = (String)this.getView().getFormShowParameter().getCustomParam("bomIdStr");
            String expendbomtimeStr = (String)this.getView().getFormShowParameter().getCustomParam("expendbomtimeStr");
            Date expendbomtime = null;
            try {
                expendbomtime = (Date)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parseObject(expendbomtimeStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String qtyStr = (String)this.getView().getFormShowParameter().getCustomParam("qtyStr");
            String materialidStr = (String)this.getView().getFormShowParameter().getCustomParam("materialidStr");
            if (StringUtils.isNotBlank((CharSequence)bomIdStr) && StringUtils.isNotBlank((CharSequence)expendbomtimeStr) && StringUtils.isNotBlank((CharSequence)qtyStr) && StringUtils.isNotBlank((CharSequence)materialidStr)) {
                this.getModel().setValue("bom", (Object)Long.parseLong(bomIdStr));
                this.getModel().setValue("expendbomtime", (Object)expendbomtime);
                this.getModel().setValue("qty", (Object)new BigDecimal(qtyStr));
                this.getModel().setValue("mftmaterial", (Object)Long.parseLong(materialidStr));
                this.getModel().setValue("bomexpandconfig", (Object)1637711947497568256L);
            }
        }
    }

    private DynamicObject getUserOrg() {
        DynamicObject org;
        DynamicObject dataEntity;
        Long orgId = 0L;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (dataEntity = parentView.getModel().getDataEntity()).containsProperty("org") && (org = (DynamicObject)parentView.getModel().getValue("org")) != null) {
            orgId = org.getLong("id");
        }
        if (orgId == 0L) {
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            orgId = UserServiceHelper.getUserMainOrgId((long)currentUserId);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
    }
}

