/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.allocationplan;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AllocationPlanListPlugin
extends AbstractListPlugin {
    public static final Log logger = LogFactory.getLog(AllocationPlanListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)e.getSource();
            String operateKey = operate.getOperateKey();
            if ("trackup".equals(operateKey)) {
                this.traceup(e);
            } else if ("push".equals(operateKey)) {
                ListSelectedRowCollection listSelectedData = e.getListSelectedData();
                listSelectedData.removeIf(x -> !x.getBillStatus().equals("C"));
                if (listSelectedData.size() == 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4e0b\u63a8\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"AllocationPlanListPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void traceup(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection selecs = this.getSelectedRows();
        if (selecs == null || selecs.size() == 0) {
            return;
        }
        Object[] ids = new Object[selecs.size()];
        for (int i = 0; i < selecs.size(); ++i) {
            ids[i] = selecs.get(i).getPrimaryKeyValue();
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pom_allocationplan", (String)"billno,upperbillid_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        ArrayList<String> srcs = new ArrayList<String>();
        for (DynamicObject b : bills) {
            String srcid = b.getString("upperbillid_tag");
            String billno = b.getString("billno");
            if (StringUtils.isBlank((CharSequence)srcid)) {
                String errorinfo = String.format(ResManager.loadKDString((String)"\uff08%1$s\uff09\u672a\u4fdd\u5b58\u4e0a\u6e38\u5355\u636e\u4fe1\u606f\uff0c\u65e0\u6cd5\u67e5\u8be2\u3002", (String)"AllocationPlanListPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]), billno);
                this.getView().showErrorNotification(errorinfo);
                continue;
            }
            srcs.add(srcid);
        }
        if (!srcs.isEmpty()) {
            ListShowParameter showParameter = AllocationPlanListPlugin.createShowParam(srcs);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        e.setCancel(true);
    }

    public static ListShowParameter createShowParam(List<String> srcs) {
        ListShowParameter showParam = new ListShowParameter();
        showParam.setHasRight(true);
        showParam.setBillFormId("pom_mftstock");
        for (String srcid : srcs) {
            StringTokenizer st = new StringTokenizer(srcid, ",");
            while (st.hasMoreTokens()) {
                showParam.addLinkQueryPkId((Object)Long.valueOf(st.nextToken()));
            }
        }
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.setShowFilter(false);
        showParam.setShowQuickFilter(false);
        return showParam;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        AllocationPlanListPlugin.doOperUtil(e, this.getView());
    }

    static void doOperUtil(AfterDoOperationEventArgs args, IFormView view) {
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        switch (operateKey) {
            case "bizclose": 
            case "bizunclose": {
                List successPkIds = result.getSuccessPkIds();
                if (successPkIds.isEmpty()) break;
                view.invokeOperation("refresh");
            }
        }
    }
}

