/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.allocationplan;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pom.formplugin.allocationplan.OrgCalendarUtil;

public class IssuePlanCalcPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ALLOWDATE = "isallowdateinpast";
    private static final String MRP_ISSPL = "pom_issueplancalc";
    private static final String ORG = "org";
    private static final String PLANPROGRAM = "plangram";
    private static final String ID = "id";
    private static final String START_CAL = "startcaculate";
    private static final String STOP_CAL = "stop";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String FLEX_CACULATE_LOG = "flex_caculate_log";
    private static final String NUMBER = "number";
    private static final String PLANGRAM_OPR = "plangram_opr";
    private static final String ISMPS = "ismps";
    private static final String ISMRP = "ismrp";
    private static final String ISREORDERPOINT = "isreorderpoint";
    private static final String PLANDATE = "plandate";
    private static final String CREATER = "creater";
    private static final String PLANTYPE = "plantype";
    private static final String CONFIRM_EXEC = "confirm_exec";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)BizAppServiceHelp.getAppIdByAppNumber((String)"mrp"), (String)MRP_ISSPL, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        if (!orgIds.isEmpty()) {
            long orgid = RequestContext.get().getOrgId();
            if (orgIds.contains(orgid)) {
                this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
            } else {
                this.getModel().setValue(ORG, orgIds.get(0));
            }
        } else if (result.hasAllOrgPerm()) {
            this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planprogram = (BasedataEdit)this.getView().getControl(PLANPROGRAM);
        planprogram.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if (PLANPROGRAM.equals(key)) {
            Long orgId = this.checkOrgIsNull();
            if (orgId != -1L) {
                QFilter orgFilter = new QFilter("createorg.id", "=", (Object)orgId);
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(orgFilter);
                param.getListFilterParameter().getQFilters().add(statusFilter);
                param.getListFilterParameter().getQFilters().add(enableFilter);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (key.equals(START_CAL)) {
            this.beforeCalculate(e);
        } else if (key.equals(STOP_CAL)) {
            this.doStopCalculat();
        }
    }

    private void doStopCalculat() {
        String logFSPPageID = this.getPageCache().get(FLEX_CACULATE_LOG);
        IFormView pageView = this.getView().getView(logFSPPageID);
        if (pageView != null) {
            OperationResult result = pageView.invokeOperation(STOP_CAL);
            if (result != null && result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"IssuePlanCalcPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            } else if (result != null && !result.getAllErrorOrValidateInfo().isEmpty()) {
                StringBuilder error = new StringBuilder();
                for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                    error.append(info.getMessage()).append("\n\r");
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ec8\u6b62\u5931\u8d25", (String)"IssuePlanCalcPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            }
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject org = this.getOrgId();
        if (org != null) {
            DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
            String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)org.getPkValue().toString());
            if (StringUtils.isBlank((CharSequence)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"IssuePlanCalcPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                this.setLogValue(number, e);
            }
        } else {
            e.setCancel(true);
        }
    }

    private void setLogValue(String number, BeforeDoOperationEventArgs e) {
        DynamicObject plangram = this.getModelPlan();
        if (plangram != null) {
            this.execGlobalPlan(number, plangram);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u8ba1\u5212\u65b9\u6848\u201d\u3002", (String)"IssuePlanCalcPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && CONFIRM_EXEC.equals(e.getCallBackId())) {
            DynamicObject plangram = this.getModelPlan();
            DynamicObject caculateLog = this.createNewLog(this.getPageCache().get(CACULATELOG_CACHE), plangram);
            caculateLog.set(PLANPROGRAM, (Object)plangram.getLong(ID));
            caculateLog.set("creator", (Object)RequestContext.get().getUserId());
            caculateLog.set("runtype", (Object)"C");
            this.runIt(caculateLog);
            this.showLogForm(caculateLog.getLong(ID));
        }
    }

    protected DynamicObject getModelPlan() {
        return (DynamicObject)this.getModel().getValue(PLANPROGRAM);
    }

    protected void runIt(DynamicObject caculateLog) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IMRPRunnerApi", (String)"pomStarter", (Object[])new Object[]{caculateLog});
    }

    private void execGlobalPlan(String number, DynamicObject plangram) {
        boolean flag = true;
        DynamicObject plan = this.getRealPlan(plangram);
        int planOutLook = plan.getInt("planoutlook");
        DynamicObjectCollection orgcoll = plan.getDynamicObjectCollection("orgentryentity");
        for (DynamicObject dyn : orgcoll) {
            String orgid;
            OrgCalendarUtil cUtil;
            if (dyn.getDynamicObject("entrydemandorg") == null || (cUtil = new OrgCalendarUtil(orgid = dyn.getDynamicObject("entrydemandorg").getString(ID))).isEmpty()) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getModel().getValue(PLANDATE));
            calendar.add(5, planOutLook);
            if (!calendar.getTime().after(cUtil.getMaxDate().getDate().getTime())) continue;
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_EXEC, (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff08%s\uff09\u7684\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u5927\u4e8e\u8ba1\u5212\u65e5\u5386\u6700\u5927\u65e5\u671f\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u8fd0\u7b97\uff1f\u5982\u9009\u62e9\u662f\uff0c\u8ba1\u7b97\u7ed3\u675f\u65e5\u671f\u53d6\u8ba1\u5212\u65e5\u5386\u7684\u6700\u5927\u65e5\u671f\u3002", (String)"IssuePlanCalcPlugin_4", (String)"mmc-pom-formplugin", (Object[])new Object[0]), dyn.getDynamicObject("entrydemandorg").getString("name"));
            flag = false;
            this.getPageCache().put(CACULATELOG_CACHE, number);
            confirmCallBack.setView(this.getView());
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBack);
            break;
        }
        if (flag) {
            DynamicObject caculateLog = this.createNewLog(number, plangram);
            this.runIt(caculateLog);
            this.showLogForm(caculateLog.getLong(ID));
        }
    }

    protected DynamicObject getRealPlan(DynamicObject plangram) {
        QFilter filter = new QFilter(ID, "=", (Object)plangram.getLong(ID));
        return ORM.create().queryOne(this.getPlanType(), new QFilter[]{filter});
    }

    protected String getPlanType() {
        return "pom_planprogram";
    }

    protected DynamicObject createNewLog(String number, DynamicObject plangram) {
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
        DynamicObject org = this.getOrgId();
        StringBuilder plantype = this.getPlanType(plangram);
        Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
        caculateLog.set(ID, (Object)id);
        caculateLog.set(NUMBER, (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("runtype", (Object)"C");
        caculateLog.set(PLANTYPE, (Object)plantype.toString());
        caculateLog.set(PLANPROGRAM, (Object)plangram.getLong(ID));
        caculateLog.set("programnumber", (Object)plangram.getString(NUMBER));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set("plangramentity", (Object)this.getPlanType());
        caculateLog.set(PLANDATE, this.getModel().getValue(PLANDATE));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set(ALLOWDATE, (Object)true);
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }

    protected DynamicObject getOrgId() {
        return (DynamicObject)this.getModel().getValue(ORG);
    }

    private void showLogForm(long id) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(MRP_CACULATE_LOG);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(ID, (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getActionId(), (CharSequence)FLEX_CACULATE_LOG)) {
            this.getView().close();
        }
    }

    private StringBuilder getPlanType(DynamicObject plangram) {
        Boolean ismrp = this.isMrp(plangram);
        Boolean ismps = this.isMps(plangram);
        Boolean isrecord = this.isReorder(plangram);
        StringBuilder plantype = new StringBuilder();
        if (ismrp.booleanValue()) {
            plantype.append("MRP");
        }
        if (ismps.booleanValue() && !"".equals(plantype.toString())) {
            plantype.append("/MPS");
        } else if (ismps.booleanValue() && "".equals(plantype.toString())) {
            plantype.append("MPS");
        }
        if (isrecord.booleanValue() && !"".equals(plantype.toString())) {
            plantype.append(ResManager.loadKDString((String)"/\u518d\u8ba2\u8d27\u70b9", (String)"IssuePlanCalcPlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        } else if (isrecord.booleanValue() && "".equals(plantype.toString())) {
            plantype.append(ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"IssuePlanCalcPlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        return plantype;
    }

    protected Boolean isMrp(DynamicObject plangram) {
        return true;
    }

    protected Boolean isMps(DynamicObject plangram) {
        return true;
    }

    protected Boolean isReorder(DynamicObject plangram) {
        return true;
    }

    private Long checkOrgIsNull() {
        if (this.getModel().getValue(ORG) != null) {
            DynamicObject org = this.getOrgId();
            return org.getLong(ID);
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u8ba1\u5212\u7ec4\u7ec7\u201d\u3002", (String)"IssuePlanCalcPlugin_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        return -1L;
    }
}

