/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.allocationplan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.pom.formplugin.allocationplan.MRPDate;

public class OrgCalendarUtil {
    private MRPDate maxDate;
    private MRPDate minDate;
    private String orgId;
    private List<MRPDate> dates;

    public OrgCalendarUtil(String orgId) {
        this.orgId = orgId;
        this.initData();
    }

    private void initData() {
        QFilter[] filters;
        this.dates = new ArrayList<MRPDate>(16);
        ORM orm = ORM.create();
        DynamicObject defCal = orm.queryOne("mrp_plancalendar", filters = new QFilter[]{new QFilter("createorg.id", "=", (Object)Long.parseLong(this.orgId)), new QFilter("isfault", "=", (Object)Character.valueOf('1')), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (defCal == null) {
            return;
        }
        boolean isSatRest = defCal.getBoolean("issatrest");
        boolean isSunRest = defCal.getBoolean("issunrest");
        boolean isMonRest = defCal.getBoolean("ismonrest");
        boolean isTueRest = defCal.getBoolean("istuerest");
        boolean isWenRest = defCal.getBoolean("iswedrest");
        boolean isThuRest = defCal.getBoolean("isthurest");
        boolean isFriRest = defCal.getBoolean("isfrirest");
        if (isSatRest && isSunRest && isMonRest && isTueRest && isWenRest && isThuRest && isFriRest) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u5386\u8bbe\u7f6e\u9519\u8bef\uff1a\u6bcf\u5929\u90fd\u662f\u4f11\u606f\u65e5\u3002", (String)"OrgCalendarUtil_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = defCal.getDynamicObjectCollection("dateentry");
        entrys.sort((o1, o2) -> o1.getDate("workdate").compareTo(o2.getDate("workdate")));
        MRPDate previousWork = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Calendar cal = Calendar.getInstance();
            cal.setTime(entry.getDate("workdate"));
            OrgCalendarUtil.nomalize(cal);
            WorkCalendarDayType dt = WorkCalendarDayType.valueOf(entry.getInt("datetype"));
            MRPDate date = new MRPDate(cal, dt, i);
            this.dates.add(date);
            date.setPreviousWorkDay(previousWork);
            if (!this.isWorkday(dt.getValue())) continue;
            previousWork = date;
            this.setNextWork(this.dates, previousWork, i);
            if (this.minDate == null) {
                this.minDate = date;
            }
            this.maxDate = date;
        }
    }

    public static void nomalize(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private boolean isWorkday(int dateType) {
        return dateType == WorkCalendarDayType.WORKDAY.getValue() || dateType == WorkCalendarDayType.HALFWORKDAY.getValue();
    }

    private void setNextWork(List<MRPDate> dates, MRPDate nextDate, int len) {
        MRPDate date;
        for (int i = len - 1; i >= 0 && (date = dates.get(i)).getNextWorkDay() == null; --i) {
            date.setNextWorkDay(nextDate);
        }
    }

    public MRPDate getMinDate() {
        return this.minDate;
    }

    public MRPDate getMaxDate() {
        return this.maxDate;
    }

    public boolean isEmpty() {
        return this.dates.isEmpty();
    }

    public static enum WorkCalendarDayType {
        WORKDAY(1),
        HALFWORKDAY(2),
        HOLIDAY(3),
        RESTDAY(4);

        private int value;

        private WorkCalendarDayType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static WorkCalendarDayType valueOf(int dt) {
            switch (dt) {
                case 1: {
                    return WORKDAY;
                }
                case 2: {
                    return HALFWORKDAY;
                }
                case 3: {
                    return HOLIDAY;
                }
                case 4: {
                    return RESTDAY;
                }
            }
            throw new KDBizException(String.format("unknown enum[%s] value: %d", WorkCalendarDayType.class.getName(), dt));
        }
    }
}

