/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.changebill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class StockChangeLogBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final Log log = LogFactory.getLog(StockChangeLogBillPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplierfield");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        log.info("StockChangeLogBillPlugin itemClick in\u3002");
        super.itemClick(evt);
        if (!StringUtils.equals((CharSequence)"changelog", (CharSequence)evt.getOperationKey())) {
            return;
        }
        IFormView view = this.getView();
        String entityId = view.getEntityId();
        TreeEntryGrid stockentry = (TreeEntryGrid)view.getControl("stockentry");
        int[] selectRows = stockentry.getSelectRows();
        if (selectRows.length <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u7ec4\u4ef6\u4fe1\u606f\u3002", (String)"StockChangeLogBillPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("stockentry");
        Object[] entryIds = new Object[selectRows.length];
        String[] entryIdString = new String[selectRows.length];
        int[] componentseqs = new int[selectRows.length];
        for (int i = 0; i < selectRows.length; ++i) {
            Object pkValue;
            int selectRow = selectRows[i];
            componentseqs[i] = selectRow + 1;
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRow);
            if (null == dynamicObject) continue;
            entryIds[i] = pkValue = dynamicObject.getPkValue();
            entryIdString[i] = pkValue.toString();
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        boolean validateOrgPermission = this.validateOrgPermission(listShowParameter, filters);
        if (!validateOrgPermission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4ee5\u83b7\u53d6\u201c\u7ec4\u4ef6\u660e\u7ec6\u53d8\u66f4\u65e5\u5fd7\u201d\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"StockChangeLogBillPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter q = new QFilter("entryidf", "in", (Object)entryIds);
        if (StringUtils.equals((CharSequence)"pom_xmftstock", (CharSequence)entityId)) {
            q = new QFilter("stockchangeentryid", "in", (Object)entryIdString);
        }
        filters.add(q);
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("pom_xmfstockchangelog");
        view.showForm((FormShowParameter)listShowParameter);
        log.info("itemClick out\u3002");
    }

    private boolean validateOrgPermission(ListShowParameter listShowParameter, List<QFilter> filters) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object orgPkValue = org.getPkValue();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
        String permItemId = "47150e89000000ac";
        long produceOrgId = Long.parseLong(orgPkValue.toString());
        int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)produceOrgId, (String)appId, (String)"pom_xmfstockchangelog", (String)permItemId);
        if (checkPermission != 1) {
            return false;
        }
        QFilter orgFilter = new QFilter("org", "=", orgPkValue);
        filters.add(orgFilter);
        ArrayList<String> orgPkValues = new ArrayList<String>();
        orgPkValues.add(orgPkValue.toString());
        listShowParameter.setCustomParam("useorgIdFilter", orgPkValues);
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        Control con = (Control)arg.getSource();
        String source = con.getKey();
        String suppliermode = (String)this.getModel().getValue("supplymodefield");
        if ("supplierfield".equals(source) && "bd_supplier".equals(suppliermode)) {
            QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

