/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.distribplan;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.business.distr.helper.DistrWriteBackSrcHelper;

public class DistribPlanLockListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("lockbylog".equalsIgnoreCase(operateKey)) {
            Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
            Map<Long, String> logMap = this.getLogNumber(ids);
            String logNumber = String.join((CharSequence)",", logMap.values());
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u662f\u5426\u5c06\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e3a'%1$s'\u7684\u914d\u9001\u6307\u4ee4\u5173\u95ed\uff1f", (String)"DistribPlanLockListPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(String.format(msg, logNumber), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    private Map<Long, String> getLogNumber(Object[] ids) {
        DataSet logSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.pom.formplugin.distribplan.DistribPlanLockListPlugin:getLogNumber", (String)"pom_distribplan", (String)"logid,logid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, (String)"logid");
        logSet = logSet.groupBy(new String[]{"logid", "logid.number"}).finish();
        HashMap<Long, String> logMap = new HashMap<Long, String>(16);
        for (Row row : logSet) {
            logMap.put(row.getLong("logid"), row.getString("logid.number"));
        }
        logSet.close();
        return logMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("lockbylog".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
            Map<Long, String> logMap = this.getLogNumber(ids);
            this.doLockByLog(logMap);
        }
    }

    public void doLockByLog(Map<Long, String> logMap) {
        HashMap<String, String> errMsg = new HashMap<String, String>(16);
        for (Map.Entry<Long, String> log : logMap.entrySet()) {
            StringBuilder msg = new StringBuilder();
            if (this.doLockByLog(log.getKey(), msg)) continue;
            errMsg.put(log.getValue(), msg.toString());
        }
        if (errMsg.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DistribPlanLockListPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
        } else {
            String itemMsg = ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7'%s':", (String)"DistribPlanLockListPlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            String msg = errMsg.entrySet().stream().map(o -> String.format(itemMsg, o.getKey()) + (String)o.getValue()).collect(Collectors.joining("\r\n"));
            String title = ResManager.loadKDString((String)"\u5171%1$d\u4e2a\u8ba1\u5212\u8fd0\u7b97\u53f7\uff0c\u6210\u529f%2$d\u6761\uff0c\u5931\u8d25%3$d\u6761", (String)"DistribPlanLockListPlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(String.format(title, logMap.size(), logMap.size() - errMsg.size(), errMsg.size()), msg, MessageTypes.Default);
        }
    }

    public boolean doLockByLog(Long logId, StringBuilder msg) {
        DynamicObject hasQty = QueryServiceHelper.queryOne((String)"pom_distribplan", (String)"closetype,billstatus,closetime,mtfdeliveryqty", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)logId).and("mtfdeliveryqty", ">", (Object)BigDecimal.ZERO)});
        if (hasQty != null) {
            String errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u751f\u4ea7\u51fa\u5e93\u6570\u91cf>0\u7684\u914d\u9001\u6307\u4ee4\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"DistribPlanLockListPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
            msg.append(errMsg);
            return false;
        }
        boolean closeRelBillSuccess = this.closeRelBill(logId, msg);
        if (!closeRelBillSuccess) {
            if (msg.length() == 0) {
                String errSsg = ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u65e0\u6cd5\u64a4\u9500\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"DistribPlanLockListPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
                msg.append(errSsg);
            }
            return false;
        }
        String sql = "update t_pom_distribplanx set fclosetime=? ,fclosetype=? where flogid=?";
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])new Object[]{new Date(), "B", logId});
        new DistrWriteBackSrcHelper(logId.longValue()).clearSrc();
        return true;
    }

    public boolean closeRelBill(Long logId, StringBuilder msg) {
        return true;
    }
}

