/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.business.mftorder.validate.OrderAutoSetDefaultValueService;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPickStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.helper.BizTypeHelper;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.BomVersionQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.common.mftorder.utils.OrderGenChildOrderUtils;
import org.apache.commons.collections.CollectionUtils;

public class ChildExpandEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(ChildExpandEditPlugin.class);
    private static String[] strName = new String[]{"isselected", "level", "productorg", "materialmftinfo", "material", "cconfiguredcode", "cbom", "gentype", "billtype", "biztype", "ctransactiontype", "cbaseunit", "cbaseqty", "reqqty", "qtytype", "useratio", "qtynumerator", "qtydenominator", "wastagerateformula", "fixscrap", "scraprate", "isjumplevel", "parentmaterial", "sourcetype", "bomentryid", "pbomentryid", "pentryid"};
    private static String[] baseDataF7SelectFiled = new String[]{"billtype", "biztype", "ctransactiontype"};
    private static String preLevel = "1.";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btngen", "btoreexpand"});
        for (String filed : baseDataF7SelectFiled) {
            BasedataEdit bizTypeEdit = (BasedataEdit)this.getView().getControl(filed);
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        String propertyName = e.getProperty().getName();
        model.beginInit();
        switch (propertyName) {
            case "gentype": {
                this.genTypeDataChanged(model, rowIndex, newValue);
                break;
            }
            case "billtype": {
                this.billTypeDataChanged(model, rowIndex, newValue);
                break;
            }
            case "biztype": {
                this.bizTypeDataChanged(model, rowIndex, newValue);
                break;
            }
        }
        model.endInit();
    }

    private void bizTypeDataChanged(AbstractFormDataModel model, int rowIndex, Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject bizType = (DynamicObject)newValue;
            String genType = (String)model.getValue("gentype");
            model.setValue("ctransactiontype", (Object)OrderGenChildOrderUtils.getDefaultTranscationType((Object)bizType.getPkValue(), (String)(StringUtils.equals((CharSequence)"B", (CharSequence)genType) ? "P" : (StringUtils.equals((CharSequence)"C", (CharSequence)genType) ? "O" : "A")), (Long)org.getLong("id")), rowIndex);
        } else {
            model.setValue("ctransactiontype", null, rowIndex);
        }
        this.getView().updateView("ctransactiontype", rowIndex);
    }

    private void billTypeDataChanged(AbstractFormDataModel model, int rowIndex, Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject billType = (DynamicObject)newValue;
            Long orderDfBillTypeid = billType.getLong("id");
            DynamicObject org = (DynamicObject)model.getValue("org");
            String genType = (String)model.getValue("gentype");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)genType)) {
                this.setBizTypeRefValue(model, rowIndex, orderDfBillTypeid, org, "pom_mftorder", "P");
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)genType)) {
                this.setBizTypeRefValue(model, rowIndex, orderDfBillTypeid, org, "om_mftorder", "O");
            }
        } else {
            model.setValue("biztype", null, rowIndex);
            model.setValue("ctransactiontype", null, rowIndex);
            this.getView().updateView("biztype", rowIndex);
            this.getView().updateView("ctransactiontype", rowIndex);
        }
    }

    private void setBizTypeRefValue(AbstractFormDataModel model, int rowIndex, Long orderDfBillTypeid, DynamicObject org, String keyEntityid, String p) {
        DynamicObject orderDefultBizType = OrderGenChildOrderUtils.getDefalutBizType((String)keyEntityid, (Long)orderDfBillTypeid, (String)"bd_billtypeparameter");
        model.setValue("biztype", (Object)orderDefultBizType, rowIndex);
        Object bizTypeid = orderDefultBizType == null ? Long.valueOf(0L) : orderDefultBizType.getPkValue();
        model.setValue("ctransactiontype", (Object)OrderGenChildOrderUtils.getDefaultTranscationType((Object)bizTypeid, (String)p, (Long)org.getLong("id")), rowIndex);
        this.getView().updateView("biztype", rowIndex);
        this.getView().updateView("ctransactiontype", rowIndex);
    }

    private void genTypeDataChanged(AbstractFormDataModel model, int rowIndex, Object newValue) {
        String genType = "A";
        if (newValue instanceof String) {
            genType = newValue.toString();
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (StringUtils.equals((CharSequence)"B", (CharSequence)genType)) {
            this.setGenTypeRefValue(model, rowIndex, org, "pom_mftorder");
        } else if (StringUtils.equals((CharSequence)"C", (CharSequence)genType)) {
            this.setGenTypeRefValue(model, rowIndex, org, "om_mftorder");
        } else {
            model.setValue("billtype", null, rowIndex);
            model.setValue("biztype", null, rowIndex);
            model.setValue("ctransactiontype", null, rowIndex);
            this.getView().updateView("billtype", rowIndex);
            this.getView().updateView("biztype", rowIndex);
            this.getView().updateView("ctransactiontype", rowIndex);
        }
    }

    private void setGenTypeRefValue(AbstractFormDataModel model, int rowIndex, DynamicObject org, String keyEntityid) {
        Object bizTypeid;
        DynamicObject billType = BillTypeQueryHelper.getBillTypesCache((String)keyEntityid);
        model.setValue("billtype", (Object)billType, rowIndex);
        Long orderDfBillTypeid = billType == null ? 0L : billType.getLong("id");
        DynamicObject orderDefultBizType = OrderGenChildOrderUtils.getDefalutBizType((String)keyEntityid, (Long)orderDfBillTypeid, (String)"bd_billtypeparameter");
        model.setValue("biztype", (Object)orderDefultBizType, rowIndex);
        Object object = bizTypeid = orderDefultBizType == null ? Long.valueOf(0L) : orderDefultBizType.getPkValue();
        model.setValue("ctransactiontype", (Object)OrderGenChildOrderUtils.getDefaultTranscationType((Object)bizTypeid, (String)(StringUtils.equals((CharSequence)keyEntityid, (CharSequence)"pom_mftorder") ? "P" : (StringUtils.equals((CharSequence)keyEntityid, (CharSequence)"om_mftorder") ? "O" : "A")), (Long)org.getLong("id")), rowIndex);
        this.getView().updateView("billtype", rowIndex);
        this.getView().updateView("biztype", rowIndex);
        this.getView().updateView("ctransactiontype", rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String source;
        Control con = (Control)e.getSource();
        switch (source = con.getKey()) {
            case "billtype": {
                this.beforeSelectBillType(e);
                break;
            }
            case "biztype": {
                this.beforeSelectBizType(e);
                break;
            }
            case "ctransactiontype": {
                this.beforeSelectTransacationType(e);
                break;
            }
        }
    }

    private void beforeSelectTransacationType(BeforeF7SelectEvent e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (bizType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u3002", (String)"ChildExpandEditPlugin_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u751f\u4ea7\u5de5\u5355\u6570\u636e\u3002", (String)"ChildExpandEditPlugin_8", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List transacationTypes = null;
        String genType = (String)model.getValue("gentype");
        if (StringUtils.equals((CharSequence)"B", (CharSequence)genType)) {
            transacationTypes = OrderGenChildOrderUtils.getTranscationTypes((Object)bizType.getPkValue(), (String)"P", (Long)org.getLong("id"));
        } else if (StringUtils.equals((CharSequence)"C", (CharSequence)genType)) {
            transacationTypes = OrderGenChildOrderUtils.getTranscationTypes((Object)bizType.getPkValue(), (String)"O", (Long)org.getLong("id"));
        }
        Set<Long> transcationIds = new HashSet<Long>(1);
        transcationIds.add(0L);
        if (transacationTypes != null && !transacationTypes.isEmpty()) {
            transcationIds = transacationTypes.stream().map(k -> k.getPkValue()).collect(Collectors.toSet());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", transcationIds);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void beforeSelectBizType(BeforeF7SelectEvent e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (billType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u3002", (String)"ChildExpandEditPlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String genType = (String)model.getValue("gentype");
        long billTypeid = billType.getLong("id");
        List<Long> bizTypes = new ArrayList<Long>(1);
        bizTypes.add(0L);
        if (StringUtils.equals((CharSequence)"B", (CharSequence)genType)) {
            bizTypes = BizTypeHelper.getAllBizTypes((String)"pom_mftorder", (Long)billTypeid, (String)"bd_billtypeparameter");
        } else if (StringUtils.equals((CharSequence)"C", (CharSequence)genType)) {
            bizTypes = BizTypeHelper.getAllBizTypes((String)"om_mftorder", (Long)billTypeid, (String)"bd_billtypeparameter");
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", bizTypes);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void beforeSelectBillType(BeforeF7SelectEvent e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String genType = (String)model.getValue("gentype");
        Set<Long> locationList = new HashSet<Long>(1);
        locationList.add(0L);
        List billTypesCacheList = null;
        if (StringUtils.equals((CharSequence)"B", (CharSequence)genType)) {
            billTypesCacheList = BillTypeQueryHelper.getBillTypesCacheList((String)"pom_mftorder");
        } else if (StringUtils.equals((CharSequence)"C", (CharSequence)genType)) {
            billTypesCacheList = BillTypeQueryHelper.getBillTypesCacheList((String)"om_mftorder");
        }
        if (billTypesCacheList != null && !billTypesCacheList.isEmpty()) {
            locationList = billTypesCacheList.stream().map(k -> k.getPkValue()).collect(Collectors.toSet());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    public void beforeBindData(EventObject e) {
        long entryId;
        super.beforeBindData(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long l = entryId = formShowParameter.getCustomParam("entryid") == null ? 0L : (Long)formShowParameter.getCustomParam("entryid");
        if (0L != entryId) {
            this.setBaseInfo((IDataModel)model, entryId);
            this.childExpand();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"reexpand", (CharSequence)key)) {
            this.childExpand();
        }
        if (StringUtils.equals((CharSequence)"genchildorder", (CharSequence)key)) {
            ArrayList<Integer> selects = new ArrayList<Integer>(10);
            DynamicObjectCollection entryEntity = model.getEntryEntity("childexpand");
            for (DynamicObject entry : entryEntity) {
                boolean isselected = entry.getBoolean("isselected");
                if (!isselected) continue;
                selects.add(entry.getInt("seq"));
            }
            if (selects.size() > 0) {
                ArrayList<DynamicObject> orderTypeChilds = new ArrayList<DynamicObject>(selects.size());
                HashMap<Long, DynamicObject> idDynaobjectMaping = new HashMap<Long, DynamicObject>(selects.size());
                StringBuilder error = new StringBuilder(200);
                this.checkSelected(orderTypeChilds, error, idDynaobjectMaping);
                if (error.length() > 0) {
                    this.getView().showTipNotification(error.append(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25", (String)"ChildExpandEditPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0])).toString());
                    e.setCancel(true);
                    return;
                }
                DynamicObject orderentry = (DynamicObject)model.getValue("orderentry");
                Object billno = model.getValue("billno");
                Long orderid = Long.parseLong(model.getValue("orderid") == null ? "0" : model.getValue("orderid").toString());
                Set<DynamicObject> bomExpandResults = entryEntity.stream().filter(k -> StringUtils.equals((CharSequence)k.getString("sourcetype"), (CharSequence)"B")).collect(Collectors.toSet());
                if (orderTypeChilds.size() > 0) {
                    Map<Long, DynamicObject> firstLevelOrders;
                    DynamicObject targetOrder = this.pushTargetChildOrder("pom_mftorder", "1707521231433068544");
                    DynamicObject targetOmOrder = this.pushTargetChildOrder("om_mftorder", "1708126760324852736");
                    OrderGenChildOrderUtils.deleteChildOrder((String)"pom_mftorder", (Object)orderid, (Object)billno, (Object)orderentry.getPkValue(), (String)orderentry.getString("entryseq"));
                    OrderGenChildOrderUtils.deleteChildOrder((String)"om_mftorder", (Object)orderid, (Object)billno, (Object)orderentry.getPkValue(), (String)orderentry.getString("entryseq"));
                    ArrayList<DynamicObject> saveOrders = new ArrayList<DynamicObject>(10);
                    if (targetOrder != null && (firstLevelOrders = this.genChildOrder(orderTypeChilds, targetOrder, targetOmOrder, null)) != null && !firstLevelOrders.isEmpty()) {
                        saveOrders.addAll(firstLevelOrders.values());
                        this.loopGenChildOrder(idDynaobjectMaping, firstLevelOrders, bomExpandResults, targetOrder, targetOmOrder, saveOrders);
                    }
                    if (saveOrders.size() > 0) {
                        ArrayList<DynamicObject> saveOrderResults = new ArrayList<DynamicObject>(saveOrders.size());
                        ArrayList<DynamicObject> saveOmOrderResults = new ArrayList<DynamicObject>(saveOrders.size());
                        for (DynamicObject saveOrder : saveOrders) {
                            String number;
                            String name = saveOrder.getDataEntityType().getName();
                            if (StringUtils.equals((CharSequence)name, (CharSequence)"pom_mftorder")) {
                                saveOrderResults.add(saveOrder);
                            }
                            if (StringUtils.equals((CharSequence)name, (CharSequence)"om_mftorder")) {
                                saveOmOrderResults.add(saveOrder);
                            }
                            if (StringUtils.isEmpty((CharSequence)(number = CodeRuleServiceHelper.readNumber((String)saveOrder.getDataEntityType().getName(), (DynamicObject)saveOrder, (String)saveOrder.getDynamicObject("org").getString("id"))))) {
                                saveOrder.set("billno", (Object)("Child_" + saveOrder.getPkValue()));
                                continue;
                            }
                            saveOrder.set("billno", (Object)number);
                        }
                        if (saveOrderResults.size() > 0) {
                            this.saveTragetOrders(saveOrderResults, "pom_mftorder");
                        }
                        if (saveOmOrderResults.size() > 0) {
                            this.saveTragetOrders(saveOmOrderResults, "om_mftorder");
                        }
                        this.updateSrcOrderBillno(saveOrders, saveOrderResults, saveOmOrderResults);
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u751f\u6210\u7684\u5b50\u9879\u3002", (String)"ChildExpandEditPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private void updateSrcOrderBillno(List<DynamicObject> saveOrders, List<DynamicObject> saveOrderResults, List<DynamicObject> saveOmOrderResults) {
        Object object;
        DataSet rows;
        QFilter qFilter;
        if (saveOrders == null || saveOrders.isEmpty()) {
            return;
        }
        HashSet<Long> orderEntryids = new HashSet<Long>(saveOrders.size());
        HashSet<Long> omorderEntryids = new HashSet<Long>(saveOrders.size());
        for (DynamicObject saveOrder : saveOrders) {
            DynamicObjectCollection orderEntrys = saveOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                long srcorderentryid = orderEntry.getLong("srcorderentryid");
                String sourcebilltype = orderEntry.getString("sourcebilltype");
                if (StringUtils.isEmpty((CharSequence)sourcebilltype)) {
                    sourcebilltype = "pom_mftorder";
                }
                if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)sourcebilltype)) {
                    orderEntryids.add(srcorderentryid);
                }
                if (!StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)sourcebilltype)) continue;
                omorderEntryids.add(srcorderentryid);
            }
        }
        HashMap<Long, String> entryidBillbnoMaps = new HashMap<Long, String>(saveOrders.size());
        if (orderEntryids.size() > 0) {
            qFilter = new QFilter("treeentryentity.id", "in", orderEntryids);
            rows = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryorder"), (String)"pom_mftorder", (String)"id,billno,treeentryentity.id entryid", (QFilter[])qFilter.toArray(), null);
            object = null;
            try {
                for (Row row : rows) {
                    entryidBillbnoMaps.put(row.getLong("entryid"), row.getString("billno"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rows != null) {
                    if (object != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        if (omorderEntryids.size() > 0) {
            qFilter = new QFilter("treeentryentity.id", "in", omorderEntryids);
            rows = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryorder"), (String)"om_mftorder", (String)"id,billno,treeentryentity.id entryid", (QFilter[])qFilter.toArray(), null);
            object = null;
            try {
                for (Row row : rows) {
                    entryidBillbnoMaps.put(row.getLong("entryid"), row.getString("billno"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rows != null) {
                    if (object != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rows.close();
                    }
                }
            }
        }
        for (DynamicObject saveOrder : saveOrders) {
            DynamicObjectCollection orderEntrys = saveOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                long srcorderentryid = orderEntry.getLong("srcorderentryid");
                orderEntry.set("sourcebillnumber", entryidBillbnoMaps.get(srcorderentryid));
            }
        }
        if (saveOrderResults.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveOrderResults.toArray(new DynamicObject[saveOrderResults.size()]));
        }
        if (saveOmOrderResults.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])saveOmOrderResults.toArray(new DynamicObject[saveOmOrderResults.size()]));
        }
    }

    private void loopGenChildOrder(Map<Long, DynamicObject> idDynaobjectMaping, Map<Long, DynamicObject> parentLevelOrders, Set<DynamicObject> bomExpandResults, DynamicObject targetOrder, DynamicObject targetOmOrder, List<DynamicObject> saveOrders) {
        if (idDynaobjectMaping == null || idDynaobjectMaping.size() <= 0) {
            return;
        }
        if (parentLevelOrders == null || parentLevelOrders.size() <= 0) {
            return;
        }
        if (bomExpandResults == null || bomExpandResults.size() <= 0) {
            return;
        }
        for (Map.Entry<Long, DynamicObject> longDynamicObjectEntry : parentLevelOrders.entrySet()) {
            long entryid = longDynamicObjectEntry.getKey();
            DynamicObject rootOrder = longDynamicObjectEntry.getValue();
            DynamicObject entryObject = idDynaobjectMaping.get(entryid);
            List<DynamicObject> childEntrys = this.findChildEntry(bomExpandResults, entryObject);
            Map<Long, DynamicObject> loopChild = this.genChildOrder(childEntrys, targetOrder, targetOmOrder, rootOrder);
            if (loopChild == null || loopChild.isEmpty()) continue;
            saveOrders.addAll(loopChild.values());
            this.loopGenChildOrder(idDynaobjectMaping, loopChild, bomExpandResults, targetOrder, targetOmOrder, saveOrders);
        }
    }

    private List<DynamicObject> findChildEntry(Set<DynamicObject> bomExpandResults, DynamicObject entryObject) {
        ArrayList<DynamicObject> childEntrys = new ArrayList<DynamicObject>(bomExpandResults.size());
        ArrayList<DynamicObject> jumpEntrys = new ArrayList<DynamicObject>(bomExpandResults.size());
        long bomentryid = entryObject.getLong("bomentryid");
        for (DynamicObject bomExpandResult : bomExpandResults) {
            long pbomentryid = bomExpandResult.getLong("pbomentryid");
            if (bomentryid != pbomentryid) continue;
            boolean isjumplevel = bomExpandResult.getBoolean("isjumplevel");
            if (isjumplevel) {
                jumpEntrys.add(bomExpandResult);
                continue;
            }
            childEntrys.add(bomExpandResult);
        }
        if (jumpEntrys.size() > 0) {
            bomExpandResults.removeAll(jumpEntrys);
            this.findSelfMade(jumpEntrys, bomExpandResults, childEntrys);
        }
        if (childEntrys.size() > 0) {
            bomExpandResults.removeAll(childEntrys);
        }
        return childEntrys;
    }

    private void findSelfMade(List<DynamicObject> jumpEntrys, Set<DynamicObject> bomExpandResults, List<DynamicObject> childEntrys) {
        if (jumpEntrys == null || jumpEntrys.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> thisjumpEntrys = new ArrayList<DynamicObject>(10);
        for (DynamicObject jumpEntry : jumpEntrys) {
            long bomentryid = jumpEntry.getLong("bomentryid");
            for (DynamicObject bomExpandResult : bomExpandResults) {
                long pbomentryid = bomExpandResult.getLong("pbomentryid");
                if (bomentryid != pbomentryid) continue;
                boolean isjumplevel = bomExpandResult.getBoolean("isjumplevel");
                if (isjumplevel) {
                    thisjumpEntrys.add(bomExpandResult);
                    continue;
                }
                childEntrys.add(bomExpandResult);
            }
        }
        if (thisjumpEntrys.size() > 0) {
            bomExpandResults.removeAll(thisjumpEntrys);
            this.findSelfMade(thisjumpEntrys, bomExpandResults, childEntrys);
        }
    }

    private void saveTragetOrders(List<DynamicObject> saveOrders, String keyEntitynumberOmmftorder) {
        if (saveOrders.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("strictvalidation", String.valueOf(true));
            option.setVariableValue("ignoreValidation", "true");
            try (TXHandle handle = TX.required((String)"order_save");){
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)keyEntitynumberOmmftorder, (DynamicObject[])saveOrders.toArray(new DynamicObject[saveOrders.size()]), (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    handle.markRollback();
                    String operationResultErrorInfos = OrderMergeHelper.getOperationResultErrorInfos((OperationResult)operationResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"ChildExpandEditPlugin_9", (String)"mmc-pom-formplugin", (Object[])new Object[0]), operationResultErrorInfos));
                }
            }
        }
    }

    private Map<Long, DynamicObject> genChildOrder(List<DynamicObject> orderTypeChilds, DynamicObject targetOrder, DynamicObject targetOmOrder, DynamicObject srcOrder) {
        if (orderTypeChilds == null || orderTypeChilds.size() < 1) {
            return null;
        }
        ArrayList<DynamicObject> saveOrders = new ArrayList<DynamicObject>(orderTypeChilds.size());
        HashMap<Long, DynamicObject> saveOrderMaps = new HashMap<Long, DynamicObject>(orderTypeChilds.size());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject rootOrderEntry = (DynamicObject)model.getValue("orderentry");
        CloneUtils cloneUtils = new CloneUtils(false, true);
        Date expendbomtime = (Date)model.getValue("expendbomtime");
        if (expendbomtime == null) {
            expendbomtime = new Date();
        }
        HashMap<String, Object> loopCacheMap = new HashMap<String, Object>(16);
        HashSet<Object> materialIDSet = new HashSet<Object>(16);
        HashSet<Object> mftIDSet = new HashSet<Object>(16);
        HashSet<Object> transcationTypeIDSet = new HashSet<Object>(16);
        for (DynamicObject orderTypeChild : orderTypeChilds) {
            DynamicObject transactiontype = orderTypeChild.getDynamicObject("ctransactiontype");
            DynamicObject materialmftinfo = orderTypeChild.getDynamicObject("materialmftinfo");
            DynamicObject material = orderTypeChild.getDynamicObject("material");
            if (transactiontype != null) {
                transcationTypeIDSet.add(transactiontype.getPkValue());
            }
            if (materialmftinfo != null) {
                mftIDSet.add(materialmftinfo.getPkValue());
            }
            if (material == null) continue;
            materialIDSet.add(material.getPkValue());
        }
        Map mftInfoCacheMap = MaterialMftQueryHelper.getDataCacheBySet(mftIDSet);
        Map materialInfoCacheMap = MaterialQueryHelper.getDataCacheBySet(materialIDSet);
        Map transcationTypeCacheMap = TransactionTypeQueryHelper.getDataCacheBySet(transcationTypeIDSet);
        for (DynamicObject orderTypeChild : orderTypeChilds) {
            long pkValue = orderTypeChild.getLong("id");
            DynamicObject productorg = orderTypeChild.getDynamicObject("productorg");
            Long deptId = productorg == null ? 0L : Long.parseLong(productorg.getPkValue().toString());
            DynamicObject newOrder = null;
            String gentype = orderTypeChild.getString("gentype");
            if (StringUtils.equals((CharSequence)gentype, (CharSequence)"B")) {
                newOrder = (DynamicObject)cloneUtils.clone((IDataEntityBase)targetOrder);
            } else {
                if (!StringUtils.equals((CharSequence)gentype, (CharSequence)"C")) continue;
                newOrder = (DynamicObject)cloneUtils.clone((IDataEntityBase)targetOmOrder);
            }
            saveOrders.add(newOrder);
            saveOrderMaps.put(pkValue, newOrder);
            newOrder.set("org", (Object)productorg);
            newOrder.set("billtype", orderTypeChild.get("billtype"));
            DynamicObject transactiontype = orderTypeChild.getDynamicObject("ctransactiontype");
            transactiontype = (DynamicObject)transcationTypeCacheMap.get(transactiontype.getPkValue());
            newOrder.set("transactiontype", (Object)transactiontype);
            DynamicObjectCollection orderEntrys = newOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                DynamicObject processroute;
                DynamicObject inwarorg;
                orderEntry.set("producttype", (Object)ManuBillProductTypeEnum.MAIN.getValue());
                DynamicObject materialmftinfo = orderTypeChild.getDynamicObject("materialmftinfo");
                materialmftinfo = (DynamicObject)mftInfoCacheMap.get(materialmftinfo.getPkValue());
                DynamicObject departmentorg = materialmftinfo.getDynamicObject("departmentorgid");
                if (departmentorg != null) {
                    orderEntry.set("producedept", materialmftinfo.get("departmentorgid"));
                } else {
                    orderEntry.set("producedept", rootOrderEntry.get("producedept"));
                }
                DynamicObject material = orderTypeChild.getDynamicObject("material");
                material = (DynamicObject)materialInfoCacheMap.get(material.getPkValue());
                orderEntry.set("material", (Object)materialmftinfo);
                orderEntry.set("materielmasterid", (Object)material);
                orderEntry.set("configuredcode", orderTypeChild.get("cconfiguredcode"));
                orderEntry.set("tracknumber", rootOrderEntry.get("tracknumber"));
                orderEntry.set("unit", materialmftinfo.get("mftunit"));
                DynamicObject cbaseunit = orderTypeChild.getDynamicObject("cbaseunit");
                orderEntry.set("baseunit", (Object)cbaseunit);
                orderEntry.set("baseqty", orderTypeChild.get("reqqty"));
                BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)cbaseunit, (BigDecimal)orderEntry.getBigDecimal("baseqty"), (DynamicObject)orderEntry.getDynamicObject("unit"));
                orderEntry.set("qty", (Object)qty);
                orderEntry.set("planqty", (Object)qty);
                orderEntry.set("planbaseqty", orderEntry.get("baseqty"));
                DynamicObject auxptyunit = material.getDynamicObject("auxptyunit");
                orderEntry.set("auxptyunit", (Object)auxptyunit);
                BigDecimal auxptyqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)cbaseunit, (BigDecimal)orderEntry.getBigDecimal("baseqty"), (DynamicObject)auxptyunit);
                orderEntry.set("auxptyqty", (Object)auxptyqty);
                DynamicObject materialPlan = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)material, (DynamicObject)productorg);
                if (materialPlan != null) {
                    orderEntry.set("yieldrate", materialPlan.get("yield"));
                }
                DynamicObject bom = orderTypeChild.getDynamicObject("cbom");
                orderEntry.set("bomid", (Object)bom);
                orderEntry.set("expendbomtime", (Object)expendbomtime);
                BigDecimal estscrapqty = OrderGenChildOrderUtils.calEstscrapqty((DynamicObject)orderEntry, (DynamicObject)materialPlan);
                orderEntry.set("estscrapqty", (Object)estscrapqty);
                if (srcOrder != null) {
                    DynamicObjectCollection srcOrderEntrys = srcOrder.getDynamicObjectCollection("treeentryentity");
                    DynamicObject srcOrderEntry = (DynamicObject)srcOrderEntrys.get(0);
                    orderEntry.set("planendtime", srcOrderEntry.get("planbegintime"));
                }
                Date planBeginDate = OrderGenChildOrderUtils.getPlanBeginDate((DynamicObject)materialPlan, (DynamicObject)orderEntry);
                orderEntry.set("planbegintime", (Object)planBeginDate);
                orderEntry.set("planpreparetime", (Object)planBeginDate);
                boolean isstoragelimit = materialmftinfo.getBoolean("isstoragelimit");
                orderEntry.set("iscontrolqty", (Object)isstoragelimit);
                if (isstoragelimit) {
                    orderEntry.set("rcvinhighlimit", materialmftinfo.get("rcvinhighlimit"));
                    orderEntry.set("rcvinlowlimit", materialmftinfo.get("rcvinlowlimit"));
                }
                boolean isreportlimit = materialmftinfo.getBoolean("isreportlimit");
                orderEntry.set("isconreportqty", (Object)isreportlimit);
                if (isreportlimit) {
                    orderEntry.set("repmaxrate", materialmftinfo.get("rpthighlimit"));
                    orderEntry.set("repminrate", materialmftinfo.get("rptlowlimit"));
                }
                if ((inwarorg = materialmftinfo.getDynamicObject("inwarorg")) != null) {
                    orderEntry.set("inwardept", (Object)inwarorg);
                    DynamicObject inwarehouse = materialmftinfo.getDynamicObject("inwarehouse");
                    DynamicObject inwarelocation = materialmftinfo.getDynamicObject("inwarelocation");
                    orderEntry.set("warehouse", (Object)inwarehouse);
                    orderEntry.set("location", (Object)inwarelocation);
                } else {
                    orderEntry.set("inwardept", (Object)this.getInOrgID(deptId, loopCacheMap));
                }
                if (srcOrder != null) {
                    DynamicObjectCollection srcOrderEntrys = srcOrder.getDynamicObjectCollection("treeentryentity");
                    if (srcOrderEntrys.size() > 0) {
                        orderEntry.set("srcorderentryid", ((DynamicObject)srcOrderEntrys.get(0)).getPkValue());
                    } else {
                        orderEntry.set("srcorderentryid", srcOrder.getPkValue());
                    }
                    orderEntry.set("sourcebilltype", (Object)srcOrder.getDynamicObjectType().getName());
                    orderEntry.set("sourceentryseq", (Object)"1");
                }
                if ((processroute = this.getProcessRoute(materialmftinfo, productorg)) == null) continue;
                orderEntry.set("processroute", (Object)processroute);
            }
            if (srcOrder == null) continue;
            DynamicObjectCollection srcOrderEntrys = srcOrder.getDynamicObjectCollection("treeentryentity");
            String orderName = srcOrder.getDataEntityType().getName();
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)orderName, (String)"treeentryentity");
            String lkEntryKey = tableDefine.getEntityKey() + "_lk";
            String lkHeadKey = "billhead_lk";
            if (orderEntrys.size() < 1) {
                DynamicObjectCollection linkRows = newOrder.getDynamicObjectCollection(lkHeadKey);
                linkRows.clear();
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRows.add((Object)linkRow);
                linkRow.set(lkHeadKey + "_stableid", (Object)tableDefine.getTableId());
                linkRow.set(lkHeadKey + "_sbillid", srcOrder.getPkValue());
                linkRow.set(lkHeadKey + "_sid", ((DynamicObject)srcOrderEntrys.get(0)).getPkValue());
                continue;
            }
            for (DynamicObject targetRow : orderEntrys) {
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                linkRows.clear();
                if (!linkRows.isEmpty() || linkRows.getDynamicObjectType() == null) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRows.add((Object)linkRow);
                linkRow.set(lkEntryKey + "_stableid", (Object)tableDefine.getTableId());
                linkRow.set(lkEntryKey + "_sbillid", srcOrder.getPkValue());
                linkRow.set(lkEntryKey + "_sid", ((DynamicObject)srcOrderEntrys.get(0)).getPkValue());
            }
        }
        if (saveOrders.size() > 0) {
            SequenceReader seqReader;
            DBRoute rt;
            IDataEntityType dataEntityType;
            ArrayList<DynamicObject> saveOrderResults = new ArrayList<DynamicObject>(saveOrders.size());
            ArrayList<DynamicObject> saveOmOrderResults = new ArrayList<DynamicObject>(saveOrders.size());
            for (DynamicObject saveOrder : saveOrders) {
                String name = saveOrder.getDataEntityType().getName();
                if (StringUtils.equals((CharSequence)name, (CharSequence)"pom_mftorder")) {
                    saveOrderResults.add(saveOrder);
                }
                if (!StringUtils.equals((CharSequence)name, (CharSequence)"om_mftorder")) continue;
                saveOmOrderResults.add(saveOrder);
            }
            if (saveOrderResults.size() > 0) {
                dataEntityType = ((DynamicObject)saveOrderResults.get(0)).getDataEntityType();
                rt = new DBRoute(dataEntityType.getDBRouteKey());
                seqReader = new SequenceReader(rt);
                seqReader.autoSetPrimaryKey(saveOrderResults, dataEntityType);
            }
            if (saveOmOrderResults.size() > 0) {
                dataEntityType = ((DynamicObject)saveOmOrderResults.get(0)).getDataEntityType();
                rt = new DBRoute(dataEntityType.getDBRouteKey());
                seqReader = new SequenceReader(rt);
                seqReader.autoSetPrimaryKey(saveOmOrderResults, dataEntityType);
            }
            OrderAutoSetDefaultValueService.autoGenEntryByBom((DynamicObject[])saveOrders.toArray(new DynamicObject[0]), (String)targetOrder.getDataEntityType().getName());
            OrderAutoSetDefaultValueService.assignQualityOrg((DynamicObject[])saveOrders.toArray(new DynamicObject[0]));
        }
        return saveOrderMaps;
    }

    private Long genGlobalLongID() {
        return DB.genGlobalLongId();
    }

    private DynamicObject pushTargetChildOrder(String targetEntityName, String ruleid) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(1);
        Long orderid = Long.parseLong(model.getValue("orderid").toString());
        DynamicObject orderEntry = (DynamicObject)model.getValue("orderentry");
        long entryId = orderEntry == null ? 0L : Long.parseLong(orderEntry.getPkValue().toString());
        ListSelectedRow srcBill = new ListSelectedRow((Object)orderid);
        srcBill.setEntryPrimaryKeyValue((Object)entryId);
        selectedRows.add(srcBill);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mftorder");
        pushArgs.setTargetEntityNumber(targetEntityName);
        pushArgs.setBuildConvReport(true);
        pushArgs.setHasRight(false);
        pushArgs.setRuleId(ruleid);
        pushArgs.setAutoSave(false);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            String billMessage = "";
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                billMessage = billReport.getFailMessage();
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u8c03\u7528\u8f6c\u6362\u89c4\u5219\u4e0b\u63a8\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u5931\u8d25\uff1a%1$s", (String)"ChildExpandEditPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]), errMessage + billMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntityName);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs != null && targetBillObjs.size() > 0) {
            DynamicObject targetOrder = (DynamicObject)targetBillObjs.get(0);
            targetOrder.set("parentorderid", (Object)entryId);
            DynamicObjectCollection orderEntrys = targetOrder.getDynamicObjectCollection("treeentryentity");
            ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>(10);
            for (DynamicObject entry : orderEntrys) {
                Long srcorderentryid = entry.getLong("srcorderentryid");
                if (srcorderentryid == 0L || srcorderentryid.equals(entryId)) continue;
                removeEntrys.add(entry);
            }
            if (removeEntrys.size() > 0) {
                orderEntrys.removeAll(removeEntrys);
            }
            return targetOrder;
        }
        return null;
    }

    private void checkSelected(List<DynamicObject> orderTypeChilds, StringBuilder error, Map<Long, DynamicObject> idDynaobjectMaping) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("childexpand");
        for (DynamicObject entryObject : entryEntity) {
            String gentype;
            long pkValue;
            boolean isselected = entryObject.getBoolean("isselected");
            if (!isselected) continue;
            int seq = entryObject.getInt("seq");
            DynamicObject materialmftinfo = entryObject.getDynamicObject("materialmftinfo");
            if (!materialmftinfo.getBoolean("ismainproduct")) {
                DynamicObject material = entryObject.getDynamicObject("material");
                String number = material.getString("number");
                error.append(String.format(ResManager.loadKDString((String)"\u5b50\u9879\u7269\u6599\u7b2c%1$s\u884c\uff0c\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff08%2$s\uff09\u672a\u52fe\u9009\u201c\u53ef\u4e3b\u4ea7\u54c1\u201d\u3002", (String)"ChildExpandEditPlugin_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]), seq, number));
                error.append("\n");
            }
            if ((pkValue = entryObject.getLong("id")) == 0L) {
                pkValue = this.genGlobalLongID();
                entryObject.set("id", (Object)pkValue);
            }
            idDynaobjectMaping.put(pkValue, entryObject);
            String sourcetype = entryObject.getString("sourcetype");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)sourcetype) || !StringUtils.equals((CharSequence)(gentype = entryObject.getString("gentype")), (CharSequence)"B") && !StringUtils.equals((CharSequence)"C", (CharSequence)gentype)) continue;
            orderTypeChilds.add(entryObject);
        }
    }

    private static String getCacheValue(String resStr) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        return (String)cache.get(resStr);
    }

    private void childExpand() {
        Date expendbomtime;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject orderEntry = (DynamicObject)model.getValue("orderentry");
        long entryId = orderEntry == null ? 0L : Long.parseLong(orderEntry.getPkValue().toString());
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject transactiontype = (DynamicObject)model.getValue("transactiontype");
        if (transactiontype != null) {
            transactiontype = TransactionTypeQueryHelper.getDataCacheByID((Object)transactiontype.getPkValue());
        }
        if ((expendbomtime = (Date)model.getValue("expendbomtime")) == null) {
            expendbomtime = new Date();
        }
        HashSet<Long> bomTypeIdSet = new HashSet<Long>(1);
        DynamicObject rootBom = (DynamicObject)this.getModel().getValue("bom");
        if (rootBom != null) {
            DynamicObject bomType = rootBom.getDynamicObject("type");
            Long bomTypeid = bomType == null ? 0L : Long.parseLong(bomType.getPkValue().toString());
            bomTypeIdSet.add(bomTypeid);
        }
        boolean showout = (Boolean)model.getValue("showout");
        HashMap<Object, String> stockEntryBomMap = new HashMap<Object, String>(16);
        QFilter filter = new QFilter("orderid", "=", model.getValue("orderid"));
        filter.and(new QFilter("orderentryid", "=", (Object)entryId));
        StringBuilder selectors = new StringBuilder(200);
        selectors.append("id,billno,transactiontypeid,stockentry.seq,stockentry.entryconfiguredcode,stockentry.useratio,stockentry.scraprate,stockentry.fixscrap,stockentry.isjumplevel,");
        selectors.append("stockentry.wastagerateformula,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.standqty,stockentry.demandqty,stockentry.materialunitid,stockentry.qtytype,");
        selectors.append("stockentry.entryconfiguredcode,stockentry.bomreversion,stockentry.materialid,stockentry.materielmasterid,stockentry.wastagerateformula,");
        selectors.append("stockentry.childauxpropertyid,stockentry.isjumplevel,stockentry.parentmaterial,stockentry.rework,stockentry.iscannegative,stockentry.bomentryid");
        DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"pom_mftstock", (String)selectors.toString(), (QFilter[])filter.toArray());
        if (stock != null) {
            Object stockEntryid;
            model.setValue("stockno", stock.get("billno"));
            model.setValue("stockid", stock.get("id"));
            Long orderDfBillTypeid = MPDMMftGenStocksUtils.getDefalutBillType((String)"pom_mftorder");
            Long omOrderDfBillTypeid = MPDMMftGenStocksUtils.getDefalutBillType((String)"om_mftorder");
            DynamicObject orderDefultBizType = OrderGenChildOrderUtils.getDefalutBizType((String)"pom_mftorder", (Long)orderDfBillTypeid, (String)"bd_billtypeparameter");
            DynamicObject omOrderDefultBizType = OrderGenChildOrderUtils.getDefalutBizType((String)"om_mftorder", (Long)omOrderDfBillTypeid, (String)"bd_billtypeparameter");
            DynamicObject defaultTranscationType = OrderGenChildOrderUtils.getDefaultTranscationType((Object)orderDefultBizType.getPkValue(), (String)"P", (Long)org.getLong("id"));
            DynamicObject omDefaultTranscationType = OrderGenChildOrderUtils.getDefaultTranscationType((Object)omOrderDefultBizType.getPkValue(), (String)"O", (Long)org.getLong("id"));
            TableValueSetter vs = new TableValueSetter(new String[0]);
            for (String str : strName) {
                vs.addField(str, new Object[0]);
            }
            DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
            int index = 1;
            JSONArray filterArrayNew = new JSONArray(16);
            for (DynamicObject stockEntry : stockEntrys) {
                BigDecimal demandQty;
                stockEntryid = stockEntry.getPkValue();
                DynamicObject materialMftInfo = stockEntry.getDynamicObject("materialid");
                String materialatt = materialMftInfo.getString("materialattr");
                if (StringUtils.equals((CharSequence)"10040", (CharSequence)materialatt) && !showout) continue;
                boolean rework = stockEntry.getBoolean("rework");
                boolean iscannegative = stockEntry.getBoolean("iscannegative");
                boolean isjumplevel = stockEntry.getBoolean("isjumplevel");
                if (rework || iscannegative || isjumplevel || (demandQty = stockEntry.getBigDecimal("demandQty")).compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject bom = this.getBOM(org, transactiontype, expendbomtime, stockEntry);
                DynamicObject entryconfiguredcode = stockEntry.getDynamicObject("entryconfiguredcode");
                DynamicObject masterMaterial = stockEntry.getDynamicObject("materielmasterid");
                Long masterid = Long.parseLong(masterMaterial.getPkValue().toString());
                Long entryConfigCodeid = entryconfiguredcode == null ? 0L : entryconfiguredcode.getLong("id");
                HashMap<String, Object> paramMap = this.getParamsMap(masterid, expendbomtime, org.getLong("id"), entryConfigCodeid, demandQty, transactiontype, bom);
                JSONObject jsonParams = CreateStockByBomUtils.getMulBOMJsonObjectParam(paramMap);
                filterArrayNew.add((Object)jsonParams);
                String resStr = CreateStockByBomUtils.getMulBomFilterStr((JSONObject)jsonParams);
                stockEntryBomMap.put(stockEntryid, resStr);
                String gentype = null;
                long billtype = 0L;
                long biztype = 0L;
                long ctransactiontype = 0L;
                boolean isSelect = false;
                if (StringUtils.equals((CharSequence)"10030", (CharSequence)materialatt)) {
                    isSelect = true;
                    gentype = "B";
                    billtype = orderDfBillTypeid;
                    biztype = orderDefultBizType == null ? 0L : Long.parseLong(orderDefultBizType.getPkValue().toString());
                    ctransactiontype = defaultTranscationType == null ? 0L : Long.parseLong(defaultTranscationType.getPkValue().toString());
                } else if (StringUtils.equals((CharSequence)"10050", (CharSequence)materialatt)) {
                    isSelect = true;
                    gentype = "C";
                    billtype = omOrderDfBillTypeid;
                    biztype = omOrderDefultBizType == null ? 0L : Long.parseLong(omOrderDefultBizType.getPkValue().toString());
                    ctransactiontype = omDefaultTranscationType == null ? 0L : Long.parseLong(omDefaultTranscationType.getPkValue().toString());
                } else if (StringUtils.equals((CharSequence)"10020", (CharSequence)materialatt) || StringUtils.equals((CharSequence)"10040", (CharSequence)materialatt)) {
                    gentype = "A";
                    isSelect = false;
                }
                if (isjumplevel) {
                    isSelect = false;
                }
                Object entryconfigCode = entryconfiguredcode == null ? Long.valueOf(0L) : entryconfiguredcode.getPkValue();
                Long materialunitid = stockEntry.getDynamicObject("materialunitid") == null ? Long.valueOf(0L) : stockEntry.getDynamicObject("materialunitid").getPkValue();
                Long parentMaterialid = stockEntry.getDynamicObject("parentmaterial") == null ? Long.valueOf(0L) : stockEntry.getDynamicObject("parentmaterial").getPkValue();
                Object bomid = bom == null ? Long.valueOf(0L) : bom.getPkValue();
                vs.addRow(new Object[]{isSelect, preLevel + index, org.getPkValue(), materialMftInfo.getPkValue(), stockEntry.getDynamicObject("materielmasterid").getPkValue(), entryconfigCode, bomid, gentype, billtype, biztype, ctransactiontype, materialunitid, stockEntry.get("standqty"), demandQty, stockEntry.get("qtytype"), stockEntry.get("useratio"), stockEntry.get("qtynumerator"), stockEntry.get("qtydenominator"), stockEntry.get("wastagerateformula"), stockEntry.get("fixscrap"), stockEntry.get("scraprate"), isjumplevel, parentMaterialid, "A", stockEntry.get("bomentryid"), 0L, 0L});
                stockEntry.set("seq", (Object)index++);
            }
            if (filterArrayNew.size() > 0) {
                Iterator result = JSON.parseArray((String)CreateStockByBomUtils.getQueryDataResMulType((String)filterArrayNew.toString()));
                JSONObject object = (JSONObject)result.get(0);
                if (result != null && StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)object.getString("success"))) {
                    String errorInfo = object.getString("msg");
                    logger.info("-------------BomExpad error:" + errorInfo);
                    throw new KDBizException(new ErrorCode("bomexpanderror", errorInfo), new Object[0]);
                }
            }
            for (DynamicObject stockEntry : stockEntrys) {
                String res;
                stockEntryid = stockEntry.getPkValue();
                BigDecimal useratioHu = stockEntry.getBigDecimal("useratio");
                BigDecimal useratio = useratioHu.divide(new BigDecimal("100"), 4, 4);
                BigDecimal demandqty = stockEntry.getBigDecimal("demandqty");
                String resKey = (String)stockEntryBomMap.get(stockEntryid);
                if (StringUtils.isEmpty((CharSequence)resKey) || StringUtils.isEmpty((CharSequence)(res = ChildExpandEditPlugin.getCacheValue(resKey)))) continue;
                logger.info("\u5b50\u9879BOM\u5c55\u5f00\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resKey = " + resKey + ",res--------------:" + res);
                JSONArray resArray = JSONArray.parseArray((String)res);
                if (resArray == null) continue;
                HashSet<Long> bomEntryIdSet = new HashSet<Long>(resArray.size());
                HashMap<Long, BigDecimal> parentDemandqty = new HashMap<Long, BigDecimal>();
                if (resArray != null) {
                    for (int i = 0; i < resArray.size(); ++i) {
                        JSONObject resJson = (JSONObject)resArray.get(i);
                        bomEntryIdSet.add(resJson.getLong("entry_Id"));
                    }
                }
                Map bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
                for (int i = 0; i < resArray.size(); ++i) {
                    boolean entryisjumplevel;
                    DynamicObject planInfo;
                    JSONObject resJson = (JSONObject)resArray.get(i);
                    String gentype = null;
                    long billtype = 0L;
                    long biztype = 0L;
                    long ctransactiontype = 0L;
                    boolean isconsiderloss = false;
                    boolean isSelect = false;
                    String materialattr = resJson.getString("entrymaterialattr");
                    if (StringUtils.equals((CharSequence)"10040", (CharSequence)materialattr) && !showout) continue;
                    if (StringUtils.equals((CharSequence)"10030", (CharSequence)materialattr)) {
                        isSelect = true;
                        gentype = "B";
                        billtype = orderDfBillTypeid;
                        biztype = orderDefultBizType == null ? 0L : Long.parseLong(orderDefultBizType.getPkValue().toString());
                        ctransactiontype = defaultTranscationType == null ? 0L : Long.parseLong(defaultTranscationType.getPkValue().toString());
                        isconsiderloss = defaultTranscationType == null ? false : defaultTranscationType.getBoolean("isconsiderloss");
                    } else if (StringUtils.equals((CharSequence)"10050", (CharSequence)materialattr)) {
                        isSelect = true;
                        gentype = "C";
                        billtype = omOrderDfBillTypeid;
                        biztype = omOrderDefultBizType == null ? 0L : Long.parseLong(omOrderDefultBizType.getPkValue().toString());
                        ctransactiontype = omDefaultTranscationType == null ? 0L : Long.parseLong(omDefaultTranscationType.getPkValue().toString());
                        isconsiderloss = omDefaultTranscationType == null ? false : omDefaultTranscationType.getBoolean("isconsiderloss");
                    } else if (StringUtils.equals((CharSequence)"10020", (CharSequence)materialattr) || StringUtils.equals((CharSequence)"10040", (CharSequence)materialattr)) {
                        gentype = "A";
                        isSelect = false;
                    }
                    DynamicObject bomEntry = (DynamicObject)bomEntryMap.get(resJson.getLong("entry_Id"));
                    DynamicObject entryunit = bomEntry.getDynamicObject("entryunit");
                    DynamicObject materialmft = bomEntry.getDynamicObject("entrymaterial");
                    DynamicObject bom = (DynamicObject)bomEntry.getParent();
                    DynamicObject parentMaterial = bom.getDynamicObject("material");
                    String qtytype = resJson.get((Object)"entryqtytype") == null ? "A" : resJson.getString("entryqtytype");
                    BigDecimal numerator = resJson.getBigDecimal("entryqtynumerator");
                    BigDecimal denominator = resJson.getBigDecimal("entryqtydenominator");
                    BigDecimal scraprate = resJson.get((Object)"entryscraprate") == null ? BigDecimal.ZERO : resJson.getBigDecimal("entryscraprate");
                    BigDecimal fixscrap = resJson.get((Object)"entryfixscrap") == null ? BigDecimal.ZERO : resJson.getBigDecimal("entryfixscrap");
                    DynamicObject material = materialmft.getDynamicObject("masterid");
                    DynamicObject childBom = MsBomQueryHelper.getBomFromCache((DynamicObject)material, (Long)org.getLong("id"), null, bomTypeIdSet, (Date)expendbomtime, (String)"id,number,type,version", (String)"", (DynamicObject)bomEntry.getDynamicObject("entryauxproperty"));
                    Long childBomId = childBom == null ? 0L : childBom.getLong("id");
                    String wastagerateformula = "B";
                    if (isconsiderloss && null != (planInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)material, (DynamicObject)org))) {
                        wastagerateformula = planInfo.getString("wastagerateformula");
                    }
                    if (entryisjumplevel = resJson.getBoolean("entryisjumplevel").booleanValue()) {
                        isSelect = false;
                    }
                    long parententryid = this.getParententryidByLongNumber(stockEntry, resJson);
                    BigDecimal parentDemandQty = parentDemandqty.getOrDefault(parententryid, demandqty);
                    BigDecimal standQty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)entryunit, (String)qtytype, (BigDecimal)useratio, (BigDecimal)parentDemandQty, (BigDecimal)numerator, (BigDecimal)denominator);
                    BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty((DynamicObject)entryunit, (boolean)isconsiderloss, (BigDecimal)standQty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
                    parentDemandqty.put(resJson.getLong("entry_Id"), demandQty);
                    String bomlevel = resJson.getString("bomlevel");
                    bomlevel = bomlevel.replaceFirst("1", "");
                    String root = stockEntry.getString("seq");
                    vs.addRow(new Object[]{isSelect, preLevel + root + bomlevel, org.getPkValue(), resJson.get((Object)"entrymaterialInfo"), resJson.get((Object)"entrymaterialId"), resJson.get((Object)"entryConfigCode"), childBomId, gentype, billtype, biztype, ctransactiontype, resJson.get((Object)"entryunit"), standQty, demandQty, qtytype, useratioHu, numerator, denominator, wastagerateformula, fixscrap, scraprate, entryisjumplevel, parentMaterial.getPkValue(), "B", bomEntry.getPkValue(), parententryid, 0L});
                }
            }
            model.beginInit();
            model.deleteEntryData("childexpand");
            model.batchCreateNewEntryRow("childexpand", vs);
            DynamicObjectCollection entryEntitys = model.getEntryEntity("childexpand");
            if (entryEntitys != null && entryEntitys.size() > 0) {
                long[] longs = DB.genGlobalLongIds((int)entryEntitys.size());
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryEntitys.get(i);
                    entry.set("id", (Object)longs[i]);
                }
            }
            model.endInit();
            this.getView().updateView("childexpand");
        }
    }

    private HashMap<String, Object> getParamsMap(Long masterid, Date expendbomtime, Long orgId, Long entryConfigCodeid, BigDecimal demandQty, DynamicObject defaultTranscationType, DynamicObject bom) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        paramMap.put("bomId", bom == null ? Long.valueOf(0L) : bom.getPkValue());
        paramMap.put("materialid", masterid);
        paramMap.put("searchDate", expendbomtime);
        paramMap.put("configcode", entryConfigCodeid);
        paramMap.put("expandConfig", defaultTranscationType == null ? Long.valueOf(0L) : defaultTranscationType.getDynamicObject("bomexpandconfig").getPkValue());
        paramMap.put("org", orgId);
        paramMap.put("num", demandQty);
        paramMap.put("showtype", "A");
        paramMap.put("purexpand", false);
        paramMap.put("model", "model_pom");
        return paramMap;
    }

    private long getParententryidByLongNumber(DynamicObject stockEntry, JSONObject resJson) {
        if (resJson == null) {
            return 0L;
        }
        String level = resJson.getString("level");
        level = StringUtils.isEmpty((CharSequence)level) ? "1" : level.replaceAll("-", "");
        int lev = Integer.parseInt(level);
        long parententryid = 0L;
        if (lev > 1) {
            String longnumber = resJson.getString("longnumber");
            String[] split = longnumber.split("-");
            parententryid = Long.parseLong(split[lev - 2]);
        } else {
            parententryid = stockEntry.getLong("bomentryid");
        }
        return parententryid;
    }

    private DynamicObject getBOM(DynamicObject org, DynamicObject transactiontype, Date expendbomtime, DynamicObject stockEntry) {
        if (org == null || expendbomtime == null || stockEntry == null) {
            return null;
        }
        DynamicObject bomreversion = stockEntry.getDynamicObject("bomreversion");
        DynamicObject materielmasterid = stockEntry.getDynamicObject("materielmasterid");
        Long entryconfigCode = stockEntry.getDynamicObject("entryconfiguredcode") == null ? 0L : stockEntry.getDynamicObject("entryconfiguredcode").getLong("id");
        DynamicObject bom = null;
        if (bomreversion != null) {
            bomreversion = BomVersionQueryHelper.getDataCacheByID((Object)bomreversion.getPkValue());
            Date effectDate = bomreversion.getDate("effectdate");
            Date invalidDate = bomreversion.getDate("invaliddate");
            if (null != effectDate && null != invalidDate && !expendbomtime.before(effectDate) && !expendbomtime.after(invalidDate)) {
                Long bomTypeid = 0L;
                DynamicObject rootBom = (DynamicObject)this.getModel().getValue("bom");
                if (rootBom != null) {
                    DynamicObject bomType = rootBom.getDynamicObject("type");
                    bomTypeid = bomType == null ? 0L : Long.parseLong(bomType.getPkValue().toString());
                }
                QFilter bomFilter = new QFilter("material", "=", stockEntry.getDynamicObject("materialid").getPkValue());
                bomFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)org.getLong("id")));
                bomFilter.and(new QFilter("version", "=", bomreversion.getPkValue()));
                bomFilter.and(new QFilter("type", "=", (Object)bomTypeid));
                bomFilter.and(new QFilter("enable", "=", (Object)"1"));
                bomFilter.and(new QFilter("status", "=", (Object)"C"));
                Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (QFilter[])bomFilter.toArray());
                if (bomMap != null && bomMap.size() > 0) {
                    List collect = bomMap.values().stream().collect(Collectors.toList());
                    bom = (DynamicObject)collect.get(0);
                }
            }
            if (bom == null) {
                bom = this.getBOMByFilter(org, transactiontype, expendbomtime, materielmasterid, stockEntry.getDynamicObject("childauxpropertyid"), entryconfigCode);
            }
        } else {
            bom = this.getBOMByFilter(org, transactiontype, expendbomtime, materielmasterid, stockEntry.getDynamicObject("childauxpropertyid"), entryconfigCode);
        }
        return bom;
    }

    private DynamicObject getBOMByFilter(DynamicObject org, DynamicObject transactiontype, Date expendbomtime, DynamicObject materielmasterid, DynamicObject auxproprtty, Long entryconfigCode) {
        DynamicObjectCollection bomtypes;
        HashSet<Long> transbomTypeIDSet = new HashSet<Long>(16);
        if (transactiontype != null && CollectionUtils.isNotEmpty((Collection)(bomtypes = transactiontype.getDynamicObjectCollection("bomtypes")))) {
            for (DynamicObject dyn : bomtypes) {
                transbomTypeIDSet.add(dyn.getLong("fbasedataid_id"));
            }
        }
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)materielmasterid, (Long)org.getLong("id"), null, transbomTypeIDSet, (Date)expendbomtime, (String)"id,number,materialid,type,version,replaceno,createorg,auxproperty,ecn,yieldrate", (String)"", (DynamicObject)auxproprtty, (Long)entryconfigCode);
        return bom;
    }

    private DynamicObject getProcessRoute(DynamicObject mftmaterial, DynamicObject org) {
        String selectProperties = "id,routeversion.effectdate";
        Map invokeBizService = MsProcessRouteQueryHelper.queryRouteMapFromCache((DynamicObject)mftmaterial, (DynamicObject)org, (String)selectProperties);
        if (invokeBizService != null) {
            Map processrouteMap = invokeBizService;
            OrderCommonService orderCommonService = new OrderCommonService();
            return orderCommonService.filterByorderBy(processrouteMap);
        }
        return null;
    }

    private void setBaseInfo(IDataModel model, long entryId) {
        try (AlgoContext algoContext = Algo.newContext();){
            QFilter filter = new QFilter("treeentryentity.id", "=", (Object)entryId);
            StringBuilder selectors = new StringBuilder(200);
            selectors.append("id,billno,org,transactiontype,treeentryentity.id,treeentryentity.material,treeentryentity.bdproject,treeentryentity.bomid,treeentryentity.expendbomtime,");
            selectors.append("treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.bizstatus,treeentryentity.pickstatus");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "beforeBindData"), (String)"pom_mftorder", (String)selectors.toString(), (QFilter[])filter.toArray(), null);
            model.beginInit();
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                model.setValue("org", next.get("org"));
                model.setValue("billno", next.get("billno"));
                model.setValue("orderid", next.get("id"));
                model.setValue("transactiontype", next.get("transactiontype"));
                model.setValue("orderentry", next.get("treeentryentity.id"));
                Object bomid = next.get("treeentryentity.bomid");
                model.setValue("bom", bomid);
                model.setValue("product", next.get("treeentryentity.material"));
                model.setValue("project", next.get("treeentryentity.bdproject"));
                model.setValue("expendbomtime", next.get("treeentryentity.expendbomtime"));
                StringBuilder status = new StringBuilder(20);
                String planstatus = ManuBillPlanStatusEnum.getName((String)next.getString("treeentryentity.planstatus"));
                status.append(planstatus);
                String taskstatus = ManuBillTaskStatusEnum.getName((String)next.getString("treeentryentity.taskstatus"));
                status.append("/").append(taskstatus);
                String bizstatus = ManuBillBizStatusEnum.getName((String)next.getString("treeentryentity.bizstatus"));
                status.append("/").append(bizstatus);
                String pickstatus = ManuBillPickStatusEnum.getName((String)next.getString("treeentryentity.pickstatus"));
                status.append("/").append(pickstatus);
                model.setValue("orderstatus", (Object)StringUtils.replaceChars((String)status.toString(), (String)"null", (String)ResManager.loadKDString((String)"\u65e0", (String)"ChildExpandEditPlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0])));
            }
            model.endInit();
        }
    }

    private DynamicObject getInOrgID(Long deptId, Map<String, Object> loopCacheMap) {
        String mapKeys = "ORGIN_" + deptId;
        if (loopCacheMap != null && loopCacheMap.containsKey(mapKeys)) {
            return (DynamicObject)loopCacheMap.get(mapKeys);
        }
        List inwareOrgFilter = OrderGenChildOrderUtils.getInwareOrgFilter((Long)deptId);
        Long inOrgID = 0L;
        if (!inwareOrgFilter.isEmpty()) {
            inOrgID = inwareOrgFilter.contains(deptId) ? deptId : (Long)inwareOrgFilter.get(0);
        }
        DynamicObject inOrgDy = null;
        if (inOrgID != null && !inOrgID.equals(0L)) {
            inOrgDy = OrgQueryHelper.getDataCacheByID((Object)inOrgID);
        }
        if (null != loopCacheMap) {
            loopCacheMap.put(mapKeys, inOrgDy);
        }
        return inOrgDy;
    }
}

