/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.SerialNumberHelper;
import kd.bd.mpdm.common.mftorder.utils.JsonUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.common.mftorder.utils.MftOrderToProorderUtil;
import kd.mmc.pom.common.mftorder.utils.OrderGenChildOrderUtils;
import kd.mmc.pom.common.utils.PomBigDecimaUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;

public class MftOrderEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static String KEY_DELETEENTRY = "deleteentry";
    private static String KEY_CHECKEXISTSCHILD = "checkExistsChild";

    public void afterF7Select(AfterF7SelectEvent arg0) {
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object billstatus;
        super.propertyChanged(e);
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString()) && "A".equals(billstatus = this.getModel().getValue("billstatus"))) {
            this.intiBillPropertyChanged(e);
        }
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "entryquainwaqty": 
            case "entryunquainwaqty": 
            case "entryscrinwaqty": {
                this.calculateStockQty();
                break;
            }
            case "entryqualifiedqty": 
            case "entryacceptqty": 
            case "entryworkwasteqty": 
            case "entrymtlcostqty": 
            case "entryreworkqty": 
            case "entryrepairqty": {
                this.calculateRptQty();
                break;
            }
        }
    }

    private void calculateStockQty() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int entryIndex = entryGrid.getSelectRows()[0];
        if (entryIndex == -1) {
            return;
        }
        BigDecimal entryquainwaqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryquainwaqty"));
        BigDecimal entryunquainwaqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryunquainwaqty"));
        BigDecimal entryscrinwaqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryscrinwaqty"));
        BigDecimal entrystockqty = entryquainwaqty.add(entryunquainwaqty).add(entryscrinwaqty);
        this.getModel().setValue("entrystockqty", (Object)entrystockqty);
        this.getModel().setValue("quainwaqty", (Object)entryquainwaqty, entryIndex);
        this.getModel().setValue("unquainwaqty", (Object)entryunquainwaqty, entryIndex);
        this.getModel().setValue("scrinwaqty", (Object)entryscrinwaqty, entryIndex);
        this.getModel().setValue("stockqty", (Object)entrystockqty, entryIndex);
    }

    private void calculateRptQty() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int entryIndex = entryGrid.getSelectRows()[0];
        if (entryIndex == -1) {
            return;
        }
        BigDecimal entryqualifiedqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryqualifiedqty"));
        BigDecimal entryacceptqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryacceptqty"));
        BigDecimal entryworkwasteqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryworkwasteqty"));
        BigDecimal entrymtlcostqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entrymtlcostqty"));
        BigDecimal entryreworkqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryreworkqty"));
        BigDecimal entryrepairqty = PomBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryrepairqty"));
        BigDecimal entryrptqty = entryqualifiedqty.add(entryacceptqty).add(entryworkwasteqty).add(entrymtlcostqty).add(entryreworkqty).add(entryrepairqty);
        this.getModel().setValue("entryrptqty", (Object)entryrptqty);
        this.getModel().setValue("entryreportqty", (Object)entryrptqty);
        BigDecimal entryscrapqty = entrymtlcostqty.add(entryworkwasteqty);
        this.getModel().setValue("entryscrapqty", (Object)entryscrapqty);
        this.getModel().setValue("qualifiedqty", (Object)entryqualifiedqty, entryIndex);
        this.getModel().setValue("acceptqty", (Object)entryacceptqty, entryIndex);
        this.getModel().setValue("workwasteqty", (Object)entryworkwasteqty, entryIndex);
        this.getModel().setValue("mtlcostqty", (Object)entrymtlcostqty, entryIndex);
        this.getModel().setValue("reworkqty", (Object)entryreworkqty, entryIndex);
        this.getModel().setValue("repairqty", (Object)entryrepairqty, entryIndex);
        this.getModel().setValue("rptqty", (Object)entryrptqty, entryIndex);
        this.getModel().setValue("reportqty", (Object)entryrptqty, entryIndex);
        this.getModel().setValue("scrapqty", (Object)entryscrapqty, entryIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getItemKey();
        if ("pushpick".equals(operationKey) || "pushreturn".equals(operationKey) || "pushapply".equals(operationKey)) {
            this.pushPick(operationKey);
        }
        switch (operationKey) {
            case "checksnnumber": 
            case "entersnnumber": 
            case "importsnnumber": {
                SerialNumberHelper.handleSNNumber((AbstractFormPlugin)this, (ItemClickEvent)evt);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    private void pushPick(String type) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5206\u5f55", (String)"MftOrderEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        IBillView billView = (IBillView)view;
        ConvertOpParameter opParameter = MftOrderToProorderUtil.buildParameter(null, (IBillView)billView, (String)type);
        if (opParameter.getSelectedRows().size() == 0) {
            String billno = this.getModel().getValue("billno").toString();
            String format = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08\u7f16\u53f7\uff1a%s\uff09\u5173\u8054\u7684\u7ec4\u4ef6\u6e05\u5355\u4e0d\u5b58\u5728\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"MftOrderEdit_8", (String)"mmc-pom-formplugin", (Object[])new Object[0]), billno);
            this.getView().showMessage(format);
            return;
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"MftOrderEdit_9", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("mft_botp_convertop");
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        IBillModel model = (IBillModel)this.getModel();
        FormOperate operate = (FormOperate)e.getSource();
        if ("genchildorder".equals(key)) {
            this.genChildOrder(operate, e);
        }
        if (KEY_DELETEENTRY.equals(key)) {
            String seqIn;
            List existsSeq;
            ArrayList<Object> entryIds = new ArrayList<Object>(10);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                int index = entryGrid.getSelectRows()[i];
                DynamicObject orderEntryDym = this.getModel().getEntryRowEntity("treeentryentity", index);
                if (null == orderEntryDym) continue;
                entryIds.add(orderEntryDym.getPkValue());
            }
            RefObject afterConfirm = new RefObject();
            if (entryIds.size() > 0 && !operate.getOption().tryGetVariableValue(KEY_CHECKEXISTSCHILD, afterConfirm) && (existsSeq = OrderGenChildOrderUtils.queryExistsChildOrder((String)model.getDataEntityType().getName(), (Object)model.getPKValue(), (Object)model.getValue("billno"), entryIds)).size() > 0 && StringUtils.isNotBlank((CharSequence)(seqIn = StringUtils.join((Object[])existsSeq.toArray(), (String)",")))) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(KEY_CHECKEXISTSCHILD, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u7b2c%0$s\u884c\u5206\u5f55\u5b58\u5728\u5173\u8054\u7684\u4e0b\u7ea7\u5de5\u5355\uff0c\u5220\u9664\u64cd\u4f5c\u4f1a\u540c\u6b65\u5220\u9664\u4e0b\u7ea7\u6240\u6709\u5de5\u5355\u3002", (String)"MftOrderEdit_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]), seqIn), MessageBoxOptions.OKCancel, listener);
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        MessageBoxResult result;
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (KEY_CHECKEXISTSCHILD.equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = e.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_CHECKEXISTSCHILD, "true");
            this.getView().invokeOperation(KEY_DELETEENTRY, operateOption);
        }
        if ("startCPSConfirm".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            String jsonstring = this.getView().getPageCache().get("idEntryidValues");
            JSONArray josnArray = JSONArray.parseArray((String)jsonstring);
            ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
            for (int i = 0; i < josnArray.size(); ++i) {
                JSONObject josnStr = (JSONObject)josnArray.get(i);
                Long[] orderLong = new Long[]{josnStr.getLong("orderid"), josnStr.getLong("orderentryid")};
                idEntryidValues.add(orderLong);
            }
            String planproid = this.getView().getPageCache().get("planproid");
            Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{Long.parseLong(planproid), "pom_mftorder", idEntryidValues});
            if (resId != null) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("mrp_cps_calc_log");
                showParameter.setPkId((Object)resId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void genChildOrder(FormOperate operate, BeforeDoOperationEventArgs e) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String checkDataChange = this.getPageCache().get("checkDataChange");
        String billStatus = (String)model.getValue("billstatus");
        boolean isCheckDataChange = false;
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) && StringUtils.equals((CharSequence)"true", (CharSequence)checkDataChange)) {
            isCheckDataChange = true;
        }
        boolean dataChanged = model.getDataChanged();
        if (isCheckDataChange && dataChanged) {
            String changeDesc = model.getChangeDesc();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MftOrderEdit_41", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MftOrderEdit_40", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ArrayList<Long> billSelectRowList = new ArrayList<Long>(10);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", orderEntry.getSelectRows()[i]);
            billSelectRowList.add(entry.getLong("id"));
        }
        if (billSelectRowList.size() <= 0) {
            e.setCancel(true);
            return;
        }
        String jsonString = SerializationUtils.toJsonString(billSelectRowList);
        operate.getOption().setVariableValue("billSelectRowList", jsonString);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult operationResult;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("viewmftprooder".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            ArrayList<Object> idList = new ArrayList<Object>();
            if (entryGrid.getSelectRows().length == 0) {
                DynamicObject manuBill = this.getModel().getDataEntity();
                DynamicObjectCollection entryCol = manuBill.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject[] entry = (DynamicObject[])entryCol.get(i);
                    idList.add(entry.getPkValue());
                }
            } else {
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
                    idList.add(entry.getPkValue());
                }
            }
            ArrayList<Object> stockids = new ArrayList<Object>();
            QFilter qFilterStock = new QFilter("orderentryid", "in", idList);
            DynamicObject[] stock = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)"id", (QFilter[])qFilterStock.toArray());
            if (stock != null && stock.length > 0) {
                for (DynamicObject dynamicObject : stock) {
                    stockids.add(dynamicObject.getPkValue());
                }
                if (stockids.size() > 0) {
                    QFilter qmftProorder = new QFilter("billentry.mainbillid", "in", stockids);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_mftproorder", (String)"id,billtype.billformid", (QFilter[])qmftProorder.toArray());
                    HashSet<Long> prolinkids = new HashSet<Long>();
                    HashSet<Long> returnlinkids = new HashSet<Long>();
                    for (DynamicObject dym : query) {
                        String billformid = dym.getString("billtype.billformid");
                        if ("im_mdc_mftproorder".equals(billformid)) {
                            prolinkids.add(dym.getLong("id"));
                            continue;
                        }
                        if (!"im_mdc_mftreturnorder".equals(billformid)) continue;
                        returnlinkids.add(dym.getLong("id"));
                    }
                    HashMap<String, HashSet<Long>> findTargetBills = new HashMap<String, HashSet<Long>>();
                    if (prolinkids.isEmpty() && returnlinkids.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u9886\u6599\u5355\u3002", (String)"MftOrderEdit_37", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    findTargetBills.put("im_mdc_mftproorder", prolinkids);
                    findTargetBills.put("im_mdc_mftreturnorder", returnlinkids);
                    HashMap<String, String> para = new HashMap<String, String>();
                    para.put("formId", "pom_proorder");
                    FormShowParameter fsParameter = FormShowParameter.createFormShowParameter(para);
                    fsParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    fsParameter.setCustomParam("paramList", findTargetBills);
                    this.getView().showForm(fsParameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftOrderEdit_38", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("viewsplitorder".equals(key)) {
            ArrayList<Object> entryIdList = new ArrayList<Object>(10);
            ArrayList<Long> entryOrgValues = new ArrayList<Long>(10);
            DynamicObject mftOrderBill = this.getModel().getDataEntity();
            entryOrgValues.add(mftOrderBill.getDynamicObject("org").getLong("id"));
            TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            int[] selectRows = orderEntry.getSelectRows();
            DynamicObjectCollection mftOrderEntrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
            for (int row : selectRows) {
                entryIdList.add(((DynamicObject)mftOrderEntrys.get(row)).getPkValue());
            }
            OrderSpliteService.viewSplitOrder(entryIdList, entryOrgValues, (IFormView)this.getView());
        }
        if ("cps_count".equals(key)) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mrp_cps_planpro", (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if ((operationResult = e.getOperationResult()) != null && operationResult.isSuccess() && "genchildorder".equals(key)) {
            FormOperate operate = (FormOperate)e.getSource();
            String passids = operate.getOption().getVariableValue("passId");
            HashSet entryIds = new HashSet(JsonUtils.jsonToList((String)passids));
            FormShowParameter showParameter = OrderGenChildOrderUtils.createShowParameter(null, (IFormPlugin)this, (String)key, (String)"pom_childexpend");
            Map customParams = showParameter.getCustomParams();
            if (entryIds.size() > 0) {
                for (Long entryId : entryIds) {
                    customParams.put("entryid", entryId);
                }
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null && "cps_count".equals(actionKey)) {
            Set<Long> set;
            Long orderId;
            Object entryPk;
            DynamicObject orderEntry;
            int i;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject orderObj = this.getModel().getDataEntity();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            HashMap<Long, Set<Long>> selectOrderIdMap = new HashMap<Long, Set<Long>>(16);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            HashMap<Long, String> billNoMap = new HashMap<Long, String>(16);
            if (entryGrid.getSelectRows().length == 0) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    orderEntry = (DynamicObject)entryEntity.get(i);
                    entryPk = orderEntry.getPkValue();
                    orderId = (Long)orderObj.getPkValue();
                    set = (HashSet<Long>)selectOrderIdMap.get(orderId);
                    if (set == null) {
                        set = new HashSet<Long>(16);
                    }
                    set.add((Long)entryPk);
                    selectOrderIdMap.put(orderId, set);
                    billNoMap.put(orderId, orderObj.getString("billno"));
                }
            } else {
                for (i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    orderEntry = this.getModel().getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
                    entryPk = orderEntry.getPkValue();
                    orderId = (Long)orderObj.getPkValue();
                    set = (Set)selectOrderIdMap.get(orderId);
                    if (set == null) {
                        set = new HashSet(16);
                    }
                    set.add((Long)entryPk);
                    selectOrderIdMap.put(orderId, set);
                    billNoMap.put(orderId, orderObj.getString("billno"));
                }
            }
            Long dataSourceId = 0L;
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mrp_cps_planpro", (String)"number,scentryentity.entryisscmrpoperat,scentryentity.resourceregisters,scentryentity.entrysupplyres,scentryentity.entrysupplyres.number", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            for (DynamicObject queryEntry : query) {
                if (!"pom_mftorder".equals(queryEntry.getString("scentryentity.entrysupplyres.number"))) continue;
                dataSourceId = queryEntry.getLong("scentryentity.resourceregisters");
            }
            if ("0".equals(dataSourceId.toString())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u9f50\u5957\u5206\u6790\u65b9\u6848\uff08%1$s\uff09\u4e2d\uff0c\u4f9b\u5e94\u53c2\u6570\u6570\u636e\u6e90\u914d\u7f6e\u672a\u5305\u542b\u751f\u4ea7\u5de5\u5355\u3002", (String)"MftOrderEdit_42", (String)"mmc-pom-formplugin", (Object[])new Object[0]), ((DynamicObject)query.get(0)).getString("number")));
                return;
            }
            DataSet dataSetByModel = DataSourceFetchDataUtil.getDataSetByModel((Long)dataSourceId, null);
            Iterator iterator = dataSetByModel.iterator();
            HashSet<Long> billEntryIdSet = new HashSet<Long>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                billEntryIdSet.add(row.getLong("entryentity.billentryid"));
            }
            HashSet<String> unpassOrderNo = new HashSet<String>(16);
            List<Long[]> idEntryidValues = this.getOrderIdEntryIdList(billEntryIdSet, selectOrderIdMap, billNoMap, unpassOrderNo);
            if (unpassOrderNo.isEmpty()) {
                Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{pk, "pom_mftorder", idEntryidValues});
                if (resId != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("mrp_cps_calc_log");
                    showParameter.setPkId((Object)resId);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else if (billNoMap.size() > unpassOrderNo.size()) {
                JSONArray josnArray = new JSONArray();
                for (Long[] orderInfo : idEntryidValues) {
                    JSONObject josnStr = new JSONObject();
                    josnStr.put("orderid", (Object)orderInfo[0]);
                    josnStr.put("orderentryid", (Object)orderInfo[1]);
                    josnArray.add((Object)josnStr);
                }
                this.getView().getPageCache().put("idEntryidValues", josnArray.toString());
                this.getView().getPageCache().put("planproid", pk.toString());
                ConfirmCallBackListener callback = new ConfirmCallBackListener("startCPSConfirm", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d%1$s\u6761\u5355\u636e\uff0c\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u6761\u4ef6\u7684\u6709%2$s\u6761\uff08\u5355\u636e\u7f16\u53f7\uff1a%3$s\uff09\uff0c\u662f\u5426\u7ee7\u7eed\u8ba1\u7b97\uff1f", (String)"MftOrderEdit_43", (String)"mmc-pom-formplugin", (Object[])new Object[0]), billNoMap.size(), unpassOrderNo.size(), ((Object)unpassOrderNo).toString()), MessageBoxOptions.YesNo, callback);
            } else if (billNoMap.size() == unpassOrderNo.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u5de5\u5355\u6570\u636e\uff0c\u5747\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u6570\u636e\u6e90\u6761\u4ef6\u3002", (String)"MftOrderEdit_44", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<Long[]> getOrderIdEntryIdList(Set<Long> billEntryIdSet, Map<Long, Set<Long>> selectOrderIdMap, Map<Long, String> billNoMap, Set<String> unpassOrderNo) {
        HashSet<Long> unpassOrderId = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            Set<Long> orderEntryIdSet = m.getValue();
            for (Long orderEntryId : orderEntryIdSet) {
                if (billEntryIdSet.contains(orderEntryId)) continue;
                unpassOrderId.add(orderId);
                unpassOrderNo.add(billNoMap.get(orderId));
            }
        }
        ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            if (unpassOrderId.contains(orderId)) continue;
            for (Long orderEntryId : m.getValue()) {
                Long[] orderLong = new Long[]{orderId, orderEntryId};
                idEntryidValues.add(orderLong);
            }
        }
        return idEntryidValues;
    }
}

