/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mftorder;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bd.mpdm.common.mftorder.dto.PickPairDto;
import kd.bd.mpdm.common.mftorder.utils.CalPickMaterialUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MftOrderPickPairPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORDER_FIELD = "billno,transactiontype,material,treeentryentity.id,treeentryentity.seq,treeentryentity.producedept,treeentryentity.unit,treeentryentity.qty,treeentryentity.baseunit,treeentryentity.baseqty,treeentryentity.bomid,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.bizstatus,treeentryentity.pickingpairs";
    public static final String ORG_OLD_VALUE = "org_old_v";
    public static final String ORG_RESET = "org_reset";
    public static final int LIMIT = 500;

    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit producedept = (BasedataEdit)this.getView().getControl("s_producedept");
        if (producedept != null) {
            producedept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("org")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"draw", (CharSequence)operateKey)) {
            this.showQueryForm();
        } else if (StringUtils.equals((CharSequence)"push", (CharSequence)operateKey)) {
            String error = this.checkDate();
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                this.getView().showTipNotification(error);
                args.setCancel(true);
                return;
            }
            DynamicObject[] stocks = this.loadStock();
            this.push(this.getView(), "pom_mftstock", "im_mdc_mftproorder", "932403241491308544", stocks, "stockentry");
        }
    }

    private PickPairDto loadPushCustomPar() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = entity.getDynamicObjectCollection("treeentryentity");
        PickPairDto pickPairDto = new PickPairDto();
        pickPairDto.setManuMode(entity.getBoolean("manualmode"));
        for (DynamicObject entry : entrys) {
            BigDecimal qty = pickPairDto.isManuMode() ? entry.getBigDecimal("manupickqty") : entry.getBigDecimal("autopickqty");
            pickPairDto.putEntryQty(Long.valueOf(entry.getLong("orderentryid")), qty);
        }
        return pickPairDto;
    }

    private DynamicObject[] loadStock() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        List selectedIndex = IntStream.of(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = entity.getDynamicObjectCollection("treeentryentity");
        List orderIdList = entrys.stream().filter(k -> selectedIndex.contains(k.getInt("seq") - 1)).map(k -> k.getString("orderid")).collect(Collectors.toList());
        List orderEntryIdList = entrys.stream().filter(k -> selectedIndex.contains(k.getInt("seq") - 1)).map(k -> k.getLong("orderentryid")).collect(Collectors.toList());
        QFilter filter = new QFilter("orderid", "in", orderIdList);
        filter.and(new QFilter("orderentryid", "in", orderEntryIdList));
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)"id,billno,orderentryid,stockentry.id", (QFilter[])new QFilter[]{filter});
        return stocks;
    }

    private String checkDate() {
        String error = null;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            error = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u3002", (String)"MftOrderPickPairPlugin7", (String)"mmc-pom-formplugin", (Object[])new Object[0]);
        } else {
            DynamicObject entity = this.getModel().getDataEntity(true);
            boolean manual = entity.getBoolean("manualmode");
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("treeentryentity");
            StringJoiner joiner = new StringJoiner("\uff1b");
            for (int index : entryGrid.getSelectRows()) {
                BigDecimal qty;
                BigDecimal bigDecimal = qty = manual ? ((DynamicObject)entrys.get(index)).getBigDecimal("manupickqty") : ((DynamicObject)entrys.get(index)).getBigDecimal("autopickqty");
                if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) continue;
                joiner.add(((DynamicObject)entrys.get(index)).getString("seq"));
            }
            if (joiner.length() > 0) {
                error = manual ? String.format(ResManager.loadKDString((String)"\u9886\u6599\u5957\u6570\u4e0d\u80fd\u4e3a0\uff08\u884c\u53f7\uff1a%1$s\uff09\u3002", (String)"MftOrderPickPairPlugin1", (String)"mmc-pom-formplugin", (Object[])new Object[0]), joiner) : String.format(ResManager.loadKDString((String)"\u8865\u9f50\u5957\u6570\u4e0d\u80fd\u4e3a0\uff08\u884c\u53f7\uff1a%1$s\uff09\u3002", (String)"MftOrderPickPairPlugin2", (String)"mmc-pom-formplugin", (Object[])new Object[0]), joiner);
            }
        }
        return error;
    }

    private void push(IFormView view, String sourceEntity, String targetEntity, String ruleId, DynamicObject[] sourceObjs, String sourceEntryKey) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        pushArgs.addCustomParam("botp_push_pickpair_dto", SerializationUtils.toJsonString((Object)this.loadPushCustomPar()));
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (int i = 0; i < sourceObjs.length; ++i) {
            DynamicObjectCollection entrys = sourceObjs[i].getDynamicObjectCollection(sourceEntryKey);
            if (entrys.size() == 0) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(sourceObjs[i].getPkValue());
                row.setEntryPrimaryKeyValue((Object)0);
                row.setBillNo(sourceObjs[i].getString("billno"));
                row.setEntryEntityKey(sourceEntryKey);
                needPushRows.add(row);
            }
            for (DynamicObject entry : entrys) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(sourceObjs[i].getPkValue());
                row.setBillNo(sourceObjs[i].getString("billno"));
                row.setEntryPrimaryKeyValue(entry.getPkValue());
                row.setEntryEntityKey(sourceEntryKey);
                needPushRows.add(row);
            }
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (convertResult.isSuccess() && convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() != 0) {
            if (convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size() == 1) {
                Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
            } else {
                Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
        }
    }

    private void changeColor(List<SourceBillReport> failReport, DynamicObject[] stocks) {
        ArrayList index = new ArrayList();
        Map<Long, Long> stockIdOrderEntryId = Stream.of(stocks).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObject("orderentryid").getLong("id")));
        List failStockIds = failReport.stream().map(k -> (Long)k.getBillId()).collect(Collectors.toList());
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        Map<Long, Integer> orderEntryIdSeq = entrys.stream().collect(Collectors.toMap(k -> k.getLong("orderentryid"), v -> v.getInt("seq") - 1));
        stockIdOrderEntryId.forEach((k, v) -> {
            if (failStockIds.contains(k)) {
                index.add(orderEntryIdSeq.get(v));
            }
        });
        ArrayList cellStyles = new ArrayList(index.size());
        index.forEach(k -> {
            CellStyle ce = new CellStyle();
            ce.setFieldKey("billno");
            ce.setRow(k.intValue());
            ce.setForeColor("red");
            cellStyles.add(ce);
        });
        EntryGrid grid = (EntryGrid)this.getView().getControl("treeentryentity");
        grid.setCellStyle(cellStyles);
        grid.setRowBackcolor("red", index.stream().mapToInt(k -> k).toArray());
    }

    private void showQueryForm() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true);
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObject org = entity.getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftOrderPickPairPlugin3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject depOrg = entity.getDynamicObject("s_producedept");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(4);
        qfilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qfilters.add(new QFilter("org", "=", org.getPkValue()));
        if (depOrg != null) {
            qfilters.add(new QFilter("treeentryentity.producedept", "=", depOrg.getPkValue()));
        }
        qfilters.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        qfilters.add(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
        qfilters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        List orderEntryIds = entity.getDynamicObjectCollection("treeentryentity").stream().map(k -> k.getLong("orderentryid")).collect(Collectors.toList());
        qfilters.add(new QFilter("treeentryentity.id", "not in", orderEntryIds));
        showParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draw");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"draw", (CharSequence)actionKey) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            int currentSit = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").size();
            if (currentSit + rows.size() > 500) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u5355\u6570\u91cf\u8d85\u8fc7%s\u6761\u9650\u5236,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MftOrderPickPairPlugin4", (String)"mmc-pom-formplugin", (Object[])new Object[0]), 500));
                return;
            }
            List<Long> entryIds = rows.stream().map(k -> (Long)k.getEntryPrimaryKeyValue()).filter(Objects::nonNull).collect(Collectors.toList());
            this.showEntry(entryIds);
            this.afterDrawRule();
        }
    }

    private void afterDrawRule() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"s_producedept", "manualmode", "automode"});
    }

    private void initDrawRule() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"s_producedept", "manualmode", "automode"});
    }

    private void showEntry(List<Long> selectEntryIds) {
        boolean autoMode = (Boolean)this.getModel().getValue("automode");
        DynamicObject[] orderEntity = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)ORDER_FIELD, (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", selectEntryIds)});
        if (orderEntity != null) {
            for (DynamicObject order : orderEntity) {
                DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                entrys.removeIf(e -> !selectEntryIds.contains(e.getLong("id")));
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            Map entrysMaxPickQty = new HashMap(orderEntity.length);
            if (autoMode) {
                entrysMaxPickQty = CalPickMaterialUtils.calPickPairs(Arrays.asList(orderEntity), (boolean)true);
            }
            for (int i = 0; i < orderEntity.length; ++i) {
                DynamicObject order;
                order = orderEntity[i];
                DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : orderEntrys) {
                    int rowIndex = this.getModel().createNewEntryRow("treeentryentity");
                    this.getModel().setValue("orderid", order.getPkValue(), rowIndex);
                    this.getModel().setValue("billno", order.get("billno"), rowIndex);
                    this.getModel().setValue("transactiontype", order.get("transactiontype"), rowIndex);
                    this.getModel().setValue("orderentryid", entry.getPkValue(), rowIndex);
                    this.getModel().setValue("targetseq", entry.get("seq"), rowIndex);
                    this.getModel().setValue("material", entry.get("material"), rowIndex);
                    this.getModel().setValue("producedept", entry.get("producedept"), rowIndex);
                    this.getModel().setValue("unit", entry.get("unit"), rowIndex);
                    this.getModel().setValue("qty", entry.get("qty"), rowIndex);
                    this.getModel().setValue("baseunit", entry.get("baseunit"), rowIndex);
                    this.getModel().setValue("baseqty", entry.get("baseqty"), rowIndex);
                    this.getModel().setValue("bomid", entry.get("bomid"), rowIndex);
                    this.getModel().setValue("planstatus", entry.get("planstatus"), rowIndex);
                    this.getModel().setValue("taskstatus", entry.get("taskstatus"), rowIndex);
                    this.getModel().setValue("bizstatus", entry.get("bizstatus"), rowIndex);
                    this.getModel().setValue("pickingpairs", entry.get("pickingpairs"), rowIndex);
                    String key = order.getString("billno") + "@" + entry.getPkValue();
                    if (!autoMode || !entrysMaxPickQty.containsKey(key)) continue;
                    BigDecimal maxPickQty = ((BigDecimal)entrysMaxPickQty.get(key)).compareTo(entry.getBigDecimal("qty")) < 0 ? (BigDecimal)entrysMaxPickQty.get(key) : entry.getBigDecimal("qty");
                    this.getModel().setValue("autopickqty", (Object)maxPickQty, rowIndex);
                }
            }
            model.endInit();
        }
        this.getView().updateView("treeentryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("s_producedept".equals(source)) {
            Set<Long> idSet = this.queryProducedeptList();
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (!idSet.isEmpty()) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        }
        if ("org".equals(source)) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    private Set<Long> queryProducedeptList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(16);
        qfs.add(new QFilter("status", "=", (Object)"C"));
        qfs.add(new QFilter("enable", "=", (Object)"1"));
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
        if (qFilter != null) {
            qfs.add(qFilter);
        }
        HashSet idSet = new HashSet(16);
        try (DataSet col = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryProducedeptBoolean"), (String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])qfs.toArray(new QFilter[0]), null);){
            if (!col.isEmpty()) {
                for (Row obj : col) {
                    idSet.add(obj.getLong("workshoporg"));
                }
            } else {
                idSet = Sets.newHashSet((Iterable)OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId));
            }
        }
        return idSet;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long id = new MainOrgProp().calcDefaultValue(this.getModel());
        if (id != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_org");
            this.getModel().getDataEntity().set("org", (Object)org);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        String reset = this.getPageCache().get(ORG_RESET);
        if ("org".equals(proName) && !StringUtils.equals((CharSequence)"true", (CharSequence)reset) && oldValue != null) {
            if (newValue != null) {
                this.getPageCache().put(ORG_OLD_VALUE, String.valueOf(((DynamicObject)oldValue).getPkValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MftOrderPickPairPlugin5", (String)"mmc-pom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("org", (IFormPlugin)this));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"MftOrderPickPairPlugin6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(ORG_RESET, "true");
                this.getModel().setValue("org", oldValue);
                this.getPageCache().remove(ORG_RESET);
            }
            return;
        }
        if ("manualmode".equals(proName)) {
            this.getModel().setValue("automode", (Object)((Boolean)newValue == false ? 1 : 0));
        } else if ("automode".equals(proName)) {
            this.getModel().setValue("manualmode", (Object)((Boolean)newValue == false ? 1 : 0));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getCallBackId(), (CharSequence)"org")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("s_producedept", null);
                this.getModel().deleteEntryData("treeentryentity");
                this.initDrawRule();
            } else {
                String oldOrgValue = this.getPageCache().get(ORG_OLD_VALUE);
                if (StringUtils.isNotEmpty((CharSequence)oldOrgValue)) {
                    this.getPageCache().put(ORG_RESET, "true");
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(oldOrgValue), (String)"bos_org");
                    this.getModel().setValue("org", (Object)org);
                    this.getPageCache().remove(ORG_RESET);
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        if (entity.getDynamicObjectCollection("treeentryentity").size() == 0) {
            this.initDrawRule();
        }
    }
}

