/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mrocard;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MROSWSReferCreatePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MROSWSReferCreatePlugin.class);
    private static final String ORG = "org";
    private static final String SIMILARPROJECT = "similarproject";
    private static final String MROORDER = "mroorder";
    private static final String MROORDERID = "mroorderid";
    private static final String WORKCARD = "workcard";
    private static final String PROJECT = "project";
    private static final String POM_MROORDER = "pom_mroorder";
    private static final String POM_MROSWS = "pom_mrosws";
    private static final String REFERCREATE = "refercreate";
    private static final String SEARCH = "search";

    public void registerListener(EventObject e) {
        BasedataEdit similarproject;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((similarproject = (BasedataEdit)this.getView().getControl(SIMILARPROJECT)) != null) {
            similarproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        TextEdit t = (TextEdit)this.getControl(MROORDER);
        t.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().getFormShowParameter().setCustomParam("ismergerows", (Object)false);
        super.afterCreateNewData(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (MROORDER.equals(fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MROSWSReferCreatePlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)POM_MROORDER, (boolean)false);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(new QFilter("treeentryentity.project.prjstate", "!=", (Object)696208292405629952L));
            filters.add(new QFilter(ORG, "=", org.getPkValue()));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        if (list.size() > 0) {
            this.getModel().setValue(actionId, (Object)list.get(0).getBillNo());
            Long primaryKeyValue = (Long)list.get(0).getPrimaryKeyValue();
            DynamicObject mroOrder = QueryServiceHelper.queryOne((String)POM_MROORDER, (String)"id,treeentryentity.workcard.id,treeentryentity.project.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
            if (mroOrder != null) {
                this.getModel().setValue(MROORDERID, (Object)mroOrder.getLong("id"));
                Long workcardId = mroOrder.getLong("treeentryentity.workcard.id");
                if (workcardId.equals(0L)) {
                    this.getModel().setValue(WORKCARD, null);
                } else {
                    this.getModel().setValue(WORKCARD, (Object)workcardId);
                }
                Long projectId = mroOrder.getLong("treeentryentity.project.id");
                if (projectId.equals(0L)) {
                    this.getModel().setValue(PROJECT, null);
                } else {
                    this.getModel().setValue(PROJECT, (Object)projectId);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (ORG.equals(filedKey)) {
            Long userId = RequestContext.get().getCurrUserId();
            String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
            List allPermissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)appId, (String)POM_MROSWS, (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)allPermissionOrgs);
            qFilters.add(qFilter);
        }
        if (SIMILARPROJECT.equals(filedKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MROSWSReferCreatePlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter(ORG, "=", (Object)org.getLong("id"));
            qFilters.add(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadBillListTap(null);
    }

    private void loadBillListTap(List<Long> swsList) {
        BillList billList = (BillList)this.getControl("billlistap");
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)"billlistap");
        FilterParameter filterParameter = new FilterParameter();
        QFilter qFilter = new QFilter("id", "in", swsList);
        filterParameter.setFilter(qFilter);
        billList.setFilterParameter(filterParameter);
        billList.getSelectedRows().clear();
        billList.refreshData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)REFERCREATE, (CharSequence)opKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] entryPrimaryKeyValues = billList.getSelectedRows().getEntryPrimaryKeyValues();
            if (entryPrimaryKeyValues == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"MROSWSReferCreatePlugin_13", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            }
            if (entryPrimaryKeyValues.length == 0) {
                if (StringUtils.equalsIgnoreCase((CharSequence)REFERCREATE, (CharSequence)opKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53c2\u7167\u7684\u8865\u5145\u5de5\u4f5c\u5355\u6570\u636e\u3002", (String)"MROSWSReferCreatePlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
                return;
            }
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u53c2\u7167\u751f\u6210\u3002", (String)"MROSWSReferCreatePlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (!this.checkPermission()) {
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                String orgname = "";
                if (null != org) {
                    orgname = org.getString("name");
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0%s\u7ec4\u7ec7\u8865\u5145\u5de5\u4f5c\u5355\u65b0\u589e\u6743\u9650\u3002", (String)"MROSWSReferCreatePlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]), orgname));
                e.setCancel(true);
                return;
            }
            StringBuilder errors = new StringBuilder();
            HashSet<Long> tarMroOrderIds = new HashSet<Long>(16);
            HashSet<Long> swsworkcardIds = new HashSet<Long>(16);
            HashMap<String, Object> swsinfo = new HashMap<String, Object>(16);
            DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
            if (null != project) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMroorderWorkcard", (String)POM_MROSWS, (String)"id,billno,sorderno,workcard.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)}, (String)"");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        if (null != row.getLong("workcard.id") && !row.getLong("workcard.id").equals(0L)) {
                            swsworkcardIds.add(row.getLong("workcard.id"));
                        } else {
                            errors.append(String.format(ResManager.loadKDString((String)"\u8865\u5145\u5de5\u4f5c\u5355%s\u6765\u6e90\u68c0\u4fee\u5de5\u5355\u6ca1\u6709\u5de5\u5361\uff0c\u4e0d\u5141\u8bb8\u53c2\u7167\u751f\u6210\u3002", (String)"MROSWSReferCreatePlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]), row.getString("billno")));
                        }
                        swsinfo.put("billno", row.get("billno"));
                        swsinfo.put("sorderno", row.get("sorderno"));
                    }
                }
                if (swsworkcardIds.size() > 0) {
                    QFilter qFilter = new QFilter("treeentryentity.project", "=", (Object)project.getLong("id"));
                    qFilter.and(new QFilter("treeentryentity.workcard", "in", swsworkcardIds));
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryTargetMroorder", (String)POM_MROORDER, (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"");){
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            tarMroOrderIds.add(row.getLong("id"));
                        }
                    }
                    if (tarMroOrderIds.size() > 0) {
                        this.getPageCache().put("tarMroOrderIds", SerializationUtils.toJsonString(tarMroOrderIds));
                    } else {
                        errors.append(String.format(ResManager.loadKDString((String)"\u8865\u5145\u5de5\u5355%1$s\uff1a\u5728\u9879\u76ee\u53f7%2$s\u5185\u5339\u914d\u4e0d\u5230\u4e0e\u6765\u6e90\u68c0\u4fee\u5de5\u5355%3$s\u5de5\u5361\u4e00\u81f4\u7684\u68c0\u4fee\u5de5\u5355\u3002", (String)"MROSWSReferCreatePlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]), swsinfo.get("billno"), project.get("number"), swsinfo.get("sorderno")));
                    }
                }
            } else {
                e.setCancel(true);
            }
            if (errors.length() > 0) {
                this.getView().showTipNotification(errors.toString());
                e.setCancel(true);
            }
        }
    }

    private boolean checkPermission() {
        String appId;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null == org) {
            return Boolean.FALSE;
        }
        Long orgId = org.getLong("id");
        Long userId = RequestContext.get().getCurrUserId();
        int hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"04", (String)(appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter())), (String)POM_MROSWS, (String)"47156aff000000ac");
        if (hasPermissin == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)SEARCH, (CharSequence)opKey) && e.getOperationResult().isSuccess()) {
            List<Long> swsList = this.queryData();
            this.loadBillListTap(swsList);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)REFERCREATE, (CharSequence)opKey) && e.getOperationResult().isSuccess()) {
            this.refercreateMroSws();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if (ORG.equals(propertyName)) {
            Object newValue = cd.getNewValue();
            Object oldValue = cd.getOldValue();
            if (null != oldValue && !oldValue.equals(newValue)) {
                DynamicObject old = (DynamicObject)oldValue;
                this.getPageCache().put("orgPageCacheOld", old.getPkValue().toString());
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgconfirm");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u5c06\u4f1a\u6e05\u7a7a\u9875\u9762\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"MROSWSReferCreatePlugin_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("orgconfirm".equals(messageBoxClosedEvent.getCallBackId())) {
            String orgPageCacheOld;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().beginInit();
                this.getModel().setValue(SIMILARPROJECT, null);
                this.getModel().setValue(MROORDER, null);
                this.getModel().setValue(MROORDERID, null);
                this.getModel().setValue(WORKCARD, null);
                this.getModel().setValue(PROJECT, null);
                this.loadBillListTap(null);
                this.getView().updateView();
                this.getModel().endInit();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No && null != (orgPageCacheOld = this.getPageCache().get("orgPageCacheOld"))) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, (Object)orgPageCacheOld);
                this.getView().updateView();
                this.getModel().endInit();
            }
        }
    }

    private List<Long> queryData() {
        ArrayList<Long> swsList;
        block32: {
            swsList = new ArrayList<Long>();
            DynamicObject similarproject = (DynamicObject)this.getModel().getValue(SIMILARPROJECT);
            Long mroorderid = (Long)this.getModel().getValue(MROORDERID);
            if (null != similarproject) {
                try {
                    Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmpd", (String)"ISimilarProjectService", (String)"getSimilarProject", (Object[])new Object[]{mroorderid, similarproject.getLong("id")});
                    if (null == resultMap || !resultMap.containsKey("status")) break block32;
                    if ("success".equals(resultMap.get("status").toString())) {
                        Row row;
                        List projectList = (List)SerializationUtils.fromJsonString((String)resultMap.get("result").toString(), List.class);
                        ArrayList<Long> orderList = new ArrayList<Long>();
                        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMroorderByProject", (String)POM_MROORDER, (String)"id", (QFilter[])new QFilter[]{new QFilter("treeentryentity.project", "in", (Object)projectList)}, (String)"");){
                            while (dataSet.hasNext()) {
                                row = dataSet.next();
                                orderList.add(row.getLong("id"));
                            }
                        }
                        if (orderList.size() > 0) {
                            dataSet = QueryServiceHelper.queryDataSet((String)"queryMroSWSByOrder", (String)POM_MROSWS, (String)"id", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", orderList)}, (String)"");
                            var8_9 = null;
                            try {
                                while (dataSet.hasNext()) {
                                    row = dataSet.next();
                                    swsList.add(row.getLong("id"));
                                }
                            }
                            catch (Throwable throwable) {
                                var8_9 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (dataSet != null) {
                                    if (var8_9 != null) {
                                        try {
                                            dataSet.close();
                                        }
                                        catch (Throwable throwable) {
                                            var8_9.addSuppressed(throwable);
                                        }
                                    } else {
                                        dataSet.close();
                                    }
                                }
                            }
                        }
                        if (swsList.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u76f8\u4f3c\u9879\u76ee\u65e0\u8865\u5145\u5de5\u4f5c\u5355\u3002", (String)"MROSWSReferCreatePlugin_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                        }
                        break block32;
                    }
                    this.getView().showTipNotification(resultMap.get("msg").toString());
                }
                catch (Exception ex) {
                    logger.error("\u8c03\u7528\u76f8\u4f3c\u9879\u76ee\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38" + ex.getMessage(), (Throwable)ex);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u76f8\u4f3c\u9879\u76ee\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"MROSWSReferCreatePlugin_12", (String)"mmc-pom-formplugin", (Object[])new Object[0]), ex.getMessage()));
                }
            }
        }
        return swsList;
    }

    private void refercreateMroSws() {
        IFormView view = this.getView();
        Set tarMroOrderIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("tarMroOrderIds"), Set.class);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(POM_MROSWS);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1442611280966856704");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber(POM_MROORDER);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Long orderid : tarMroOrderIds) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)orderid);
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().getEntryPrimaryKeyValues() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"MROSWSReferCreatePlugin_13", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
        HashSet swsEntryIds = Sets.newHashSet((Object[])billList.getSelectedRows().getEntryPrimaryKeyValues());
        pushArgs.addCustomParam("swsEntryIds", SerializationUtils.toJsonString((Object)swsEntryIds));
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess() && !result.getCachePageIds().isEmpty()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)POM_MROSWS);
            List targetBillObjs = result.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (targetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)result);
        }
    }
}

