/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mroorder;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.wordcard.consts.FileCodeEntity;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.pom.business.mroorder.DocTypeParamHelper;
import kd.mmc.pom.common.service.GetMROMaterialMFTInfo;

public class MROOrderBatchEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MROOrderBatchEdit.class);
    private static final String ATA = "ata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit transactiontype = (BasedataEdit)this.getView().getControl("transactiontype");
        transactiontype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit zone = (BasedataEdit)this.getView().getControl("zone");
        if (zone != null) {
            zone.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"controlno"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setItemValueByID("createorg", (Object)orgId);
        this.setDefaultMaterial();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String source = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        switch (source) {
            case "zone": {
                QFilter zoneFilter = this.getZoneFilter();
                listShowParameter.getListFilterParameter().getQFilters().add(zoneFilter);
                break;
            }
            case "transactiontype": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                if (project == null) break;
                HashSet<String> typeSet = new HashSet<String>(8);
                typeSet.add("DUMMYJOB_S");
                typeSet.add("SPECJOB_S");
                boolean nrccontrol = project.getBoolean("nrccontrol");
                boolean autojob = project.getBoolean("autojob");
                if (autojob) {
                    typeSet.add("BASICJOB_S");
                    typeSet.add("INNERJOB_S");
                    typeSet.add("PANELJOB_S");
                    if (nrccontrol) {
                        typeSet.add("NRCJOB_S");
                    }
                } else if (nrccontrol) {
                    typeSet.add("NRCJOB_S");
                }
                QFilter qfilter = new QFilter("mroordertype", "in", typeSet);
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
                break;
            }
            case "project": {
                DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
                if (transactiontype == null) break;
                long transId = (Long)transactiontype.getPkValue();
                transactiontype = TransactionTypeQueryHelper.getDataCacheByID((Object)transId);
                String mroordertype = transactiontype.getString("mroordertype");
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                if ("NRCJOB_S".equals(mroordertype)) {
                    qFilters.add(new QFilter("nrccontrol", "=", (Object)Boolean.TRUE));
                    break;
                }
                if (!"BASICJOB_S".equals(mroordertype) && !"INNERJOB_S".equals(mroordertype) && !"PANELJOB_S".equals(mroordertype)) break;
                qFilters.add(new QFilter("autojob", "=", (Object)Boolean.TRUE));
                break;
            }
        }
    }

    private void setDefaultMaterial() {
        DynamicObject materialmftinfo = GetMROMaterialMFTInfo.readParam();
        if (materialmftinfo != null) {
            this.getModel().setValue("material", (Object)materialmftinfo);
            this.getModel().setValue("unit", (Object)materialmftinfo.getDynamicObject("mftunit"));
            this.getModel().setValue("qty", (Object)1L);
            this.getModel().setValue("baseunit", (Object)materialmftinfo.getDynamicObject("masterid.baseunit"));
            this.getModel().setValue("baseqty", (Object)1L);
        }
    }

    public void click(EventObject e) {
        String srcKey;
        super.click(e);
        Object srcObj = e.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String string = srcKey = srcC == null ? null : srcC.getKey();
        if ("controlno".equalsIgnoreCase(srcKey)) {
            ListShowParameter listShowPrams;
            ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"mpdm_businesscontrol", (boolean)false, (int)2);
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            Object object = listShowPrams = formShowParameter instanceof ListShowParameter ? formShowParameter : null;
            if (listShowPrams == null) {
                return;
            }
            ListFilterParameter listParams = listShowPrams.getListFilterParameter();
            listParams.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, srcKey));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void clearATA() {
        this.getModel().setValue(ATA, (Object)"");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String colName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (colName) {
            case "project": {
                String workcontent;
                this.clearATA();
                Object newValue = changeSet[0].getNewValue();
                DynamicObject project = (DynamicObject)newValue;
                if (project == null || (workcontent = project.getString("workcontent")) == null || workcontent.isEmpty()) break;
                this.getModel().setValue("cardtitle", (Object)workcontent);
                break;
            }
            case "customer": {
                this.clearATA();
                break;
            }
            case "ata": {
                this.checkATA(changeSet);
                break;
            }
            case "transactiontype": {
                this.propChangeTransactionType(changeSet);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection retLMap;
        super.closedCallBack(e);
        Object retDataObj = e.getReturnData();
        String actID = e.getActionId();
        if (e.getReturnData() != null && "controlno".equalsIgnoreCase(actID) && (retLMap = (ListSelectedRowCollection)retDataObj) != null && !retLMap.isEmpty()) {
            this.getModel().setValue("controlno", (Object)retLMap.get(0).getNumber());
        }
    }

    private void checkATA(ChangeData[] changeSet) {
        FileCodeEntity fileCode;
        Object newValue = changeSet[0].getNewValue();
        if (newValue == null || "".equals(newValue)) {
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject docType = (DynamicObject)this.getModel().getValue("atatype");
        DynamicObject materielmtc = null;
        DynamicObject customer = null;
        if (project != null) {
            customer = project.getDynamicObject("customer");
            materielmtc = project.getDynamicObject("devices");
        }
        if (!(fileCode = DocTypeParamHelper.validFileCode((String)((String)newValue), (DynamicObject)project, (DynamicObject)materielmtc, (DynamicObject)docType, (DynamicObject)customer, (String)"pom_mroorder")).isAllowed()) {
            String errMsg = fileCode.getErrMsg();
            this.getView().showTipNotification(errMsg);
            this.getModel().setValue(ATA, null);
        } else {
            this.getModel().setValue(ATA, (Object)fileCode.getReturnMsg());
        }
    }

    private void propChangeTransactionType(ChangeData[] changeSet) {
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        DynamicObject transactiontype = (DynamicObject)newValue;
        if (transactiontype != null) {
            long transId = (Long)transactiontype.getPkValue();
            transactiontype = TransactionTypeQueryHelper.getDataCacheByID((Object)transId);
            String mroordertype = transactiontype.getString("mroordertype");
            BasedataEdit workstage = (BasedataEdit)this.getView().getControl("workstage");
            BasedataProp property = (BasedataProp)workstage.getProperty();
            if ("DUMMYJOB_S".equals(mroordertype) || "NRCJOB_S".equals(mroordertype) || "BASICJOB_S".equals(mroordertype)) {
                workstage.setMustInput(Boolean.TRUE.booleanValue());
                property.setMustInput(Boolean.TRUE.booleanValue());
                BasedataEdit zone = (BasedataEdit)this.getView().getControl("zone");
                if ("NRCJOB_S".equals(mroordertype) || "BASICJOB_S".equals(mroordertype)) {
                    zone.setMustInput(Boolean.TRUE.booleanValue());
                    BasedataProp zoneproperty = (BasedataProp)zone.getProperty();
                    zoneproperty.setMustInput(Boolean.TRUE.booleanValue());
                } else {
                    zone.setMustInput(Boolean.FALSE.booleanValue());
                    BasedataProp zoneproperty = (BasedataProp)zone.getProperty();
                    zoneproperty.setMustInput(Boolean.FALSE.booleanValue());
                }
            } else {
                workstage.setMustInput(Boolean.FALSE.booleanValue());
                property.setMustInput(Boolean.FALSE.booleanValue());
            }
        }
    }

    private QFilter getZoneFilter() {
        DynamicObject mratypeL3;
        QFilter filter1 = new QFilter("status", "=", (Object)"C");
        filter1.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            return filter1;
        }
        DynamicObject materialMTC = project.getDynamicObject("devices");
        QFilter filterL1MPD = new QFilter("materialtype", "=", (Object)0L);
        if (materialMTC != null && (mratypeL3 = (materialMTC = BusinessDataServiceHelper.loadSingleFromCache((Object)materialMTC.getPkValue(), (String)"mpdm_materialmtcinfo", (String)"maintenequipmodel")).getDynamicObject("maintenequipmodel")) != null) {
            try {
                Long mpdOne;
                Map typeResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getParentTypeById", (Object[])new Object[]{mratypeL3.getPkValue()});
                if (!typeResult.isEmpty() && (mpdOne = (Long)typeResult.get("modelmpdone")) != null) {
                    filterL1MPD = new QFilter("materialtype", "=", (Object)mpdOne);
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        filter1.and(filterL1MPD);
        return filter1;
    }
}

