/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.mroorder;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class MROToolEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] f7Keys = new String[]{"supplierid", "supplyorgid", "warehouseid", "location"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String f7Key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7Key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String name = this.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)op.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> errBOMList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errPushList = new ArrayList<Integer>(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                int i = selectRows[j];
                String stocksource = (String)this.getModel().getValue("stocksource", i);
                DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", i);
                boolean isPush = BFTrackerServiceHelper.isPush((String)name, (String)"stockentry", (Long)Long.parseLong(stockEntry.getPkValue().toString()));
                if (!"A".equals(stocksource)) {
                    errBOMList.add(i + 1);
                    continue;
                }
                if (!isPush) continue;
                errPushList.add(i + 1);
            }
            if (!errBOMList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4e0d\u662f\u624b\u5de5\u65b0\u589e\u3002", (String)"MROToolEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]), ((Object)errBOMList).toString()));
                e.cancel = true;
                return;
            }
            if (!errPushList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"MROToolEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]), ((Object)errPushList).toString()));
                e.cancel = true;
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("updatetool".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)e.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
            this.setLevelEnable(entryEntity.size() - 1);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MPDMMftGenStocksUtils.setOrderStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        IFormView view = this.getView();
        this.getModel().beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String stocksource = (String)this.getModel().getValue("stocksource", i);
            if (!"A".equals(stocksource)) {
                view.setEnable(Boolean.FALSE, i, new String[]{"materielmasterid"});
            } else {
                view.setEnable(Boolean.TRUE, i, new String[]{"materielmasterid"});
            }
            this.setLevelEnable(i);
        }
        this.getModel().endInit();
        view.updateView("stockentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        Object newObj = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "entryreplacegroup": {
                this.setLevelEnable(changeIndex);
                this.removeLevel(changeIndex);
                break;
            }
            case "begintime": {
                this.calUseTime(changeIndex);
                break;
            }
            case "endtime": {
                this.calUseTime(changeIndex);
                break;
            }
            case "supplyorgid": {
                this.supplyorgChange(changeIndex);
                break;
            }
            case "warehouseid": {
                this.warehouseChange(changeIndex);
                break;
            }
            case "materielmasterid": {
                if (newObj == null) break;
                this.getModel().setValue("materialunitid", ((DynamicObject)newObj).get("baseunit"));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals("supplyorgid")) {
            this.supplyOrgBeforeF7Select(e);
        } else if (fieldKey.equals("warehouseid")) {
            this.warehouseBeforeF7Select(e);
        } else if (fieldKey.equals("location")) {
            this.locationBeforeF7Select(e);
        } else if (fieldKey.equals("supplierid")) {
            this.supplyerBeforeF7Select(e);
        }
    }

    private void supplyerBeforeF7Select(BeforeF7SelectEvent e) {
        int row = e.getRow();
        String supplyfield = (String)this.getModel().getValue("supplymode", row);
        DynamicObject sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorgid", row);
        if ("bos_org".equals(supplyfield) && sypplyorgfield != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)sypplyorgfield.getPkValue();
            List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
            array.addAll(ownerArray);
            if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                array.add(sypplyorgfield.get("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", array));
        }
    }

    private void locationBeforeF7Select(BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouseid", e.getRow());
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u8d27\u4ed3\u5e93\u3002", (String)"MROToolEdit_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouse.getPkValue(), (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            DynamicObject location = (DynamicObject)obj.get("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void warehouseBeforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("supplyorgid", e.getRow());
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u8d27\u7ec4\u7ec7", (String)"MROToolEdit_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long[] warehouseids = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long warehouseid : warehouseids) {
            if (warehouseid == null) continue;
            ids.add(warehouseid);
        }
        if (!ids.isEmpty()) {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", (Object)Long.valueOf("0"));
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void supplyOrgBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("org");
        if (supplyOrg != null) {
            List idList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)Long.valueOf(supplyOrg.getPkValue().toString()), (boolean)true);
            e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setMultiSelect(false);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
        }
    }

    private void warehouseChange(int changeIndex) {
        this.getModel().setValue("location", null, changeIndex);
    }

    private void supplyorgChange(int changeIndex) {
        this.getModel().setValue("warehouseid", null, changeIndex);
        this.getModel().setValue("location", null, changeIndex);
        String supplyfield = (String)this.getModel().getValue("supplymode", changeIndex);
        DynamicObject sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorgid", changeIndex);
        if ("bos_org".equals(supplyfield) && sypplyorgfield != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)sypplyorgfield.getPkValue();
            List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
            array.addAll(ownerArray);
            if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                array.add(sypplyorgfield.getPkValue());
            }
            if (!array.isEmpty()) {
                this.getModel().setValue("supplierid", array.get(0), changeIndex);
            } else {
                this.getModel().setValue("supplierid", null, changeIndex);
            }
        }
    }

    private void removeLevel(int changeIndex) {
        String rep = (String)this.getModel().getValue("entryreplacegroup", changeIndex);
        if ("".equals(rep)) {
            this.getModel().setValue("entrylevel", (Object)0, changeIndex);
        }
    }

    private void calUseTime(int changeIndex) {
    }

    private void setLevelEnable(int i) {
        String rep = (String)this.getModel().getValue("entryreplacegroup", i);
        if ("".equals(rep)) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"entrylevel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"entrylevel"});
        }
    }
}

