/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.prodwip;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.pom.formplugin.prodwip.consts.ProdWipConst;

public class ProdWipSearchEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProdWipSearchEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("org");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        RequestContext requestContext = RequestContext.get();
        Long orgId = requestContext.getOrgId();
        Long userId = requestContext.getCurrUserId();
        if (this.isAddNewStatus()) {
            this.initOrg(orgId, userId);
            this.initDate();
        }
    }

    private boolean isAddNewStatus() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return OperationStatus.ADDNEW.equals((Object)status);
    }

    private void initOrg(Long orgId, Long userId) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        if (model.getValue("org") == null) {
            if (Objects.equals(orgId, 0L)) {
                model.setValue("org", (Object)0L);
                return;
            }
            String entityNum = model.getDataEntityType().getName();
            String appId = model.getDataEntityType().getAppId();
            Long orgByUserOrg = ProdWipSearchEdit.getOrgByUserOrg(userId, orgId, entityNum, appId);
            model.setValue("org", (Object)orgByUserOrg);
        }
    }

    private static Long getOrgByUserOrg(Long userId, Long orgId, String entityNum, String appId) {
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04")) {
            return orgId;
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"04", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        if (hasPermOrgs != null && !hasPermOrgs.isEmpty()) {
            return (Long)hasPermOrgs.get(0);
        }
        return 0L;
    }

    private void initDate() {
        Date now = TimeServiceHelper.now();
        this.getModel().setValue("auditdate", (Object)now);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        JSONObject org = (JSONObject)sourceData.get("org");
        Long orgId = (Long)org.get((Object)"id");
        String date = (String)sourceData.get("auditdate");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date auditdate = null;
        try {
            auditdate = simpleDateFormat.parse(date);
        }
        catch (ParseException ex) {
            log.error(ex.getMessage());
            this.throwImportException(e, ResManager.loadKDString((String)"\u5355\u636e\u4e1a\u52a1\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ProdWipSearchEdit_10", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isLastPeriod(auditdate)) {
            this.throwImportException(e, ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e1a\u52a1\u65e5\u671f\u5728\u5f80\u671f\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ProdWipSearchEdit_11", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long otherBillId = this.getOtherBillId(orgId, auditdate);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long thisBillId = dataEntity.getLong("id");
        if (!otherBillId.equals(0L) && !otherBillId.equals(thisBillId)) {
            this.throwImportException(e, ResManager.loadKDString((String)"\u540c\u4e00\u751f\u4ea7\u7ec4\u7ec7\u4ee5\u53ca\u4e1a\u52a1\u671f\u95f4\u4e0b\u5b58\u5728\u591a\u884c\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ProdWipSearchEdit_12", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
        }
    }

    private void throwImportException(BeforeImportDataEventArgs e, String errMessage) {
        e.setCancel(true);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(errMessage);
        e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), strings);
        e.setFireAfterImportData(false);
    }

    private boolean isLastPeriod(Date auditDate) {
        if (auditDate == null) {
            return false;
        }
        LocalDate date = auditDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate now = LocalDate.now();
        return date.getYear() != now.getYear() || date.getMonth() != now.getMonth();
    }

    private Long getOtherBillId(Long orgId, Date auditDate) {
        Long otherBillId = 0L;
        Date[] firstAndLastDayOfMonth = this.getFirstAndLastDay(auditDate);
        QFilter qfiter = new QFilter("org", "=", (Object)orgId);
        qfiter.and(new QFilter("auditdate", ">=", (Object)firstAndLastDayOfMonth[0]));
        qfiter.and(new QFilter("auditdate", "<=", (Object)firstAndLastDayOfMonth[1]));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(ProdWipSearchEdit.class.getName() + "_getOtherBill"), (String)"pom_prodwipbill", (String)"id", (QFilter[])new QFilter[]{qfiter}, null);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                otherBillId = arow.getLong("id");
            }
        }
        return otherBillId;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        Map sourceData = e.getSourceData();
        JSONArray billentry = (JSONArray)sourceData.get("billentry");
        for (int i = 0; i < billentry.size(); ++i) {
            JSONObject o = (JSONObject)billentry.get(i);
            BigDecimal wipqty = o.getBigDecimal("wipqty");
            BigDecimal checkqty = o.getBigDecimal("checkqty") == null ? BigDecimal.ZERO : o.getBigDecimal("checkqty");
            model.setValue("diffqty", (Object)wipqty.subtract(checkqty), i);
            Long textfield = o.getLong("childauxpropertyinnerid");
            model.setValue("childauxproperty", (Object)textfield, i);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.isAddNewStatus() || this.isLastPeriod()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
    }

    private boolean isLastPeriod() {
        Date auditDate = (Date)this.getModel().getValue("auditdate");
        if (auditDate == null) {
            return false;
        }
        LocalDate date = auditDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate now = LocalDate.now();
        return date.getYear() != now.getYear() || date.getMonth() != now.getMonth();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        boolean isCancel = false;
        switch (operateKey) {
            case "querydata": {
                isCancel = this.verifyQuery(args);
                break;
            }
            case "save": {
                isCancel = this.verifySave(args);
                if (isCancel || !Boolean.parseBoolean(this.getView().getPageCache().get("ischange"))) break;
                this.getModel().setValue("modifier", (Object)UserServiceHelper.getCurrentUserId());
                break;
            }
            case "delete": {
                isCancel = this.verifyDelete(args);
            }
        }
        args.setCancel(isCancel);
    }

    private boolean verifyDelete(BeforeDoOperationEventArgs args) {
        if (this.isLastPeriod()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e3a\u5f80\u671f\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ProdWipSearchEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean verifyQuery(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getView().getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3002", (String)"ProdWipSearchEdit_1", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        Date auditDate = (Date)model.getValue("auditdate");
        if (auditDate == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u671f\u95f4\u201d\u3002", (String)"ProdWipSearchEdit_2", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.isLastPeriod()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e1a\u52a1\u65e5\u671f\u5728\u5f80\u671f\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u67e5\u8be2\u3002", (String)"ProdWipSearchEdit_3", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        FormOperate source = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Long otherBillId = this.getOtherBillId();
            if (otherBillId != null && !otherBillId.equals(0L)) {
                String msg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\uff08\u751f\u4ea7\u7ec4\u7ec7\uff1a%2$s\uff1b\u4e1a\u52a1\u671f\u95f4\uff1a%1$s\uff09\u7684\u5728\u5236\u6570\u636e\uff0c\u662f\u5426\u91cd\u65b0\u67e5\u8be2\u5e76\u8986\u76d6\uff1f", (String)"ProdWipSearchEdit_4", (String)"mmc-pom-formplugin", (Object[])new Object[0]), df.format(auditDate), org.getString("name"));
                ConfirmCallBackListener listener = new ConfirmCallBackListener("checkexistsdata", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                return true;
            }
        }
        return false;
    }

    private Long getOtherBillId() {
        IFormView view = this.getView();
        Long otherBillId = 0L;
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        DynamicObject orgObj = (DynamicObject)model.getValue("org");
        Date auditDate = (Date)model.getValue("auditdate");
        Date[] firstAndLastDayOfMonth = this.getFirstAndLastDay(auditDate);
        QFilter qfiter = new QFilter("org", "=", orgObj.getPkValue());
        qfiter.and(new QFilter("auditdate", ">=", (Object)firstAndLastDayOfMonth[0]));
        qfiter.and(new QFilter("auditdate", "<=", (Object)firstAndLastDayOfMonth[1]));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(ProdWipSearchEdit.class.getName() + "_getOtherBill"), (String)"pom_prodwipbill", (String)"id", (QFilter[])new QFilter[]{qfiter}, null);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                otherBillId = arow.getLong("id");
            }
        }
        return otherBillId;
    }

    private Date[] getFirstAndLastDay(Date nowDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String startDay = df.format(nowDate);
        Date[] result = new Date[2];
        Calendar calendarFirstDay = Calendar.getInstance();
        calendarFirstDay.set(Integer.parseInt(startDay.substring(0, 4)), Integer.parseInt(startDay.substring(5, 7)) - 1, 1);
        calendarFirstDay.set(13, 0);
        calendarFirstDay.set(12, 0);
        calendarFirstDay.set(11, 0);
        calendarFirstDay.set(14, 0);
        result[0] = calendarFirstDay.getTime();
        Calendar calendarLastDay = Calendar.getInstance();
        startDay = startDay + " 23:59:59";
        calendarLastDay.set(Integer.parseInt(startDay.substring(0, 4)), Integer.parseInt(startDay.substring(5, 7)), 1);
        calendarLastDay.add(5, -1);
        calendarLastDay.set(13, 59);
        calendarLastDay.set(12, 59);
        calendarLastDay.set(11, 23);
        calendarLastDay.set(14, 59);
        result[1] = calendarLastDay.getTime();
        return result;
    }

    private boolean verifySave(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getView().getModel();
        DynamicObject orgObj = (DynamicObject)model.getValue("org");
        if (orgObj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5355\u636e\u751f\u4ea7\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8fdb\u884c\u67e5\u8be2\u540e\u518d\u4fdd\u5b58\u3002", (String)"ProdWipSearchEdit_5", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        Date auditDate = (Date)model.getValue("auditdate");
        if (auditDate == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a\uff0c\u53ef\u80fd\u8fd8\u672a\u8fdb\u884c\u67e5\u8be2\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ProdWipSearchEdit_6", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.isLastPeriod()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u7684\u4e1a\u52a1\u65e5\u671f\u5728\u5f80\u671f\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ProdWipSearchEdit_7", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long otherBillId = this.getOtherBillId();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long thisBillId = dataEntity.getLong("id");
        if (thisBillId == null) {
            thisBillId = 0L;
        }
        if (!otherBillId.equals(0L) && !thisBillId.equals(otherBillId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u4e00\u751f\u4ea7\u7ec4\u7ec7\u4ee5\u53ca\u4e1a\u52a1\u671f\u95f4\u4e0b\u5b58\u5728\u591a\u884c\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"ProdWipSearchEdit_8", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("checkexistsdata".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.No.equals((Object)result)) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("querydata", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("querydata".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("pom_prodwip_filiter");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            formShowParameter.setCustomParam("org", org.getPkValue());
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pom_prodwip_filiter"));
            this.getView().showForm(formShowParameter);
        } else if ("modifylog".equals(e.getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            HashSet<Object> pkValues = new HashSet<Object>(16);
            pkValues.add(dataEntity.getPkValue());
            List<Long> allLogList = this.queryLogs(pkValues);
            if (allLogList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u8bb0\u5f55\u3002", (String)"ProdWipSearchEdit_13", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
                return;
            }
            if (allLogList.size() == 1) {
                BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam((String)"pom_prodwipbill_log", (Object)allLogList.get(0));
                showParameter.setHasRight(false);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                QFilter qfilterWithPermission = new QFilter("id", "in", allLogList);
                qfilterList.add(qfilterWithPermission);
                ListShowParameter showParam = new ListShowParameter();
                showParam.setHasRight(false);
                showParam.setIsolationOrg(false);
                showParam.setBillFormId("pom_prodwipbill_log");
                showParam.getListFilterParameter().setQFilters(qfilterList);
                showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParam.setShowFilter(false);
                showParam.setShowQuickFilter(false);
                showParam.setCustomParam("isshowtoolbarap", (Object)"yes");
                showParam.setCustomParam("istmctracebillop", (Object)"yes");
                this.getView().showForm((FormShowParameter)showParam);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        String selectedProperty = this.getSelectFields();
        List<QFilter> qFilterList = this.createHeadFilters(returnData);
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        model.deleteEntryData("billentry");
        int isize = 0;
        try (DataSet stockDataSet = QueryServiceHelper.queryDataSet((String)"query_pom_mftstock", (String)"pom_mftstock", (String)selectedProperty, (QFilter[])qFilters, null);){
            DataSet result = stockDataSet.groupBy(ProdWipConst.groupByFields).sum("useqty").sum("wipqty").sum("actissueqty").sum("rejectedqty").sum("feedingqty").finish();
            TableValueSetter vs = new TableValueSetter(ProdWipConst.fields);
            model.beginInit();
            ArrayList<Object[]> listValues = new ArrayList<Object[]>(128);
            while (result.hasNext()) {
                Row row = result.next();
                ArrayList<Object> listValue = new ArrayList<Object>(64);
                listValue.add(row.get("billno") == null ? "" : row.getString("billno"));
                listValue.add(0L);
                listValue.add(0L);
                listValue.add("");
                listValue.add(row.get("material") == null ? Long.valueOf(0L) : row.getLong("material"));
                Long materielmasterid = row.getLong("materielmasterid");
                if (materielmasterid == null || materielmasterid == 0L) continue;
                listValue.add(materielmasterid);
                listValue.add(row.get("materialno") == null ? "" : row.get("materialno"));
                listValue.add(row.get("e_materialunit") == null ? Long.valueOf(0L) : row.getLong("e_materialunit"));
                BigDecimal actissueqty = row.get("actissueqty") == null ? BigDecimal.ZERO : row.getBigDecimal("actissueqty");
                BigDecimal rejectedqty = row.get("rejectedqty") == null ? BigDecimal.ZERO : row.getBigDecimal("rejectedqty");
                BigDecimal feedingqty = row.get("feedingqty") == null ? BigDecimal.ZERO : row.getBigDecimal("feedingqty");
                BigDecimal wipqty = row.get("wipqty") == null ? BigDecimal.ZERO : row.getBigDecimal("wipqty");
                listValue.add(actissueqty.subtract(rejectedqty).add(feedingqty));
                listValue.add(row.get("useqty") == null ? BigDecimal.ZERO : row.getBigDecimal("useqty"));
                listValue.add(wipqty);
                listValue.add(row.get("entryconfigcode") == null ? Long.valueOf(0L) : row.getLong("entryconfigcode"));
                listValue.add(row.get("childauxproperty") == null ? Long.valueOf(0L) : row.getLong("childauxproperty"));
                listValue.add(BigDecimal.ZERO);
                listValue.add(wipqty);
                listValue.add(row.get("childauxproperty") == null ? null : row.getString("childauxproperty"));
                listValues.add(listValue.toArray());
            }
            if (!listValues.isEmpty()) {
                for (Object[] value : listValues) {
                    vs.addRow(value);
                }
                isize = listValues.size();
            }
            model.batchCreateNewEntryRow("billentry", vs);
            model.endInit();
        }
        view.updateView("billentry");
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff0c\u5171%d\u6761\u6570\u636e\u3002", (String)"ProdWipSearchEdit_9", (String)"mmc-pom-formplugin", (Object[])new Object[0]), isize));
    }

    private List<QFilter> createHeadFilters(Map<String, Object> resultMap) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(16);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject orgObj = (DynamicObject)model.getValue("org");
        qfList.add(new QFilter("orderentryid.producttype", "=", (Object)"C"));
        qfList.add(new QFilter("org", "=", orgObj.getPkValue()));
        this.createBizTypeFilter(qfList, resultMap);
        this.createTransactionFilter(qfList, resultMap);
        this.createBillNoFilter(qfList, resultMap);
        this.createProdNoFilter(qfList, resultMap);
        this.createStockFilter(qfList, resultMap);
        this.createBDProjFilter(qfList, resultMap);
        this.createFollowNoFilter(qfList, resultMap);
        this.createCrTimeFilter(qfList, resultMap);
        this.createStartTimeFilter(qfList, resultMap);
        this.createFinishTimeFilter(qfList, resultMap);
        this.createBizStatusFilter(qfList, resultMap);
        this.createPlanStatusFilter(qfList, resultMap);
        this.createTaskStatusFilter(qfList, resultMap);
        this.createPickStatusFilter(qfList, resultMap);
        return qfList;
    }

    private void createBizTypeFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList bizType = (ArrayList)resultMap.get("biztypemul");
        if (bizType != null && bizType.size() > 0) {
            qfList.add(new QFilter("transactiontypeid.transactiontype", "in", (Object)bizType));
        }
    }

    private void createTransactionFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList transactionTypeId = (ArrayList)resultMap.get("transactmul");
        if (transactionTypeId != null && transactionTypeId.size() > 0) {
            qfList.add(new QFilter("transactiontypeid", "in", (Object)transactionTypeId));
        }
    }

    private void createBillNoFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList billNo = (ArrayList)resultMap.get("prodnomul");
        if (billNo != null && billNo.size() > 0) {
            qfList.add(new QFilter("orderentryid.headbillno", "in", (Object)billNo));
        }
    }

    private void createProdNoFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList prodNo = (ArrayList)resultMap.get("productnomul");
        if (prodNo != null && prodNo.size() > 0) {
            qfList.add(new QFilter("orderentryid.material", "in", (Object)prodNo));
        }
    }

    private void createStockFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList moduleNo = (ArrayList)resultMap.get("modulenomul");
        if (moduleNo != null && moduleNo.size() > 0) {
            qfList.add(new QFilter("stockentry.materialid", "in", (Object)moduleNo));
        }
    }

    private void createBDProjFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList bdProj = (ArrayList)resultMap.get("projectnomul");
        if (bdProj != null && bdProj.size() > 0) {
            qfList.add(new QFilter("bdproject", "in", (Object)bdProj));
        }
    }

    private void createFollowNoFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        ArrayList followNo = (ArrayList)resultMap.get("follownomul");
        if (followNo != null && followNo.size() > 0) {
            qfList.add(new QFilter("orderentryid.tracknumber", "in", (Object)followNo));
        }
    }

    private void createCrTimeFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        Date beginDate = (Date)resultMap.get("bctbegin");
        Date endDate = (Date)resultMap.get("bctend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("createtime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("createtime", "<", (Object)cal.getTime()));
        }
    }

    private void createStartTimeFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        Date beginDate = (Date)resultMap.get("pbtbegin");
        Date endDate = (Date)resultMap.get("pbtend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planbegintime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planbegintime", "<", (Object)cal.getTime()));
        }
    }

    private void createFinishTimeFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        Date beginDate = (Date)resultMap.get("petbegin");
        Date endDate = (Date)resultMap.get("petend");
        Calendar cal = Calendar.getInstance();
        if (beginDate != null) {
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("orderentryid.planendtime", ">=", (Object)cal.getTime()));
        }
        if (endDate != null) {
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("orderentryid.planendtime", "<", (Object)cal.getTime()));
        }
    }

    private void createBizStatusFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        String[] bizStatus = (String[])resultMap.get("bizstatus");
        qfList.add(new QFilter("orderentryid.bizstatus", "in", (Object)bizStatus));
    }

    private void createPlanStatusFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        String[] planStatus = (String[])resultMap.get("planstatus");
        qfList.add(new QFilter("orderentryid.planstatus", "in", (Object)planStatus));
    }

    private void createTaskStatusFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        String[] taskStatus = (String[])resultMap.get("taskstatus");
        qfList.add(new QFilter("orderentryid.taskstatus", "in", (Object)taskStatus));
    }

    private void createPickStatusFilter(List<QFilter> qfList, Map<String, Object> resultMap) {
        String[] pickStatus = (String[])resultMap.get("pickstatus");
        qfList.add(new QFilter("orderentryid.pickstatus", "in", (Object)pickStatus));
    }

    private String getSelectFields() {
        StringJoiner sb = new StringJoiner(",");
        sb.add("orderentryid.headbillno AS billno");
        sb.add("orderentryid.id AS mftentryid");
        sb.add("orderentryid.entryseq AS entrynum");
        sb.add("orderentryid.workcenter AS productline");
        sb.add("orderentryid.planbegintime AS planbegintime");
        sb.add("orderentryid.material AS material");
        sb.add("orderentryid.configuredcode AS configuredcode");
        sb.add("transactiontypeid AS transactiontype");
        sb.add("stockentry.materialid AS materialno");
        sb.add("stockentry.entryconfiguredcode AS entryconfigcode");
        sb.add("stockentry.childauxpropertyid AS childauxproperty");
        sb.add("stockentry.materialunitid AS e_materialunit");
        sb.add("stockentry.demandqty AS demandqty");
        sb.add("stockentry.actissueqty AS actissueqty");
        sb.add("stockentry.rejectedqty AS rejectedqty");
        sb.add("stockentry.feedingqty AS feedingqty");
        sb.add("stockentry.useqty AS useqty");
        sb.add("stockentry.wipqty AS wipqty");
        sb.add("stockentry.allotqty AS allotqty");
        sb.add("stockentry.processseq AS processseq");
        sb.add("stockentry.operationdesc AS operationdescsea");
        sb.add("orderentryid.tracknumber AS tracknumber");
        sb.add("stockentry.workstation AS workstation");
        sb.add("stockentry.oprworkcenter AS oprworkcenter");
        sb.add("stockentry.operationdesc AS operationdesc");
        sb.add("stockentry.materielmasterid AS materielmasterid");
        sb.add("stockentry.id AS stockentryid");
        sb.add("id AS stockid");
        sb.add("billno AS stockno");
        sb.add("org");
        sb.add("productmasterid");
        sb.add("bdproject");
        return sb.toString();
    }

    private List<Long> queryLogs(Set<Object> pkValues) {
        ArrayList<Long> queryLogList = new ArrayList<Long>(16);
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_prodwipbill_log", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", pkValues)});
        for (DynamicObject query : querys) {
            queryLogList.add(query.getLong("id"));
        }
        return queryLogList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal diffqty;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        if ("checkqty".equals(propertyName)) {
            BigDecimal checkQty = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
            BigDecimal wipQty = (BigDecimal)this.getModel().getValue("wipqty", rowIndex);
            diffqty = wipQty.subtract(checkQty);
            this.getModel().setValue("diffqty", (Object)diffqty, rowIndex);
            this.getView().updateView("diffqty", rowIndex);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("ischange", "true");
        }
        if ("wipqty".equals(propertyName)) {
            BigDecimal wipQty = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
            BigDecimal checkQty = (BigDecimal)this.getModel().getValue("checkqty", rowIndex);
            diffqty = wipQty.subtract(checkQty);
            this.getModel().setValue("diffqty", (Object)diffqty, rowIndex);
            this.getView().updateView("diffqty", rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String entityNum;
        String appId;
        long userID;
        HasPermOrgResult result;
        String name = e.getProperty().getName();
        if ("org".equals(name) && !(result = PermissionServiceHelper.getAllPermOrgs((long)(userID = RequestContext.get().getCurrUserId()), (String)"04", (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)(entityNum = this.getModel().getDataEntityType().getName()), (String)"47150e89000000ac")).hasAllOrgPerm()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }
}

