/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.formplugin.resready;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.pom.common.resready.consts.ResReadySumReportField;
import kd.mmc.pom.common.resready.util.DataSetListTransUtil;
import kd.mmc.pom.common.resready.util.ResReadyBussinessUtil;
import kd.mmc.pom.formplugin.resready.ResReadyReportPlugin;

public class ResReadySumReportPlugin
extends ResReadyReportPlugin {
    private static final String DIMENRADIO_GROUP = "dimenradiogroup";

    @Override
    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        try {
            DataSet query = super.query(param, o);
            FilterInfo filterInfo = param.getFilter();
            String viewDimen = filterInfo.getString(DIMENRADIO_GROUP);
            if (query != null) {
                query = this.calcStatusSum(viewDimen, query);
            }
            return query;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("report-error", ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u660e\u7ec6\u8868\u6c47\u603b\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"ResReadySumReportPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet calcStatusSum(String viewDimen, DataSet query) {
        boolean isTask = false;
        isTask = StringUtils.equals((CharSequence)"1", (CharSequence)viewDimen);
        long orgId = RequestContext.get().getOrgId();
        Map levelMap = ResReadyBussinessUtil.getLeveMap((Long)orgId);
        try {
            DataSet dataSet;
            HashSet<String> taskChickBillSet = new HashSet<String>(128);
            ArrayList<Map<String, Object>> sumReportList = new ArrayList<Map<String, Object>>(128);
            HashMap<String, Map<String, Object>> checkBillTaskRow = new HashMap<String, Map<String, Object>>(128);
            HashMap<String, Set<String>> taskInCheckBillMap = new HashMap<String, Set<String>>(128);
            HashMap<String, Set<String>> workCardMap = new HashMap<String, Set<String>>(128);
            HashMap<String, Set<String>> proGroupMap = new HashMap<String, Set<String>>(128);
            HashMap<String, Set<String>> industryMap = new HashMap<String, Set<String>>(128);
            while (query.hasNext()) {
                String materialControlNO;
                String checkBillNO;
                Row next = query.next();
                String resType = next.getString("restype");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)resType)) continue;
                String string = checkBillNO = next.getString("checkebill") == null ? "" : next.getString("checkebill");
                String checkBillTaskNo = isTask ? (next.getString("projecttask") == null ? "" : next.getString("projecttask")) : checkBillNO;
                Long projectNumber = next.getLong("projectnumber");
                String workCardNO = next.getString("mrocard") == null ? "" : next.getString("mrocard");
                String proGroupNO = next.getString("progroup") == null ? "" : next.getString("progroup");
                String industryNO = next.getString("mulbasedatafield") == null ? "" : next.getString("mulbasedatafield");
                String string2 = materialControlNO = next.getString("materialcontrolgroup") == null ? "" : next.getString("materialcontrolgroup");
                if (StringUtils.isEmpty((CharSequence)checkBillNO)) continue;
                if (taskChickBillSet.contains(checkBillTaskNo)) {
                    Map lastRowMap = (Map)checkBillTaskRow.get(checkBillTaskNo);
                    if (lastRowMap == null) continue;
                    String resTypeStatus = next.getString("readystatusrestype");
                    this.writeResStatus(lastRowMap, resType, resTypeStatus, levelMap);
                    this.writeCheckBill(isTask, checkBillTaskNo, taskInCheckBillMap, lastRowMap, checkBillNO, "checkebillsum");
                    this.writeCheckBill(isTask, checkBillTaskNo, workCardMap, lastRowMap, workCardNO, "mrocardsum");
                    continue;
                }
                Map<String, Object> rowMap = this.setValueToMap(next, levelMap);
                if (rowMap != null) {
                    sumReportList.add(rowMap);
                    checkBillTaskRow.put(checkBillTaskNo, rowMap);
                }
                taskChickBillSet.add(checkBillTaskNo);
                this.writeCheckBill(isTask, checkBillTaskNo, taskInCheckBillMap, null, checkBillNO, "checkebillsum");
                this.writeCheckBill(isTask, checkBillTaskNo, workCardMap, null, workCardNO, "checkebillsum");
                this.writeCheckBill(isTask, checkBillTaskNo, proGroupMap, null, proGroupNO, "progroupsum");
                this.writeCheckBill(isTask, checkBillTaskNo, industryMap, null, industryNO, "mulbasedatafieldsum");
                this.writeCheckBill(isTask, checkBillTaskNo, industryMap, null, materialControlNO, "materialcontrolgroupsum");
            }
            DataSet dataSet2 = dataSet = DataSetListTransUtil.parseToReportDataSet((Object)((Object)this), sumReportList, (boolean)true);
            return dataSet2;
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    private void writeCheckBill(boolean isTask, String checkBillTaskNo, Map<String, Set<String>> taskInCheckBillMap, Map<String, Object> lastRowMap, String checkBillNO, String fieldName) {
        if (!isTask || taskInCheckBillMap == null) {
            return;
        }
        if (isTask) {
            Set orDefault = taskInCheckBillMap.getOrDefault(checkBillTaskNo, new HashSet(8));
            orDefault.add(checkBillNO);
            taskInCheckBillMap.put(checkBillTaskNo, orDefault);
            if (lastRowMap == null) {
                return;
            }
            StringBuilder billNoStr = new StringBuilder();
            int i = 0;
            for (String billNo : orDefault) {
                String string = billNo = billNo == null ? "" : billNo;
                if (StringUtils.isEmpty((CharSequence)billNo)) continue;
                billNoStr.append(billNo).append("\uff1b");
                ++i;
            }
            String resultStr = billNoStr.toString();
            if (StringUtils.isNotEmpty((CharSequence)resultStr) && resultStr.length() > 1) {
                resultStr = resultStr.substring(0, resultStr.length() - 1);
            }
            lastRowMap.put(fieldName, resultStr);
        }
    }

    private Map<String, Object> setValueToMap(Row next, Map<String, Integer> levelMap) {
        if (next == null) {
            return null;
        }
        HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
        String[] customField = ResReadySumReportField.getCustomField();
        for (int i = 0; i < customField.length; ++i) {
            String rowFiled = customField[i].substring(0, customField[i].lastIndexOf("sum"));
            Object value = next.get(rowFiled);
            rowMap.put(customField[i], value);
        }
        String resType = next.getString("restype");
        String resTypeStatus = next.getString("readystatusrestype");
        this.writeResStatus(rowMap, resType, resTypeStatus, levelMap);
        return rowMap;
    }

    private void writeResStatus(Map<String, Object> rowMap, String resType, String resTypeStatus, Map<String, Integer> levelMap) {
        if (rowMap == null) {
            return;
        }
        String preStatus = "";
        String levelToStatus = "";
        String fieldName = "";
        switch (resType) {
            case "0": {
                preStatus = rowMap.get("materialstatussum") == null ? "" : String.valueOf(rowMap.get("materialstatussum"));
                levelToStatus = ResReadyBussinessUtil.getLevelToStatus((String)preStatus, (String)resTypeStatus, levelMap);
                fieldName = "materialstatussum";
                break;
            }
            case "2": {
                preStatus = rowMap.get("toolstatussum") == null ? "" : String.valueOf(rowMap.get("toolstatussum"));
                levelToStatus = ResReadyBussinessUtil.getLevelToStatus((String)preStatus, (String)resTypeStatus, levelMap);
                fieldName = "toolstatussum";
                break;
            }
            case "3": {
                preStatus = rowMap.get("filestatussum") == null ? "" : String.valueOf(rowMap.get("filestatussum"));
                levelToStatus = ResReadyBussinessUtil.getLevelToStatus((String)preStatus, (String)resTypeStatus, levelMap);
                fieldName = "filestatussum";
                break;
            }
            case "4": {
                preStatus = rowMap.get("technicalstatussum") == null ? "" : String.valueOf(rowMap.get("technicalstatussum"));
                levelToStatus = ResReadyBussinessUtil.getLevelToStatus((String)preStatus, (String)resTypeStatus, levelMap);
                fieldName = "technicalstatussum";
                break;
            }
            case "5": {
                preStatus = rowMap.get("workcardstatussum") == null ? "" : String.valueOf(rowMap.get("workcardstatussum"));
                levelToStatus = ResReadyBussinessUtil.getLevelToStatus((String)preStatus, (String)resTypeStatus, levelMap);
                fieldName = "workcardstatussum";
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
            this.writeResStatusInfo(rowMap, fieldName, levelToStatus);
        }
    }

    private void writeResStatusInfo(Map<String, Object> rowMap, String statusSumField, String resTypeStatus) {
        Object status = rowMap.get(statusSumField);
        if (status != null && StringUtils.equals((CharSequence)"D", (CharSequence)resTypeStatus)) {
            return;
        }
        rowMap.put(statusSumField, resTypeStatus);
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        String dimenRadioGroup = queryParam.getFilter().getString(DIMENRADIO_GROUP);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn = (ReportColumn)column;
            String fieldKey = reportColumn.getFieldKey();
            if (!StringUtils.equals((CharSequence)fieldKey, (CharSequence)"execonditionsum") && !StringUtils.equals((CharSequence)fieldKey, (CharSequence)"majorflagsum")) continue;
            if (StringUtils.equals((CharSequence)dimenRadioGroup, (CharSequence)"0")) {
                reportColumn.setHide(false);
                continue;
            }
            reportColumn.setHide(true);
        }
        return super.getColumns(columns);
    }
}

