/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;
import kd.mmc.pom.business.utils.OrderClearLockUtils;
import kd.mmc.pom.common.service.GetMROMaterialMFTInfo;
import kd.mmc.pom.mservice.api.IBatchCreateMroOrder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class BatchCreateMroOrderImpl
implements IBatchCreateMroOrder {
    private static final Log logger = LogFactory.getLog(BatchCreateMroOrderImpl.class);
    private static final int MAXBATCHSAVECOUNT = 100;
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final DBRoute sysDBRoute = new DBRoute("sys");
    private static final String MROMANUFTECHENTITYNUMBER = "sfc_mromanuftech";
    private static final String MROSTOCKENTITYNUMBER = "pom_mrostock";
    private static final String MROORDERENTITYNUMBER = "pom_mroorder";

    public JSONArray batchCreateMroOrderFromExecPack(JSONArray param) {
        DynamicObject project;
        int size = param.size();
        JSONArray result = new JSONArray(size);
        DynamicObject materialmftinfo = GetMROMaterialMFTInfo.readParam();
        if (materialmftinfo == null) {
            logger.info("batchCreateOrder \u672a\u8bbe\u7f6e\u8d39\u7528\u7269\u6599");
            String msgerror = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8d39\u7528\u7269\u6599", (String)"BatchCreateMroOrderImpl_6", (String)"mmc-pom-mservice", (Object[])new Object[0]);
            return this.genErrorReturnArray(result, param, msgerror);
        }
        DynamicObject codeDynamic = MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)1387752287631338496L);
        if (codeDynamic == null) {
            logger.info("batchCreateOrder \u672a\u8bbe\u7f6e\u4e8b\u52a1\u7c7b\u578b\u4e3a\u3010\u68c0\u4fee\u751f\u4ea7\u3011\u7684\u68c0\u4fee\u5de5\u5355\u7f16\u7801\u89c4\u5219,codeDynamic is null,\u4e8b\u52a1\u7c7b\u578bID=1387752287631338496L");
            String msgerror = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4e8b\u52a1\u7c7b\u578b\u4e3a\u3010\u68c0\u4fee\u751f\u4ea7\u3011\u7684\u68c0\u4fee\u5de5\u5355\u7f16\u7801\u89c4\u5219\u3002", (String)"BatchCreateMroOrderImpl_2", (String)"mmc-pom-mservice", (Object[])new Object[0]);
            return this.genErrorReturnArray(result, param, msgerror);
        }
        DynamicObject transactype = BusinessDataServiceHelper.loadSingleFromCache((Object)1387752287631338496L, (String)"mpdm_transactproduct");
        DynamicObject billtype = BusinessDataServiceHelper.loadSingleFromCache((Object)1387624395492574208L, (String)"bos_billtype", (String)"id");
        DynamicObject doctype = BusinessDataServiceHelper.loadSingleFromCache((Object)1539125409843563520L, (String)"mpdm_doctype", (String)"id");
        ORM orm = ORM.create();
        HashMap<Long, DynamicObject> projectMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, List<DynamicObject>> allSaveOrdersListMap = new HashMap<Long, List<DynamicObject>>(size);
        HashMap<Long, List<DynamicObject>> allSubmitOrdersListMap = new HashMap<Long, List<DynamicObject>>(size);
        HashMap<String, ArrayList> rowMap = new HashMap<String, ArrayList>(size);
        boolean iserror = false;
        String errorString = "";
        HashSet<Long> allIDSet = new HashSet<Long>(2000);
        HashMap<String, Map<String, Object>> codeMap = new HashMap<String, Map<String, Object>>(16);
        for (int i = 0; i < size; ++i) {
            JSONObject execPack = (JSONObject)param.get(i);
            if (iserror) {
                JSONObject returnJson = new JSONObject();
                returnJson.put("status", (Object)false);
                returnJson.put("msg", (Object)"");
                returnJson.put("packageid", (Object)execPack.getLong("packageid"));
                result.set(i, (Object)returnJson);
                continue;
            }
            String allsetpString = " allsize = " + size + ",current step = " + (i + 1);
            logger.info("start batchCreateOrder:" + allsetpString);
            JSONObject opResult = this.batchCreateOrder(execPack, orm, transactype, billtype, codeDynamic, materialmftinfo, orgMap, projectMap, codeMap, doctype);
            boolean status = opResult.getBooleanValue("status");
            if (status) {
                ArrayList saveOrdersList = (ArrayList)opResult.get((Object)"saveOrdersList");
                ArrayList submitOrdersList = (ArrayList)opResult.get((Object)"submitOrdersList");
                DynamicObject project2 = (DynamicObject)opResult.get((Object)"project");
                this.addToAllOrder(saveOrdersList, allSaveOrdersListMap, project2);
                this.addToAllOrder(submitOrdersList, allSubmitOrdersListMap, project2);
                ArrayList allOrderIdList = (ArrayList)opResult.get((Object)"allOrderIdList");
                rowMap.put(String.valueOf(i), allOrderIdList);
                allIDSet.addAll(allOrderIdList);
            } else {
                errorString = opResult.getString("msg");
                iserror = true;
            }
            result.set(i, (Object)opResult);
        }
        if (iserror) {
            this.recycleOrderNumbers(codeMap);
            return this.genAllErrorReturnArray(result, errorString);
        }
        try {
            JSONObject returnJson;
            Long projectID;
            for (Map.Entry orderMaps : allSaveOrdersListMap.entrySet()) {
                projectID = (Long)orderMaps.getKey();
                project = this.getProject(projectID, projectMap);
                List newOrdersList = (List)orderMaps.getValue();
                returnJson = new JSONObject();
                if ((returnJson = this.batchExecuteOrdersOp(newOrdersList, transactype, codeDynamic, project, orm, returnJson, allIDSet, "save", true)).getBooleanValue("status")) continue;
                iserror = true;
                errorString = returnJson.getString("msg");
                break;
            }
            if (iserror) {
                this.rollbackDatas(codeMap, allIDSet);
                return this.genAllErrorReturnArray(result, errorString);
            }
            for (Map.Entry orderMaps : allSubmitOrdersListMap.entrySet()) {
                projectID = (Long)orderMaps.getKey();
                project = this.getProject(projectID, projectMap);
                List newOrdersList = (List)orderMaps.getValue();
                returnJson = new JSONObject();
                if ((returnJson = this.batchExecuteOrdersOp(newOrdersList, transactype, codeDynamic, project, orm, returnJson, allIDSet, "submit", true)).getBooleanValue("status")) continue;
                iserror = true;
                errorString = returnJson.getString("msg");
                break;
            }
            if (iserror) {
                this.rollbackDatas(codeMap, allIDSet);
                return this.genAllErrorReturnArray(result, errorString);
            }
        }
        catch (Exception e) {
            logger.info("execute data has error", (Object)e);
            errorString = this.getErrorString(e);
            this.rollbackDatas(codeMap, allIDSet);
            return this.genAllErrorReturnArray(result, errorString);
        }
        for (int i = 0; i < result.size(); ++i) {
            JSONObject opResult = result.getJSONObject(i);
            List orderIDList = (List)rowMap.get(String.valueOf(i));
            project = (DynamicObject)opResult.get((Object)"project");
            int returnSeq = 0;
            JSONArray returnArray = new JSONArray();
            Map<Long, String> billnoMap = this.getOrderBillnoMap(orderIDList);
            for (int rowIndex = 0; rowIndex < orderIDList.size(); ++rowIndex) {
                Long orderId = (Long)orderIDList.get(rowIndex);
                JSONObject returnObj = new JSONObject();
                returnObj.put("project", project.getPkValue());
                returnObj.put("orderno", (Object)billnoMap.get(orderId));
                returnObj.put("orderid", (Object)orderId);
                returnArray.add(returnSeq, (Object)returnObj);
                ++returnSeq;
            }
            opResult.put("entryentity", (Object)returnArray);
        }
        return result;
    }

    public JSONArray batchCreateMroOrderFromOverHead(JSONArray param) {
        int size = param.size();
        JSONArray result = new JSONArray(size);
        ORM orm = ORM.create();
        for (int i = 0; i < size; ++i) {
            JSONObject execPack = (JSONObject)param.get(i);
            JSONObject opResult = this.batchCreateOrderByOverHead(execPack, orm);
            result.set(i, (Object)opResult);
        }
        return result;
    }

    public JSONArray batchCreateManftechFromPageSeq(JSONArray param) {
        JSONObject returnJson;
        int size = param.size();
        JSONArray result = new JSONArray(size);
        ORM orm = ORM.create();
        ArrayList<DynamicObject> submitList = new ArrayList<DynamicObject>(2000);
        boolean iserror = false;
        for (int i = 0; i < size; ++i) {
            if (iserror) {
                returnJson = new JSONObject();
                returnJson.put("status", (Object)false);
                returnJson.put("msg", (Object)"");
                result.set(i, (Object)returnJson);
                continue;
            }
            JSONObject execPack = (JSONObject)param.get(i);
            JSONObject opResult = this.batchCreateManftech(execPack, orm, submitList);
            if (!opResult.getBooleanValue("status")) {
                iserror = true;
            }
            result.set(i, (Object)opResult);
        }
        if (iserror) {
            return result;
        }
        if (!submitList.isEmpty()) {
            HashSet<Long> allIDSet = new HashSet<Long>(16);
            returnJson = new JSONObject();
            if (!(returnJson = this.batchExecuteOrdersOp(submitList, null, null, null, orm, returnJson, allIDSet, "submit", false)).getBooleanValue("status")) {
                String errorString = returnJson.getString("msg");
                ArrayList sucessPkIds = new ArrayList(submitList.size());
                if (returnJson.containsKey((Object)"sucessPkIds")) {
                    Object success = returnJson.get((Object)"sucessPkIds");
                    if (success instanceof JSONArray) {
                        for (Object json : (JSONArray)success) {
                            sucessPkIds.add(json);
                        }
                    } else {
                        sucessPkIds = (ArrayList)returnJson.get((Object)"sucessPkIds");
                    }
                }
                return this.genAllErrorReturnArray(result, errorString, sucessPkIds, param);
            }
        }
        return result;
    }

    private JSONObject batchCreateManftech(JSONObject execPack, ORM orm, List<DynamicObject> submitList) {
        DynamicObject[] mroOrders;
        JSONObject returnJson = new JSONObject();
        JSONArray entry = execPack.getJSONArray("entryentity");
        int count = entry.size();
        HashMap<Long, String> pkPageSeqMaps = new HashMap<Long, String>(16);
        for (int i = 0; i < count; ++i) {
            JSONObject entryJson = (JSONObject)entry.get(i);
            Long orderId = entryJson.getLong("orderid");
            Object pageseq = entryJson.get((Object)"pageseq");
            if (null == pageseq) continue;
            pkPageSeqMaps.put(orderId, pageseq.toString());
        }
        Set pkValues = pkPageSeqMaps.keySet();
        DynamicObject mroOrder = ORM.create().newDynamicObject(MROORDERENTITYNUMBER);
        long startdate = System.currentTimeMillis();
        logger.info("batchCreateManftech begin load mroorder by  pkValues.....pkValues.size=" + pkValues.size());
        for (DynamicObject order : mroOrders = BusinessDataServiceHelper.load((Object[])pkValues.toArray(new Object[pkValues.size()]), (DynamicObjectType)mroOrder.getDynamicObjectType())) {
            if (!pkPageSeqMaps.containsKey(order.getPkValue())) continue;
            String pageSeq = (String)pkPageSeqMaps.get(order.getPkValue());
            DynamicObjectCollection colls = order.getDynamicObjectCollection("treeentryentity");
            DynamicObject workcard = ((DynamicObject)colls.get(0)).getDynamicObject("workcard");
            for (DynamicObject dyn : workcard.getDynamicObjectCollection("pageentity")) {
                if (!StringUtils.equals((CharSequence)pageSeq, (CharSequence)dyn.getString("pageseq"))) continue;
                ((DynamicObject)colls.get(0)).set("planhours", (Object)dyn.getBigDecimal("pagesumhours"));
            }
            ((DynamicObject)colls.get(0)).set("pageseq", (Object)pageSeq);
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("batchCreateManftech  begin load mroorder by  pkValues.....cost:" + enddate + "ms");
        returnJson.put("status", (Object)true);
        returnJson.put("msg", (Object)"");
        for (DynamicObject dy : mroOrders) {
            submitList.add(dy);
        }
        return returnJson;
    }

    private JSONObject batchCreateOrder(JSONObject execPack, ORM orm, DynamicObject transactype, DynamicObject billtype, DynamicObject codeDynamic, DynamicObject materialmftinfo, Map<Long, DynamicObject> orgMap, Map<Long, DynamicObject> projectMap, Map<String, Map<String, Object>> codeMap, DynamicObject doctype) {
        JSONObject returnJson = new JSONObject();
        Long packageid = execPack.getLong("packageid");
        returnJson.put("packageid", (Object)packageid);
        Long projectID = execPack.getLong("projectid");
        Long orgid = execPack.getLong("orgid");
        String workPackType = execPack.getString("workpacktype");
        DynamicObject orgdy = this.getOrg(orgid, orgMap);
        DynamicObject project = this.getProject(projectID, projectMap);
        JSONArray entry = execPack.getJSONArray("entryentity");
        int count = entry.size();
        long startdate = System.currentTimeMillis();
        logger.info("batchCreateOrder begin query workcard datas,count = " + count);
        HashSet<Long> cardIdSet = new HashSet<Long>(16);
        for (int i = 0; i < count; ++i) {
            JSONObject card = (JSONObject)entry.get(i);
            Long workcardID = card.getLong("workcardid");
            cardIdSet.add(workcardID);
        }
        Map cardMap = new HashMap(16);
        if (!cardIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", cardIdSet);
            cardMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (QFilter[])new QFilter[]{qFilter});
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("batchCreateOrder end query workcard datas,cardIdSet.size = " + cardIdSet.size() + ",cost:" + enddate + "ms");
        ArrayList<DynamicObject> saveOrdersList = new ArrayList<DynamicObject>(count);
        ArrayList<DynamicObject> submitOrdersList = new ArrayList<DynamicObject>(count);
        ArrayList<Long> allOrderIdList = new ArrayList<Long>(count);
        startdate = System.currentTimeMillis();
        Date currentDate = TimeServiceHelper.now();
        long[] genLongIds = orm.genLongIds(MROORDERENTITYNUMBER, count);
        for (int i = 0; i < count; ++i) {
            DynamicObjectCollection mulconditionexe;
            DynamicObjectCollection multypeid;
            DynamicObjectCollection mulworkarea;
            JSONObject card = (JSONObject)entry.get(i);
            Long workcardID = card.getLong("workcardid");
            DynamicObject workcardIDdy = (DynamicObject)cardMap.get(workcardID);
            if (workcardIDdy == null) {
                logger.info("batchCreateOrder workcardid not find cardDynamicObject,workcardID = " + workcardID);
                returnJson.put("status", (Object)false);
                returnJson.put("msg", (Object)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5de5\u5361\u6570\u636e\u4fe1\u606f\u3002", (String)"BatchCreateMroOrderImpl_4", (String)"mmc-pom-mservice", (Object[])new Object[0]));
                return returnJson;
            }
            DynamicObject order = BusinessDataServiceHelper.newDynamicObject((String)MROORDERENTITYNUMBER);
            Object pageseq = card.get((Object)"pageseq");
            order.set("id", (Object)genLongIds[i]);
            Object billno = card.get((Object)"billno");
            logger.info("batchCreateOrder  billno" + billno);
            if (ObjectUtils.isEmpty((Object)billno) && !"execworkpack".equals(workPackType)) {
                List genCodeRuleNumbers = MROOrderCodeRuleHelper.genCodeRuleNumbersByImmediately((DynamicObject)codeDynamic, (DynamicObject)project, (String)"", (int)1);
                billno = genCodeRuleNumbers.get(0);
            }
            order.set("billno", billno);
            order.set("org", (Object)orgdy);
            order.set("transactiontype", (Object)transactype);
            order.set("billdate", (Object)currentDate);
            order.set("entitytype", (Object)MROORDERENTITYNUMBER);
            order.set("isshowlist", (Object)Boolean.TRUE);
            order.set("billtype", (Object)billtype);
            order.set("billstatus", (Object)"A");
            order.set("numberautogen", (Object)Boolean.FALSE);
            DynamicObjectCollection entryentity = order.getDynamicObjectCollection("treeentryentity");
            DynamicObject row = new DynamicObject(entryentity.getDynamicObjectType());
            row.set("sourcebilltype", (Object)workPackType);
            row.set("sourcebillnumber", (Object)packageid);
            row.set("isfirstexe", (Object)card.getBoolean("isfirstexe"));
            row.set("isom", (Object)card.getBoolean("isom"));
            row.set("riskcard", (Object)card.getBoolean("riskcard"));
            row.set("ismajorwork", (Object)card.getBoolean("ismajorwork"));
            row.set("ispriority", (Object)card.getBoolean("ispriority"));
            Object paneldefids = card.get((Object)"paneldefids");
            if (ObjectUtils.isNotEmpty((Object)paneldefids)) {
                row.set("mulpaneldef", (Object)this.getMulBaseDataDyColl(MROORDERENTITYNUMBER, (List)paneldefids, "mulpaneldef", "mpdm_paneldef"));
            }
            row.set("project", (Object)project);
            row.set("customer", (Object)project.getDynamicObject("customer"));
            row.set("materielmtc", (Object)project.getDynamicObject("devices"));
            row.set("workcard", (Object)workcardIDdy);
            row.set("zone", (Object)workcardIDdy.getDynamicObject("zone"));
            row.set("area", (Object)workcardIDdy.getDynamicObject("workarea"));
            DynamicObjectCollection mulzone = workcardIDdy.getDynamicObjectCollection("mulzone");
            if (CollectionUtils.isNotEmpty((Collection)mulzone)) {
                row.set("mulzone", (Object)this.getMulBaseDataDyColl(MROORDERENTITYNUMBER, this.getPkValuesByMulData(mulzone), "mulzone", "mpdm_functionlocation"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(mulworkarea = workcardIDdy.getDynamicObjectCollection("mulworkarea")))) {
                row.set("mularea", (Object)this.getMulBaseDataDyColl(MROORDERENTITYNUMBER, this.getPkValuesByMulData(mulworkarea), "mularea", "mpdm_area"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(multypeid = workcardIDdy.getDynamicObjectCollection("typeidentity")))) {
                row.set("multypeid", (Object)this.getMulBaseDataDyColl(MROORDERENTITYNUMBER, this.getPkValuesByMulData(multypeid), "multypeid", "mpdm_typeidentity"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(mulconditionexe = workcardIDdy.getDynamicObjectCollection("mulconditionexe")))) {
                row.set("mulexecondition", (Object)this.getMulBaseDataDyColl(MROORDERENTITYNUMBER, this.getPkValuesByMulData(mulconditionexe), "mulexecondition", "mpdm_execondition"));
            }
            row.set("ata", (Object)workcardIDdy.getString("ata"));
            row.set("atatype", (Object)doctype);
            row.set("workstage", (Object)workcardIDdy.getDynamicObject("group"));
            row.set("maintrade", (Object)workcardIDdy.getDynamicObject("maintrade"));
            row.set("cardtitle", (Object)workcardIDdy.getString("cardname"));
            row.set("controlno", (Object)workcardIDdy.getString("businesscontrol"));
            row.set("isladder", (Object)workcardIDdy.getBoolean("ladder"));
            row.set("workhourunit", (Object)workcardIDdy.getDynamicObject("workunit"));
            row.set("resourcestatus", (Object)"B");
            if (ObjectUtils.isNotEmpty((Object)pageseq)) {
                row.set("pageseq", pageseq);
                for (DynamicObject dyn : workcardIDdy.getDynamicObjectCollection("pageentity")) {
                    if (!StringUtils.equals((CharSequence)((String)pageseq), (CharSequence)dyn.getString("pageseq"))) continue;
                    row.set("planhours", (Object)dyn.getBigDecimal("pagesumhours"));
                }
            }
            row.set("producttype", (Object)"C");
            row.set("material", (Object)materialmftinfo);
            row.set("unit", materialmftinfo.get("mftunit"));
            row.set("qty", (Object)1L);
            row.set("baseunit", materialmftinfo.get("mftunit"));
            row.set("baseqty", (Object)1L);
            row.set("planbegintime", (Object)currentDate);
            row.set("planendtime", (Object)currentDate);
            entryentity.add((Object)row);
            if (ObjectUtils.isNotEmpty((Object)pageseq) || ObjectUtils.isNotEmpty((Object)paneldefids)) {
                submitOrdersList.add(order);
            } else {
                saveOrdersList.add(order);
            }
            allOrderIdList.add(order.getLong("id"));
        }
        enddate = System.currentTimeMillis() - startdate;
        logger.info("batchCreateOrder end genOrderDatas,saveOrdersList.size = " + saveOrdersList.size() + ",submitOrdersList.size = " + submitOrdersList.size() + ",cost:" + enddate + "ms");
        returnJson.put("status", (Object)true);
        returnJson.put("saveOrdersList", saveOrdersList);
        returnJson.put("submitOrdersList", submitOrdersList);
        returnJson.put("allOrderIdList", allOrderIdList);
        returnJson.put("project", (Object)project);
        return returnJson;
    }

    private JSONObject batchCreateOrderByOverHead(JSONObject execPack, ORM orm) {
        logger.info("start batchCreateOrderByOverHead");
        JSONObject returnJson = new JSONObject();
        DynamicObject materialmftinfo = GetMROMaterialMFTInfo.readParam();
        if (materialmftinfo == null) {
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8d39\u7528\u7269\u6599", (String)"BatchCreateMroOrderImpl_6", (String)"mmc-pom-mservice", (Object[])new Object[0]));
            return returnJson;
        }
        Long projectID = execPack.getLong("projectid");
        Long orgid = execPack.getLong("orgid");
        DynamicObject orgdy = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org", (String)"id");
        DynamicObject billtype = BusinessDataServiceHelper.loadSingleFromCache((Object)1387624395492574208L, (String)"bos_billtype", (String)"id");
        DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectID, (String)"pmpd_project", (String)"id,sysproject,customer,devices,realfinshdate,prjstate,isspecial");
        QFilter qf = this.getDailyDefQFilter();
        Map dailyDefMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_dailyexptypedef", (QFilter[])new QFilter[]{qf});
        if (MapUtils.isEmpty((Map)dailyDefMap)) {
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u65e5\u5e38\u4efb\u52a1\u5b9a\u4e49", (String)"BatchCreateMroOrderImpl_1", (String)"mmc-pom-mservice", (Object[])new Object[0]));
            logger.info("batchCreateOrderByOverHead \u672a\u8bbe\u7f6e\u65e5\u5e38\u4efb\u52a1\u5b9a\u4e49.");
            return returnJson;
        }
        List<Long> dailyPkLists = this.getDailyPkByMroOrderList(orgid, projectID, dailyDefMap);
        int count = dailyDefMap.size();
        JSONArray returnArray = new JSONArray();
        long[] genLongIds = orm.genLongIds(MROORDERENTITYNUMBER, count);
        ArrayList<DynamicObject> newOrderColls = new ArrayList<DynamicObject>(16);
        int i = 0;
        for (DynamicObject value : dailyDefMap.values()) {
            DynamicObject transType = this.getTransactType(value, orgdy);
            if (null == transType) {
                logger.info("batchCreateOrderByOverHead \u65e5\u5e38\u4efb\u52a1\u5b9a\u4e49\u5bf9\u5e94\u7684\u4e1a\u52a1\u7c7b\u578b\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b.");
                continue;
            }
            if (dailyPkLists.contains((Long)value.getPkValue())) {
                logger.info(String.format("batchCreateOrderByOverHead \u5df2\u751f\u6210\u65e5\u5e38\u4efb\u52a1\u7c7b\u578b\u4e3a%s\u7684\u68c0\u4fee\u5de5\u5355.", value.get("name")));
                continue;
            }
            DynamicObject order = BusinessDataServiceHelper.newDynamicObject((String)MROORDERENTITYNUMBER);
            String orderno = value.getString("number") + project.getString("number");
            order.set("id", (Object)genLongIds[i]);
            order.set("billno", (Object)orderno);
            order.set("org", (Object)orgdy);
            order.set("transactiontype", (Object)transType);
            order.set("billdate", (Object)TimeServiceHelper.now());
            order.set("entitytype", (Object)MROORDERENTITYNUMBER);
            order.set("isshowlist", (Object)Boolean.TRUE);
            order.set("billtype", (Object)billtype);
            order.set("billstatus", (Object)"A");
            order.set("dailyexptype", (Object)value);
            DynamicObjectCollection entryentity = order.getDynamicObjectCollection("treeentryentity");
            DynamicObject row = new DynamicObject(entryentity.getDynamicObjectType());
            row.set("project", (Object)project);
            row.set("producttype", (Object)"C");
            row.set("material", (Object)materialmftinfo);
            row.set("unit", materialmftinfo.get("mftunit"));
            row.set("qty", (Object)1L);
            row.set("baseunit", materialmftinfo.get("mftunit"));
            row.set("baseqty", (Object)1L);
            row.set("planbegintime", (Object)TimeServiceHelper.now());
            row.set("planendtime", (Object)TimeServiceHelper.now());
            JSONObject returnObj = new JSONObject();
            returnObj.put("project", (Object)projectID);
            returnObj.put("orderno", (Object)orderno);
            returnObj.put("orderid", (Object)genLongIds[i]);
            returnArray.add(i, (Object)returnObj);
            entryentity.add((Object)row);
            newOrderColls.add(order);
            ++i;
        }
        if (CollectionUtils.isEmpty(newOrderColls)) {
            logger.info("batchCreateOrderByOverHead \u5931\u8d25.");
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u65e5\u5e38\u4efb\u52a1\u5b9a\u4e49\u5df2\u5168\u90e8\u751f\u6210\u68c0\u4fee\u5de5\u5355", (String)"BatchCreateMroOrderImpl_3", (String)"mmc-pom-mservice", (Object[])new Object[0]));
            return returnJson;
        }
        DynamicObject[] newOrders = new DynamicObject[newOrderColls.size()];
        for (int t = 0; t < newOrderColls.size(); ++t) {
            newOrders[t] = (DynamicObject)newOrderColls.get(t);
        }
        OperateOption option = OperateOption.create();
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)MROORDERENTITYNUMBER, (DynamicObject[])newOrders, (OperateOption)option);
        if (!saveOperate.isSuccess()) {
            logger.info(String.format("batchCreateOrderByOverHead \u5931\u8d25%s", OrderOpUtils.getErrDetail((OperationResult)saveOperate)));
            returnJson.put("entryentity", (Object)returnArray);
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)(saveOperate.getMessage() + OrderOpUtils.getErrDetail((OperationResult)saveOperate)));
            return returnJson;
        }
        logger.info("batchCreateOrderByOverHead \u6210\u529f.");
        returnJson.put("status", (Object)true);
        returnJson.put("entryentity", (Object)returnArray);
        return returnJson;
    }

    private List<Long> getDailyPkByMroOrderList(Long orgid, Long projectID, Map<Object, DynamicObject> dailyDefMap) {
        ArrayList<Long> dailyPkList = new ArrayList<Long>(16);
        ArrayList<Long> pkValues = new ArrayList<Long>(16);
        for (DynamicObject obj : dailyDefMap.values()) {
            pkValues.add((Long)obj.getPkValue());
        }
        QFilter qf = new QFilter("org", "=", (Object)orgid);
        qf.and(new QFilter("treeentryentity.project", "=", (Object)projectID));
        qf.and(new QFilter("dailyexptype", "in", pkValues));
        DataSet result = QueryServiceHelper.queryDataSet((String)"queryMroOrder", (String)MROORDERENTITYNUMBER, (String)"dailyexptype", (QFilter[])new QFilter[]{qf}, null);
        while (result.hasNext()) {
            Row row = result.next();
            Object dailyObj = row.get("dailyexptype");
            if (null == dailyObj) continue;
            dailyPkList.add((Long)dailyObj);
        }
        return dailyPkList;
    }

    private DynamicObject getTransactType(DynamicObject value, DynamicObject orgdy) {
        DynamicObject affairtype = value.getDynamicObject("affairtype");
        if (null == affairtype) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)affairtype.getPkValue(), (String)"mpdm_transactproduct");
    }

    private QFilter getDailyDefQFilter() {
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        qf.and("status", "=", (Object)"C");
        qf.and("type", "=", (Object)"A");
        return qf;
    }

    private List<Object> getPkValuesByMulData(DynamicObjectCollection mulDatas) {
        ArrayList<Object> pkValues = new ArrayList<Object>(16);
        if (CollectionUtils.isEmpty((Collection)mulDatas)) {
            return pkValues;
        }
        for (DynamicObject mulData : mulDatas) {
            pkValues.add(mulData.getLong("fbasedataid_id"));
        }
        return pkValues;
    }

    private DynamicObjectCollection getMulBaseDataDyColl(String entityName, List<Object> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObject paySchDy = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectCollection entryentity = paySchDy.getDynamicObjectCollection("treeentryentity");
        DynamicObject row = new DynamicObject(entryentity.getDynamicObjectType());
        DynamicObjectCollection dyColl = row.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (int i = 0; i < fieldValueIds.size(); ++i) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)mulBasedataEntity);
            payBizActDy.set("id", fieldValueIds.get(i));
            mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    private JSONObject batchExecuteOrdersOp(List<DynamicObject> ordersList, DynamicObject transactionType, DynamicObject codeDynamic, DynamicObject project, ORM orm, JSONObject returnJson, Set<Long> allIDSet, String operationType, boolean isTotalError) {
        returnJson.put("status", (Object)true);
        returnJson.put("msg", (Object)"");
        String errorString = "";
        try {
            OperateOption option = OrderClearLockUtils.getOperateOption();
            DynamicObject[] mroOrders = ordersList.toArray(new DynamicObject[ordersList.size()]);
            OperationResult submitOperate = OperationServiceHelper.executeOperate((String)operationType, (String)MROORDERENTITYNUMBER, (DynamicObject[])mroOrders, (OperateOption)option);
            List sucessPkIds = submitOperate.getSuccessPkIds();
            if (!submitOperate.isSuccess()) {
                if (submitOperate.getMessage() != null) {
                    errorString = submitOperate.getMessage();
                }
                logger.info(String.format("MroOrderSubmitOpTask begin\u68c0\u4fee\u5de5\u5355\u5931\u8d25%s", errorString));
                String errDetail = OrderOpUtils.getErrDetail((OperationResult)submitOperate);
                if (StringUtils.isNotEmpty((CharSequence)errDetail)) {
                    errorString = errDetail;
                }
                logger.info("MroOrderSubmitOpTask \u64cd\u4f5c\uff1a" + operationType);
                logger.info(String.format("MroOrderSubmitOpTask \u68c0\u4fee\u5de5\u5355\u5931\u8d25%s", errDetail));
                returnJson.put("status", (Object)false);
                returnJson.put("sucessPkIds", (Object)sucessPkIds);
                returnJson.put("msg", (Object)errorString);
                returnJson.put("billList", ordersList);
            } else {
                returnJson.put("status", (Object)true);
                returnJson.put("msg", (Object)"");
                returnJson.put("billList", ordersList);
                returnJson.put("sucessPkIds", (Object)sucessPkIds);
            }
        }
        catch (Exception e) {
            logger.info("batchExecuteOrdersOp Exception ", (Object)e);
            errorString = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : (e.getMessage() == null ? "" : e.getMessage());
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)errorString);
        }
        boolean status = returnJson.getBooleanValue("status");
        if (!status) {
            errorString = returnJson.getString("msg");
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)errorString);
        }
        if (project != null) {
            returnJson.put("project", (Object)project);
        }
        return returnJson;
    }

    private void initSuccDataSet(Set<Long> savedIDSet, Set<String> savedBillnoSet, List<DynamicObject> subList) {
        int size = subList.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dy = subList.get(i);
            Long id = dy.getLong("id");
            String billno = dy.getString("billno");
            if (id != null && !id.equals(0L)) {
                savedIDSet.add(id);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)billno)) continue;
            savedBillnoSet.add(billno);
        }
    }

    private Map<Long, String> getOrderBillnoMap(List<Long> allIDList) {
        SqlBuilder bf = new SqlBuilder();
        HashMap<Long, String> billnoMap = new HashMap<Long, String>(allIDList.size());
        bf.append(" Select fid,fbillno from t_pom_mroorder where ", new Object[0]);
        bf.appendIn("fid", allIDList.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-batchSave-getOrderBillnoMap", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                billnoMap.put(row.getLong("fid"), row.getString("fbillno"));
            }
        }
        return billnoMap;
    }

    private String deleteOrders(Set<Long> allIDSet) {
        return OrderClearLockUtils.deleteOrders(allIDSet);
    }

    private String recycleOrderNumbers(Map<String, Map<String, Object>> codeMap) {
        return "";
    }

    private String rollbackDatas(Map<String, Map<String, Object>> codeMap, Set<Long> savedIDSet) {
        logger.info("---------------- begin execute rollbackDatas ------------------");
        String error1 = "";
        try {
            error1 = this.deleteOrders(savedIDSet);
            logger.info("---------------- rollbackDatas  deleteOrders ok" + savedIDSet.toString());
        }
        catch (Exception e) {
            error1 = this.getErrorString(e);
            logger.info("rollbackDatas deleteOrders error: " + error1);
            try {
                OrderClearLockUtils.deleteOrdersByDB(savedIDSet);
            }
            catch (Exception e1) {
                error1 = error1 + "_" + this.getErrorString(e1);
                logger.info("rollbackDatas deleteOrdersByDB error: " + error1);
            }
        }
        String error2 = "";
        if (codeMap != null && !codeMap.isEmpty()) {
            try {
                logger.info("---------------- rollbackDatas begin recycleOrderNumbers,codeMap =" + codeMap.toString());
                error2 = this.recycleOrderNumbers(codeMap);
            }
            catch (Exception e) {
                error2 = this.getErrorString(e);
                logger.info("rollbackDatas recycleOrderNumbers error: " + error2);
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)error1)) {
            return error2;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)error2)) {
            return error1;
        }
        return error1 + " " + error2;
    }

    private int getThreadCount() {
        DynamicObject billParameter = ParameterReader.getBillParameter((String)MROORDERENTITYNUMBER);
        int threadCount = billParameter.getInt("createorderthreadcount");
        if (threadCount == 0) {
            threadCount = 1;
        }
        logger.info("getThreadCount = " + threadCount);
        return threadCount;
    }

    private String getErrorString(Exception e) {
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            return e.getCause().getMessage();
        }
        return e.getMessage() == null ? "" : e.getMessage();
    }

    private int getTimes(int allCount, int batchCount) {
        int times = allCount / batchCount;
        if (allCount % batchCount > 0) {
            ++times;
        }
        return times;
    }

    private int getBatchCount(int allCount, int threadCount) {
        if (allCount <= threadCount) {
            return 1;
        }
        int times = this.getTimes(allCount, threadCount);
        if (times >= 100) {
            return 100;
        }
        return times;
    }

    private DynamicObject getProject(Long id, Map<Long, DynamicObject> cacheMap) {
        DynamicObject datas = cacheMap.get(id);
        if (datas == null) {
            datas = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pmpd_project", (String)"id,sysproject,customer,devices,realfinshdate,prjstate,isspecial");
            cacheMap.put(id, datas);
        }
        return datas;
    }

    private DynamicObject getOrg(Long id, Map<Long, DynamicObject> cacheMap) {
        DynamicObject datas = cacheMap.get(id);
        if (datas == null) {
            datas = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_org", (String)"id");
            cacheMap.put(id, datas);
        }
        return datas;
    }

    private void addToAllOrder(List<DynamicObject> newOrdersList, Map<Long, List<DynamicObject>> allOrdersListMap, DynamicObject project) {
        if (newOrdersList == null || newOrdersList.isEmpty()) {
            return;
        }
        Long projectID = project.getLong("id");
        List<DynamicObject> subList = allOrdersListMap.get(projectID);
        if (subList == null) {
            subList = new ArrayList<DynamicObject>(2000);
        }
        subList.addAll(newOrdersList);
        allOrdersListMap.put(projectID, subList);
    }

    private DynamicObject getOrderFromMap(Long orderID, Map<Long, List<DynamicObject>> allSaveOrdersListMap, Map<Long, List<DynamicObject>> allSubmitOrdersListMap, DynamicObject project) {
        DynamicObject dy;
        int i;
        Long projectID = project.getLong("id");
        List<DynamicObject> subList = allSaveOrdersListMap.get(projectID);
        if (subList != null && !subList.isEmpty()) {
            for (i = 0; i < subList.size(); ++i) {
                dy = subList.get(i);
                if (!orderID.equals(dy.getLong("id"))) continue;
                return dy;
            }
        }
        if ((subList = allSubmitOrdersListMap.get(projectID)) != null && !subList.isEmpty()) {
            for (i = 0; i < subList.size(); ++i) {
                dy = subList.get(i);
                if (!orderID.equals(dy.getLong("id"))) continue;
                return dy;
            }
        }
        return null;
    }

    private JSONArray genErrorReturnArray(JSONArray result, JSONArray param, String msgerror) {
        int size = param.size();
        for (int i = 0; i < size; ++i) {
            JSONObject execPack = (JSONObject)param.get(i);
            JSONObject returnJson = new JSONObject();
            returnJson.put("status", (Object)false);
            returnJson.put("msg", (Object)msgerror);
            returnJson.put("packageid", (Object)execPack.getLong("packageid"));
            result.set(i, (Object)returnJson);
        }
        return result;
    }

    private JSONArray genAllErrorReturnArray(JSONArray result, String msgerror) {
        for (int i = 0; i < result.size(); ++i) {
            JSONObject opResult = result.getJSONObject(i);
            opResult.put("status", (Object)false);
            opResult.put("msg", (Object)msgerror);
        }
        return result;
    }

    private JSONArray genAllErrorReturnArray(JSONArray result, String msgerror, List<Object> sucessPkIds, JSONArray param) {
        for (int i = 0; i < result.size(); ++i) {
            JSONObject opResult = result.getJSONObject(i);
            opResult.put("status", (Object)false);
            opResult.put("msg", (Object)msgerror);
            JSONObject execPack = (JSONObject)param.get(i);
            JSONArray entry = execPack.getJSONArray("entryentity");
            int count = entry.size();
            ArrayList<Long> currentSucessPkIds = new ArrayList<Long>(count);
            for (int j = 0; j < count; ++j) {
                JSONObject entryJson = (JSONObject)entry.get(j);
                Long orderId = entryJson.getLong("orderid");
                if (!sucessPkIds.contains(orderId)) continue;
                currentSucessPkIds.add(orderId);
            }
            opResult.put("sucessPkIds", currentSucessPkIds);
        }
        return result;
    }

    private boolean isSubmit(String operationType) {
        return "submit".equals(operationType);
    }

    private boolean isNullList(List aList) {
        return OrderClearLockUtils.isNullList((List)aList);
    }

    private void clearLockData(List<Long> idLongList, String entityNumber) {
        OrderClearLockUtils.clearLockData(idLongList, (String)entityNumber);
    }

    private List<String> toListString(List<Long> longList) {
        return OrderClearLockUtils.toListString(longList);
    }
}

