/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;
import kd.mmc.pom.mservice.api.IMroOrderCodeRuleService;

public class MroOrderCodeRuleServiceImpl
implements IMroOrderCodeRuleService {
    private static final Log logger = LogFactory.getLog(MroOrderCodeRuleServiceImpl.class);

    public DynamicObject getTransactionTypeCodeMode(Long transID) {
        logger.info("MroOrderCodeRuleServiceImpl---transID--" + transID);
        return MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)transID);
    }

    public List<String> genCodeRuleNumbers(Long projectid, String sourceBillNo, int count) {
        logger.info("genCodeRuleNumbers----projectid--" + projectid + "--sourceBillNo--" + sourceBillNo + "--count--" + count);
        DynamicObject transCodeDynamicObj = MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)1387752287631338496L);
        logger.info("genCodeRuleNumbers----transCodeDynamicObj--" + transCodeDynamicObj);
        DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectid, (String)"pmpd_project", (String)"id,sysproject,customer,devices,realfinshdate,prjstate,isspecial");
        logger.info("genCodeRuleNumbers----project--" + project);
        List genCodeRuleNumbers = MROOrderCodeRuleHelper.genCodeRuleNumbers((DynamicObject)transCodeDynamicObj, (DynamicObject)project, (String)sourceBillNo, (int)count);
        logger.info("genCodeRuleNumbers----genCodeRuleNumbers--" + genCodeRuleNumbers);
        return genCodeRuleNumbers;
    }

    public List<String> genCodeRuleNumbersByImmediately(Long projectid, String sourceBillNo, int count) {
        logger.info("genCodeRuleNumbersByImmediately----projectid--" + projectid + "--sourceBillNo--" + sourceBillNo + "--count--" + count);
        DynamicObject transCodeDynamicObj = MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)1387752287631338496L);
        logger.info("genCodeRuleNumbersByImmediately----transCodeDynamicObj--" + transCodeDynamicObj);
        DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectid, (String)"pmpd_project", (String)"id,sysproject,customer,devices,realfinshdate,prjstate,isspecial");
        logger.info("genCodeRuleNumbersByImmediately----project--" + project);
        List genCodeRuleNumbers = MROOrderCodeRuleHelper.genCodeRuleNumbersByImmediately((DynamicObject)transCodeDynamicObj, (DynamicObject)project, (String)sourceBillNo, (int)count);
        logger.info("genCodeRuleNumbersByImmediately----genCodeRuleNumbers--" + genCodeRuleNumbers);
        return genCodeRuleNumbers;
    }

    public void recycleCodeRuleNumbers(DynamicObject transCodeDynamicObj, String projectKeys, Set<String> codeSet) {
        logger.info("recycleCodeRuleNumbers---transCodeDynamicObj--" + transCodeDynamicObj + "--projectKeys--" + projectKeys + "--codeSet--" + codeSet);
        MROOrderCodeRuleHelper.recycleCodeRuleNumbers((DynamicObject)transCodeDynamicObj, (String)projectKeys, codeSet);
    }

    public void updateOrderNumbers(Map<String, String> updateData) {
        if (updateData == null || updateData.isEmpty()) {
            logger.info("updateOrderNumbers----param is empty");
            return;
        }
        logger.info("updateOrderNumbers----update count:" + updateData.size());
        String orderSql = "update t_pom_mroorder set fbillno=? where fbillno=?";
        String orderEntrySql = "update t_pom_mroorderentry set fheadbillno=? where fheadbillno=?";
        String stockSql = "update t_pom_mrostock set forderno=? where forderno=?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<String, String> data : updateData.entrySet()) {
            String oldNumber = data.getKey();
            String newNumber = data.getValue();
            Object[] update = new Object[]{newNumber, oldNumber};
            updateList.add(update);
        }
        DBRoute route = DBRoute.of((String)"scm");
        DB.executeBatch((DBRoute)route, (String)orderSql, updateList);
        DB.executeBatch((DBRoute)route, (String)orderEntrySql, updateList);
        DB.executeBatch((DBRoute)route, (String)stockSql, updateList);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("appId", "pom");
        param.put("updateData", updateData);
        String jsonString = JSON.toJSONString(param);
        EventServiceHelper.triggerEventSubscribe((String)"pom_mroorder.updateordernumber", (String)jsonString);
    }
}

