/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.mservice.api.IMroOrderQureyTypeService;

public class MroOrderQueryTypeServiceImpl
implements IMroOrderQureyTypeService {
    private static final Log logger = LogFactory.getLog(MroOrderQueryTypeServiceImpl.class);
    private static final int MAXBATCHSAVECOUNT = 1000;
    private static final String POM_MROORDER = "pom_mroorder";
    private static final String POM_MROSWS = "pom_mrosws";

    public Map<Long, Map<String, String>> queryOrderType(Set<Long> idSet) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        logger.info("queryOrderType----start----");
        logger.info("queryOrderType----idSet.size()---" + idSet.size());
        if (idSet == null || idSet.isEmpty()) {
            return resultMap;
        }
        HashSet<Long> querySet = new HashSet<Long>(1000);
        for (Long id : idSet) {
            querySet.add(id);
            if (querySet.size() < 1000) continue;
            this.loadOrderTypeData(resultMap, querySet);
            querySet = new HashSet(1000);
        }
        if (!querySet.isEmpty()) {
            this.loadOrderTypeData(resultMap, querySet);
        }
        logger.info("queryOrderType----resultMap----" + resultMap);
        logger.info("queryOrderType----end----");
        return resultMap;
    }

    private void loadOrderTypeData(Map<Long, Map<String, String>> resultMap, Set<Long> querySet) {
        QFilter qf = new QFilter("id", "in", querySet);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)POM_MROORDER, (String)"id,mroordertypeid,mroswsid", (QFilter[])new QFilter[]{qf});
        logger.info("queryOrderType----loadOrderTypeData----" + loadFromCache);
        Map<Long, String> subJobTypeMap = this.getSubJobType(loadFromCache);
        for (Map.Entry mroMap : loadFromCache.entrySet()) {
            HashMap<String, String> mMap = new HashMap<String, String>(2);
            DynamicObject mroorder = (DynamicObject)mroMap.getValue();
            Long orderId = mroorder.getLong("id");
            DynamicObject mroordertypeid = mroorder.getDynamicObject("mroordertypeid");
            if (mroordertypeid == null) {
                mMap.put("type", "OTHER");
            } else {
                String number;
                switch (number = mroordertypeid.getString("number")) {
                    case "BASICJOB_S": 
                    case "INNERJOB_S": 
                    case "PANELJOB_S": 
                    case "SPECJOB_S": {
                        mMap.put("type", "RTN");
                        break;
                    }
                    case "NRCJOB_S": {
                        mMap.put("type", "NRC");
                        break;
                    }
                    case "DUMMYJOB_S": {
                        mMap.put("type", "DUMMY");
                        break;
                    }
                    case "OTHERJOB_S": {
                        mMap.put("type", "OTHER");
                        break;
                    }
                    case "OVERHEADJOB_S": {
                        mMap.put("type", "OVERHEAD");
                        break;
                    }
                    case "SUBJOB_S": {
                        mMap.put("type", "SUB");
                        if (!subJobTypeMap.containsKey(orderId)) break;
                        mMap.put("subtype", subJobTypeMap.get(orderId));
                        break;
                    }
                }
            }
            resultMap.put(orderId, mMap);
        }
    }

    private Map<Long, String> getSubJobType(Map<Object, DynamicObject> loadFromCache) {
        HashMap<Long, String> subJogOrderMap = new HashMap<Long, String>(16);
        HashSet<Long> subsrcidSet = new HashSet<Long>(16);
        HashMap<Long, Long> subsrcidMap = new HashMap<Long, Long>(16);
        for (Map.Entry<Object, DynamicObject> mroMap1 : loadFromCache.entrySet()) {
            String number;
            DynamicObject mroorder = mroMap1.getValue();
            Long orderId = mroorder.getLong("id");
            Long mroswsid = mroorder.getLong("mroswsid");
            DynamicObject mroordertypeid = mroorder.getDynamicObject("mroordertypeid");
            if (mroordertypeid == null || !"SUBJOB_S".equals(number = mroordertypeid.getString("number"))) continue;
            subsrcidSet.add(mroswsid);
            subsrcidMap.put(orderId, mroswsid);
        }
        HashSet<Long> srcidSet = new HashSet<Long>(16);
        HashMap<Long, Long> srcidMap = new HashMap<Long, Long>(16);
        if (!subsrcidSet.isEmpty()) {
            QFilter qfsws = new QFilter("id", "in", subsrcidSet);
            Map swsLoadCache = BusinessDataServiceHelper.loadFromCache((String)POM_MROSWS, (String)"id,srcbillid", (QFilter[])new QFilter[]{qfsws});
            for (Map.Entry mroMap : swsLoadCache.entrySet()) {
                DynamicObject sws = (DynamicObject)mroMap.getValue();
                Long srcbillid = sws.getLong("srcbillid");
                Long swsid = sws.getLong("id");
                srcidSet.add(srcbillid);
                srcidMap.put(srcbillid, swsid);
            }
        }
        if (!srcidSet.isEmpty()) {
            QFilter qf2 = new QFilter("id", "in", srcidSet);
            Map loadFromCache2 = BusinessDataServiceHelper.loadFromCache((String)POM_MROORDER, (String)"id,mroordertypeid,mroswsid", (QFilter[])new QFilter[]{qf2});
            for (Map.Entry mroMap2 : loadFromCache2.entrySet()) {
                String number;
                DynamicObject mroorder2 = (DynamicObject)mroMap2.getValue();
                DynamicObject mroordertypeid = mroorder2.getDynamicObject("mroordertypeid");
                Long id = mroorder2.getLong("id");
                if (mroordertypeid == null) {
                    subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "OTHER");
                    continue;
                }
                switch (number = mroordertypeid.getString("number")) {
                    case "BASICJOB_S": 
                    case "INNERJOB_S": 
                    case "PANELJOB_S": 
                    case "SPECJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "RTN");
                        break;
                    }
                    case "NRCJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "NRC");
                        break;
                    }
                    case "DUMMYJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "DUMMY");
                        break;
                    }
                    case "OTHERJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "OTHER");
                        break;
                    }
                    case "OVERHEADJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "OVERHEAD");
                        break;
                    }
                    case "SUBJOB_S": {
                        subJogOrderMap.put(this.getSubJobId(id, srcidMap, subsrcidMap), "SUB");
                        break;
                    }
                }
            }
        }
        return subJogOrderMap;
    }

    private Long getSubJobId(Long id, Map<Long, Long> srcidMap, Map<Long, Long> subsrcidMap) {
        if (srcidMap.containsKey(id)) {
            Long swsid = srcidMap.get(id);
            for (Map.Entry<Long, Long> subsrc : subsrcidMap.entrySet()) {
                Long value = subsrc.getValue();
                if (!swsid.equals(value)) continue;
                return subsrc.getKey();
            }
        }
        return 0L;
    }

    public Map<Long, Integer> countMroOrder(Set<Long> idSet) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(16);
        HashSet typeSet = Sets.newHashSet((Object[])new Long[]{1568897944227163136L, 1549848051215020032L});
        QFilter orderqf = new QFilter("entitytype", "=", (Object)POM_MROORDER);
        orderqf.or(new QFilter("entitytype", "!=", (Object)POM_MROORDER).and("billstatus", "=", (Object)"C"));
        QFilter orderqf2 = new QFilter("treeentryentity.project", "in", idSet);
        QFilter orderqf3 = new QFilter("mroordertypeid", "not in", (Object)typeSet);
        orderqf2.and(orderqf).and(orderqf3);
        DataSet dSet = QueryServiceHelper.queryDataSet((String)"servicequery_pom_mroorder", (String)POM_MROORDER, (String)"id,treeentryentity.project", (QFilter[])new QFilter[]{orderqf2}, (String)"");
        DataSet dataSet = dSet.groupBy(new String[]{"treeentryentity.project"}).count("treeentryentity.project").finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object object = row.get(0);
            Object object2 = row.get(1);
            Integer count = Integer.valueOf(object2.toString());
            Long project = Long.valueOf(object.toString());
            resultMap.put(project, count);
        }
        dSet.close();
        dataSet.close();
        return resultMap;
    }
}

