/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PomRptTransUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PomRptTransUpgradeServiceImpl.class);
    private DBRoute scmRoute = new DBRoute("scm");
    private static final String[] dataSetFileds = new String[]{"fid", "mftid", "fentryid"};
    private static final String[] mftEntryFileds = new String[]{"mftid", "fentryid"};
    private static final String[] rptEFileds = new String[]{"fid"};
    private static final String[] mftFileds = new String[]{"ftransactiontype"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DataSet dataSet_rpt;
        UpgradeResult result = new UpgradeResult();
        String algoKey_rpt = "query-rpt";
        String sql_rpt = "select count(1) as count from t_pom_mftorderreport where ftransactiontypeid = 0 or ftransactiontypeid is null";
        try (DataSet countSet = DB.queryDataSet((String)algoKey_rpt, (DBRoute)this.scmRoute, (String)sql_rpt);){
            while (countSet.hasNext()) {
                Row next = countSet.next();
                Integer count = next.getInteger("count");
                if (count != 0) continue;
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
        }
        DataSet copy = dataSet_rpt = this.getRptDataSet();
        int batchSize = 100000;
        int rowCount = 0;
        ArrayList<Long> fids = new ArrayList<Long>(batchSize);
        while (copy.hasNext()) {
            Row next = copy.next();
            Long fid = next.getLong("fid");
            fids.add(fid);
            if (++rowCount < batchSize) continue;
            this.doUpdate(fids);
            fids.clear();
            rowCount = 0;
        }
        if (rowCount > 0) {
            this.doUpdate(fids);
            fids.clear();
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void doUpdate(List<Long> fids) {
        DataSet dataSet_rptEntry = this.getRptEntryDataSet(fids);
        Set<Long> fmftentryids = this.getMftEntryIds(dataSet_rptEntry);
        DataSet dataSet_MftEntry = this.getMftEntryDataSet(fmftentryids);
        Set<Long> mftIds = this.getMftIds(dataSet_MftEntry);
        DataSet dataSet_Mft = this.getMftDataSet(mftIds);
        DataSet dataSet = dataSet_rptEntry.join(dataSet_MftEntry).select(rptEFileds, mftEntryFileds).on("fmftentryid", "fentryid").finish();
        dataSet = dataSet.join(dataSet_Mft).select(dataSetFileds, mftFileds).on("mftid", "fid").finish();
        dataSet = dataSet.distinct();
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Long repId = next.getLong("fid");
            Long transId = next.getLong("ftransactiontype");
            Object[] param = new Object[]{transId, repId};
            params.add(param);
        }
        if (!params.isEmpty()) {
            String updateSql = "update t_pom_mftorderreport set ftransactiontypeid = ? where fid = ?";
            DB.executeBatch((DBRoute)this.scmRoute, (String)updateSql, params);
        }
    }

    private Set<Long> getMftIds(DataSet dataSet_MftEntry) {
        DataSet dataSet_MftEntryCopy = dataSet_MftEntry.copy();
        HashSet<Long> mftIds = new HashSet<Long>(16);
        while (dataSet_MftEntryCopy.hasNext()) {
            Row next = dataSet_MftEntryCopy.next();
            Long mftId = next.getLong("mftid");
            mftIds.add(mftId);
        }
        return mftIds;
    }

    private Set<Long> getMftEntryIds(DataSet dataSet_rptEntry) {
        DataSet dataSet_rptEntryCopy = dataSet_rptEntry.copy();
        HashSet<Long> fmftentryids = new HashSet<Long>(16);
        while (dataSet_rptEntryCopy.hasNext()) {
            Row next = dataSet_rptEntryCopy.next();
            Long fmftentryid = next.getLong("fmftentryid");
            fmftentryids.add(fmftentryid);
        }
        return fmftentryids;
    }

    private DataSet getMftDataSet(Set<Long> mftIds) {
        String algoKey = "query-rpt";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fid ,ftransactiontype from t_pom_mftorder where ", new Object[0]);
        if (mftIds.isEmpty()) {
            sb.append(" 1!=1 ", new Object[0]);
        } else {
            sb.appendIn("fid", mftIds.toArray());
        }
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)this.scmRoute, (SqlBuilder)sb);
        return dataSet;
    }

    private DataSet getMftEntryDataSet(Set<Long> fmftentryids) {
        String algoKey = "query-rpt";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fid mftid ,fentryid from t_pom_mftorderentry where ", new Object[0]);
        if (fmftentryids.isEmpty()) {
            sb.append(" 1!=1 ", new Object[0]);
        } else {
            sb.appendIn("fentryid", fmftentryids.toArray());
        }
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)this.scmRoute, (SqlBuilder)sb);
        return dataSet;
    }

    private DataSet getRptEntryDataSet(List<Long> fids) {
        String algoKey = "query-rpt";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select fid ,fmftentryid from t_pom_mftreportsummary where ", new Object[0]);
        if (fids.isEmpty()) {
            sb.append(" 1!=1 ", new Object[0]);
        } else {
            sb.appendIn("fid", fids.toArray());
        }
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)this.scmRoute, (SqlBuilder)sb);
        dataSet = dataSet.select("fid,Long(fmftentryid) fmftentryid");
        return dataSet;
    }

    private DataSet getRptDataSet() {
        String algoKey = "query-rpt";
        String sql = "select fid from t_pom_mftorderreport where ftransactiontypeid = 0 or ftransactiontypeid is null";
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)this.scmRoute, (String)sql);
        return dataSet;
    }
}

