/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.mservice.upgrade.entity.SubinStorageEntity;
import org.apache.commons.collections4.CollectionUtils;

public class Qualityorg4PomOrderUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(Qualityorg4PomOrderUpgradeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DataSet srcEntryId = null;
        try {
            Object subinStorageEntity;
            String sql = "select distinct a.fentryid,ra.fqualityorg,a.forgid from (select m.fid,m.fentryid,p.forgid  from t_pom_mftorderentry as m,t_pom_mftorderentry_e as me,t_pom_mftorder p \r\nwhere m.fqualityorg is null and m.fentryid = me.fentryid and me.fisinspection = '1' and m.fid = p.fid) a left join t_pom_mftreportsummary as r on DECIMAL (r.fmftentryid,23,0)=a.fentryid left join t_pom_mftreportsummary_a ra on r.fentryid = ra.fentryid;";
            srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
            ArrayList<SubinStorageEntity> detailIds = new ArrayList<SubinStorageEntity>(10);
            HashSet<Long> ids = new HashSet<Long>(16);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                subinStorageEntity = new SubinStorageEntity();
                ((SubinStorageEntity)subinStorageEntity).setManufactureEntryId(row.getLong("fentryid"));
                ((SubinStorageEntity)subinStorageEntity).setOrg(row.getLong("forgid"));
                ((SubinStorageEntity)subinStorageEntity).setQualityorg(row.getLong("fqualityorg"));
                detailIds.add((SubinStorageEntity)subinStorageEntity);
                ids.add(row.getLong("fentryid"));
            }
            result.setLog(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u6765\u6570\u636esize %1$s", (String)"Qualityorg4PomOrderUpgradeServiceImpl_4", (String)"mmc-pom-mservice", (Object[])new Object[0]), detailIds.size()));
            ArrayList<SubinStorageEntity> updates = new ArrayList<SubinStorageEntity>(10);
            subinStorageEntity = ids.iterator();
            while (subinStorageEntity.hasNext()) {
                long id = (Long)subinStorageEntity.next();
                SubinStorageEntity subinStorageEntity2 = new SubinStorageEntity();
                long orgId = 0L;
                long qualityorgId = 0L;
                for (SubinStorageEntity detailId : detailIds) {
                    long qualityorg;
                    long entryId = detailId.getManufactureEntryId();
                    if (id != entryId) continue;
                    if (orgId == 0L && 0L != detailId.getOrg()) {
                        orgId = detailId.getOrg();
                    }
                    if (orgId == (qualityorg = detailId.getQualityorg().longValue())) {
                        qualityorgId = qualityorg;
                        break;
                    }
                    if (qualityorgId != 0L || qualityorg == 0L) continue;
                    qualityorgId = qualityorg;
                }
                if (0L != orgId && 0L == qualityorgId) {
                    qualityorgId = orgId;
                }
                subinStorageEntity2.setManufactureEntryId(id);
                subinStorageEntity2.setQualityorg(qualityorgId);
                updates.add(subinStorageEntity2);
            }
            result.setLog(String.format(ResManager.loadKDString((String)"\u9700\u8981\u66f4\u65b0\u6570\u636esize %1$s", (String)"Qualityorg4PomOrderUpgradeServiceImpl_5", (String)"mmc-pom-mservice", (Object[])new Object[0]), updates.size()));
            String updateInvTypeSql = "update t_pom_mftorderentry set fqualityorg = ? where fentryid = ?";
            ArrayList paramsList = new ArrayList(10);
            updates.forEach(var -> paramsList.add(new Object[]{var.getQualityorg(), var.getManufactureEntryId()}));
            result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u7684size %1$s", (String)"Qualityorg4PomOrderUpgradeServiceImpl_6", (String)"mmc-pom-mservice", (Object[])new Object[0]), paramsList.size()));
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u5207\u5272\u540e\u7684size %1$s", (String)"Qualityorg4PomOrderUpgradeServiceImpl_7", (String)"mmc-pom-mservice", (Object[])new Object[0]), partition.size()));
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.setLog(e.toString());
            result.setSuccess(false);
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
        finally {
            if (null != srcEntryId) {
                srcEntryId.close();
            }
        }
        result.setSuccess(true);
        return result;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"QtyUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

