/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.mservice.upgrade.entity.SubinStorageEntity;
import org.apache.commons.collections4.CollectionUtils;

public class SplitOrderUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SplitOrderUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        try (DataSet srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"select a.forderentryid,b.fsplitqty,b.fsplitbaseqty from t_pom_splitlog a left join t_pom_splitentry b on a.fid = b.fid where a.forderstatus = 'C'");){
            Row row;
            HashMap<Long, SubinStorageEntity> detailIds = new HashMap<Long, SubinStorageEntity>(16);
            ArrayList<Long> mftorderEntryIds = new ArrayList<Long>(16);
            while (srcEntryId.hasNext()) {
                row = srcEntryId.next();
                long orderentryid = row.getLong("forderentryid");
                SubinStorageEntity subinStorageEntity = (SubinStorageEntity)detailIds.get(orderentryid);
                if (null == subinStorageEntity) {
                    subinStorageEntity = new SubinStorageEntity();
                }
                subinStorageEntity.setSplitqty(row.getBigDecimal("fsplitqty").add(null == subinStorageEntity.getSplitqty() ? BigDecimal.ZERO : subinStorageEntity.getSplitqty()));
                subinStorageEntity.setSplitbaseqty(row.getBigDecimal("fsplitbaseqty").add(null == subinStorageEntity.getSplitbaseqty() ? BigDecimal.ZERO : subinStorageEntity.getSplitbaseqty()));
                detailIds.put(orderentryid, subinStorageEntity);
                mftorderEntryIds.add(orderentryid);
            }
            if (CollectionUtils.isEmpty(mftorderEntryIds)) {
                logger.info("SplitOrderUpgradeServiceImpl mftorderEntryIds is empty");
                row = null;
                return row;
            }
            String updateInvTypeSql = "update t_pom_mftorderentry_e set ftotalsplitqty  = ?,ftotalsplitbaseqty = ? where fentryid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            for (Map.Entry entry : detailIds.entrySet()) {
                SubinStorageEntity temp = (SubinStorageEntity)entry.getValue();
                paramsList.add(new Object[]{temp.getSplitqty(), temp.getSplitbaseqty(), entry.getKey()});
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"ResourcesUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

