/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade.xstock;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.mmc.pom.mservice.upgrade.xstock.SplitSQLHelper;

public class PomXStockWBUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PomXStockWBUpgradeServiceImpl.class);
    private DBRoute scmRoute = new DBRoute("scm");
    private int BATCH_EXEC_NUMS = 200000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object count;
        UpgradeResult result = new UpgradeResult();
        boolean exitsTable = DB.exitsTable((DBRoute)this.scmRoute, (String)"t_pom_mftorderentry_s_wb");
        if (!exitsTable) {
            return result;
        }
        String switchSql = "select count(1) as count from t_pom_xmftorderentry_s_wb where 1=1";
        try (DataSet countSet = DB.queryDataSet((String)"query-t_pom_xmftorderentry_s_wb", (DBRoute)this.scmRoute, (String)switchSql);){
            while (countSet.hasNext()) {
                Row next = countSet.next();
                count = next.getInteger("count");
                if ((Integer)count <= 0) continue;
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
        }
        var9_9 = null;
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            Map<Integer, Object[]> execSqlParams = SplitSQLHelper.getExecSqlParams(PomXStockWBUpgradeServiceImpl.class.getName(), this.scmRoute, "t_pom_mftorderentry_s_wb", "fentryid", this.BATCH_EXEC_NUMS);
            if (execSqlParams.isEmpty()) {
                count = result;
                return count;
            }
            try {
                for (Object[] param : execSqlParams.values()) {
                    this.executeInsert(param);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "xstock-t_pom_xmftorderentry_s_wb database executeBatch failed,insertError " + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("xstock-t_pom_xmftorderentry_s_wb database executeBatch failed,insertError " + e.getMessage());
                logger.error(err);
                UpgradeResult upgradeResult = result;
                return upgradeResult;
            }
        }
        return result;
    }

    private void executeInsert(Object[] param) {
        String algokey = "query-t_pom_mftorderentry_s_wb";
        String sql = "select fid,fentryid,fseq,fruleverid,fruleitemid,foperate,fstableid,fsid,fsbillid,fwritevalue from t_pom_mftorderentry_s_wb where fentryid >= ? and fentryid < ?";
        try (DataSet dataSet = DB.queryDataSet((String)algokey, (DBRoute)this.scmRoute, (String)sql, (Object[])param);){
            ArrayList<Object[]> paramLs = new ArrayList<Object[]>(this.BATCH_EXEC_NUMS);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] paramObjs = new Object[]{row.get("fid"), row.get("fentryid"), row.get("fseq"), row.get("fruleverid"), row.get("fruleitemid"), row.get("foperate"), row.get("fstableid"), row.get("fsid"), row.get("fsbillid"), row.get("fwritevalue")};
                paramLs.add(paramObjs);
            }
            String insertSql = "insert into t_pom_xmftorderentry_s_wb (fid,fentryid,fseq,fruleverid,fruleitemid,foperate,fstableid,fsid,fsbillid,fwritevalue) VALUES (?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)this.scmRoute, (String)insertSql, paramLs);
            paramLs.clear();
        }
    }
}

