/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.botp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.DateChangeProHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pom.common.manufacture.utils.MftOrderReportUtils;

public class OrderToOrderReportPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(OrderToOrderReportPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        e.setCustFilterDesc(ResManager.loadKDString((String)"\uff08\u5206\u5f55\u63a7\u5236\u6c47\u62a5\u6570\u91cf \u7b49\u4e8e \u662f and \u5206\u5f55\uff08\u7d2f\u8ba1\uff09\u6c47\u62a5\u6570\u91cf- \u5206\u5f55\uff08\u7d2f\u8ba1\uff09\u8fd4\u4fee\u6570\u91cf \u5c0f\u4e8e \u6c47\u62a5\u4e0a\u9650\u6570\u91cf) or \u5206\u5f55\u63a7\u5236\u6c47\u62a5\u6570\u91cf \u7b49\u4e8e \u5426", (String)"OrderToOrderReportPlugin_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression(" (treeentryentity.isconreportqty = true and treeentryentity.reportqty - treeentryentity.repairqty < treeentryentity.repmaxqty) or treeentryentity.isconreportqty = false");
        QFilter isconreportqtyTrue = new QFilter(" treeentryentity.isconreportqty", "=", (Object)true);
        QFilter lessRepmaxqty = new QFilter("treeentryentity.reportqty", "<", (Object)"treeentryentity.repmaxqty + treeentryentity.repairqty", true);
        QFilter isconreportqtyFalse = new QFilter(" treeentryentity.isconreportqty", "=", (Object)false);
        QFilter qFilter = isconreportqtyTrue.and(lessRepmaxqty).or(isconreportqtyFalse);
        e.getCustQFilters().add(qFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        Serializable reportDate;
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        ArrayList<Long> mftOrderIdsList = new ArrayList<Long>(10);
        HashMap<String, Date> cacheBookDateMap = new HashMap<String, Date>(16);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            reportDate = extendedDataEntity.getDataEntity().getDate("reportdate");
            extendedDataEntity.setValue("bookdate", (Object)this.getBookDate((Date)reportDate, extendedDataEntity.getDataEntity().getDynamicObject("org").getLong("id"), cacheBookDateMap));
            DynamicObjectCollection sumentrys = (DynamicObjectCollection)extendedDataEntity.getValue("sumentry");
            for (DynamicObject row : sumentrys) {
                if (null == row || 0L == row.getLong("mftentryid")) continue;
                mftOrderIdsList.add(row.getLong("mftentryid"));
            }
        }
        if (!mftOrderIdsList.isEmpty()) {
            String selectPro = "treeentryentity.processroute,treeentryentity.id,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routereplace";
            QFilter qf = new QFilter("treeentryentity.id", "in", mftOrderIdsList);
            HashMap<Long, Map<String, Object>> dsMap = new HashMap(16);
            DataSet mftOrderEntryDataSets = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mftorder", (String)selectPro, (QFilter[])qf.toArray(), null);
            reportDate = null;
            try {
                dsMap = this.convertDsToMap(mftOrderEntryDataSets);
            }
            catch (Throwable throwable) {
                reportDate = throwable;
                throw throwable;
            }
            finally {
                if (mftOrderEntryDataSets != null) {
                    if (reportDate != null) {
                        try {
                            mftOrderEntryDataSets.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)reportDate).addSuppressed(throwable);
                        }
                    } else {
                        mftOrderEntryDataSets.close();
                    }
                }
            }
            Set<Long> routeIDSet = this.getRouteIDSet(dsMap);
            Map<Object, DynamicObject> routeMap = this.getRouteMap(routeIDSet);
            for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
                DynamicObject reportBill = extendedDataEntity.getDataEntity();
                Long orgId = 0L;
                if (null != reportBill && null != reportBill.getDynamicObject("org")) {
                    orgId = reportBill.getDynamicObject("org").getLong("id");
                }
                DynamicObjectCollection sumentrys = (DynamicObjectCollection)extendedDataEntity.getValue("sumentry");
                for (DynamicObject sumentry : sumentrys) {
                    DynamicObject route;
                    Long mftOrderEntryId;
                    Map orderMap;
                    String matertype;
                    if (null == sumentry || !"C".equals(matertype = sumentry.getString("matertype")) || (orderMap = (Map)dsMap.get(mftOrderEntryId = Long.valueOf(sumentry.getLong("mftentryid")))) == null) continue;
                    ArrayList<DynamicObject> tgtList = new ArrayList<DynamicObject>(sumentrys.size());
                    DynamicObjectCollection subRows = sumentry.getDynamicObjectCollection("subentryentity");
                    Date planbegintime = null;
                    if (orderMap.get("planbegintime") != null) {
                        planbegintime = (Date)orderMap.get("planbegintime");
                    }
                    Date planendtime = null;
                    if (orderMap.get("planendtime") != null) {
                        planendtime = (Date)orderMap.get("planendtime");
                    }
                    Long pdmRoute = 0L;
                    if (orderMap.get("pdmRoute") != null) {
                        pdmRoute = Long.parseLong(orderMap.get("pdmRoute").toString());
                    }
                    if ((route = routeMap.get(pdmRoute)) == null) continue;
                    this.autoCreateActEntrys(planbegintime, planendtime, route, tgtList, sumentry, orgId);
                    if (tgtList.isEmpty()) continue;
                    subRows.clear();
                    subRows.addAll(tgtList);
                }
            }
        }
    }

    private void autoCreateActEntrys(Date planbegintime, Date planendtime, DynamicObject pdmRoute, List<DynamicObject> tgtList, DynamicObject sumentry, Long orgId) {
        int seq = 0;
        DynamicObjectCollection pdmRouteProcessentrys = pdmRoute.getDynamicObjectCollection("processentry");
        HashSet<Long> actIds = new HashSet<Long>(16);
        HashSet<Long> formulaIds = new HashSet<Long>(16);
        HashSet<Long> resourceIds = new HashSet<Long>(16);
        for (DynamicObject pdmRouteProcessentry : pdmRouteProcessentrys) {
            if (null == pdmRouteProcessentry) continue;
            DynamicObjectCollection actEntryEntitys = pdmRouteProcessentry.getDynamicObjectCollection("actentryentity");
            for (DynamicObject actEntryEntity : actEntryEntitys) {
                DynamicObject actresource;
                DynamicObject standardformula1;
                if (null == actEntryEntity) continue;
                DynamicObject repactivity = actEntryEntity.getDynamicObject("activity");
                if (null != repactivity) {
                    actIds.add(repactivity.getLong("id"));
                }
                if (null != (standardformula1 = actEntryEntity.getDynamicObject("standardformula1"))) {
                    formulaIds.add(standardformula1.getLong("id"));
                }
                if (null == (actresource = actEntryEntity.getDynamicObject("actresource"))) continue;
                resourceIds.add(actresource.getLong("id"));
            }
        }
        QFilter actQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processactivity", (Long)orgId);
        Set<Long> actSelectedIds = this.filterByUseOrg(actIds, actQFilter, "mpdm_processactivity");
        QFilter processformulaQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processformula", (Long)orgId);
        Set<Long> formulaSelectedIds = this.filterByUseOrg(formulaIds, processformulaQFilter, "mpdm_processformula");
        QFilter resourcesQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_resources", (Long)orgId);
        Set<Long> resourceSelectedIds = this.filterByUseOrg(resourceIds, resourcesQFilter, "mpdm_resources");
        for (DynamicObject pdmRouteProcessentry : pdmRouteProcessentrys) {
            if (null == pdmRouteProcessentry) continue;
            DynamicObjectCollection actEntryEntitys = pdmRouteProcessentry.getDynamicObjectCollection("actentryentity");
            for (DynamicObject actEntryEntity : actEntryEntitys) {
                if (null == actEntryEntity) continue;
                DynamicObject repactivity = actEntryEntity.getDynamicObject("activity");
                DynamicObject standardformula1 = actEntryEntity.getDynamicObject("standardformula1");
                DynamicObject actresource = actEntryEntity.getDynamicObject("actresource");
                if (null != repactivity && !actSelectedIds.contains(repactivity.getLong("id")) || null != standardformula1 && !formulaSelectedIds.contains(standardformula1.getLong("id")) || null != actresource && !resourceSelectedIds.contains(actresource.getLong("id"))) continue;
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pom_mftorderreport");
                EntityType subEntryType = (EntityType)mainType.getAllEntities().get("subentryentity");
                DynamicObject subentryOrm = new DynamicObject((DynamicObjectType)subEntryType);
                subentryOrm.setParent((Object)sumentry);
                subentryOrm.set("seq", (Object)(++seq));
                subentryOrm.set("repactivity", (Object)repactivity);
                subentryOrm.set("repbaseqty", actEntryEntity.get("baseqty"));
                subentryOrm.set("actstandardformula", actEntryEntity.get("standardformula1"));
                subentryOrm.set("represources", actEntryEntity.get("actresource"));
                subentryOrm.set("repactualbegintime", (Object)planbegintime);
                subentryOrm.set("repactualfinishtime", (Object)planendtime);
                BigDecimal repactualqty = new BigDecimal(0);
                try {
                    Object processactivityPk;
                    DynamicObject processactivity = actEntryEntity.getDynamicObject("activity");
                    if (null != processactivity && null != (processactivityPk = processactivity.getPkValue())) {
                        processactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)processactivityPk, (String)"mpdm_processactivity");
                        repactualqty = MftOrderReportUtils.runFormula((DynamicObject)subentryOrm, (DynamicObject)processactivity);
                    }
                }
                catch (Exception e) {
                    logger.info("\u516c\u5f0f\u6267\u884c\u51fa\u9519,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (Object)e);
                }
                subentryOrm.set("repactualqty", (Object)repactualqty);
                tgtList.add(subentryOrm);
            }
        }
    }

    private Set<Long> filterByUseOrg(Set<Long> actIds, QFilter actQFilter, String baseDataName) {
        HashSet<Long> actSelectedIds = new HashSet<Long>(16);
        QFilter actQueryFilter = new QFilter("id", "in", actIds);
        if (null != actQFilter) {
            actQueryFilter.and(actQFilter);
        }
        Map actMap = BusinessDataServiceHelper.loadFromCache((String)baseDataName, (String)"id", (QFilter[])actQueryFilter.toArray());
        for (Map.Entry objectDynamicObjectEntry : actMap.entrySet()) {
            DynamicObject actObj = (DynamicObject)objectDynamicObjectEntry.getValue();
            if (null == actObj) continue;
            actSelectedIds.add(actObj.getLong("id"));
        }
        return actSelectedIds;
    }

    private Date getBookDate(Date reportDate, Long orgID, Map<String, Date> cacheBookDateMap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date shortReportDate = DateUtils.getShortDate((Date)reportDate);
        String mapKeys = sdf.format(shortReportDate) + "_" + String.valueOf(orgID);
        Date bookDate = cacheBookDateMap.get(mapKeys);
        if (bookDate == null) {
            bookDate = DateChangeProHelper.getBookDate((Date)reportDate, (Long)orgID);
            cacheBookDateMap.put(mapKeys, bookDate);
        }
        return bookDate;
    }

    private Map<Long, Map<String, Object>> convertDsToMap(DataSet ds) {
        if (ds == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> returnMap = new HashMap<Long, Map<String, Object>>(16);
        while (ds.hasNext()) {
            Row mftOrderEntryDataSet = ds.next();
            long entryId = mftOrderEntryDataSet.getLong("treeentryentity.id");
            Date planbegintime = mftOrderEntryDataSet.getDate("treeentryentity.planbegintime");
            Date planendtime = mftOrderEntryDataSet.getDate("treeentryentity.planendtime");
            long pdmRoute = mftOrderEntryDataSet.getLong("treeentryentity.processroute");
            HashMap<String, Comparable<Date>> paramMap = new HashMap<String, Comparable<Date>>(16);
            paramMap.put("planbegintime", planbegintime);
            paramMap.put("planendtime", planendtime);
            paramMap.put("pdmRoute", Long.valueOf(pdmRoute));
            returnMap.put(entryId, paramMap);
        }
        return returnMap;
    }

    private Set<Long> getRouteIDSet(Map<Long, Map<String, Object>> dsMap) {
        if (dsMap == null || dsMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> rtIDSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Map<String, Object>> paramMaps : dsMap.entrySet()) {
            Map<String, Object> paramMap = paramMaps.getValue();
            long pdmRoute = 0L;
            if (paramMap.get("pdmRoute") != null) {
                pdmRoute = Long.parseLong(paramMap.get("pdmRoute").toString());
            }
            if (0L == pdmRoute) continue;
            rtIDSet.add(pdmRoute);
        }
        return rtIDSet;
    }

    private Map<Object, DynamicObject> getRouteMap(Set<Long> rtIDSet) {
        QFilter qfilter = new QFilter("id", "in", rtIDSet);
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_route", (String)"processentry,processentry.actentryentity,actentryentity.activity,actentryentity.baseqty,actentryentity.standardformula1,actentryentity.actresource,actentryentity.activity.creatorg", (QFilter[])new QFilter[]{qfilter});
    }
}

