/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import kd.bd.mpdm.business.helper.OrderSplitTechnicsHelper;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pom.business.orderrestructure.OrderRestructureService;
import org.apache.commons.codec.binary.StringUtils;

public class OrderToOrderRestructApplyPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(OrderToOrderRestructApplyPlugin.class);

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject targetDataEntity;
        super.afterBuildDrawFilter(e);
        ConvertOpType opType = this.getOpType();
        if (opType == ConvertOpType.BeforeDraw && (targetDataEntity = e.getTargetDataEntity()) != null) {
            QFilter qFilter = this.pakeageQfilters(targetDataEntity);
            e.setPlugFilter(qFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObject orderRestructureBill = extendedDataEntity.getDataEntity();
            DynamicObject srcOrderEntryDym = orderRestructureBill.getDynamicObject("pborderentryid");
            srcOrderEntryIds.add(srcOrderEntryDym.getLong("id"));
        }
        String techEntityId = "sfc_manftech";
        DynamicObject[] techBills = BusinessDataServiceHelper.load((String)techEntityId, (String)OrderSplitTechnicsHelper.getAllProperties((String)"sfc_manftech", (String[])new String[]{"oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity"}), (QFilter[])new QFilter[]{new QFilter("mftentryseq", "in", srcOrderEntryIds)});
        String selectPro = OrderSpliteService.getBillAllPropers((String)"pom_mftorder", (String[])new String[]{"treeentryentity"});
        QFilter qFilter = new QFilter("treeentryentity.id", "in", srcOrderEntryIds);
        DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObject orderRestructureBill = extendedDataEntity.getDataEntity();
            DynamicObject srcOrderEntryDym = orderRestructureBill.getDynamicObject("pborderentryid");
            long srcOrderEntryId = srcOrderEntryDym.getLong("id");
            DynamicObject srcOrder = OrderRestructureService.matchOrderByOrderEntryId((Long)srcOrderEntryId, Arrays.asList(mftorderBillForPks));
            String restructurtype = orderRestructureBill.getString("restructurtype");
            DynamicObject pbmftmaterial = orderRestructureBill.getDynamicObject("pbmftmaterial");
            DynamicObject techBill = OrderRestructureService.matchTechBill((Long)srcOrderEntryDym.getLong("id"), Arrays.asList(techBills));
            BigDecimal pbcanrestructurqty = OrderRestructureService.getCanrestructurqty((DynamicObject)srcOrderEntryDym, (String)restructurtype, (DynamicObject)srcOrder, (DynamicObject)techBill);
            orderRestructureBill.set("pbcanrestructurqty", (Object)pbcanrestructurqty);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)restructurtype)) {
                DynamicObjectCollection mrqEntrys = orderRestructureBill.getDynamicObjectCollection("mrqstockentry");
                boolean isExistFlag = false;
                for (DynamicObject mrqEntry : mrqEntrys) {
                    String mrqsourcetype = mrqEntry.getString("mrqsourcetype");
                    if (!StringUtils.equals((CharSequence)"D", (CharSequence)mrqsourcetype)) continue;
                    isExistFlag = true;
                    mrqEntry.set("mrqmftmaterial", (Object)pbmftmaterial);
                    mrqEntry.set("mrqsupplyorgid", pbmftmaterial.get("supplyorgunitid"));
                    DynamicObject masterid = pbmftmaterial.getDynamicObject("masterid");
                    mrqEntry.set("mrqmaterial", (Object)masterid);
                    mrqEntry.set("mrqbaseunitid", masterid.get("baseunit"));
                    DynamicObject mrqsupplyorgid = mrqEntry.getDynamicObject("mrqsupplyorgid");
                    DynamicObject mrqsupplierid = mrqEntry.getDynamicObject("mrqsupplierid");
                    String mrqsupplymode = mrqEntry.getString("mrqsupplymode");
                    if (null != mrqsupplierid || !kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"bos_org", (CharSequence)mrqsupplymode)) continue;
                    mrqsupplierid = OrderRestructureService.queryAccountingByInventory((DynamicObject)mrqsupplyorgid);
                    mrqEntry.set("mrqsupplierid", (Object)mrqsupplierid);
                }
                if (!isExistFlag) {
                    DynamicObject newEntry = mrqEntrys.addNew();
                    newEntry.set("mrqmftmaterial", (Object)pbmftmaterial);
                    newEntry.set("mrqsourcetype", (Object)"D");
                    newEntry.set("mrqqtytype", (Object)"A");
                    newEntry.set("mrquseratio", (Object)BigDecimal.valueOf(100L));
                    newEntry.set("mrqprocessseq", (Object)"1");
                    newEntry.set("mrqoprno", (Object)"10");
                    newEntry.set("mrqsupplymode", (Object)"bos_org");
                    newEntry.set("mrqissuemode", (Object)"A");
                    DynamicObject masterid = pbmftmaterial.getDynamicObject("masterid");
                    newEntry.set("mrqmaterial", (Object)masterid);
                    newEntry.set("mrqbaseunitid", masterid.get("baseunit"));
                    DynamicObject mrqsupplyorgid = pbmftmaterial.getDynamicObject("supplyorgunitid");
                    newEntry.set("mrqsupplyorgid", (Object)mrqsupplyorgid);
                    DynamicObject mrqsupplierid = OrderRestructureService.queryAccountingByInventory((DynamicObject)mrqsupplyorgid);
                    newEntry.set("mrqsupplierid", (Object)mrqsupplierid);
                }
            }
            if (null == techBills || techBills.length <= 0) continue;
            DynamicObjectCollection srcentryentity = orderRestructureBill.getDynamicObjectCollection("srcentryentity");
            DynamicObjectCollection oprentrys = techBill.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject oprentry : oprentrys) {
                String oprstatus = oprentry.getString("oprstatus");
                boolean oprinvalid = oprentry.getBoolean("oprinvalid");
                if (StringUtils.equals((CharSequence)"G", (CharSequence)oprstatus) || oprinvalid) continue;
                DynamicObject techOprparentEntry = OrderRestructureService.matchStockProentry((String)oprentry.getString("oprparent"), (DynamicObject)techBill);
                DynamicObject newEntry = srcentryentity.addNew();
                OrderRestructureService.setSrcentryEntity2((DynamicObject)orderRestructureBill, (DynamicObject)newEntry, (DynamicObject)techBill, (DynamicObject)oprentry, (DynamicObject)techOprparentEntry);
                newEntry.set("srcsourcetype", (Object)"B");
            }
        }
    }

    private QFilter pakeageQfilters(DynamicObject targetDataEntity) {
        QFilter qFilter = new QFilter("treeentryentity.producttype", "=", (Object)ManuBillProductTypeEnum.MAIN.getValue());
        if (null != targetDataEntity) {
            String restructurtype;
            DynamicObject tracknumberBiz;
            DynamicObject configuredcodeBiz;
            DynamicObject mftmaterialBiz;
            DynamicObject orgBiz = targetDataEntity.getDynamicObject("org");
            if (null != orgBiz) {
                qFilter.and(new QFilter("org", "=", (Object)orgBiz.getLong("id")));
            }
            if (null != (mftmaterialBiz = targetDataEntity.getDynamicObject("pbmftmaterial"))) {
                qFilter.and(new QFilter("treeentryentity.material", "=", (Object)mftmaterialBiz.getLong("id")));
            }
            if (null != (configuredcodeBiz = targetDataEntity.getDynamicObject("pbconfiguredcode"))) {
                qFilter.and(new QFilter("treeentryentity.configuredcode", "=", (Object)configuredcodeBiz.getLong("id")));
            }
            if (null != (tracknumberBiz = targetDataEntity.getDynamicObject("pbtracknumber"))) {
                qFilter.and(new QFilter("treeentryentity.tracknumber", "=", (Object)tracknumberBiz.getLong("id")));
            }
            if ("B".equals(restructurtype = targetDataEntity.getString("restructurtype"))) {
                qFilter.and(this.makeUpOrderFilter());
            } else if ("A".equals(restructurtype)) {
                qFilter.and(this.makeUpInvFilter());
            } else {
                qFilter.and(this.makeUpOrderFilter().or(this.makeUpInvFilter()));
            }
        }
        return qFilter;
    }

    private QFilter makeUpOrderFilter() {
        QFilter qFilter = new QFilter("treeentryentity.taskstatus", "!=", (Object)ManuBillTaskStatusEnum.ENDWORK.getValue());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(ManuBillPlanStatusEnum.TRANSMIT.getValue());
        list.add(ManuBillPlanStatusEnum.PLANSURE.getValue());
        qFilter.and(new QFilter("treeentryentity.planstatus", "in", list));
        qFilter.and(new QFilter("treeentryentity.bizstatus", "=", (Object)ManuBillBizStatusEnum.NORMAL.getValue()));
        qFilter.and(new QFilter("treeentryentity.qty", ">", (Object)"treeentryentity.rptqty", Boolean.TRUE.booleanValue()));
        qFilter.and(new QFilter("treeentryentity.baseqty", ">", (Object)"treeentryentity.stockqty", Boolean.TRUE.booleanValue()));
        return qFilter;
    }

    private QFilter makeUpInvFilter() {
        QFilter qFilter = new QFilter("treeentryentity.taskstatus", "=", (Object)ManuBillTaskStatusEnum.ENDWORK.getValue());
        qFilter.and(new QFilter("treeentryentity.planstatus", "=", (Object)ManuBillPlanStatusEnum.TRANSMIT.getValue()));
        HashSet<String> set = new HashSet<String>(16);
        set.add(ManuBillBizStatusEnum.NORMAL.getValue());
        set.add(ManuBillBizStatusEnum.CLOSE.getValue());
        qFilter.and(new QFilter("treeentryentity.bizstatus", "in", set));
        qFilter.and(new QFilter("treeentryentity.unquainwaqty", ">", (Object)BigDecimal.ZERO).or("treeentryentity.quainwaqty", ">", (Object)BigDecimal.ZERO));
        return qFilter;
    }
}

