/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.manufacturemodel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.common.mftorder.utils.OrderGenChildOrderUtils;
import kd.mmc.pom.common.mftorder.utils.PomDyObjUtil;
import org.apache.commons.lang.StringUtils;

public class MftOrderOperatePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("reportqty");
        e.getFieldKeys().add("repairqty");
        e.getFieldKeys().add("unreportqty");
        e.getFieldKeys().add("scheduler");
        e.getFieldKeys().add("workcenter");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        BigDecimal unReportQty = BigDecimal.ZERO;
        for (DynamicObject order : dataEntities) {
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal reportQty = entry.get("reportqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("reportqty");
                BigDecimal repairQty = entry.get("repairqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("repairqty");
                unReportQty = qty.subtract(reportQty).add(repairQty);
                unReportQty = unReportQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : unReportQty;
                entry.set("unreportqty", (Object)unReportQty);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Set<Object> deleteEntryids;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        HashSet<Object> idSet = new HashSet<Object>(dataEntities.length);
        HashSet<Object> entryidSet = new HashSet<Object>(dataEntities.length * 3);
        String eneityName = dataEntities[0].getDataEntityType().getName();
        for (DynamicObject order : dataEntities) {
            idSet.add(order.getPkValue());
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                entryidSet.add(entry.getPkValue());
            }
        }
        if (StringUtils.equals((String)"pom_mftorder", (String)eneityName) && (deleteEntryids = this.getUnExistsEntryIDSet(idSet, entryidSet, eneityName)).size() > 0) {
            OrderGenChildOrderUtils.batchDeleteChildOrder((String)eneityName, idSet, deleteEntryids);
            OrderGenChildOrderUtils.batchDeleteChildOrder((String)"om_mftorder", idSet, deleteEntryids);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> manuVersionIds = new ArrayList<Long>(16);
        HashMap<Long, Object> workCenterFormVersion = new HashMap<Long, Object>(16);
        HashMap<Long, Object> personFormVersion = new HashMap<Long, Object>(16);
        this.setDataMap(dataEntities, manuVersionIds, workCenterFormVersion, personFormVersion);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection treeentryentity = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                Object manuVersion = entry.get("manuversion");
                Long manuVersionId = PomDyObjUtil.getDyObjId((Object)manuVersion);
                DynamicObject workCenter = entry.getDynamicObject("workcenter");
                DynamicObject person = entry.getDynamicObject("scheduler");
                if (manuVersion != null && workCenter == null) {
                    entry.set("workcenter", workCenterFormVersion.get(manuVersionId));
                }
                if (manuVersion == null || person != null) continue;
                entry.set("scheduler", personFormVersion.get(manuVersionId));
            }
        }
    }

    private void setDataMap(DynamicObject[] dataEntities, List<Long> manuVersionIds, HashMap<Long, Object> workCenterFormVersion, HashMap<Long, Object> personFormVersion) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection treeentryentity = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                Object manuVersion = entry.get("manuversion");
                Long manuVersionId = PomDyObjUtil.getDyObjId((Object)manuVersion);
                if (!PomDyObjUtil.isNotEmptyId((Long)manuVersionId)) continue;
                manuVersionIds.add(manuVersionId);
            }
        }
        if (!CollectionUtils.isEmpty(manuVersionIds)) {
            QFilter filter = new QFilter("id", "in", manuVersionIds);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pdm_manuversion", (String)"id,workcenter,person", (QFilter[])filter.toArray(), null);){
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    Object workcenter = row.get("workcenter");
                    Object person = row.get("person");
                    workCenterFormVersion.put(id, workcenter);
                    personFormVersion.put(id, person);
                }
            }
        }
    }

    private Set<Object> getUnExistsEntryIDSet(Set<Object> idSet, Set<Object> entryidSet, String eneityName) {
        HashSet<Object> deleteEntryids = new HashSet<Object>(16);
        if (idSet == null || idSet.isEmpty()) {
            return deleteEntryids;
        }
        QFilter[] idQFilters = new QFilter[]{new QFilter("id", "in", idSet)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(MftOrderOperatePlugin.class.getName() + "-getUnExistsEntryIDSet"), (String)eneityName, (String)"id,treeentryentity.id", (QFilter[])idQFilters, null);){
            while (ds.hasNext()) {
                Row idRow = ds.next();
                Object etnryid = idRow.get("treeentryentity.id");
                if (entryidSet.contains(etnryid)) continue;
                deleteEntryids.add(etnryid);
            }
        }
        return deleteEntryids;
    }
}

