/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.manufacturemodel.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.CheckManuOrderUtil;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class StockSubmitOnAddVal
extends AbstractValidator {
    private Map<String, Map<String, Object>> mftOrders = null;
    private Map<String, String> mtoMap = null;
    private Map<Long, Map<Long, List<DynamicObject>>> mMaterialInvInfoLst = new HashMap<Long, Map<Long, List<DynamicObject>>>(16);

    private Map<String, Object> loadMftOrderStatus(String orderId) {
        if (this.mftOrders != null) {
            return this.mftOrders.get(orderId);
        }
        this.mftOrders = new HashMap<String, Map<String, Object>>(16);
        String mftorder = this.getOption().getVariableValue("manuorder", "");
        if (mftorder.equals("")) {
            mftorder = EntityNameUtils.getEntityName((int)1, (int)0, (String)this.getEntityKey());
        }
        HashSet<Long> orderIds = new HashSet<Long>(this.getDataEntities().length);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject manufactureStock = rowDataEntity.getDataEntity();
            String orderid = manufactureStock.getString("orderid");
            if (!StringUtils.isNotBlank((CharSequence)orderid)) continue;
            orderIds.add(Long.valueOf(orderid));
        }
        if (!orderIds.isEmpty()) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockSubmitOnAddVal", (String)mftorder, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)}, (String)"");){
                while (ds.hasNext()) {
                    Row arow = ds.next();
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    dataMap.put("billstatus", arow.getString("billstatus"));
                    this.mftOrders.put(String.valueOf(arow.getLong("id")), dataMap);
                }
            }
        }
        return this.mftOrders.get(orderId);
    }

    private boolean isMTO(Object masterid, long orgId) {
        List<DynamicObject> materialInfos;
        boolean isMTO;
        String key = masterid.toString() + orgId;
        if (this.mtoMap != null && StringUtils.isNotEmpty((CharSequence)this.mtoMap.get(key))) {
            String value = this.mtoMap.get(key);
            return "1".equals(value);
        }
        if (this.mtoMap == null) {
            this.mtoMap = new HashMap<String, String>(16);
        }
        if (isMTO = (materialInfos = this.getMaterialInvInfos(orgId, (Long)masterid)).stream().anyMatch(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getString("manustrategy.demandmodel"), (CharSequence)"MTO"))) {
            this.mtoMap.put(key, "1");
            return true;
        }
        this.mtoMap.put(key, "0");
        return false;
    }

    public void validate() {
        HashSet<Long> mftSeqIDSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> mftechMap = new HashMap<Long, DynamicObject>(16);
        List<DynamicObject> stockBills = this.setMfTechData(mftechMap, mftSeqIDSet);
        CheckManuOrderUtil.updateWareHouseManuStock(stockBills, mftechMap, mftSeqIDSet);
        this.setMaterialInvInfoLst();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String status;
            DynamicObject manufactureStock = rowDataEntity.getDataEntity();
            if (this.isXmftStock()) {
                this.saveaddva(rowDataEntity);
                continue;
            }
            String orderid = manufactureStock.getString("orderid");
            if (orderid == null || "".equals(orderid)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"StockSubmitOnAddVal_23", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                continue;
            }
            Map<String, Object> manufactureOrder = this.loadMftOrderStatus(orderid);
            String string = status = manufactureOrder == null ? "" : manufactureOrder.get("billstatus").toString();
            if (manufactureOrder != null && "D".equals(status)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u5de5\u5355\u5df2\u4f5c\u5e9f\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"StockSubmitOnAddVal_24", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.saveaddva(rowDataEntity);
        }
    }

    private List<DynamicObject> setMfTechData(Map<Long, DynamicObject> mftechMap, Set<Long> mftSeqIDSet) {
        DynamicObject[] manfTech;
        ArrayList<DynamicObject> stockBills = new ArrayList<DynamicObject>(16);
        HashSet<String> orderIds = new HashSet<String>(16);
        HashSet<Object> orderEntrySeqs = new HashSet<Object>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject orderEntryId;
            DynamicObject manufactureStock = rowDataEntity.getDataEntity();
            stockBills.add(manufactureStock);
            String orderid = manufactureStock.getString("orderid");
            if (StringUtils.isNotBlank((CharSequence)orderid)) {
                orderIds.add(orderid);
            }
            if ((orderEntryId = manufactureStock.getDynamicObject("orderentryid")) == null) continue;
            orderEntrySeqs.add(orderEntryId.getPkValue());
        }
        String manftechName = "sfc_manftech";
        if ("om_mftstock".equals(this.getEntityKey()) || "om_xmftstock".equals(this.getEntityKey())) {
            manftechName = "om_mfttechnics";
        } else if ("prop_mftstock".equals(this.getEntityKey())) {
            manftechName = "prop_manftech";
        }
        QFilter qFilter = new QFilter("manufactureorderid", "in", orderIds);
        qFilter.and("mftentryseq", "in", orderEntrySeqs);
        for (DynamicObject load : manfTech = BusinessDataServiceHelper.load((String)manftechName, (String)MPDMMftGenStocksUtils.manftechSelectProperties().toString(), (QFilter[])new QFilter[]{qFilter})) {
            Long pkvalue = (Long)((DynamicObject)load.get("mftentryseq")).getPkValue();
            if (pkvalue == null || this.getOrderBillType().equals("pom_mroorder")) continue;
            mftechMap.put(pkvalue, load);
            mftSeqIDSet.add(pkvalue);
        }
        return stockBills;
    }

    protected String getOrderBillType() {
        String name = "pom_mftorder";
        if (this.getOption().containsVariable("orderBillType")) {
            name = this.getOption().getVariableValue("orderBillType");
        }
        return name;
    }

    private boolean isXmftStock() {
        String entityKey = this.getEntityKey();
        return "pom_xmftstock".equals(entityKey) || "om_xmftstock".equals(entityKey);
    }

    private void saveaddva(ExtendedDataEntity rowDataEntity) {
        DynamicObject product;
        long orgId;
        Object masterid;
        Object productMaster;
        ArrayList<Integer> warehouseList = new ArrayList<Integer>();
        ArrayList<Integer> locationList = new ArrayList<Integer>();
        ArrayList<Integer> backflushtimeList = new ArrayList<Integer>();
        ArrayList<Integer> overissuecontrlList = new ArrayList<Integer>();
        ArrayList<Integer> outorgunit = new ArrayList<Integer>();
        ArrayList<Integer> wastagerateList = new ArrayList<Integer>();
        ArrayList<Integer> supplierList = new ArrayList<Integer>();
        ArrayList<Integer> supplyorgList = new ArrayList<Integer>();
        ArrayList<Integer> isbackflushList = new ArrayList<Integer>();
        ArrayList<Integer> issuemodeList = new ArrayList<Integer>();
        List<Object> equalsMainList = new ArrayList();
        ArrayList<Integer> mtoList = new ArrayList<Integer>();
        DynamicObject manufactureStock = rowDataEntity.getDataEntity();
        DynamicObject transactionType = manufactureStock.getDynamicObject("transactiontypeid");
        String bizBomType = "";
        boolean checkMain = false;
        String stockName = manufactureStock.getDataEntityType().getName();
        if (transactionType != null) {
            if ("mpdm_transactout".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("feedtype");
                checkMain = !"E".equals(bizBomType);
            } else if ("mpdm_transactproduct".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("stockmaterials");
                boolean bl = checkMain = !"B".equals(bizBomType);
                if (TransactionTypeQueryHelper.isReworkTransType((DynamicObject)transactionType)) {
                    checkMain = false;
                }
            }
        }
        if (checkMain) {
            equalsMainList = this.getEqualsMainList(stockName, manufactureStock);
        }
        DynamicObjectCollection listdym = manufactureStock.getDynamicObjectCollection("stockentry");
        int rowcount = listdym.size();
        boolean flag = false;
        Object productMTO = 0L;
        DynamicObject tran = (DynamicObject)rowDataEntity.getDataEntity().get("transactiontypeid");
        if (checkMain && (productMaster = rowDataEntity.getDataEntity().get("productmasterid")) != null && this.isMTO(masterid = ((DynamicObject)productMaster).getPkValue(), orgId = ((DynamicObject)rowDataEntity.getDataEntity().get("org")).getLong("id")) && (product = (DynamicObject)rowDataEntity.getDataEntity().get("orderentryid")).get("configuredcode") != null) {
            productMTO = product.getDynamicObject("configuredcode").getPkValue();
            flag = true;
        }
        for (int index = 0; index < rowcount; ++index) {
            Object entryCodeId;
            DynamicObject supplyorg;
            String wastagerate;
            boolean s;
            Object outorg;
            Boolean isstockallot;
            String overissuecontrl;
            String backflushtime;
            DynamicObject stockdym = (DynamicObject)listdym.get(index);
            DynamicObject materialMft = stockdym.getDynamicObject("materialid");
            if (materialMft == null) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_25", (String)"mmc-pom-opplugin", (Object[])new Object[0]), index + 1));
                return;
            }
            String isbackflush = stockdym.getString("isbackflush");
            if (!("A".equals(isbackflush) || "B".equals(isbackflush) || "C".equals(isbackflush))) {
                isbackflushList.add(index + 1);
            }
            String issuemode = (String)stockdym.get("issuemode");
            DynamicObject warehouse = stockdym.getDynamicObject("warehouseid");
            if (warehouse == null && "B".equals(isbackflush) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                warehouseList.add(index + 1);
            }
            if ("B".equals(isbackflush) && ("A".equals(issuemode) || "B".equals(issuemode)) && !"A".equals(backflushtime = stockdym.getString("backflushtime")) && !"B".equals(backflushtime)) {
                backflushtimeList.add(index + 1);
            }
            if (!"A".equals(overissuecontrl = stockdym.getString("overissuecontrl")) && !"B".equals(overissuecontrl) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                overissuecontrlList.add(index + 1);
            }
            if (warehouse != null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                if ("B".equals(isbackflush) && isopenlocation.booleanValue() && stockdym.get("location") == null) {
                    locationList.add(index + 1);
                }
            }
            if ((isstockallot = (Boolean)stockdym.get("isstockallot")).booleanValue() && StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)stockName) && (outorg = stockdym.get("outorgunitid")) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                outorgunit.add(index + 1);
            }
            if ((s = tran.getBoolean("isconsiderloss")) && !"A".equals(wastagerate = (String)stockdym.get("wastagerateformula")) && !"B".equals(wastagerate)) {
                wastagerateList.add(index + 1);
            }
            String supplyfield = (String)stockdym.get("supplymode");
            DynamicObject supply = (DynamicObject)stockdym.get("supplierid");
            if (supply == null && "bos_org".equals(supplyfield) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplierList.add(index + 1);
            }
            if ((supplyorg = (DynamicObject)stockdym.get("supplyorgid")) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplyorgList.add(index + 1);
            }
            if (!("A".equals(issuemode) || "B".equals(issuemode) || "C".equals(issuemode))) {
                issuemodeList.add(index + 1);
            }
            if (!flag || stockdym.get("entryconfiguredcode") == null || !"A".equals(issuemode) && !"B".equals(issuemode) || !productMTO.equals(entryCodeId = stockdym.getDynamicObject("entryconfiguredcode").getPkValue())) continue;
            mtoList.add(index + 1);
        }
        StringBuilder err = new StringBuilder();
        if (!flag && !equalsMainList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(equalsMainList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u7f16\u7801\u540c\u5de5\u5355\u5206\u5f55\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\u3002", (String)"StockSubmitOnAddVal_5", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!warehouseList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(warehouseList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u201c\u4f9b\u8d27\u4ed3\u5e93\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_6", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!locationList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(locationList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u4e14\u4f9b\u8d27\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406\uff0c\u201c\u4f9b\u8d27\u4ed3\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_7", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!backflushtimeList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(backflushtimeList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u201c\u5012\u51b2\u65f6\u673a\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_8", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!overissuecontrlList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(overissuecontrlList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u8d85\u53d1\u63a7\u5236\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_9", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!outorgunit.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(outorgunit.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u7269\u6599\u542f\u7528\u5907\u6599\u8c03\u62e8\uff0c\u201c\u8c03\u51fa\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_11", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!wastagerateList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(wastagerateList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u635f\u8017\u8ba1\u7b97\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_12", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!supplierList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(supplierList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u8d27\u4e3b\u7c7b\u578b\u201d\u4e3a\u201c\u4e1a\u52a1\u5355\u5143\u201d\uff0c\u201c\u8d27\u4e3b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_13", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!supplyorgList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(supplyorgList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u4f9b\u8d27\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_14", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!isbackflushList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(isbackflushList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u5012\u51b2\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_15", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!issuemodeList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(issuemodeList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7684\u201c\u9886\u9001\u6599\u65b9\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StockSubmitOnAddVal_16", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!mtoList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"StockSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            err.append(mtoList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7ec4\u4ef6\u7684\u914d\u7f6e\u53f7\u4e0d\u80fd\u4e0e\u4ea7\u54c1\u7684\u914d\u7f6e\u53f7\u4e00\u81f4\u3002", (String)"StockSubmitOnAddVal_18", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
        if (!"".equals(err.toString())) {
            this.addErrorMessage(rowDataEntity, err.toString());
        }
    }

    private List<Integer> getEqualsMainList(String entityName, DynamicObject manufactureStock) {
        ArrayList<Integer> equalsMainList = new ArrayList<Integer>();
        DynamicObjectCollection entryEntity = manufactureStock.getDynamicObjectCollection("stockentry");
        if (entityName.equals("pom_xmftstock") || entityName.equals("om_xmftstock")) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                String changeType = entry.getString("entrychangetype");
                if (!"A".equals(changeType)) continue;
                String productId = "";
                DynamicObject productDym = entry.getDynamicObject("productno");
                if (productDym != null) {
                    productId = productDym.getPkValue().toString();
                }
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else if (entityName.equals("om_componentlist")) {
            String productId = "";
            DynamicObject productDym = manufactureStock.getDynamicObject("productid");
            if (productDym != null) {
                productId = productDym.getDynamicObject("masterid").getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getDynamicObject("masterid").getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else {
            String productId = "";
            DynamicObject productDym = manufactureStock.getDynamicObject("productid");
            if (productDym != null) {
                productId = productDym.getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        }
        return equalsMainList;
    }

    private void setMaterialInvInfoLst() {
        if (this.mMaterialInvInfoLst.size() == 0) {
            this.mMaterialInvInfoLst = this.getMaterialInvInfoLst();
        }
    }

    private List<DynamicObject> getMaterialInvInfos(Long orgId, Long materialId) {
        Map<Long, List<DynamicObject>> matrialMap = this.mMaterialInvInfoLst.get(materialId);
        List<DynamicObject> invInfoLst = null;
        if (matrialMap != null) {
            invInfoLst = matrialMap.get(orgId);
        }
        if (invInfoLst == null) {
            invInfoLst = new ArrayList<DynamicObject>(16);
        }
        return invInfoLst;
    }

    private Map<Long, Map<Long, List<DynamicObject>>> getMaterialInvInfoLst() {
        HashMap<Long, HashSet<Long>> orgMaterialGrp = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, QFilter> orgPerMap = new HashMap<Long, QFilter>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject billOrder = rowDataEntity.getDataEntity();
            DynamicObject orgObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)billOrder, (String)"org");
            DynamicObject prodmasteridObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)billOrder, (String)"productmasterid");
            if (orgObj == null || prodmasteridObj == null) continue;
            Long orgId = orgObj.getLong("id");
            Long materialId = prodmasteridObj.getLong("id");
            HashSet<Long> materialIDs = (HashSet<Long>)orgMaterialGrp.get(orgId);
            if (materialIDs == null) {
                materialIDs = new HashSet<Long>(16);
            }
            materialIDs.add(materialId);
            if (!orgPerMap.containsKey(orgId)) {
                QFilter qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
                orgPerMap.put(orgId, qFilterUseOrg);
            }
            orgMaterialGrp.put(orgId, materialIDs);
        }
        DynamicObjectCollection invMaterialColl = new DynamicObjectCollection();
        for (Map.Entry entry : orgMaterialGrp.entrySet()) {
            Long orgID = (Long)entry.getKey();
            Set materialIds = (Set)entry.getValue();
            QFilter qFilterUseOrg = (QFilter)orgPerMap.get(orgID);
            QFilter qf = new QFilter("masterid", "in", (Object)materialIds);
            qf.and(qFilterUseOrg);
            String fiedStr = String.format("id,masterid,%s org,manustrategy.demandmodel", orgID);
            DynamicObjectCollection invMaterialRows = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)fiedStr, (QFilter[])qf.toArray());
            invMaterialColl.addAll((Collection)invMaterialRows);
        }
        Map<Long, Map<Long, List<DynamicObject>>> invMaterialMap = invMaterialColl.stream().collect(Collectors.groupingBy(d -> d.getLong("masterid"), Collectors.groupingBy(d -> d.getLong("org"))));
        return invMaterialMap;
    }
}

