/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mftreport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MmcLockHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.opplugin.mftreport.validator.POMMftorderReptBillValidator;
import kd.mmc.pom.opplugin.mftreport.validator.POMMftorderReptListValidator;
import org.apache.commons.lang3.StringUtils;

public class POMMftorderReportAuditOp
extends AbstractOperationServicePlugIn {
    private static final String AUDIT = "audit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sumentry.isautowarehouse");
        fieldKeys.add("sumentry.manufacturenun");
        fieldKeys.add("sumentry.mftentryid");
        fieldKeys.add("sumentry.completqty");
        fieldKeys.add("sumentry.matertype");
        fieldKeys.add("sumentry.qualifyqty");
        fieldKeys.add("sumentry.concesionqty");
        fieldKeys.add("sumentry.scrappedqty");
        fieldKeys.add("sumentry.repairqty");
        fieldKeys.add("sumentry.reworkqty");
        fieldKeys.add("sumentry.completbsqty");
        fieldKeys.add("sumentry.matertype");
        fieldKeys.add("sumentry.material");
        fieldKeys.add("sumentry.seq");
        fieldKeys.add("sumentry.concesionbsqty");
        fieldKeys.add("sumentry.qualityorg");
        fieldKeys.add("sumentry.ischeckmaterial");
        fieldKeys.add("reportdate");
        fieldKeys.add("completbsqty");
        fieldKeys.add("bookdate");
        fieldKeys.add("srctype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new POMMftorderReptListValidator());
        e.addValidator((AbstractValidator)new POMMftorderReptBillValidator());
    }

    private void setWipQty(DynamicObjectCollection sumColls, List<Long> orderEntryIdList) {
        for (DynamicObject dyn : sumColls) {
            if (!dyn.getString("matertype").equals("C")) continue;
            orderEntryIdList.add(dyn.getLong("mftentryid"));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateOrderBeginDate(DynamicObject[] dObjects) {
        HashSet<Long> orderEntryids = new HashSet<Long>(16);
        HashMap<String, DynamicObject> orderBills = new HashMap<String, DynamicObject>(16);
        for (DynamicObject reportBill : dObjects) {
            DynamicObjectCollection sumentrys = reportBill.getDynamicObjectCollection("sumentry");
            Iterator iterator = sumentrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject sumentry = (DynamicObject)iterator.next();
                String matertype = sumentry.getString("matertype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)matertype)) continue;
                Long mftentryid = sumentry.get("mftentryid") == null ? 0L : Long.parseLong(sumentry.getString("mftentryid"));
                orderEntryids.add(mftentryid);
            }
        }
        HashSet<String> lockKeys = new HashSet<String>(orderEntryids.size());
        for (Long orderentryid : orderEntryids) {
            lockKeys.add("updateorderdbookdate/" + orderentryid.toString());
        }
        Map dLocks = MmcLockHelper.createDLocks(lockKeys, (boolean)false);
        try {
            Map successdLocks = MmcLockHelper.tryDLocks((Map)dLocks, (Long)100L);
            if (successdLocks == null || successdLocks.isEmpty()) {
                return;
            }
            HashSet<Long> updateorderEntryids = new HashSet<Long>(successdLocks.size());
            for (String successdLock : successdLocks.keySet()) {
                String[] split = successdLock.split("/");
                updateorderEntryids.add(Long.parseLong(split[1]));
            }
            if (updateorderEntryids.size() > 0) {
                QFilter filters = new QFilter("treeentryentity.id", "in", updateorderEntryids);
                DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)this.getOrderSelecors(), (QFilter[])filters.toArray());
                for (String string : orders) {
                    orderBills.put(string.getString("billno"), (DynamicObject)string);
                }
            }
            if (orderBills.size() > 0) {
                void var13_22;
                HashSet<DynamicObject> updateData = new HashSet<DynamicObject>(dObjects.length);
                HashSet<Long> updateEntryids = new HashSet<Long>(dObjects.length);
                HashSet<Long> updateSplitEntryids = new HashSet<Long>(dObjects.length);
                DynamicObject[] dynamicObjectArray = dObjects;
                int n = dynamicObjectArray.length;
                boolean bl = false;
                while (var13_22 < n) {
                    DynamicObject reportBill = dynamicObjectArray[var13_22];
                    Date bookdate = reportBill.getDate("bookdate");
                    DynamicObjectCollection sumentrys = reportBill.getDynamicObjectCollection("sumentry");
                    for (DynamicObject sumentry : sumentrys) {
                        String manufacturenun = sumentry.getString("manufacturenun");
                        DynamicObject orderBill = (DynamicObject)orderBills.get(manufacturenun);
                        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject treeentryentity : treeentryentitys) {
                            Date beginbookdate;
                            Long entryid = treeentryentity.getLong("id");
                            Long pid = treeentryentity.getLong("pid");
                            if (!updateorderEntryids.contains(entryid) && !updateorderEntryids.contains(pid) || (beginbookdate = treeentryentity.getDate("beginbookdate")) != null && !beginbookdate.after(bookdate)) continue;
                            treeentryentity.set("beginbookdate", (Object)(bookdate != null ? DateUtils.getShortDate((Date)bookdate) : bookdate));
                            updateData.add(orderBill);
                            updateEntryids.add(entryid);
                            if (orderEntryids.contains(pid)) continue;
                            updateSplitEntryids.add(entryid);
                        }
                    }
                    ++var13_22;
                }
                if (updateData.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[0]));
                    this.updateChangeLog(orderBills, updateEntryids);
                }
                if (updateSplitEntryids.size() > 0) {
                    this.updateSplitLog(orderBills, updateSplitEntryids);
                }
            }
        }
        finally {
            if (dLocks != null && dLocks.size() > 0) {
                MmcLockHelper.unDLocks(new ArrayList(dLocks.values()));
            }
        }
    }

    private void updateSplitLog(Map<String, DynamicObject> orderBills, Set<Long> updateEntryids) {
        DynamicObject[] splitlogs;
        if (updateEntryids == null || updateEntryids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> splitlogUpdateData = new HashSet<DynamicObject>(updateEntryids.size());
        QFilter qf = new QFilter("orderentryid", "in", updateEntryids);
        for (DynamicObject splitlog : splitlogs = BusinessDataServiceHelper.load((String)"pom_mftorder_splitlog", (String)"orderid,orderno,orderentryid,billentry,billentry.beginbookdate", (QFilter[])qf.toArray())) {
            Date beginbookdate;
            DynamicObject orderBill;
            String orderno = splitlog.getString("orderno");
            if (StringUtils.isEmpty((CharSequence)orderno) || (orderBill = orderBills.get(orderno)) == null) continue;
            Long odentryid = 0L;
            DynamicObject orderentryid = splitlog.getDynamicObject("orderentryid");
            if (orderentryid != null) {
                odentryid = Long.parseLong(orderentryid.getPkValue().toString());
            }
            if ((beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid)) == null) continue;
            DynamicObjectCollection billentrys = splitlog.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                Object beginbookdate1 = billentry.get("beginbookdate");
                if (beginbookdate1 != null) continue;
                billentry.set("beginbookdate", (Object)(beginbookdate != null ? DateUtils.getShortDate((Date)beginbookdate) : beginbookdate));
                splitlogUpdateData.add(splitlog);
            }
        }
        if (splitlogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])splitlogUpdateData.toArray(new DynamicObject[splitlogUpdateData.size()]));
        }
    }

    private void updateChangeLog(Map<String, DynamicObject> orderBills, Set<Long> updateEntryids) {
        DynamicObject[] changelogs;
        if (updateEntryids == null || updateEntryids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> changelogUpdateData = new HashSet<DynamicObject>(updateEntryids.size());
        QFilter qf = new QFilter("srcbillentryid", "in", updateEntryids);
        for (DynamicObject changelog : changelogs = BusinessDataServiceHelper.load((String)"pom_xmftorderlog", (String)"srcbillid,srcbillno,srcbillentryid,beginbookdate", (QFilter[])qf.toArray())) {
            Object beginbookdateObj;
            Long odentryid;
            Date beginbookdate;
            DynamicObject orderBill;
            String orderno = changelog.getString("srcbillno");
            if (StringUtils.isEmpty((CharSequence)orderno) || (orderBill = orderBills.get(orderno)) == null || (beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid = Long.valueOf(changelog.getLong("srcbillentryid")))) == null || (beginbookdateObj = changelog.get("beginbookdate")) != null) continue;
            changelog.set("beginbookdate", (Object)beginbookdate);
            changelogUpdateData.add(changelog);
        }
        if (changelogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])changelogUpdateData.toArray(new DynamicObject[changelogUpdateData.size()]));
        }
    }

    private Date getOrderBeginBookDate(DynamicObject orderBill, Long odentryid) {
        if (orderBill == null || odentryid == null) {
            return null;
        }
        Date beginbookdate = null;
        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject treeentryentity : treeentryentitys) {
            Long entryid = treeentryentity.getLong("id");
            if (!odentryid.equals(entryid)) continue;
            beginbookdate = treeentryentity.getDate("beginbookdate");
        }
        return beginbookdate;
    }

    private String getOrderSelecors() {
        StringBuilder fileds = new StringBuilder(200);
        fileds.append("billno");
        fileds.append(",treeentryentity");
        fileds.append(",treeentryentity.pid");
        fileds.append(",treeentryentity.beginbookdate");
        fileds.append(",treeentryentity.closebookdate");
        return fileds.toString();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataArray = e.getDataEntities();
        DynamicObjectCollection notAllowColls = new DynamicObjectCollection();
        ArrayList<Long> orderEntryIdList = new ArrayList<Long>(10);
        for (DynamicObject mftReptBill : dataArray) {
            DynamicObjectCollection sumColls = mftReptBill.getDynamicObjectCollection("sumentry");
            if (sumColls == null || sumColls.isEmpty()) continue;
            this.setWipQty(sumColls, orderEntryIdList);
            if (!StringUtils.equals((CharSequence)AUDIT, (CharSequence)e.getOperationKey())) continue;
            this.executePushOperate(notAllowColls, mftReptBill, sumColls);
            sumColls.addAll((Collection)notAllowColls);
        }
        if (!orderEntryIdList.isEmpty()) {
            StockCulUtils.batchCulUseQtyByOrderEntryId(orderEntryIdList, (String)"pom_mftorder");
        }
        if (AUDIT.equals(operationKey)) {
            this.updateOrderBeginDate(dataArray);
        }
    }

    private void executePushOperate(DynamicObjectCollection notAllowColls, DynamicObject mftRepotDyObj, DynamicObjectCollection sumentryColl) {
        notAllowColls.clear();
        for (DynamicObject sumentryDyObj : sumentryColl) {
            boolean isautowarehouse = sumentryDyObj.getBoolean("isautowarehouse");
            if (isautowarehouse) continue;
            notAllowColls.add((Object)sumentryDyObj);
        }
        if (!notAllowColls.isEmpty()) {
            sumentryColl.removeAll((Collection)notAllowColls);
        }
        if (!sumentryColl.isEmpty()) {
            this.pushAndSave("pom_mftorderreport", "im_mdc_mftmanuinbill", "1114515031602500608", mftRepotDyObj);
        }
    }

    private void pushAndSave(String sourceEntity, String targetEntity, String ruleId, DynamicObject info) {
        OperationResult processSave;
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess()) {
            return;
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        for (int i = 0; i < dynamicresults.size(); ++i) {
            DynamicObject destBill;
            dataEntities[i] = destBill = (DynamicObject)dynamicresults.get(i);
            String billno = CodeRuleServiceHelper.getNumber((String)targetEntity, (DynamicObject)destBill, (String)destBill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billno)) {
                ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u7f3a\u5c11\u7f16\u7801\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u3002", (String)"POMMftorderReportAuditOp_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
            dataEntities[i].set("billno", (Object)billno);
        }
        if (dataEntities.length > 0 && !(processSave = OperationServiceHelper.executeOperate((String)"save", (String)"im_mdc_mftmanuinbill", (DynamicObject[])dataEntities, null)).isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u4fdd\u5b58\u5931\u8d25%1$s", (String)"POMMftorderReportAuditOp_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]), this.getErrDetail(processSave)));
        }
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }
}

