/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mftstock;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class StockBatchImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(StockBatchImportPlugin.class);

    public String getDefaultImportType() {
        return ImportStartData.ImportStartTypeEnum.OVERRIDE.getType();
    }

    public List<String> getDefaultLockUIs() {
        List defaultLockUIs = super.getDefaultLockUIs();
        defaultLockUIs.add("flexpanelap6");
        return defaultLockUIs;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        items.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"StockBatchImportPlugin_0", (String)"mmc-pom-opplugin", (Object[])new Object[0])), entityType.getPrimaryKey().getName()));
        return items;
    }

    public String getDefaultKeyFields() {
        String billFormId = this.getBillFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        return entityType.getPrimaryKey().getName();
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            if (bill.isEmpty()) continue;
            try {
                int startIndex = bill.getStartIndex();
                JSONObject data = bill.getData();
                ImportEntityMapping mapping = bill.getEntityMapping();
                for (Map.Entry col : mapping.getCols().entrySet()) {
                    String fieldKey = (String)col.getKey();
                    ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)col.getValue();
                    String displayName = colInfo.getDisplayName();
                    IDataEntityProperty iDataEntityProperty = colInfo.getProperty();
                    Object val = data.get((Object)fieldKey);
                    if ("billstatus".equals(fieldKey) && !"A".equals(val)) {
                        logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"%1$s\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u5f15\u5165\u975e\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5f15\u5165\u3002", (String)"StockBatchImportPlugin_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), displayName));
                        it.remove();
                        logger.fail();
                        logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    }
                    if ("isinitbill".equals(fieldKey) && Boolean.FALSE.equals(val)) {
                        logger.log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u201c\u521d\u59cb\u5316\u201d\u4e3a\u201c\u5426\u201d\u7684\u5355\u636e\u3002", (String)"StockBatchImportPlugin_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                        it.remove();
                        logger.fail();
                        logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
                    }
                    if (!this.getUnModifyHeaderFieldKey().contains(fieldKey)) continue;
                    data.remove((Object)fieldKey);
                }
                ImportEntityMapping stockEntryMapping = (ImportEntityMapping)mapping.getEntries().get("stockentry");
                JSONArray rows = data.getJSONArray("stockentry");
                if (rows == null || rows.isEmpty()) continue;
                for (JSONObject dataObj : rows) {
                    Object sourcetype;
                    boolean bl;
                    for (Map.Entry entry : stockEntryMapping.getCols().entrySet()) {
                        String fieldKey = (String)entry.getKey();
                        if (!this.getUnModifyCommStockEntryFieldKey().contains(fieldKey)) continue;
                        dataObj.remove((Object)fieldKey);
                    }
                    Object entryId = dataObj.get((Object)"id");
                    boolean bl2 = true;
                    if (entryId != null && StringUtils.isNotEmpty((CharSequence)entryId.toString())) {
                        bl = false;
                    }
                    if (bl || "B".equals(sourcetype = dataObj.get((Object)"sourcetype"))) continue;
                    for (Map.Entry col : stockEntryMapping.getCols().entrySet()) {
                        String fieldKey = (String)col.getKey();
                        if (!this.getUnModifyStockEntryFieldKey().contains(fieldKey)) continue;
                        dataObj.remove((Object)fieldKey);
                    }
                }
            }
            catch (Throwable throwable) {
                log.error(throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"StockBatchImportPlugin_3", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
    }

    private List<String> getUnModifyHeaderFieldKey() {
        String billFormId = this.getBillFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        Set allHeaderFields = entityType.getFields().keySet();
        ArrayList<String> fieldKeys = new ArrayList<String>(allHeaderFields);
        fieldKeys.remove("id");
        fieldKeys.remove("billstatus");
        return fieldKeys;
    }

    private List<String> getUnModifyStockEntryFieldKey() {
        ArrayList<String> fieldKeys = new ArrayList<String>(16);
        fieldKeys.add("materialid");
        fieldKeys.add("qtytype");
        return fieldKeys;
    }

    private List<String> getUnModifyCommStockEntryFieldKey() {
        ArrayList<String> fieldKeys = new ArrayList<String>(16);
        fieldKeys.add("standqty");
        return fieldKeys;
    }
}

