/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.opplugin.mro.CoordinationTradeVal;

public class CoordinationTradeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CoordinationTradeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("apply");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("applytrade");
        e.getFieldKeys().add("businessstatus");
        e.getFieldKeys().add("provider");
        e.getFieldKeys().add("expenddate");
        e.getFieldKeys().add("providdate");
        e.getFieldKeys().add("recipient");
        e.getFieldKeys().add("recipitrade");
        e.getFieldKeys().add("preenddate");
        e.getFieldKeys().add("finisher");
        e.getFieldKeys().add("certifier");
        e.getFieldKeys().add("picker");
        e.getFieldKeys().add("pickdate");
        e.getFieldKeys().add("finisher");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CoordinationTradeVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities2 = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                DynamicObject row;
                int n;
                DynamicObject[] dynamicObjectArray = dataEntities2;
                int n2 = dynamicObjectArray.length;
                for (n = 0; n < n2; ++n) {
                    row = dynamicObjectArray[n];
                    row.set("businessstatus", (Object)"A");
                }
                break;
            }
            case "workend": {
                DynamicObject row;
                int n;
                DynamicObject[] dynamicObjectArray = dataEntities2;
                int n2 = dynamicObjectArray.length;
                for (n = 0; n < n2; ++n) {
                    row = dynamicObjectArray[n];
                    row.set("businessstatus", (Object)"C");
                    row.set("finisher", (Object)RequestContext.get().getCurrUserId());
                }
                break;
            }
            case "workclose": {
                DynamicObject row;
                int n;
                DynamicObject[] dynamicObjectArray = dataEntities2;
                int n2 = dynamicObjectArray.length;
                for (n = 0; n < n2; ++n) {
                    row = dynamicObjectArray[n];
                    row.set("businessstatus", (Object)"E");
                }
                break;
            }
            case "cancel": {
                DynamicObject row;
                int n;
                DynamicObject[] dynamicObjectArray = dataEntities2;
                int n2 = dynamicObjectArray.length;
                for (n = 0; n < n2; ++n) {
                    row = dynamicObjectArray[n];
                    row.set("businessstatus", (Object)"F");
                }
                break;
            }
        }
        if ("workend".equals(operationKey) || "workclose".equals(operationKey) || "cancel".equals(operationKey)) {
            SaveServiceHelper.save((DynamicObject[])dataEntities2);
        }
        HashSet<Long> coorDinaTradeIds = new HashSet<Long>(dataEntities2.length);
        for (DynamicObject coorDinaTrade : dataEntities2) {
            long coorDinaTradeId = coorDinaTrade.getPkValue() == null ? 0L : Long.parseLong(coorDinaTrade.getPkValue().toString());
            coorDinaTradeIds.add(coorDinaTradeId);
        }
        if ("workend".equals(operationKey)) {
            Date now = TimeServiceHelper.now();
            DynamicObject hourUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)10L, (String)"bd_measureunits");
            QFilter filter = new QFilter("oprentryentity.srcbillid", "in", coorDinaTradeIds);
            StringBuilder selectors = new StringBuilder(420);
            selectors.append("id,billno,taskstatus,tasksrctype,");
            selectors.append("oprentryentity,oprentryentity.srcbillid,oprentryentity.srcbillentryid,oprentryentity.workhour,oprentryentity.profession,oprentryentity.dailyexptype,");
            selectors.append("repsubentryentity.id,repsubentryentity.person,repsubentryentity.reportbegintime,status,");
            selectors.append("repsubentryentity.reportendtime,repsubentryentity.workhourunit,repsubentryentity.actualhour,");
            selectors.append("repsubentryentity.worktype,repsubentryentity.isreported");
            DynamicObject[] dailyplans = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectors.toString(), (QFilter[])new QFilter[]{filter});
            if (dailyplans == null || dailyplans.length < 1) {
                return;
            }
            String error = this.createDailyReport(dailyplans, now);
            if (StringUtils.isNotBlank((CharSequence)error)) {
                logger.error("\u751f\u6210\u6c47\u62a5\u5355\u5931\u8d25\uff1a" + error);
            }
            for (DynamicObject dailyplan : dailyplans) {
                DynamicObjectCollection oprentryentitys = dailyplan.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentryentity : oprentryentitys) {
                    long srcbillid;
                    Object srcbillidObj = oprentryentity.get("srcbillid");
                    if (srcbillidObj == null || !coorDinaTradeIds.contains(srcbillid = Long.parseLong(srcbillidObj.toString()))) continue;
                    oprentryentity.set("status", (Object)"F");
                    DynamicObjectCollection repsubentryentitys = oprentryentity.getDynamicObjectCollection("repsubentryentity");
                    for (DynamicObject repsubentryentity : repsubentryentitys) {
                        if (repsubentryentity.get("reportbegintime") == null || repsubentryentity.get("reportendtime") != null) continue;
                        Date reportbegintime = repsubentryentity.getDate("reportbegintime");
                        BigDecimal beginTime = new BigDecimal(reportbegintime.getTime());
                        BigDecimal end = new BigDecimal(now.getTime());
                        BigDecimal subtract = end.subtract(beginTime);
                        repsubentryentity.set("reportendtime", (Object)now);
                        repsubentryentity.set("workhourunit", (Object)hourUnit);
                        repsubentryentity.set("actualhour", (Object)subtract.divide(new BigDecimal("3600000"), 2, 4));
                        repsubentryentity.set("isreported", (Object)Boolean.TRUE);
                    }
                }
                boolean isAllFinishflag = true;
                for (DynamicObject oprentry : oprentryentitys) {
                    if ("F".equals(oprentry.getString("status"))) continue;
                    isAllFinishflag = false;
                }
                if (!isAllFinishflag) continue;
                dailyplan.set("taskstatus", (Object)"C");
            }
            SaveServiceHelper.update((DynamicObject[])dailyplans);
        }
    }

    private String createDailyReport(DynamicObject[] object, Date now) {
        String ec = null;
        try {
            ec = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"DailyPlanFinishToReportService", (String)"createReport", (Object[])new Object[]{object, now});
        }
        catch (Throwable throwable) {
            throw new KDBizException(new ErrorCode("create DailyPlanReport error", throwable.getMessage()), new Object[]{object[0]});
        }
        return ec;
    }
}

