/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.botp.BotpRowLinkUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.pom.common.mro.utils.MRONRCUtils;
import kd.mmc.pom.opplugin.mro.validator.MRONrcUnAuditStatusValidator;

public class MRONrcStatusOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("approvalstatus");
        e.getFieldKeys().add("entrydefecttype");
        e.getFieldKeys().add("srcorderno");
        e.getFieldKeys().add("treeentryentity.taskstatus");
        e.getFieldKeys().add("treeentryentity.planstatus");
        e.getFieldKeys().add("treeentryentity.bizstatus");
        e.getFieldKeys().add("treeentryentity.carduser");
        e.getFieldKeys().add("treeentryentity.defecttype");
        e.getFieldKeys().add("treeentryentity.sorderno");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        Long userId = UserServiceHelper.getCurrentUserId();
        Map<Long, DynamicObject> userAuthAndUserManuPersMap = this.isUserAuthAndUserManuPersMap(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            String billstatus = dataEntity.getString("billstatus");
            DynamicObject org = dataEntity.getDynamicObject("org");
            if ("submit".equals(operationKey)) {
                dataEntity.set("approvalstatus", (Object)"B");
            } else if ("audit".equals(operationKey)) {
                dataEntity.set("approvalstatus", (Object)"C");
            } else if (!"save".equals(operationKey)) {
                dataEntity.set("approvalstatus", (Object)billstatus);
            }
            DynamicObjectCollection entrydefecttype = dataEntity.getDynamicObjectCollection("entrydefecttype");
            Boolean sysIsAuth = MRONRCUtils.getSysIsAuth((DynamicObject)org);
            DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : billentry) {
                DynamicObject entrycarduser;
                if (sysIsAuth.booleanValue() && (StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey) || StringUtils.equals((CharSequence)"save", (CharSequence)operationKey)) && null == (entrycarduser = entry.getDynamicObject("carduser")) && userAuthAndUserManuPersMap != null) {
                    entry.set("carduser", (Object)userAuthAndUserManuPersMap.get(userId));
                }
                if (!StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey) && !StringUtils.equals((CharSequence)"save", (CharSequence)operationKey)) continue;
                DynamicObjectCollection defecttype = entry.getDynamicObjectCollection("defecttype");
                if (defecttype.isEmpty() && !entrydefecttype.isEmpty()) {
                    for (DynamicObject type : entrydefecttype) {
                        defecttype.addNew().set("fbasedataid", type.get("fbasedataid"));
                    }
                    entry.set("defecttype", (Object)defecttype);
                }
                if (defecttype.isEmpty() || !entrydefecttype.isEmpty()) continue;
                for (DynamicObject type : defecttype) {
                    entrydefecttype.addNew().set("fbasedataid", type.get("fbasedataid"));
                }
                dataEntity.set("entrydefecttype", (Object)entrydefecttype);
            }
        }
    }

    public DynamicObject getOldSrcOrder(Long orgId, String sorderno) {
        QFilter orderFilter = new QFilter("org", "=", (Object)orgId);
        orderFilter.and(new QFilter("billno", "=", (Object)sorderno));
        DynamicObject mroOrder = BusinessDataServiceHelper.loadSingle((String)"pom_mroorder", (String)"id,treeentryentity.seq", (QFilter[])orderFilter.toArray());
        return mroOrder;
    }

    public Map<Long, Long> getNewSrcOrder(List<DynamicObject> modifyNrcBills) {
        DynamicObject[] orders;
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject modifyNrcBill : modifyNrcBills) {
            DynamicObject srcorderno = modifyNrcBill.getDynamicObject("srcorderno");
            if (srcorderno == null) continue;
            Long pkValue = (Long)srcorderno.getPkValue();
            idSet.add(pkValue);
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)"pom_mroorder", (String)"id,treeentryentity.seq,treeentryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            long id = order.getLong("id");
            DynamicObjectCollection treeentryentity = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                Long entryPkValue = (Long)entry.getPkValue();
                resultMap.put(id, entryPkValue);
            }
        }
        return resultMap;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] nrcBills;
        List<DynamicObject> modifyNrcBills;
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ((StringUtils.equals((CharSequence)operationKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) && MRONRCUtils.readNRCIsModifySrcOrderParam().booleanValue() && !(modifyNrcBills = this.getModifyedNrcBills(nrcBills = e.getDataEntities())).isEmpty()) {
            List<Object[]> deleteList = this.getDeleteList(modifyNrcBills);
            this.clearBotpRelation(modifyNrcBills, deleteList);
            List<Map<String, Object>> linkList = this.getLinkList(modifyNrcBills);
            if (!linkList.isEmpty()) {
                this.fixRowLink(linkList);
            }
            this.updateEntrySOrderNo(modifyNrcBills);
        }
    }

    private List<Map<String, Object>> getLinkList(List<DynamicObject> modifyNrcBills) {
        ArrayList<Map<String, Object>> linkList = new ArrayList<Map<String, Object>>(16);
        Map<Long, Long> newSrcOrder = this.getNewSrcOrder(modifyNrcBills);
        for (DynamicObject modifyNrcBill : modifyNrcBills) {
            Long pkValue = (Long)modifyNrcBill.getPkValue();
            HashMap<String, Object> linkMap = new HashMap<String, Object>(16);
            linkMap.put("tbillid", pkValue);
            DynamicObject srcorderno = modifyNrcBill.getDynamicObject("srcorderno");
            if (null != srcorderno && newSrcOrder != null) {
                Long srcOrderId = (Long)srcorderno.getPkValue();
                Long entryId = newSrcOrder.get(srcOrderId);
                linkMap.put("sbillid", srcOrderId);
                linkMap.put("sbillentryid", entryId);
            }
            DynamicObjectCollection treeentryentity = modifyNrcBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                Object entryPkValue = entry.getPkValue();
                linkMap.put("tbillentryid", entryPkValue);
                linkMap.put("tseq", entry.get("seq"));
            }
            linkList.add(linkMap);
        }
        return linkList;
    }

    private List<Object[]> getDeleteList(List<DynamicObject> modifyNrcBills) {
        ArrayList<Object[]> deleteList = new ArrayList<Object[]>(16);
        for (DynamicObject modifyNrcBill : modifyNrcBills) {
            DynamicObject srcOrder;
            Long pkValue = (Long)modifyNrcBill.getPkValue();
            DynamicObject org = modifyNrcBill.getDynamicObject("org");
            Long orgId = 0L;
            if (null != org) {
                orgId = (Long)org.getPkValue();
            }
            DynamicObjectCollection treeentryentity = modifyNrcBill.getDynamicObjectCollection("treeentryentity");
            String sorderno = "";
            for (DynamicObject entry : treeentryentity) {
                sorderno = entry.getString("sorderno");
            }
            if (!StringUtils.isNotBlank((CharSequence)sorderno) || orgId == 0L || null == (srcOrder = this.getOldSrcOrder(orgId, sorderno))) continue;
            Long id = srcOrder.getLong("id");
            deleteList.add(new Object[]{pkValue, id});
        }
        return deleteList;
    }

    private void updateEntrySOrderNo(List<DynamicObject> modifyNrcBills) {
        for (DynamicObject modifyNrcBill : modifyNrcBills) {
            DynamicObject srcorderno = modifyNrcBill.getDynamicObject("srcorderno");
            DynamicObjectCollection treeentryentity = modifyNrcBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                if (null != srcorderno) {
                    entry.set("sorderno", (Object)srcorderno.getString("billno"));
                    continue;
                }
                entry.set("sorderno", null);
            }
        }
        SaveServiceHelper.save((DynamicObject[])modifyNrcBills.toArray(new DynamicObject[modifyNrcBills.size()]));
    }

    private void clearBotpRelation(List<DynamicObject> modifyNrcBills, List<Object[]> deleteList) {
        if (!modifyNrcBills.isEmpty()) {
            String tBillType = modifyNrcBills.get(0).getDynamicObjectType().getName();
            String entryName = "treeentryentity";
            Long tTableId = ConvertMetaServiceHelper.loadTableDefine((String)tBillType, (String)entryName).getTableId();
            Long sTableId = ConvertMetaServiceHelper.loadTableDefine((String)"pom_mroorder", (String)entryName).getTableId();
            Long tMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)tBillType).getTableId();
            Long sMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)"pom_mroorder").getTableId();
            for (DynamicObject modifyNrcBill : modifyNrcBills) {
                DynamicObjectCollection billeEntrys = modifyNrcBill.getDynamicObjectCollection(entryName);
                for (DynamicObject billeEntry : billeEntrys) {
                    DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)billeEntry.get("treeentryentity_lk");
                    tagLinkRows.clear();
                }
                DynamicObjectCollection linkRows = (DynamicObjectCollection)modifyNrcBill.get("billhead_lk");
                if (null == linkRows) continue;
                linkRows.clear();
            }
            SaveServiceHelper.save((DynamicObject[])modifyNrcBills.toArray(new DynamicObject[modifyNrcBills.size()]));
            if (!deleteList.isEmpty()) {
                String sql = "delete from t_pom_mroorder_tc where fttableid = " + tTableId + " and fstableid = " + sTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute scmRoute = new DBRoute("scm");
                DB.executeBatch((DBRoute)scmRoute, (String)sql, deleteList);
                String trackerSql = "delete from t_botp_billtracker where fttableid = " + tMainTableId + " and fstableid = " + sMainTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute sysRoute = new DBRoute("sys");
                DB.executeBatch((DBRoute)sysRoute, (String)trackerSql, deleteList);
            }
        }
    }

    public List<DynamicObject> getModifyedNrcBills(DynamicObject[] nrcBills) {
        ArrayList<DynamicObject> modifyNrcBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject nrcBill : nrcBills) {
            DynamicObject srcorderno = nrcBill.getDynamicObject("srcorderno");
            String srcOrderNoNew = "";
            if (null != srcorderno) {
                srcOrderNoNew = srcorderno.getString("billno");
            }
            DynamicObjectCollection treeentryentity = nrcBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                String sorderno = entry.getString("sorderno");
                if (StringUtils.equals((CharSequence)sorderno, (CharSequence)srcOrderNoNew)) continue;
                modifyNrcBills.add(nrcBill);
            }
        }
        return modifyNrcBills;
    }

    public Map<Long, DynamicObject> isUserAuthAndUserManuPersMap(DynamicObject[] dataEntities) {
        Map<Long, Object> userIdAndManuPersMap = new HashMap<Long, DynamicObject>(16);
        Boolean isAuth = this.getIsAuth(dataEntities);
        List<Long> userIdList = this.getUserList(dataEntities);
        if (isAuth.booleanValue()) {
            userIdAndManuPersMap = MRONRCUtils.getManuPersonByUserId(userIdList);
        }
        return userIdAndManuPersMap;
    }

    public Boolean getIsAuth(DynamicObject[] dataEntities) {
        Boolean isAuth = false;
        for (DynamicObject mrosws : dataEntities) {
            DynamicObject org = mrosws.getDynamicObject("org");
            Boolean sysIsAuth = MRONRCUtils.getSysIsAuth((DynamicObject)org);
            if (!sysIsAuth.booleanValue() || isAuth.booleanValue()) continue;
            isAuth = true;
        }
        return isAuth;
    }

    public List<Long> getUserList(DynamicObject[] dataEntities) {
        ArrayList<Long> userIdList = new ArrayList<Long>(16);
        Long userId = UserServiceHelper.getCurrentUserId();
        userIdList.add(userId);
        for (DynamicObject mrosws : dataEntities) {
            DynamicObjectCollection billentry = mrosws.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : billentry) {
                DynamicObject userInfo;
                DynamicObject entrycarduser = entry.getDynamicObject("carduser");
                if (null == entrycarduser || null == (userInfo = entrycarduser.getDynamicObject("user"))) continue;
                Long pkValue = (Long)userInfo.getPkValue();
                userIdList.add(pkValue);
            }
        }
        return userIdList;
    }

    private void fixRowLink(List<Map<String, Object>> linkList) {
        String targetEntityNumber = "pom_mronrc";
        String targetEntryKey = "treeentryentity";
        String srcBillTypeFld = "pom_mroorder";
        String srcEntryFld = "treeentryentity";
        BotpRowLinkUtils.batchFixRowLinkDB((String)targetEntityNumber, (String)targetEntryKey, (String)srcBillTypeFld, (String)srcEntryFld, linkList);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MRONrcUnAuditStatusValidator());
    }
}

