/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;

public class MROOrderBatchCreateOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities2 = e.getDataEntities();
        if (dataEntities2.length > 0) {
            DynamicObject bill = dataEntities2[0];
            this.batchCreateMROOrder(bill);
        }
    }

    private void batchCreateMROOrder(DynamicObject bill) {
        int count = bill.getInt("billcount");
        DynamicObject transactiontype = bill.getDynamicObject("transactiontype");
        DynamicObject project = bill.getDynamicObject("project");
        DynamicObject billtype = BusinessDataServiceHelper.loadSingleFromCache((Object)1387624395492574208L, (String)"bos_billtype", (String)"id");
        DynamicObject codeDynamic = MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)((Long)transactiontype.getPkValue()));
        List genCodeRuleNumbers = MROOrderCodeRuleHelper.genCodeRuleNumbers((DynamicObject)codeDynamic, (DynamicObject)project, (String)"", (int)count);
        DynamicObject[] newOrders = new DynamicObject[count];
        ORM orm = ORM.create();
        long[] genLongIds = orm.genLongIds("pom_mroorder", count);
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"pom_mrobatchjoblog");
        DynamicObjectCollection logEntryEntity = log.getDynamicObjectCollection("entryentity");
        log.set("billno", (Object)String.format("%1$s-%2$s", genCodeRuleNumbers.get(0), genCodeRuleNumbers.get(count - 1)));
        log.set("cardbillno", bill.get("cardbillno"));
        log.set("project", (Object)project);
        log.set("transactiontype", (Object)transactiontype);
        log.set("workstage", bill.get("workstage"));
        log.set("creater", (Object)RequestContext.get().getCurrUserId());
        for (long pkId : genLongIds) {
            DynamicObject logRow = new DynamicObject(logEntryEntity.getDynamicObjectType());
            logRow.set("orderid", (Object)pkId);
            logEntryEntity.add((Object)logRow);
        }
        OperateOption optionLog = OperateOption.create();
        OperationResult saveOperateLog = SaveServiceHelper.saveOperate((String)"pom_mrobatchjoblog", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)optionLog);
        if (!saveOperateLog.isSuccess()) {
            throw new KDBizException(saveOperateLog.getMessage());
        }
        for (int i = 0; i < count; ++i) {
            DynamicObject order = BusinessDataServiceHelper.newDynamicObject((String)"pom_mroorder");
            String orderno = (String)genCodeRuleNumbers.get(i);
            order.set("id", (Object)genLongIds[i]);
            order.set("billno", (Object)orderno);
            order.set("org", bill.get("createorg"));
            order.set("transactiontype", (Object)transactiontype);
            order.set("billdate", (Object)TimeServiceHelper.now());
            order.set("entitytype", (Object)"pom_mroorder");
            order.set("isshowlist", (Object)Boolean.TRUE);
            order.set("billtype", (Object)billtype);
            order.set("billstatus", (Object)"A");
            DynamicObjectCollection entryentity = order.getDynamicObjectCollection("treeentryentity");
            DynamicObject row = new DynamicObject(entryentity.getDynamicObjectType());
            row.set("project", (Object)project);
            row.set("cardtitle", bill.get("cardtitle"));
            row.set("producttype", (Object)"C");
            row.set("material", bill.get("material"));
            row.set("unit", bill.get("unit"));
            row.set("qty", bill.get("qty"));
            row.set("baseunit", bill.get("baseunit"));
            row.set("baseqty", bill.get("baseqty"));
            row.set("mratype", bill.get("mratype"));
            row.set("materielmtc", project.get("devices"));
            row.set("zone", bill.get("zone"));
            row.set("workstage", bill.get("workstage"));
            row.set("area", bill.get("area"));
            row.set("maintrade", bill.get("maintrade"));
            row.set("atatype", bill.get("atatype"));
            row.set("ata", bill.get("ata"));
            row.set("planbegintime", (Object)TimeServiceHelper.now());
            row.set("planendtime", (Object)TimeServiceHelper.now());
            row.set("customer", project.get("customer"));
            row.set("controlno", bill.get("controlno"));
            entryentity.add((Object)row);
            newOrders[i] = order;
        }
        bill.set("ordernofrom", genCodeRuleNumbers.get(0));
        bill.set("ordernoto", genCodeRuleNumbers.get(count - 1));
        OperateOption option = OperateOption.create();
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pom_mroorder", (DynamicObject[])newOrders, (OperateOption)option);
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(saveOperate.getMessage());
        }
    }

    private String getTitleFromProject(DynamicObject project) {
        boolean isspecial;
        if (project != null && (isspecial = project.getBoolean("isspecial"))) {
            return project.getString("workcontent");
        }
        return "";
    }
}

