/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MROOrderResStatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MROOrderResStatusOp.class);
    private static List<String> opList = new ArrayList<String>(Arrays.asList("noready", "preready", "actready"));

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("treeentryentity.resourcestatus");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        this.setOperation(dataArray);
        String selectRowStr = this.getOption().getVariableValue("operateOption");
        logger.info("selectRowStr:" + selectRowStr);
        Set<String> entityentryidList = this.getBillSelectRowInfoSet(selectRowStr);
        String entityNum = this.billEntityType.getName();
        String key = e.getOperationKey();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(dataArray.length);
        if (opList.contains(key)) {
            HashSet<Long> ids = new HashSet<Long>(16);
            for (DynamicObject mftorder : dataArray) {
                ids.add(mftorder.getLong("id"));
            }
            Map<Long, DynamicObject> mftOrderDataMap = this.getMftOrderDataMap(ids, entityNum);
            if (mftOrderDataMap != null && !mftOrderDataMap.isEmpty()) {
                for (DynamicObject data : dataArray) {
                    boolean isDataChange = false;
                    Long billPkId = (Long)data.getPkValue();
                    DynamicObject manubill = mftOrderDataMap.get(billPkId);
                    DynamicObjectCollection entryCol = manubill.getDynamicObjectCollection("treeentryentity");
                    block12: for (int j = 0; j < entryCol.size(); ++j) {
                        DynamicObject entry = (DynamicObject)entryCol.get(j);
                        String entityentryid = entry.getPkValue().toString();
                        if (!entityentryidList.contains(entityentryid)) continue;
                        switch (key) {
                            case "noready": {
                                entry.set("resourcestatus", (Object)"A");
                                this.updateStatusByMainProduct(entryCol, entityentryid, "A");
                                isDataChange = true;
                                continue block12;
                            }
                            case "preready": {
                                entry.set("resourcestatus", (Object)"B");
                                this.updateStatusByMainProduct(entryCol, entityentryid, "C");
                                isDataChange = true;
                                continue block12;
                            }
                            case "actready": {
                                entry.set("resourcestatus", (Object)"C");
                                this.updateStatusByMainProduct(entryCol, entityentryid, "C");
                                isDataChange = true;
                                continue block12;
                            }
                        }
                    }
                    if (!isDataChange) continue;
                    updateList.add(manubill);
                    logger.info("\u5355\u636e\u7f16\u53f7\uff1a" + data.getString("billno") + " isDataChange: " + isDataChange);
                }
                if (updateList.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                }
            }
        }
    }

    public Map<Long, DynamicObject> getMftOrderDataMap(Set<Long> ids, String entityid) {
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(20);
        if (!ids.isEmpty()) {
            DynamicObject[] load;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityid);
            String selectFields = "id,transactiontype,org,number,treeentryentity.pid,treeentryentity.id,treeentryentity.resourcestatus";
            for (DynamicObject dym : load = BusinessDataServiceHelper.load((String)entityType.getName(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                Long pkValue = (Long)dym.getPkValue();
                if (orderMap.containsKey(pkValue)) continue;
                orderMap.put(pkValue, dym);
            }
        }
        return orderMap;
    }

    public Set<String> getBillSelectRowInfoSet(String selectRowStr) {
        String[] rowstr;
        HashSet<String> resultList = new HashSet<String>();
        for (String row : rowstr = selectRowStr.split("@@@")) {
            String[] billstr = row.split(",");
            if (billstr.length != 2) continue;
            resultList.add(billstr[1]);
        }
        return resultList;
    }

    private void updateStatusByMainProduct(DynamicObjectCollection entryCol, String entityentryid, String status) {
        for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject entry = (DynamicObject)entryCol.get(j);
            if (!entry.get("pid").toString().equals(entityentryid)) continue;
            entry.set("resourcestatus", (Object)status);
        }
    }

    private void setOperation(DynamicObject[] dataarr) {
        boolean containsVariable = this.getOption().containsVariable("operateOption");
        if (!containsVariable) {
            logger.info("[operateOption] not include");
            this.autoSelectAllRows(dataarr);
        } else {
            String operateOption = this.getOption().getVariableValue("operateOption");
            if (operateOption.isEmpty()) {
                logger.info("[operateOption] is empty");
                this.autoSelectAllRows(dataarr);
            } else {
                logger.info("[operateOption]\uff1a" + operateOption);
            }
        }
    }

    private void autoSelectAllRows(DynamicObject[] dataarr) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dataEntity : dataarr) {
            String billno = dataEntity.getString("billno");
            DynamicObjectCollection entrycol = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrycol) {
                String productty = entry.getString("producttype");
                if (!"C".equals(productty)) continue;
                Object entryPK = entry.getPkValue();
                sb.append(billno).append(',').append(entryPK).append("@@@");
            }
        }
        this.getOption().setVariableValue("operateOption", sb.toString());
    }
}

