/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.business.mroorder.MroOrderAutoTransmitUtils;

public class MROOrderSubmitAutoTransmitOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MROOrderSubmitAutoTransmitOp.class);
    private static final String KEY_ENTITY_MROORDER = "pom_mroorder";
    private static final String KEY_MROORDERID = "mroorderid";
    private static final String KEY_BILLNO = "billno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add(KEY_BILLNO);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("treeentryentity.project");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        OperationResult operationResult2 = this.getOperationResult();
        List successPkIds = operationResult2.getSuccessPkIds();
        HashSet<Long> submitMroOrder = new HashSet<Long>(successPkIds.size());
        for (Object spid : successPkIds) {
            submitMroOrder.add(Long.parseLong(spid.toString()));
        }
        HashMap<Long, String> orderNameMap = new HashMap<Long, String>(successPkIds.size());
        HashMap<Long, Set<Long>> projectOrderMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> projectIdSet = new HashSet<Long>(16);
        for (DynamicObject row : e.getDataEntities()) {
            String billno = row.getString(KEY_BILLNO);
            Long orderid = row.getLong("id");
            if (!submitMroOrder.contains(orderid)) continue;
            DynamicObjectCollection treeentryentity = row.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject cell : treeentryentity) {
                HashSet<Long> set;
                DynamicObject project = cell.getDynamicObject("project");
                if (project == null) continue;
                Long pkvalue = (Long)project.getPkValue();
                if (projectOrderMap.containsKey(pkvalue)) {
                    set = (HashSet<Long>)projectOrderMap.get(pkvalue);
                    set.add(orderid);
                    projectOrderMap.put(pkvalue, set);
                } else {
                    set = new HashSet<Long>(16);
                    set.add(orderid);
                    projectOrderMap.put(pkvalue, set);
                }
                projectIdSet.add(pkvalue);
            }
            orderNameMap.put(row.getLong("id"), billno);
        }
        if (!projectOrderMap.isEmpty()) {
            String entityNum = "pom_mronrc";
            if (e.getDataEntities().length > 0) {
                entityNum = e.getDataEntities()[0].getDataEntityType().getName();
            }
            long startdate = System.currentTimeMillis();
            logger.info("MROOrderSubmitAutoTransmitOp begin getStateControlRules.....projectIdSet.size=" + projectIdSet.size());
            Object invokeBizService = DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"StateService", (String)"getStateControlRules", (Object[])new Object[]{"pmpd_project", projectIdSet});
            Map projectMap = (Map)invokeBizService;
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("MROOrderSubmitAutoTransmitOp end getStateControlRules.....cost:" + enddate + "ms");
            StringBuilder error = new StringBuilder();
            for (Map.Entry sMap : projectMap.entrySet()) {
                String key = (String)sMap.getKey();
                if (!"data".equals(key)) continue;
                Map project = (Map)sMap.getValue();
                try {
                    logger.info("MROOrderSubmitAutoTransmitOp exec autoTransmitOp");
                    this.autoTransmitOp(entityNum, projectOrderMap, project, operationKey, orderNameMap, error);
                }
                catch (Exception ee) {
                    logger.info("autotransmit---error---ee---" + ee);
                    error.append(ee.getMessage());
                    throw new KDBizException(error.toString());
                }
            }
            if (error.toString().length() > 0) {
                throw new KDBizException(error.toString());
            }
        }
    }

    private void autoTransmitOp(String entityNum, Map<Long, Set<Long>> projectOrderMap, Map<Long, List<Map<String, String>>> project, String operationKey, Map<Long, String> orderNameMap, StringBuilder error) {
        block0: for (Map.Entry<Long, List<Map<String, String>>> list : project.entrySet()) {
            Long projectid = list.getKey();
            List<Map<String, String>> value = list.getValue();
            if (!projectOrderMap.containsKey(projectid)) continue;
            Set<Long> submitMroOrder = projectOrderMap.get(projectid);
            for (Map<String, String> subMap : value) {
                String bcbill = subMap.get("bcbill");
                String bcoperationobject = subMap.get("bcoperationobject");
                if ("bar_submit".equals(bcoperationobject) && entityNum.equals(bcbill) && "submit".equals(operationKey)) {
                    HashSet auditMroOrder = new HashSet(submitMroOrder.size());
                    DynamicObject dynamicObject = ParameterReader.getBillParameter((String)entityNum);
                    logger.info("MROOrderSubmitAutoTransmitOp---autoTransmitOp---exec audit data2");
                    MroOrderAutoTransmitUtils.autoAuditMroOrderNoThread(submitMroOrder, orderNameMap, auditMroOrder, (StringBuilder)error, (String)"audit", (String)entityNum);
                    logger.info("MROOrderSubmitAutoTransmitOp---autoTransmitOp---exec audit data2" + error);
                    continue block0;
                }
                if (!"bar_audit".equals(bcoperationobject) || !entityNum.equals(bcbill) || !"audit".equals(operationKey) || this.getOption().containsVariable("notransmit") || (submitMroOrder = this.excludeTransmitOrder(submitMroOrder)).isEmpty()) continue;
                logger.info("MROOrderSubmitAutoTransmitOp---autoTransmitOp---exec transmit data");
                MroOrderAutoTransmitUtils.autoAuditMroOrderNoThread(submitMroOrder, orderNameMap, null, (StringBuilder)error, (String)"transmit", (String)KEY_ENTITY_MROORDER);
                logger.info("MROOrderSubmitAutoTransmitOp---autoTransmitOp---exec transmit data" + error);
                continue block0;
            }
        }
    }

    private Set<Long> excludeTransmitOrder(Set<Long> transmitOrder) {
        QFilter filter = new QFilter("id", "in", transmitOrder);
        filter.and(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)MROOrderSubmitAutoTransmitOp.class.getName(), (String)KEY_ENTITY_MROORDER, (String)"id,treeentryentity.planstatus", (QFilter[])filter.toArray(), null);){
            for (Row row : queryDataSet) {
                Long transedID = row.getLong("id");
                transmitOrder.remove(transedID);
            }
        }
        return transmitOrder;
    }
}

