/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MROOrderTypeSetOp
extends AbstractOperationServicePlugIn {
    private static Map<String, Long> mroorderTypeMap = new HashMap<String, Long>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entitytype");
        e.getFieldKeys().add("mroordertypeid");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("workcard");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("materielmtc");
        e.getFieldKeys().add("dailyexptype");
        e.getFieldKeys().add("workstage");
        e.getFieldKeys().add("stagetxt");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject transactiontype;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Object> transactiontypeSet = new HashSet<Object>(dataEntities.length);
        Map transactiontypeMap = new HashMap(16);
        for (DynamicObject data : dataEntities) {
            transactiontype = (DynamicObject)data.get("transactiontype");
            if (transactiontype == null) continue;
            transactiontypeSet.add(transactiontype.getPkValue());
        }
        if (!transactiontypeSet.isEmpty()) {
            QFilter qf = new QFilter("id", "in", transactiontypeSet);
            transactiontypeMap = TransactionTypeQueryHelper.getDataCacheBySet(transactiontypeSet);
        }
        for (DynamicObject data : dataEntities) {
            Object pkValue;
            transactiontype = (DynamicObject)data.get("transactiontype");
            if (transactiontype == null || !transactiontypeMap.containsKey(pkValue = transactiontype.getPkValue())) continue;
            DynamicObject type = (DynamicObject)transactiontypeMap.get(pkValue);
            String mroordertype = type.getString("mroordertype");
            data.set("mroordertypeid", (Object)this.getOrderType(mroorderTypeMap.get(mroordertype)));
            DynamicObjectCollection entryData = data.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject row : entryData) {
                DynamicObject projectDevices;
                DynamicObject project = row.getDynamicObject("project");
                if (project == null) continue;
                DynamicObject projectCustomer = project.getDynamicObject("customer");
                if (projectCustomer != null) {
                    row.set("customer", (Object)projectCustomer);
                }
                if ((projectDevices = project.getDynamicObject("devices")) == null) continue;
                row.set("materielmtc", (Object)projectDevices);
            }
        }
        this.setStageTxt(e);
    }

    private DynamicObject getOrderType(Long id) {
        if (id != null && id > 0L) {
            QFilter fil = new QFilter("id", "=", (Object)id);
            return BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_mroordertype", (String)"id", (QFilter[])new QFilter[]{fil});
        }
        return null;
    }

    private void setStageTxt(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        HashSet<Long> stageIDs = new HashSet<Long>(16);
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject row : entry) {
                DynamicObject stageDy = row.getDynamicObject("workstage");
                if (stageDy == null) continue;
                stageIDs.add(stageDy.getLong("id"));
            }
        }
        QFilter filter = new QFilter("id", "in", stageIDs);
        Map stageMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_workcategories", (String)"id,number,alias", (QFilter[])filter.toArray());
        for (DynamicObject bill : dataEntities) {
            DynamicObject type = bill.getDynamicObject("mroordertypeid");
            if (type == null) continue;
            Long typeid = type.getLong("id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject row : entry) {
                DynamicObject stageDy = row.getDynamicObject("workstage");
                if (stageDy == null) continue;
                stageDy = (DynamicObject)stageMap.get(stageDy.getPkValue());
                if (typeid.equals(1549847746037460992L)) {
                    row.set("stagetxt", (Object)stageDy.getLocaleString("alias").getLocaleValue_zh_CN());
                    continue;
                }
                row.set("stagetxt", stageDy.get("number"));
            }
        }
    }

    static {
        mroorderTypeMap.put("BASICJOB_S", 1549847396006014976L);
        mroorderTypeMap.put("NRCJOB_S", 1549847746037460992L);
        mroorderTypeMap.put("DUMMYJOB_S", 1549849217080537088L);
        mroorderTypeMap.put("INNERJOB_S", 1549848412084547584L);
        mroorderTypeMap.put("PANELJOB_S", 1549848656880906240L);
        mroorderTypeMap.put("SUBJOB_S", 1549848051215020032L);
        mroorderTypeMap.put("SPECJOB_S", 1549849460861874176L);
        mroorderTypeMap.put("OTHERJOB_S", 1549849979831496704L);
        mroorderTypeMap.put("OVERHEADJOB_S", 1568897944227163136L);
    }
}

